/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.value.decorator;

import ai.timefold.solver.core.impl.domain.variable.ListVariableStateSupply;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.selector.AbstractDemandEnabledSelector;
import ai.timefold.solver.core.impl.heuristic.selector.common.ReachableValues;
import ai.timefold.solver.core.impl.heuristic.selector.value.IterableValueSelector;
import ai.timefold.solver.core.impl.phase.scope.AbstractPhaseScope;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import ai.timefold.solver.core.preview.api.domain.metamodel.ElementPosition;
import ai.timefold.solver.core.preview.api.domain.metamodel.PositionInList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Random;
import java.util.function.Supplier;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

public final class FilteringValueRangeSelector<Solution_>
extends AbstractDemandEnabledSelector<Solution_>
implements IterableValueSelector<Solution_> {
    private final IterableValueSelector<Solution_> nonReplayingValueSelector;
    private final IterableValueSelector<Solution_> replayingValueSelector;
    private final boolean randomSelection;
    private Object replayedValue = null;
    private long valuesSize;
    private ListVariableStateSupply<Solution_> listVariableStateSupply;
    private ReachableValues reachableValues;
    private final boolean checkSourceAndDestination;

    public FilteringValueRangeSelector(IterableValueSelector<Solution_> nonReplayingValueSelector, IterableValueSelector<Solution_> replayingValueSelector, boolean randomSelection, boolean checkSourceAndDestination) {
        this.nonReplayingValueSelector = nonReplayingValueSelector;
        this.replayingValueSelector = replayingValueSelector;
        this.randomSelection = randomSelection;
        this.checkSourceAndDestination = checkSourceAndDestination;
    }

    @Override
    public void solvingStarted(SolverScope<Solution_> solverScope) {
        super.solvingStarted(solverScope);
        this.nonReplayingValueSelector.solvingStarted(solverScope);
        this.replayingValueSelector.solvingStarted(solverScope);
        this.listVariableStateSupply = solverScope.getScoreDirector().getListVariableStateSupply((ListVariableDescriptor)this.nonReplayingValueSelector.getVariableDescriptor());
    }

    @Override
    public void phaseStarted(AbstractPhaseScope<Solution_> phaseScope) {
        super.phaseStarted(phaseScope);
        this.nonReplayingValueSelector.phaseStarted(phaseScope);
        this.replayingValueSelector.phaseStarted(phaseScope);
        this.reachableValues = phaseScope.getScoreDirector().getValueRangeManager().getReachableValues((GenuineVariableDescriptor<Solution_>)this.listVariableStateSupply.getSourceVariableDescriptor());
        this.valuesSize = this.reachableValues.getSize();
    }

    @Override
    public void phaseEnded(AbstractPhaseScope<Solution_> phaseScope) {
        super.phaseEnded(phaseScope);
        this.nonReplayingValueSelector.phaseEnded(phaseScope);
        this.replayingValueSelector.phaseEnded(phaseScope);
        this.reachableValues = null;
    }

    public IterableValueSelector<Solution_> getChildValueSelector() {
        return this.nonReplayingValueSelector;
    }

    @Override
    public GenuineVariableDescriptor<Solution_> getVariableDescriptor() {
        return this.nonReplayingValueSelector.getVariableDescriptor();
    }

    @Override
    public boolean isCountable() {
        return this.nonReplayingValueSelector.isCountable();
    }

    @Override
    public boolean isNeverEnding() {
        return this.nonReplayingValueSelector.isNeverEnding();
    }

    @Override
    public long getSize(Object entity) {
        return this.getSize();
    }

    @Override
    public long getSize() {
        return this.valuesSize;
    }

    @Override
    public Iterator<Object> iterator(Object entity) {
        return this.iterator();
    }

    private Object selectReplayedValue() {
        Iterator iterator = this.replayingValueSelector.iterator();
        if (iterator.hasNext()) {
            this.replayedValue = iterator.next();
        }
        return this.replayedValue;
    }

    @Override
    public Iterator<Object> iterator() {
        if (this.randomSelection) {
            return new RandomFilteringValueRangeIterator(this::selectReplayedValue, this.reachableValues, this.listVariableStateSupply, this.workingRandom, this.checkSourceAndDestination);
        }
        return new OriginalFilteringValueRangeIterator(this::selectReplayedValue, this.reachableValues, this.listVariableStateSupply, this.checkSourceAndDestination);
    }

    @Override
    public Iterator<Object> endingIterator(Object entity) {
        return new OriginalFilteringValueRangeIterator(this::selectReplayedValue, this.reachableValues, this.listVariableStateSupply, this.checkSourceAndDestination);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object other) {
        if (!(other instanceof FilteringValueRangeSelector)) return false;
        FilteringValueRangeSelector that = (FilteringValueRangeSelector)other;
        if (!Objects.equals(this.nonReplayingValueSelector, that.nonReplayingValueSelector)) return false;
        if (!Objects.equals(this.replayingValueSelector, that.replayingValueSelector)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.nonReplayingValueSelector, this.replayingValueSelector);
    }

    private class RandomFilteringValueRangeIterator
    extends AbstractFilteringValueRangeIterator {
        private final Random workingRandom;
        private int maxBailoutSize;
        private Object replayedValue;
        private List<Object> reachableValueList;

        private RandomFilteringValueRangeIterator(Supplier<Object> upcomingValueSupplier, ReachableValues reachableValues, ListVariableStateSupply<Solution_> listVariableStateSupply, Random workingRandom, boolean checkSourceAndDestination) {
            super(upcomingValueSupplier, reachableValues, listVariableStateSupply, checkSourceAndDestination);
            this.reachableValueList = null;
            this.workingRandom = workingRandom;
        }

        @Override
        void processUpcomingValue(Object upcomingValue, List<Object> upcomingList) {
            this.replayedValue = upcomingValue;
            this.reachableValueList = Objects.requireNonNull(upcomingList);
            this.maxBailoutSize = this.reachableValueList.size();
        }

        @Override
        public boolean hasNext() {
            this.checkUpcomingValue();
            return FilteringValueRangeSelector.this.reachableValues != null && !this.reachableValueList.isEmpty();
        }

        @Override
        public Object next() {
            if (this.hasNoData()) {
                throw new NoSuchElementException();
            }
            int bailoutSize = this.maxBailoutSize;
            do {
                --bailoutSize;
                int index = this.workingRandom.nextInt(this.reachableValueList.size());
                Object next = this.reachableValueList.get(index);
                if (!this.isReachable(next)) continue;
                return next;
            } while (bailoutSize > 0);
            return this.replayedValue;
        }
    }

    private class OriginalFilteringValueRangeIterator
    extends AbstractFilteringValueRangeIterator {
        private Iterator<Object> reachableValueIterator;
        private Object selected;

        private OriginalFilteringValueRangeIterator(Supplier<Object> upcomingValueSupplier, ReachableValues reachableValues, ListVariableStateSupply<Solution_> listVariableStateSupply, boolean checkSourceAndDestination) {
            super(upcomingValueSupplier, reachableValues, listVariableStateSupply, checkSourceAndDestination);
            this.selected = null;
        }

        @Override
        void processUpcomingValue(Object upcomingValue, List<Object> upcomingList) {
            this.reachableValueIterator = Objects.requireNonNull(upcomingList).iterator();
            this.selected = null;
        }

        @Override
        public boolean hasNext() {
            this.selected = this.pickNext();
            return this.selected != null;
        }

        private Object pickNext() {
            if (this.selected != null) {
                throw new IllegalStateException("The next value has already been picked.");
            }
            this.initialize();
            this.selected = null;
            while (this.reachableValueIterator.hasNext()) {
                Object value = this.reachableValueIterator.next();
                if (!this.isReachable(value)) continue;
                return value;
            }
            return null;
        }

        @Override
        public Object next() {
            if (this.selected == null) {
                throw new NoSuchElementException();
            }
            Object result = this.selected;
            this.selected = null;
            return result;
        }
    }

    @NullMarked
    private abstract class AbstractFilteringValueRangeIterator
    implements Iterator<Object> {
        private final Supplier<Object> upcomingValueSupplier;
        private final ListVariableStateSupply<Solution_> listVariableStateSupply;
        private final ReachableValues reachableValues;
        private final boolean checkSourceAndDestination;
        private boolean initialized = false;
        private boolean hasData = false;
        private @Nullable Object currentUpcomingValue;
        private @Nullable Object currentUpcomingEntity;
        private @Nullable List<Object> currentUpcomingList;

        AbstractFilteringValueRangeIterator(Supplier<Object> upcomingValueSupplier, ReachableValues reachableValues, ListVariableStateSupply<Solution_> listVariableStateSupply, boolean checkSourceAndDestination) {
            this.upcomingValueSupplier = upcomingValueSupplier;
            this.reachableValues = Objects.requireNonNull(reachableValues);
            this.listVariableStateSupply = listVariableStateSupply;
            this.checkSourceAndDestination = checkSourceAndDestination;
        }

        void initialize() {
            if (this.initialized) {
                return;
            }
            this.checkUpcomingValue();
        }

        void checkUpcomingValue() {
            if (this.currentUpcomingValue != null) {
                Object updatedUpcomingValue = this.upcomingValueSupplier.get();
                if (updatedUpcomingValue != this.currentUpcomingValue) {
                    this.loadValues(updatedUpcomingValue);
                }
            } else {
                this.loadValues(this.upcomingValueSupplier.get());
            }
        }

        private void loadValues(@Nullable Object upcomingValue) {
            ElementPosition position;
            if (upcomingValue == null) {
                this.noData();
                return;
            }
            if (upcomingValue == this.currentUpcomingValue) {
                return;
            }
            this.currentUpcomingValue = upcomingValue;
            this.currentUpcomingEntity = null;
            this.currentUpcomingList = null;
            if (this.checkSourceAndDestination && (position = this.listVariableStateSupply.getElementPosition(this.currentUpcomingValue)) instanceof PositionInList) {
                PositionInList positionInList = (PositionInList)position;
                this.currentUpcomingEntity = positionInList.entity();
            }
            this.currentUpcomingList = this.reachableValues.extractValuesAsList(this.currentUpcomingValue);
            this.processUpcomingValue(this.currentUpcomingValue, this.currentUpcomingList);
            this.hasData = !this.currentUpcomingList.isEmpty();
            this.initialized = true;
        }

        abstract void processUpcomingValue(Object var1, List<Object> var2);

        boolean hasNoData() {
            return !this.hasData;
        }

        private void noData() {
            this.currentUpcomingEntity = null;
            this.hasData = false;
            this.initialized = true;
            this.currentUpcomingList = Collections.emptyList();
        }

        boolean isReachable(Object destinationValue) {
            Object destinationEntity = null;
            ElementPosition assignedDestinationPosition = this.listVariableStateSupply.getElementPosition(destinationValue);
            if (assignedDestinationPosition instanceof PositionInList) {
                PositionInList elementPosition = (PositionInList)assignedDestinationPosition;
                destinationEntity = elementPosition.entity();
            }
            if (this.checkSourceAndDestination) {
                return this.reachableValues.isEntityReachable(Objects.requireNonNull(this.currentUpcomingValue), destinationEntity) && this.reachableValues.isEntityReachable(Objects.requireNonNull(destinationValue), this.currentUpcomingEntity);
            }
            return this.reachableValues.isEntityReachable(Objects.requireNonNull(this.currentUpcomingValue), destinationEntity);
        }
    }
}

