/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.move.generic.list;

import ai.timefold.solver.core.impl.domain.variable.ListVariableStateSupply;
import ai.timefold.solver.core.impl.domain.variable.descriptor.VariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.move.Move;
import ai.timefold.solver.core.impl.heuristic.move.NoChangeMove;
import ai.timefold.solver.core.impl.heuristic.selector.common.iterator.UpcomingSelectionIterator;
import ai.timefold.solver.core.impl.heuristic.selector.list.DestinationSelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.ListAssignMove;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.ListChangeMove;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.ListUnassignMove;
import ai.timefold.solver.core.impl.heuristic.selector.value.IterableValueSelector;
import ai.timefold.solver.core.preview.api.domain.metamodel.ElementPosition;
import ai.timefold.solver.core.preview.api.domain.metamodel.PositionInList;
import java.util.Collections;
import java.util.Iterator;

public class OriginalListChangeIterator<Solution_>
extends UpcomingSelectionIterator<Move<Solution_>> {
    private final ListVariableStateSupply<Solution_> listVariableStateSupply;
    private final Iterator<Object> valueIterator;
    private final DestinationSelector<Solution_> destinationSelector;
    private Iterator<ElementPosition> destinationIterator;
    private Object upcomingValue;

    public OriginalListChangeIterator(ListVariableStateSupply<Solution_> listVariableStateSupply, IterableValueSelector<Solution_> valueSelector, DestinationSelector<Solution_> destinationSelector) {
        this.listVariableStateSupply = listVariableStateSupply;
        this.valueIterator = valueSelector.iterator();
        this.destinationSelector = destinationSelector;
        this.destinationIterator = Collections.emptyIterator();
    }

    @Override
    protected Move<Solution_> createUpcomingSelection() {
        while (!this.destinationIterator.hasNext()) {
            if (!this.valueIterator.hasNext()) {
                return (Move)this.noUpcomingSelection();
            }
            this.upcomingValue = this.valueIterator.next();
            this.destinationIterator = this.destinationSelector.iterator();
        }
        Move<Solution_> move = OriginalListChangeIterator.buildChangeMove(this.listVariableStateSupply, this.upcomingValue, this.destinationIterator);
        if (move == null) {
            return (Move)this.noUpcomingSelection();
        }
        return move;
    }

    static <Solution_> Move<Solution_> buildChangeMove(ListVariableStateSupply<Solution_> listVariableStateSupply, Object upcomingLeftValue, Iterator<ElementPosition> destinationIterator) {
        VariableDescriptor listVariableDescriptor = listVariableStateSupply.getSourceVariableDescriptor();
        ElementPosition upcomingDestination = OriginalListChangeIterator.findUnpinnedDestination(destinationIterator, listVariableDescriptor);
        if (upcomingDestination == null) {
            return null;
        }
        ElementPosition upcomingSource = listVariableStateSupply.getElementPosition(upcomingLeftValue);
        if (upcomingSource instanceof PositionInList) {
            PositionInList sourceElement = (PositionInList)upcomingSource;
            if (upcomingDestination instanceof PositionInList) {
                PositionInList destinationElement = (PositionInList)upcomingDestination;
                return new ListChangeMove(listVariableDescriptor, sourceElement.entity(), sourceElement.index(), destinationElement.entity(), destinationElement.index());
            }
            return new ListUnassignMove(listVariableDescriptor, sourceElement.entity(), sourceElement.index());
        }
        if (upcomingDestination instanceof PositionInList) {
            PositionInList destinationElement = (PositionInList)upcomingDestination;
            return new ListAssignMove(listVariableDescriptor, upcomingLeftValue, destinationElement.entity(), destinationElement.index());
        }
        return NoChangeMove.getInstance();
    }
}

