/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.move.generic;

import ai.timefold.solver.core.api.domain.valuerange.ValueRange;
import ai.timefold.solver.core.api.score.director.ScoreDirector;
import ai.timefold.solver.core.impl.domain.valuerange.descriptor.ValueRangeDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.move.AbstractMove;
import ai.timefold.solver.core.impl.score.director.VariableDescriptorAwareScoreDirector;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class PillarChangeMove<Solution_>
extends AbstractMove<Solution_> {
    protected final GenuineVariableDescriptor<Solution_> variableDescriptor;
    protected final List<Object> pillar;
    protected final Object toPlanningValue;

    public PillarChangeMove(List<Object> pillar, GenuineVariableDescriptor<Solution_> variableDescriptor, Object toPlanningValue) {
        this.pillar = pillar;
        this.variableDescriptor = variableDescriptor;
        this.toPlanningValue = toPlanningValue;
    }

    public List<Object> getPillar() {
        return this.pillar;
    }

    public String getVariableName() {
        return this.variableDescriptor.getVariableName();
    }

    public Object getToPlanningValue() {
        return this.toPlanningValue;
    }

    @Override
    public boolean isMoveDoable(ScoreDirector<Solution_> scoreDirector) {
        Object oldValue = this.variableDescriptor.getValue(this.pillar.get(0));
        if (Objects.equals(oldValue, this.toPlanningValue)) {
            return false;
        }
        if (!this.variableDescriptor.canExtractValueRangeFromSolution()) {
            ValueRangeDescriptor<Solution_> valueRangeDescriptor = this.variableDescriptor.getValueRangeDescriptor();
            for (Object entity : this.pillar) {
                ValueRange rightValueRange = this.extractValueRangeFromEntity(scoreDirector, valueRangeDescriptor, entity);
                if (rightValueRange.contains(this.toPlanningValue)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    protected void doMoveOnGenuineVariables(ScoreDirector<Solution_> scoreDirector) {
        VariableDescriptorAwareScoreDirector castScoreDirector = (VariableDescriptorAwareScoreDirector)scoreDirector;
        for (Object entity : this.pillar) {
            castScoreDirector.changeVariableFacade(this.variableDescriptor, entity, this.toPlanningValue);
        }
    }

    @Override
    public PillarChangeMove<Solution_> rebase(ScoreDirector<Solution_> destinationScoreDirector) {
        return new PillarChangeMove<Solution_>(PillarChangeMove.rebaseList(this.pillar, destinationScoreDirector), this.variableDescriptor, destinationScoreDirector.lookUpWorkingObject(this.toPlanningValue));
    }

    @Override
    public String getSimpleMoveTypeDescription() {
        return this.getClass().getSimpleName() + "(" + this.variableDescriptor.getSimpleEntityAndVariableName() + ")";
    }

    @Override
    public Collection<? extends Object> getPlanningEntities() {
        return this.pillar;
    }

    @Override
    public Collection<? extends Object> getPlanningValues() {
        return Collections.singletonList(this.toPlanningValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PillarChangeMove other = (PillarChangeMove)o;
        return Objects.equals(this.variableDescriptor, other.variableDescriptor) && Objects.equals(this.pillar, other.pillar) && Objects.equals(this.toPlanningValue, other.toPlanningValue);
    }

    public int hashCode() {
        return Objects.hash(this.variableDescriptor, this.pillar, this.toPlanningValue);
    }

    public String toString() {
        Object oldValue = this.variableDescriptor.getValue(this.pillar.get(0));
        return String.valueOf(this.pillar) + " {" + String.valueOf(oldValue) + " -> " + String.valueOf(this.toPlanningValue) + "}";
    }
}

