/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.variable.inverserelation;

import ai.timefold.solver.core.api.domain.variable.VariableListener;
import ai.timefold.solver.core.api.score.director.ScoreDirector;
import ai.timefold.solver.core.impl.domain.variable.descriptor.VariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.inverserelation.InverseRelationShadowVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import org.jspecify.annotations.NonNull;

public class SingletonInverseVariableListener<Solution_>
implements VariableListener<Solution_, Object>,
SingletonInverseVariableSupply {
    protected final InverseRelationShadowVariableDescriptor<Solution_> shadowVariableDescriptor;
    protected final VariableDescriptor<Solution_> sourceVariableDescriptor;

    public SingletonInverseVariableListener(InverseRelationShadowVariableDescriptor<Solution_> shadowVariableDescriptor, VariableDescriptor<Solution_> sourceVariableDescriptor) {
        this.shadowVariableDescriptor = shadowVariableDescriptor;
        this.sourceVariableDescriptor = sourceVariableDescriptor;
    }

    @Override
    public void beforeEntityAdded(@NonNull ScoreDirector<Solution_> scoreDirector, @NonNull Object entity) {
    }

    @Override
    public void afterEntityAdded(@NonNull ScoreDirector<Solution_> scoreDirector, @NonNull Object entity) {
        this.insert((InnerScoreDirector)scoreDirector, entity);
    }

    @Override
    public void beforeVariableChanged(@NonNull ScoreDirector<Solution_> scoreDirector, @NonNull Object entity) {
        this.retract((InnerScoreDirector)scoreDirector, entity);
    }

    @Override
    public void afterVariableChanged(@NonNull ScoreDirector<Solution_> scoreDirector, @NonNull Object entity) {
        this.insert((InnerScoreDirector)scoreDirector, entity);
    }

    @Override
    public void beforeEntityRemoved(@NonNull ScoreDirector<Solution_> scoreDirector, @NonNull Object entity) {
        this.retract((InnerScoreDirector)scoreDirector, entity);
    }

    @Override
    public void afterEntityRemoved(@NonNull ScoreDirector<Solution_> scoreDirector, @NonNull Object entity) {
    }

    protected void insert(InnerScoreDirector<Solution_, ?> scoreDirector, Object entity) {
        Object shadowEntity = this.sourceVariableDescriptor.getValue(entity);
        if (shadowEntity != null) {
            Object shadowValue = this.shadowVariableDescriptor.getValue(shadowEntity);
            if (scoreDirector.expectShadowVariablesInCorrectState() && shadowValue != null) {
                throw new IllegalStateException("The entity (" + String.valueOf(entity) + ") has a variable (" + this.sourceVariableDescriptor.getVariableName() + ") with value (" + String.valueOf(shadowEntity) + ") which has a sourceVariableName variable (" + this.shadowVariableDescriptor.getVariableName() + ") with a value (" + String.valueOf(shadowValue) + ") which is not null.\nVerify the consistency of your input problem for that sourceVariableName variable.");
            }
            scoreDirector.beforeVariableChanged(this.shadowVariableDescriptor, shadowEntity);
            this.shadowVariableDescriptor.setValue(shadowEntity, entity);
            scoreDirector.afterVariableChanged(this.shadowVariableDescriptor, shadowEntity);
        }
    }

    protected void retract(InnerScoreDirector<Solution_, ?> scoreDirector, Object entity) {
        Object shadowEntity = this.sourceVariableDescriptor.getValue(entity);
        if (shadowEntity != null) {
            Object shadowValue = this.shadowVariableDescriptor.getValue(shadowEntity);
            if (scoreDirector.expectShadowVariablesInCorrectState() && shadowValue != entity) {
                throw new IllegalStateException("The entity (" + String.valueOf(entity) + ") has a variable (" + this.sourceVariableDescriptor.getVariableName() + ") with value (" + String.valueOf(shadowEntity) + ") which has a sourceVariableName variable (" + this.shadowVariableDescriptor.getVariableName() + ") with a value (" + String.valueOf(shadowValue) + ") which is not that entity.\nVerify the consistency of your input problem for that sourceVariableName variable.");
            }
            scoreDirector.beforeVariableChanged(this.shadowVariableDescriptor, shadowEntity);
            this.shadowVariableDescriptor.setValue(shadowEntity, null);
            scoreDirector.afterVariableChanged(this.shadowVariableDescriptor, shadowEntity);
        }
    }

    @Override
    public Object getInverseSingleton(Object planningValue) {
        return this.shadowVariableDescriptor.getValue(planningValue);
    }
}

