/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.constructionheuristic;

import ai.timefold.solver.core.config.constructionheuristic.ConstructionHeuristicPhaseConfig;
import ai.timefold.solver.core.config.constructionheuristic.ConstructionHeuristicType;
import ai.timefold.solver.core.config.constructionheuristic.decider.forager.ConstructionHeuristicForagerConfig;
import ai.timefold.solver.core.config.constructionheuristic.placer.EntityPlacerConfig;
import ai.timefold.solver.core.config.constructionheuristic.placer.PooledEntityPlacerConfig;
import ai.timefold.solver.core.config.constructionheuristic.placer.QueuedEntityPlacerConfig;
import ai.timefold.solver.core.config.constructionheuristic.placer.QueuedValuePlacerConfig;
import ai.timefold.solver.core.config.heuristic.selector.common.SelectionCacheType;
import ai.timefold.solver.core.config.heuristic.selector.common.SelectionOrder;
import ai.timefold.solver.core.config.heuristic.selector.entity.EntitySorterManner;
import ai.timefold.solver.core.config.heuristic.selector.move.MoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.composite.CartesianProductMoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.composite.UnionMoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.generic.list.ListChangeMoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.value.ValueSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.value.ValueSorterManner;
import ai.timefold.solver.core.config.util.ConfigUtils;
import ai.timefold.solver.core.enterprise.TimefoldSolverEnterpriseService;
import ai.timefold.solver.core.impl.constructionheuristic.ConstructionHeuristicPhase;
import ai.timefold.solver.core.impl.constructionheuristic.DefaultConstructionHeuristicPhase;
import ai.timefold.solver.core.impl.constructionheuristic.decider.ConstructionHeuristicDecider;
import ai.timefold.solver.core.impl.constructionheuristic.decider.forager.ConstructionHeuristicForager;
import ai.timefold.solver.core.impl.constructionheuristic.decider.forager.ConstructionHeuristicForagerFactory;
import ai.timefold.solver.core.impl.constructionheuristic.placer.EntityPlacer;
import ai.timefold.solver.core.impl.constructionheuristic.placer.EntityPlacerFactory;
import ai.timefold.solver.core.impl.constructionheuristic.placer.PooledEntityPlacerFactory;
import ai.timefold.solver.core.impl.constructionheuristic.placer.QueuedEntityPlacerFactory;
import ai.timefold.solver.core.impl.constructionheuristic.placer.QueuedValuePlacerFactory;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.HeuristicConfigPolicy;
import ai.timefold.solver.core.impl.phase.AbstractPhaseFactory;
import ai.timefold.solver.core.impl.solver.recaller.BestSolutionRecaller;
import ai.timefold.solver.core.impl.solver.termination.PhaseTermination;
import ai.timefold.solver.core.impl.solver.termination.SolverTermination;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class DefaultConstructionHeuristicPhaseFactory<Solution_>
extends AbstractPhaseFactory<Solution_, ConstructionHeuristicPhaseConfig> {
    public DefaultConstructionHeuristicPhaseFactory(ConstructionHeuristicPhaseConfig phaseConfig) {
        super(phaseConfig);
    }

    public final DefaultConstructionHeuristicPhase.DefaultConstructionHeuristicPhaseBuilder<Solution_> getBuilder(int phaseIndex, boolean lastInitializingPhase, HeuristicConfigPolicy<Solution_> solverConfigPolicy, SolverTermination<Solution_> solverTermination) {
        ConstructionHeuristicType constructionHeuristicType_ = Objects.requireNonNullElse(((ConstructionHeuristicPhaseConfig)this.phaseConfig).getConstructionHeuristicType(), ConstructionHeuristicType.ALLOCATE_ENTITY_FROM_QUEUE);
        EntitySorterManner entitySorterManner = Objects.requireNonNullElse(((ConstructionHeuristicPhaseConfig)this.phaseConfig).getEntitySorterManner(), constructionHeuristicType_.getDefaultEntitySorterManner());
        ValueSorterManner valueSorterManner = Objects.requireNonNullElse(((ConstructionHeuristicPhaseConfig)this.phaseConfig).getValueSorterManner(), constructionHeuristicType_.getDefaultValueSorterManner());
        HeuristicConfigPolicy<Solution_> phaseConfigPolicy = solverConfigPolicy.cloneBuilder().withReinitializeVariableFilterEnabled(true).withInitializedChainedValueFilterEnabled(true).withUnassignedValuesAllowed(true).withEntitySorterManner(entitySorterManner).withValueSorterManner(valueSorterManner).build();
        EntityPlacerConfig entityPlacerConfig_ = this.getValidEntityPlacerConfig().orElseGet(() -> this.buildDefaultEntityPlacerConfig(phaseConfigPolicy, constructionHeuristicType_));
        EntityPlacer entityPlacer = EntityPlacerFactory.create(entityPlacerConfig_).buildEntityPlacer(phaseConfigPolicy);
        return this.createBuilder(phaseConfigPolicy, solverTermination, phaseIndex, lastInitializingPhase, entityPlacer);
    }

    protected DefaultConstructionHeuristicPhase.DefaultConstructionHeuristicPhaseBuilder<Solution_> createBuilder(HeuristicConfigPolicy<Solution_> phaseConfigPolicy, SolverTermination<Solution_> solverTermination, int phaseIndex, boolean lastInitializingPhase, EntityPlacer<Solution_> entityPlacer) {
        PhaseTermination<Solution_> phaseTermination = this.buildPhaseTermination(phaseConfigPolicy, solverTermination);
        return new DefaultConstructionHeuristicPhase.DefaultConstructionHeuristicPhaseBuilder<Solution_>(phaseIndex, lastInitializingPhase, phaseConfigPolicy.getLogIndentation(), phaseTermination, entityPlacer, this.buildDecider(phaseConfigPolicy, phaseTermination)).enableAssertions(phaseConfigPolicy.getEnvironmentMode());
    }

    @Override
    public ConstructionHeuristicPhase<Solution_> buildPhase(int phaseIndex, boolean lastInitializingPhase, HeuristicConfigPolicy<Solution_> solverConfigPolicy, BestSolutionRecaller<Solution_> bestSolutionRecaller, SolverTermination<Solution_> solverTermination) {
        return this.getBuilder(phaseIndex, lastInitializingPhase, solverConfigPolicy, solverTermination).build();
    }

    private Optional<EntityPlacerConfig<?>> getValidEntityPlacerConfig() {
        EntityPlacerConfig entityPlacerConfig = ((ConstructionHeuristicPhaseConfig)this.phaseConfig).getEntityPlacerConfig();
        if (entityPlacerConfig == null) {
            return Optional.empty();
        }
        if (((ConstructionHeuristicPhaseConfig)this.phaseConfig).getConstructionHeuristicType() != null) {
            throw new IllegalArgumentException("The constructionHeuristicType (%s) must not be configured if the entityPlacerConfig (%s) is explicitly configured.".formatted(new Object[]{((ConstructionHeuristicPhaseConfig)this.phaseConfig).getConstructionHeuristicType(), entityPlacerConfig}));
        }
        List<MoveSelectorConfig> moveSelectorConfigList = ((ConstructionHeuristicPhaseConfig)this.phaseConfig).getMoveSelectorConfigList();
        if (moveSelectorConfigList != null) {
            throw new IllegalArgumentException("The moveSelectorConfigList (%s) cannot be configured if the entityPlacerConfig (%s) is explicitly configured.".formatted(moveSelectorConfigList, entityPlacerConfig));
        }
        return Optional.of(entityPlacerConfig);
    }

    private EntityPlacerConfig<?> buildDefaultEntityPlacerConfig(HeuristicConfigPolicy<Solution_> configPolicy, ConstructionHeuristicType constructionHeuristicType) {
        return this.findValidListVariableDescriptor(configPolicy.getSolutionDescriptor()).map(listVariableDescriptor -> DefaultConstructionHeuristicPhaseFactory.buildListVariableQueuedValuePlacerConfig(configPolicy, listVariableDescriptor)).orElseGet(() -> this.buildUnfoldedEntityPlacerConfig(configPolicy, constructionHeuristicType));
    }

    private Optional<ListVariableDescriptor<?>> findValidListVariableDescriptor(SolutionDescriptor<Solution_> solutionDescriptor) {
        ListVariableDescriptor<Solution_> listVariableDescriptor = solutionDescriptor.getListVariableDescriptor();
        if (listVariableDescriptor == null) {
            return Optional.empty();
        }
        DefaultConstructionHeuristicPhaseFactory.failIfConfigured((Object)((ConstructionHeuristicPhaseConfig)this.phaseConfig).getConstructionHeuristicType(), "constructionHeuristicType");
        DefaultConstructionHeuristicPhaseFactory.failIfConfigured(((ConstructionHeuristicPhaseConfig)this.phaseConfig).getMoveSelectorConfigList(), "moveSelectorConfigList");
        if (listVariableDescriptor.getEntityDescriptor().hasAnyGenuineBasicVariables()) {
            throw new IllegalArgumentException("The entity (%s) has both basic and list variables and cannot be deduced automatically.\nMaybe customize the phase configuration and add separate construction heuristic phases for each variable.".formatted(listVariableDescriptor.getEntityDescriptor().getEntityClass()));
        }
        return Optional.of(listVariableDescriptor);
    }

    private static void failIfConfigured(Object configValue, String configName) {
        if (configValue != null) {
            throw new IllegalArgumentException("Construction Heuristic phase with a list variable does not support " + configName + " configuration. Remove the " + configName + " (" + String.valueOf(configValue) + ") from the config.");
        }
    }

    public static EntityPlacerConfig buildListVariableQueuedValuePlacerConfig(HeuristicConfigPolicy<?> configPolicy, ListVariableDescriptor<?> variableDescriptor) {
        String mimicSelectorId = variableDescriptor.getVariableName();
        ValueSelectorConfig mimicRecordingValueSelectorConfig = new ValueSelectorConfig(variableDescriptor.getVariableName()).withId(mimicSelectorId);
        if (ValueSelectorConfig.hasSorter(configPolicy.getValueSorterManner(), variableDescriptor)) {
            mimicRecordingValueSelectorConfig = mimicRecordingValueSelectorConfig.withCacheType(SelectionCacheType.PHASE).withSelectionOrder(SelectionOrder.SORTED).withSorterManner(configPolicy.getValueSorterManner());
        }
        ValueSelectorConfig mimicReplayingValueSelectorConfig = new ValueSelectorConfig().withMimicSelectorRef(mimicSelectorId).withVariableName(variableDescriptor.getVariableName());
        ListChangeMoveSelectorConfig listChangeMoveSelectorConfig = new ListChangeMoveSelectorConfig().withValueSelectorConfig(mimicReplayingValueSelectorConfig);
        return new QueuedValuePlacerConfig().withEntityClass(variableDescriptor.getEntityDescriptor().getEntityClass()).withValueSelectorConfig(mimicRecordingValueSelectorConfig).withMoveSelectorConfig(listChangeMoveSelectorConfig);
    }

    protected ConstructionHeuristicDecider<Solution_> buildDecider(HeuristicConfigPolicy<Solution_> configPolicy, PhaseTermination<Solution_> termination) {
        ConstructionHeuristicForager<Solution_> forager = this.buildForager(configPolicy);
        Integer moveThreadCount = configPolicy.getMoveThreadCount();
        ConstructionHeuristicDecider<Solution_> decider = moveThreadCount == null ? new ConstructionHeuristicDecider<Solution_>(configPolicy.getLogIndentation(), termination, forager) : TimefoldSolverEnterpriseService.loadOrFail(TimefoldSolverEnterpriseService.Feature.MULTITHREADED_SOLVING).buildConstructionHeuristic(termination, forager, configPolicy);
        decider.enableAssertions(configPolicy.getEnvironmentMode());
        return decider;
    }

    protected ConstructionHeuristicForager<Solution_> buildForager(HeuristicConfigPolicy<Solution_> configPolicy) {
        ConstructionHeuristicForagerConfig foragerConfig_ = Objects.requireNonNullElseGet(((ConstructionHeuristicPhaseConfig)this.phaseConfig).getForagerConfig(), ConstructionHeuristicForagerConfig::new);
        return ConstructionHeuristicForagerFactory.create(foragerConfig_).buildForager(configPolicy);
    }

    private EntityPlacerConfig<?> buildUnfoldedEntityPlacerConfig(HeuristicConfigPolicy<Solution_> phaseConfigPolicy, ConstructionHeuristicType constructionHeuristicType) {
        return switch (constructionHeuristicType) {
            default -> throw new IncompatibleClassChangeError();
            case ConstructionHeuristicType.FIRST_FIT, ConstructionHeuristicType.FIRST_FIT_DECREASING, ConstructionHeuristicType.WEAKEST_FIT, ConstructionHeuristicType.WEAKEST_FIT_DECREASING, ConstructionHeuristicType.STRONGEST_FIT, ConstructionHeuristicType.STRONGEST_FIT_DECREASING, ConstructionHeuristicType.ALLOCATE_ENTITY_FROM_QUEUE -> {
                if (!ConfigUtils.isEmptyCollection(((ConstructionHeuristicPhaseConfig)this.phaseConfig).getMoveSelectorConfigList())) {
                    yield QueuedEntityPlacerFactory.unfoldNew(phaseConfigPolicy, ((ConstructionHeuristicPhaseConfig)this.phaseConfig).getMoveSelectorConfigList());
                }
                yield new QueuedEntityPlacerConfig();
            }
            case ConstructionHeuristicType.ALLOCATE_TO_VALUE_FROM_QUEUE -> {
                if (!ConfigUtils.isEmptyCollection(((ConstructionHeuristicPhaseConfig)this.phaseConfig).getMoveSelectorConfigList())) {
                    yield QueuedValuePlacerFactory.unfoldNew(this.checkSingleMoveSelectorConfig());
                }
                yield new QueuedValuePlacerConfig();
            }
            case ConstructionHeuristicType.CHEAPEST_INSERTION, ConstructionHeuristicType.ALLOCATE_FROM_POOL -> !ConfigUtils.isEmptyCollection(((ConstructionHeuristicPhaseConfig)this.phaseConfig).getMoveSelectorConfigList()) ? PooledEntityPlacerFactory.unfoldNew(phaseConfigPolicy, this.checkSingleMoveSelectorConfig()) : new PooledEntityPlacerConfig();
        };
    }

    private MoveSelectorConfig<?> checkSingleMoveSelectorConfig() {
        List<MoveSelectorConfig> moveSelectorConfigList = Objects.requireNonNull(((ConstructionHeuristicPhaseConfig)this.phaseConfig).getMoveSelectorConfigList());
        if (moveSelectorConfigList.size() != 1) {
            throw new IllegalArgumentException("For the constructionHeuristicType (%s), the moveSelectorConfigList (%s) must be a singleton.\nUse a single %s or %s element to nest multiple MoveSelectors.".formatted(new Object[]{((ConstructionHeuristicPhaseConfig)this.phaseConfig).getConstructionHeuristicType(), ((ConstructionHeuristicPhaseConfig)this.phaseConfig).getMoveSelectorConfigList(), UnionMoveSelectorConfig.class.getSimpleName(), CartesianProductMoveSelectorConfig.class.getSimpleName()}));
        }
        return moveSelectorConfigList.get(0);
    }
}

