/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.common;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.stream.Constraint;
import ai.timefold.solver.core.api.score.stream.ConstraintBuilder;
import ai.timefold.solver.core.impl.score.stream.common.ConstraintConstructor;
import ai.timefold.solver.core.impl.score.stream.common.ScoreImpactType;
import java.util.Objects;
import org.jspecify.annotations.NonNull;

public abstract class AbstractConstraintBuilder<Score_ extends Score<Score_>>
implements ConstraintBuilder {
    private final ConstraintConstructor constraintConstructor;
    private final ScoreImpactType impactType;
    private final Score_ constraintWeight;

    protected AbstractConstraintBuilder(ConstraintConstructor constraintConstructor, ScoreImpactType impactType, Score_ constraintWeight) {
        this.constraintConstructor = Objects.requireNonNull(constraintConstructor);
        this.impactType = Objects.requireNonNull(impactType);
        this.constraintWeight = constraintWeight;
    }

    protected abstract <JustificationMapping_> JustificationMapping_ getJustificationMapping();

    protected abstract <IndictedObjectsMapping_> IndictedObjectsMapping_ getIndictedObjectsMapping();

    @Override
    public final @NonNull Constraint asConstraintDescribed(@NonNull String constraintName, @NonNull String constraintDescription, @NonNull String constraintGroup) {
        return this.constraintConstructor.apply(null, constraintName, constraintDescription, constraintGroup, this.constraintWeight, this.impactType, this.getJustificationMapping(), this.getIndictedObjectsMapping());
    }

    @Override
    public final Constraint asConstraint(String constraintPackage, String constraintName) {
        return this.constraintConstructor.apply(constraintPackage, constraintName, "", "default", this.constraintWeight, this.impactType, this.getJustificationMapping(), this.getIndictedObjectsMapping());
    }
}

