/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.buildin;

import ai.timefold.solver.core.api.score.buildin.bendablebigdecimal.BendableBigDecimalScore;
import ai.timefold.solver.core.impl.score.definition.AbstractBendableScoreDefinition;
import ai.timefold.solver.core.impl.score.trend.InitializingScoreTrend;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.stream.Stream;

public class BendableBigDecimalScoreDefinition
extends AbstractBendableScoreDefinition<BendableBigDecimalScore> {
    public BendableBigDecimalScoreDefinition(int hardLevelsSize, int softLevelsSize) {
        super(hardLevelsSize, softLevelsSize);
    }

    @Override
    public Class<BendableBigDecimalScore> getScoreClass() {
        return BendableBigDecimalScore.class;
    }

    @Override
    public BendableBigDecimalScore getZeroScore() {
        return BendableBigDecimalScore.zero(this.hardLevelsSize, this.softLevelsSize);
    }

    @Override
    public final BendableBigDecimalScore getOneSoftestScore() {
        return BendableBigDecimalScore.ofSoft(this.hardLevelsSize, this.softLevelsSize, this.softLevelsSize - 1, BigDecimal.ONE);
    }

    @Override
    public BendableBigDecimalScore parseScore(String scoreString) {
        BendableBigDecimalScore score = BendableBigDecimalScore.parseScore(scoreString);
        if (score.hardLevelsSize() != this.hardLevelsSize) {
            throw new IllegalArgumentException("The scoreString (" + scoreString + ") for the scoreClass (" + BendableBigDecimalScore.class.getSimpleName() + ") doesn't follow the correct pattern: the hardLevelsSize (" + score.hardLevelsSize() + ") doesn't match the scoreDefinition's hardLevelsSize (" + this.hardLevelsSize + ").");
        }
        if (score.softLevelsSize() != this.softLevelsSize) {
            throw new IllegalArgumentException("The scoreString (" + scoreString + ") for the scoreClass (" + BendableBigDecimalScore.class.getSimpleName() + ") doesn't follow the correct pattern: the softLevelsSize (" + score.softLevelsSize() + ") doesn't match the scoreDefinition's softLevelsSize (" + this.softLevelsSize + ").");
        }
        return score;
    }

    @Override
    public BendableBigDecimalScore fromLevelNumbers(Number[] levelNumbers) {
        if (levelNumbers.length != this.getLevelsSize()) {
            throw new IllegalStateException("The levelNumbers (" + Arrays.toString(levelNumbers) + ")'s length (" + levelNumbers.length + ") must equal the levelSize (" + this.getLevelsSize() + ").");
        }
        BigDecimal[] hardScores = new BigDecimal[this.hardLevelsSize];
        for (int i = 0; i < this.hardLevelsSize; ++i) {
            hardScores[i] = (BigDecimal)levelNumbers[i];
        }
        BigDecimal[] softScores = new BigDecimal[this.softLevelsSize];
        for (int i = 0; i < this.softLevelsSize; ++i) {
            softScores[i] = (BigDecimal)levelNumbers[this.hardLevelsSize + i];
        }
        return BendableBigDecimalScore.of(hardScores, softScores);
    }

    public BendableBigDecimalScore createScore(BigDecimal ... scores) {
        int levelsSize = this.hardLevelsSize + this.softLevelsSize;
        if (scores.length != levelsSize) {
            throw new IllegalArgumentException("The scores (" + Arrays.toString(scores) + ")'s length (" + scores.length + ") is not levelsSize (" + levelsSize + ").");
        }
        return BendableBigDecimalScore.of(Arrays.copyOfRange(scores, 0, this.hardLevelsSize), Arrays.copyOfRange(scores, this.hardLevelsSize, levelsSize));
    }

    @Override
    public BendableBigDecimalScore buildOptimisticBound(InitializingScoreTrend initializingScoreTrend, BendableBigDecimalScore score) {
        throw new UnsupportedOperationException("BigDecimalScore does not support bounds because a BigDecimal cannot represent infinity.");
    }

    @Override
    public BendableBigDecimalScore buildPessimisticBound(InitializingScoreTrend initializingScoreTrend, BendableBigDecimalScore score) {
        throw new UnsupportedOperationException("BigDecimalScore does not support bounds because a BigDecimal cannot represent infinity.");
    }

    @Override
    public BendableBigDecimalScore divideBySanitizedDivisor(BendableBigDecimalScore dividend, BendableBigDecimalScore divisor) {
        BigDecimal[] hardScores = new BigDecimal[this.hardLevelsSize];
        for (int i = 0; i < this.hardLevelsSize; ++i) {
            hardScores[i] = BendableBigDecimalScoreDefinition.divide(dividend.hardScore(i), BendableBigDecimalScoreDefinition.sanitize(divisor.hardScore(i)));
        }
        BigDecimal[] softScores = new BigDecimal[this.softLevelsSize];
        for (int i = 0; i < this.softLevelsSize; ++i) {
            softScores[i] = BendableBigDecimalScoreDefinition.divide(dividend.softScore(i), BendableBigDecimalScoreDefinition.sanitize(divisor.softScore(i)));
        }
        BigDecimal[] levels = (BigDecimal[])Stream.concat(Arrays.stream(hardScores), Arrays.stream(softScores)).toArray(BigDecimal[]::new);
        return this.createScore(levels);
    }

    @Override
    public Class<?> getNumericType() {
        return BigDecimal.class;
    }
}

