/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.collector;

import ai.timefold.solver.core.impl.score.stream.collector.ToMapPerKeyCounter;
import ai.timefold.solver.core.impl.score.stream.collector.ToMapResultContainer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.function.Supplier;

public final class ToMultiMapResultContainer<Key_, Value_, Set_ extends Set<Value_>, Result_ extends Map<Key_, Set_>>
implements ToMapResultContainer<Key_, Value_, Set_, Result_> {
    private final Supplier<Set_> setSupplier;
    private final Result_ result;
    private final Map<Key_, ToMapPerKeyCounter<Value_>> valueCounts = new HashMap<Key_, ToMapPerKeyCounter<Value_>>(0);

    public ToMultiMapResultContainer(Supplier<Result_> resultSupplier, IntFunction<Set_> setFunction) {
        IntFunction nonNullSetFunction = Objects.requireNonNull(setFunction);
        this.setSupplier = () -> (Set)nonNullSetFunction.apply(0);
        this.result = (Map)Objects.requireNonNull(resultSupplier).get();
    }

    public ToMultiMapResultContainer(IntFunction<Result_> resultFunction, IntFunction<Set_> setFunction) {
        IntFunction nonNullSetFunction = Objects.requireNonNull(setFunction);
        this.setSupplier = () -> (Set)nonNullSetFunction.apply(0);
        this.result = (Map)Objects.requireNonNull(resultFunction).apply(0);
    }

    @Override
    public void add(Key_ key, Value_ value) {
        ToMapPerKeyCounter counter = this.valueCounts.computeIfAbsent(key, k -> new ToMapPerKeyCounter());
        counter.add(value);
        this.result.computeIfAbsent(key, k -> (Set)this.setSupplier.get()).add(value);
    }

    @Override
    public void remove(Key_ key, Value_ value) {
        ToMapPerKeyCounter<Value_> counter = this.valueCounts.get(key);
        long newCount = counter.remove(value);
        if (newCount == 0L) {
            ((Set)this.result.get(key)).remove(value);
        }
        if (counter.isEmpty()) {
            this.valueCounts.remove(key);
            this.result.remove(key);
        }
    }

    @Override
    public Result_ getResult() {
        return this.result;
    }
}

