/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.director;

import ai.timefold.solver.core.api.domain.valuerange.CountableValueRange;
import ai.timefold.solver.core.api.domain.valuerange.ValueRange;
import ai.timefold.solver.core.api.solver.ProblemSizeStatistics;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.solution.descriptor.ProblemScaleTracker;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.domain.valuerange.buildin.bigdecimal.BigDecimalValueRange;
import ai.timefold.solver.core.impl.domain.valuerange.buildin.composite.NullAllowingCountableValueRange;
import ai.timefold.solver.core.impl.domain.valuerange.buildin.primdouble.DoubleValueRange;
import ai.timefold.solver.core.impl.domain.valuerange.descriptor.ValueRangeDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.BasicVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.VariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.selector.common.ReachableValues;
import ai.timefold.solver.core.impl.score.director.SolutionInitializationStatistics;
import ai.timefold.solver.core.impl.util.MathUtils;
import ai.timefold.solver.core.impl.util.MutableInt;
import ai.timefold.solver.core.impl.util.MutableLong;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class ValueRangeManager<Solution_> {
    private final SolutionDescriptor<Solution_> solutionDescriptor;
    private final Map<ValueRangeDescriptor<Solution_>, CountableValueRange<?>> fromSolutionMap = new IdentityHashMap();
    private final Map<Object, Map<ValueRangeDescriptor<Solution_>, CountableValueRange<?>>> fromEntityMap = new IdentityHashMap();
    private @Nullable ReachableValues reachableValues = null;
    private @Nullable Solution_ cachedWorkingSolution = null;
    private @Nullable SolutionInitializationStatistics cachedInitializationStatistics = null;
    private @Nullable ProblemSizeStatistics cachedProblemSizeStatistics = null;

    public static <Solution_> ValueRangeManager<Solution_> of(SolutionDescriptor<Solution_> solutionDescriptor, Solution_ solution) {
        ValueRangeManager<Solution_> valueRangeManager = new ValueRangeManager<Solution_>(solutionDescriptor);
        valueRangeManager.reset(solution);
        return valueRangeManager;
    }

    public ValueRangeManager(SolutionDescriptor<Solution_> solutionDescriptor) {
        this.solutionDescriptor = Objects.requireNonNull(solutionDescriptor);
    }

    public SolutionInitializationStatistics getInitializationStatistics() {
        if (this.cachedWorkingSolution == null) {
            throw new IllegalStateException("Impossible state: initialization statistics requested before the working solution is known.");
        }
        return this.getInitializationStatistics(null);
    }

    public SolutionInitializationStatistics getInitializationStatistics(@Nullable Consumer<Object> finisher) {
        if (this.cachedWorkingSolution == null) {
            throw new IllegalStateException("Impossible state: initialization statistics requested before the working solution is known.");
        }
        if (finisher == null) {
            if (this.cachedInitializationStatistics == null) {
                this.cachedInitializationStatistics = this.computeInitializationStatistics(this.cachedWorkingSolution, null);
            }
        } else {
            this.cachedInitializationStatistics = this.computeInitializationStatistics(this.cachedWorkingSolution, finisher);
        }
        return this.cachedInitializationStatistics;
    }

    public SolutionInitializationStatistics computeInitializationStatistics(Solution_ solution, @Nullable Consumer<Object> finisher) {
        MutableInt uninitializedEntityCount = new MutableInt();
        MutableInt uninitializedVariableCount = new MutableInt();
        MutableInt unassignedValueCount = new MutableInt();
        MutableInt notInAnyListValueCount = new MutableInt();
        MutableInt genuineEntityCount = new MutableInt();
        MutableInt shadowEntityCount = new MutableInt();
        ListVariableDescriptor<Solution_> listVariableDescriptor = this.solutionDescriptor.getListVariableDescriptor();
        if (listVariableDescriptor != null) {
            int countOnSolution = (int)this.countOnSolution(listVariableDescriptor.getValueRangeDescriptor(), solution);
            notInAnyListValueCount.add(countOnSolution);
            if (!listVariableDescriptor.allowsUnassignedValues()) {
                unassignedValueCount.add(countOnSolution);
            }
        }
        this.solutionDescriptor.visitAllEntities(solution, entity -> {
            EntityDescriptor<Solution_> entityDescriptor = this.solutionDescriptor.findEntityDescriptorOrFail(entity.getClass());
            if (entityDescriptor.isGenuine()) {
                genuineEntityCount.increment();
                int uninitializedVariableCountForEntity = entityDescriptor.countUninitializedVariables(entity);
                if (uninitializedVariableCountForEntity > 0) {
                    uninitializedEntityCount.increment();
                    uninitializedVariableCount.add(uninitializedVariableCountForEntity);
                }
            } else {
                shadowEntityCount.increment();
            }
            if (finisher != null) {
                finisher.accept(entity);
            }
            if (!entityDescriptor.hasAnyGenuineListVariables()) {
                return;
            }
            EntityDescriptor listVariableEntityDescriptor = listVariableDescriptor.getEntityDescriptor();
            int countOnEntity = listVariableDescriptor.getListSize(entity);
            notInAnyListValueCount.subtract(countOnEntity);
            if (!listVariableDescriptor.allowsUnassignedValues() && listVariableEntityDescriptor.matchesEntity(entity)) {
                unassignedValueCount.subtract(countOnEntity);
            }
        });
        return new SolutionInitializationStatistics(genuineEntityCount.intValue(), shadowEntityCount.intValue(), uninitializedEntityCount.intValue(), uninitializedVariableCount.intValue(), unassignedValueCount.intValue(), notInAnyListValueCount.intValue());
    }

    public ProblemSizeStatistics getProblemSizeStatistics() {
        if (this.cachedWorkingSolution == null) {
            throw new IllegalStateException("Impossible state: problem size requested before the working solution is known.");
        }
        if (this.cachedProblemSizeStatistics == null) {
            this.cachedProblemSizeStatistics = new ProblemSizeStatistics(this.solutionDescriptor.getGenuineEntityCount(this.cachedWorkingSolution), this.solutionDescriptor.getGenuineVariableCount(this.cachedWorkingSolution), this.getApproximateValueCount(), this.getProblemScale());
        }
        return this.cachedProblemSizeStatistics;
    }

    long getApproximateValueCount() {
        Set<GenuineVariableDescriptor> genuineVariableDescriptorSet = Collections.newSetFromMap(new IdentityHashMap());
        this.solutionDescriptor.visitAllEntities(this.cachedWorkingSolution, entity -> {
            EntityDescriptor<Solution_> entityDescriptor = this.solutionDescriptor.findEntityDescriptorOrFail(entity.getClass());
            if (entityDescriptor.isGenuine()) {
                genuineVariableDescriptorSet.addAll(entityDescriptor.getGenuineVariableDescriptorList());
            }
        });
        MutableLong out = new MutableLong();
        for (GenuineVariableDescriptor variableDescriptor : genuineVariableDescriptorSet) {
            ValueRangeDescriptor valueRangeDescriptor = variableDescriptor.getValueRangeDescriptor();
            if (valueRangeDescriptor.canExtractValueRangeFromSolution()) {
                out.add(this.countOnSolution(valueRangeDescriptor, this.cachedWorkingSolution));
                continue;
            }
            this.solutionDescriptor.visitEntitiesByEntityClass(this.cachedWorkingSolution, variableDescriptor.getEntityDescriptor().getEntityClass(), entity -> {
                out.add(this.countOnEntity(valueRangeDescriptor, entity));
                return false;
            });
        }
        return out.longValue();
    }

    double getProblemScale() {
        double scale;
        long logBase = Math.max(2L, this.getMaximumValueRangeSize());
        ProblemScaleTracker problemScaleTracker = new ProblemScaleTracker(logBase);
        this.solutionDescriptor.visitAllEntities(this.cachedWorkingSolution, entity -> {
            EntityDescriptor<Solution_> entityDescriptor = this.solutionDescriptor.findEntityDescriptorOrFail(entity.getClass());
            if (entityDescriptor.isGenuine()) {
                this.processProblemScale(entityDescriptor, entity, problemScaleTracker);
            }
        });
        long result = problemScaleTracker.getBasicProblemScaleLog();
        if ((long)problemScaleTracker.getListTotalEntityCount() != 0L) {
            int totalListValueCount = problemScaleTracker.getListTotalValueCount();
            int totalListMovableValueCount = totalListValueCount - problemScaleTracker.getListPinnedValueCount();
            int possibleTargetsForListValue = problemScaleTracker.getListMovableEntityCount();
            ListVariableDescriptor<Solution_> listVariableDescriptor = this.solutionDescriptor.getListVariableDescriptor();
            if (listVariableDescriptor != null && listVariableDescriptor.allowsUnassignedValues()) {
                ++possibleTargetsForListValue;
            }
            result += MathUtils.getPossibleArrangementsScaledApproximateLog(1000000L, logBase, totalListMovableValueCount, possibleTargetsForListValue);
        }
        if (Double.isNaN(scale = (double)result / 1000000.0 / MathUtils.getLogInBase(logBase, 10.0)) || Double.isInfinite(scale)) {
            return 0.0;
        }
        return scale;
    }

    long getMaximumValueRangeSize() {
        return this.solutionDescriptor.extractAllEntitiesStream(this.cachedWorkingSolution).mapToLong(entity -> {
            EntityDescriptor<Solution_> entityDescriptor = this.solutionDescriptor.findEntityDescriptorOrFail(entity.getClass());
            return entityDescriptor.isGenuine() ? this.getMaximumValueCount(entityDescriptor, entity) : 0L;
        }).max().orElse(0L);
    }

    private long getMaximumValueCount(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
        long maximumValueCount = 0L;
        for (GenuineVariableDescriptor<Solution_> variableDescriptor : entityDescriptor.getGenuineVariableDescriptorList()) {
            if (variableDescriptor.canExtractValueRangeFromSolution()) {
                maximumValueCount = Math.max(maximumValueCount, this.countOnSolution(variableDescriptor.getValueRangeDescriptor(), this.cachedWorkingSolution));
                continue;
            }
            maximumValueCount = Math.max(maximumValueCount, this.countOnEntity(variableDescriptor.getValueRangeDescriptor(), entity));
        }
        return maximumValueCount;
    }

    private void processProblemScale(EntityDescriptor<Solution_> entityDescriptor, Object entity, ProblemScaleTracker tracker) {
        for (GenuineVariableDescriptor<Solution_> variableDescriptor : entityDescriptor.getGenuineVariableDescriptorList()) {
            long valueCount;
            long l = valueCount = variableDescriptor.canExtractValueRangeFromSolution() ? this.countOnSolution(variableDescriptor.getValueRangeDescriptor(), this.cachedWorkingSolution) : this.countOnEntity(variableDescriptor.getValueRangeDescriptor(), entity);
            if (variableDescriptor instanceof BasicVariableDescriptor) {
                BasicVariableDescriptor basicVariableDescriptor = (BasicVariableDescriptor)variableDescriptor;
                if (basicVariableDescriptor.isChained()) {
                    tracker.addListValueCount(1);
                    if (!entityDescriptor.isMovable(this.cachedWorkingSolution, entity)) {
                        tracker.addPinnedListValueCount(1);
                    }
                    CountableValueRange valueRange = variableDescriptor.canExtractValueRangeFromSolution() ? this.getFromSolution(variableDescriptor.getValueRangeDescriptor(), this.cachedWorkingSolution) : this.getFromEntity(variableDescriptor.getValueRangeDescriptor(), entity);
                    Iterator valueIterator = valueRange.createOriginalIterator();
                    while (valueIterator.hasNext()) {
                        Object value = valueIterator.next();
                        if (!variableDescriptor.isValuePotentialAnchor(value) || tracker.isAnchorVisited(value)) continue;
                        tracker.incrementListEntityCount(true);
                    }
                    continue;
                }
                if (!entityDescriptor.isMovable(this.cachedWorkingSolution, entity)) continue;
                tracker.addBasicProblemScale(valueCount);
                continue;
            }
            if (variableDescriptor instanceof ListVariableDescriptor) {
                ListVariableDescriptor listVariableDescriptor = (ListVariableDescriptor)variableDescriptor;
                long size = this.countOnSolution(listVariableDescriptor.getValueRangeDescriptor(), this.cachedWorkingSolution);
                tracker.setListTotalValueCount((int)size);
                if (entityDescriptor.isMovable(this.cachedWorkingSolution, entity)) {
                    tracker.incrementListEntityCount(true);
                    tracker.addPinnedListValueCount(listVariableDescriptor.getFirstUnpinnedIndex(entity));
                    continue;
                }
                tracker.incrementListEntityCount(false);
                tracker.addPinnedListValueCount(listVariableDescriptor.getListSize(entity));
                continue;
            }
            throw new IllegalStateException("Unhandled subclass of %s encountered (%s).".formatted(VariableDescriptor.class.getSimpleName(), variableDescriptor.getClass().getSimpleName()));
        }
    }

    public <T> CountableValueRange<T> getFromSolution(ValueRangeDescriptor<Solution_> valueRangeDescriptor) {
        if (this.cachedWorkingSolution == null) {
            throw new IllegalStateException("Impossible state: value range (%s) requested before the working solution is known.".formatted(valueRangeDescriptor));
        }
        return this.getFromSolution(valueRangeDescriptor, this.cachedWorkingSolution);
    }

    public <T> CountableValueRange<T> getFromSolution(ValueRangeDescriptor<Solution_> valueRangeDescriptor, Solution_ solution) {
        NullAllowingCountableValueRange valueRange = this.fromSolutionMap.get(valueRangeDescriptor);
        if (valueRange == null) {
            ValueRange extractedValueRange = valueRangeDescriptor.extractAllValues(Objects.requireNonNull(solution));
            if (!(extractedValueRange instanceof CountableValueRange)) {
                throw new UnsupportedOperationException("Impossible state: value range (%s) on planning solution (%s) is not countable.\nMaybe replace %s with %s.".formatted(valueRangeDescriptor, solution, DoubleValueRange.class.getSimpleName(), BigDecimalValueRange.class.getSimpleName()));
            }
            NullAllowingCountableValueRange countableValueRange = (NullAllowingCountableValueRange)extractedValueRange;
            valueRange = valueRangeDescriptor.acceptsNullInValueRange() ? new NullAllowingCountableValueRange(countableValueRange) : countableValueRange;
            this.fromSolutionMap.put(valueRangeDescriptor, valueRange);
        }
        return valueRange;
    }

    public <T> CountableValueRange<T> getFromEntity(ValueRangeDescriptor<Solution_> valueRangeDescriptor, Object entity) {
        if (this.cachedWorkingSolution == null) {
            throw new IllegalStateException("Impossible state: value range (%s) on planning entity (%s) requested before the working solution is known.".formatted(valueRangeDescriptor, entity));
        }
        Map valueRangeMap = this.fromEntityMap.computeIfAbsent(entity, e -> new IdentityHashMap());
        CountableValueRange valueRange = (NullAllowingCountableValueRange)valueRangeMap.get(valueRangeDescriptor);
        if (valueRange == null) {
            ValueRange extractedValueRange = valueRangeDescriptor.extractValuesFromEntity(this.cachedWorkingSolution, Objects.requireNonNull(entity));
            if (!(extractedValueRange instanceof CountableValueRange)) {
                throw new UnsupportedOperationException("Impossible state: value range (%s) on planning entity (%s) is not countable.\nMaybe replace %s with %s.".formatted(valueRangeDescriptor, entity, DoubleValueRange.class.getSimpleName(), BigDecimalValueRange.class.getSimpleName()));
            }
            CountableValueRange countableValueRange = (CountableValueRange)extractedValueRange;
            valueRange = valueRangeDescriptor.acceptsNullInValueRange() ? new NullAllowingCountableValueRange(countableValueRange) : countableValueRange;
            valueRangeMap.put(valueRangeDescriptor, valueRange);
        }
        return valueRange;
    }

    public long countOnSolution(ValueRangeDescriptor<Solution_> valueRangeDescriptor, Solution_ solution) {
        return this.getFromSolution(valueRangeDescriptor, solution).getSize();
    }

    public long countOnEntity(ValueRangeDescriptor<Solution_> valueRangeDescriptor, Object entity) {
        return this.getFromEntity(valueRangeDescriptor, entity).getSize();
    }

    public ReachableValues getReachableValues(ListVariableDescriptor<Solution_> listVariableDescriptor) {
        if (this.reachableValues == null) {
            if (this.cachedWorkingSolution == null) {
                throw new IllegalStateException("Impossible state: value reachability requested before the working solution is known.");
            }
            EntityDescriptor<Solution_> entityDescriptor = listVariableDescriptor.getEntityDescriptor();
            List<Object> entityList = entityDescriptor.extractEntities(this.cachedWorkingSolution);
            CountableValueRange allValues = this.getFromSolution(listVariableDescriptor.getValueRangeDescriptor());
            long valuesSize = allValues.getSize();
            if (valuesSize > Integer.MAX_VALUE) {
                throw new IllegalStateException("The matrix %s cannot be built for the entity %s (%s) because value range has a size (%d) which is higher than Integer.MAX_VALUE.".formatted(ReachableValues.class.getSimpleName(), entityDescriptor.getEntityClass().getSimpleName(), listVariableDescriptor.getVariableName(), valuesSize));
            }
            IdentityHashMap<Object, Set<Object>> entityMatrix = new IdentityHashMap<Object, Set<Object>>((int)valuesSize);
            IdentityHashMap<Object, Set<Object>> valueMatrix = new IdentityHashMap<Object, Set<Object>>((int)valuesSize);
            for (Object entity : entityList) {
                Iterator valuesIterator = allValues.createOriginalIterator();
                CountableValueRange<Object> range = this.getFromEntity(listVariableDescriptor.getValueRangeDescriptor(), entity);
                while (valuesIterator.hasNext()) {
                    Object value = valuesIterator.next();
                    if (!range.contains(value)) continue;
                    ValueRangeManager.updateEntityMap(entityMatrix, entity, value, entityList.size());
                    ValueRangeManager.updateValueMap(valueMatrix, range, value, (int)valuesSize);
                }
            }
            this.reachableValues = new ReachableValues(entityMatrix, valueMatrix);
        }
        return this.reachableValues;
    }

    private static void updateEntityMap(Map<Object, Set<Object>> entityMatrix, Object entity, Object value, int entityListSize) {
        Set<Object> entitySet = entityMatrix.get(value);
        if (entitySet == null) {
            entitySet = new LinkedHashSet<Object>(entityListSize);
            entityMatrix.put(value, entitySet);
        }
        entitySet.add(entity);
    }

    private static void updateValueMap(Map<Object, Set<Object>> valueMatrix, CountableValueRange<Object> range, Object value, int valueListSize) {
        Set<Object> reachableValues = valueMatrix.get(value);
        if (reachableValues == null) {
            reachableValues = new LinkedHashSet<Object>(valueListSize);
            valueMatrix.put(value, reachableValues);
        }
        Iterator<Object> entityValuesIterator = range.createOriginalIterator();
        while (entityValuesIterator.hasNext()) {
            Object entityValue = entityValuesIterator.next();
            if (Objects.equals(entityValue, value)) continue;
            reachableValues.add(entityValue);
        }
    }

    public void reset(@Nullable Solution_ workingSolution) {
        this.fromSolutionMap.clear();
        this.fromEntityMap.clear();
        this.reachableValues = null;
        if (workingSolution != null) {
            this.cachedWorkingSolution = workingSolution;
            this.cachedInitializationStatistics = null;
            this.cachedProblemSizeStatistics = null;
        }
    }
}

