/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.move.streams.maybeapi.generic.move;

import ai.timefold.solver.core.impl.move.streams.maybeapi.generic.move.AbstractMove;
import ai.timefold.solver.core.preview.api.domain.metamodel.PlanningListVariableMetaModel;
import ai.timefold.solver.core.preview.api.domain.metamodel.VariableMetaModel;
import ai.timefold.solver.core.preview.api.move.MutableSolutionView;
import ai.timefold.solver.core.preview.api.move.Rebaser;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class ListChangeMove<Solution_, Entity_, Value_>
extends AbstractMove<Solution_> {
    private final PlanningListVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel;
    private final Entity_ sourceEntity;
    private final int sourceIndex;
    private final Entity_ destinationEntity;
    private final int destinationIndex;
    private @Nullable Value_ planningValue;

    public ListChangeMove(PlanningListVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel, Entity_ sourceEntity, int sourceIndex, Entity_ destinationEntity, int destinationIndex) {
        this.variableMetaModel = Objects.requireNonNull(variableMetaModel);
        this.sourceEntity = Objects.requireNonNull(sourceEntity);
        if (sourceIndex < 0) {
            throw new IllegalArgumentException("The sourceIndex (" + sourceIndex + ") must be greater than 0.");
        }
        this.sourceIndex = sourceIndex;
        this.destinationEntity = Objects.requireNonNull(destinationEntity);
        if (destinationIndex < 0) {
            throw new IllegalArgumentException("The destinationIndex (" + destinationIndex + ") must be greater than 0.");
        }
        this.destinationIndex = destinationIndex;
    }

    private Value_ getMovedValue() {
        if (this.planningValue == null) {
            this.planningValue = ListChangeMove.getVariableDescriptor(this.variableMetaModel).getValue(this.sourceEntity).get(this.sourceIndex);
        }
        return this.planningValue;
    }

    @Override
    public void execute(MutableSolutionView<Solution_> solutionView) {
        this.planningValue = this.sourceEntity == this.destinationEntity ? solutionView.moveValueInList(this.variableMetaModel, this.sourceEntity, this.sourceIndex, this.destinationIndex) : solutionView.moveValueBetweenLists(this.variableMetaModel, this.sourceEntity, this.sourceIndex, this.destinationEntity, this.destinationIndex);
    }

    public ListChangeMove<Solution_, Entity_, Value_> rebase(Rebaser rebaser) {
        return new ListChangeMove<Solution_, Entity_, Value_>(this.variableMetaModel, Objects.requireNonNull(rebaser.rebase(this.sourceEntity)), this.sourceIndex, Objects.requireNonNull(rebaser.rebase(this.destinationEntity)), this.destinationIndex);
    }

    @Override
    public Collection<Entity_> extractPlanningEntities() {
        if (this.sourceEntity == this.destinationEntity) {
            return Collections.singleton(this.sourceEntity);
        }
        return List.of(this.sourceEntity, this.destinationEntity);
    }

    @Override
    public Collection<Value_> extractPlanningValues() {
        return Collections.singleton(this.getMovedValue());
    }

    @Override
    protected List<VariableMetaModel<Solution_, ?, ?>> getVariableMetaModels() {
        return List.of(this.variableMetaModel);
    }

    public Entity_ getSourceEntity() {
        return this.sourceEntity;
    }

    public int getSourceIndex() {
        return this.sourceIndex;
    }

    public Entity_ getDestinationEntity() {
        return this.destinationEntity;
    }

    public int getDestinationIndex() {
        return this.destinationIndex;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof ListChangeMove)) return false;
        ListChangeMove other = (ListChangeMove)o;
        if (!Objects.equals(this.variableMetaModel, other.variableMetaModel)) return false;
        if (!Objects.equals(this.sourceEntity, other.sourceEntity)) return false;
        if (this.sourceIndex != other.sourceIndex) return false;
        if (!Objects.equals(this.destinationEntity, other.destinationEntity)) return false;
        if (this.destinationIndex != other.destinationIndex) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.variableMetaModel, this.sourceEntity, this.sourceIndex, this.destinationEntity, this.destinationIndex);
    }

    @Override
    public String toString() {
        return String.format("%s {%s[%d] -> %s[%d]}", this.getMovedValue(), this.sourceEntity, this.sourceIndex, this.destinationEntity, this.destinationIndex);
    }
}

