/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.move.streams.maybeapi.generic.move;

import ai.timefold.solver.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import ai.timefold.solver.core.impl.move.streams.maybeapi.generic.move.ChangeMove;
import ai.timefold.solver.core.preview.api.domain.metamodel.PlanningVariableMetaModel;
import ai.timefold.solver.core.preview.api.move.MutableSolutionView;
import ai.timefold.solver.core.preview.api.move.Rebaser;
import java.util.Objects;
import org.jspecify.annotations.NonNull;

public final class ChainedChangeMove<Solution_, Entity_>
extends ChangeMove<Solution_, Entity_, Entity_> {
    private final Entity_ oldTrailingEntity;
    private final Entity_ newTrailingEntity;

    public ChainedChangeMove(PlanningVariableMetaModel<Solution_, Entity_, Entity_> variableMetaModel, Entity_ entity, Entity_ toPlanningValue, SingletonInverseVariableSupply inverseVariableSupply) {
        super(variableMetaModel, entity, toPlanningValue);
        this.oldTrailingEntity = Objects.requireNonNull(inverseVariableSupply).getInverseSingleton(entity);
        this.newTrailingEntity = toPlanningValue == null ? null : inverseVariableSupply.getInverseSingleton(toPlanningValue);
    }

    ChainedChangeMove(PlanningVariableMetaModel<Solution_, Entity_, Entity_> variableMetaModel, Entity_ entity, Entity_ toPlanningValue, Entity_ oldTrailingEntity, Entity_ newTrailingEntity) {
        super(variableMetaModel, entity, toPlanningValue);
        this.oldTrailingEntity = oldTrailingEntity;
        this.newTrailingEntity = newTrailingEntity;
    }

    @Override
    public void execute(@NonNull MutableSolutionView<Solution_> solutionView) {
        if (this.oldTrailingEntity != null) {
            solutionView.changeVariable(this.variableMetaModel, this.oldTrailingEntity, this.readValue(solutionView));
        }
        solutionView.changeVariable(this.variableMetaModel, this.entity, this.toPlanningValue);
        if (this.newTrailingEntity != null) {
            solutionView.changeVariable(this.variableMetaModel, this.newTrailingEntity, this.entity);
        }
    }

    @Override
    public @NonNull ChainedChangeMove<Solution_, Entity_> rebase(@NonNull Rebaser rebaser) {
        return new ChainedChangeMove<Solution_, Object>(this.variableMetaModel, rebaser.rebase(this.entity), rebaser.rebase(this.toPlanningValue), rebaser.rebase(this.oldTrailingEntity), rebaser.rebase(this.newTrailingEntity));
    }
}

