/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.move.streams.maybeapi.generic.move;

import ai.timefold.solver.core.api.score.director.ScoreDirector;
import ai.timefold.solver.core.impl.domain.solution.descriptor.DefaultPlanningListVariableMetaModel;
import ai.timefold.solver.core.impl.domain.solution.descriptor.DefaultPlanningVariableMetaModel;
import ai.timefold.solver.core.impl.domain.solution.descriptor.InnerVariableMetaModel;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.VariableDescriptor;
import ai.timefold.solver.core.preview.api.domain.metamodel.PlanningListVariableMetaModel;
import ai.timefold.solver.core.preview.api.domain.metamodel.PlanningVariableMetaModel;
import ai.timefold.solver.core.preview.api.domain.metamodel.VariableMetaModel;
import ai.timefold.solver.core.preview.api.move.Move;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jspecify.annotations.NullMarked;

@NullMarked
public abstract class AbstractMove<Solution_>
implements Move<Solution_> {
    private static final char OPENING_PARENTHESES = '(';
    private static final char CLOSING_PARENTHESES = ')';

    @Override
    public final String describe() {
        List<VariableMetaModel<Solution_, ?, ?>> metaModels = this.getVariableMetaModels();
        String substring = switch (metaModels.size()) {
            case 0 -> "";
            case 1 -> "(" + AbstractMove.getVariableDescriptor(metaModels.get(0)).getSimpleEntityAndVariableName() + ")";
            default -> {
                StringBuilder stringBuilder = new StringBuilder().append('(');
                boolean first = true;
                for (VariableMetaModel<Solution_, ?, ?> variableMetaModel : this.getVariableMetaModels()) {
                    if (first) {
                        first = false;
                    } else {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(AbstractMove.getVariableDescriptor(variableMetaModel).getSimpleEntityAndVariableName());
                }
                stringBuilder.append(')');
                yield stringBuilder.toString();
            }
        };
        return this.getClass().getSimpleName() + substring;
    }

    @Override
    public abstract String toString();

    protected List<VariableMetaModel<Solution_, ?, ?>> getVariableMetaModels() {
        return Collections.emptyList();
    }

    protected static <Solution_> VariableDescriptor<Solution_> getVariableDescriptor(VariableMetaModel<Solution_, ?, ?> variableMetaModel) {
        return ((InnerVariableMetaModel)((Object)variableMetaModel)).variableDescriptor();
    }

    protected static <Solution_> GenuineVariableDescriptor<Solution_> getVariableDescriptor(PlanningVariableMetaModel<Solution_, ?, ?> variableMetaModel) {
        return ((DefaultPlanningVariableMetaModel)variableMetaModel).variableDescriptor();
    }

    protected static <Solution_> ListVariableDescriptor<Solution_> getVariableDescriptor(PlanningListVariableMetaModel<Solution_, ?, ?> variableMetaModel) {
        return ((DefaultPlanningListVariableMetaModel)variableMetaModel).variableDescriptor();
    }

    public static <E> List<E> rebaseList(List<E> externalObjectList, ScoreDirector<?> destinationScoreDirector) {
        ArrayList<E> rebasedObjectList = new ArrayList<E>(externalObjectList.size());
        for (E entity : externalObjectList) {
            rebasedObjectList.add(destinationScoreDirector.lookUpWorkingObject(entity));
        }
        return rebasedObjectList;
    }

    public static <E> Set<E> rebaseSet(Set<E> externalObjectSet, ScoreDirector<?> destinationScoreDirector) {
        LinkedHashSet<E> rebasedObjectSet = new LinkedHashSet<E>(externalObjectSet.size());
        for (E entity : externalObjectSet) {
            rebasedObjectSet.add(destinationScoreDirector.lookUpWorkingObject(entity));
        }
        return rebasedObjectSet;
    }
}

