/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.value.decorator;

import ai.timefold.solver.core.impl.domain.variable.ListVariableStateSupply;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.selector.AbstractDemandEnabledSelector;
import ai.timefold.solver.core.impl.heuristic.selector.common.ReachableValues;
import ai.timefold.solver.core.impl.heuristic.selector.common.iterator.UpcomingSelectionIterator;
import ai.timefold.solver.core.impl.heuristic.selector.value.IterableValueSelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.decorator.IterableFromEntityPropertyValueSelector;
import ai.timefold.solver.core.impl.phase.scope.AbstractPhaseScope;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import ai.timefold.solver.core.preview.api.domain.metamodel.ElementPosition;
import ai.timefold.solver.core.preview.api.domain.metamodel.PositionInList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

public final class FilteringValueRangeSelector<Solution_>
extends AbstractDemandEnabledSelector<Solution_>
implements IterableValueSelector<Solution_> {
    private final IterableValueSelector<Solution_> nonReplayingValueSelector;
    private final IterableValueSelector<Solution_> replayingValueSelector;
    private final boolean randomSelection;
    private long valuesSize;
    private ListVariableStateSupply<Solution_> listVariableStateSupply;
    private ReachableValues reachableValues;
    private final boolean checkSourceAndDestination;

    public FilteringValueRangeSelector(IterableValueSelector<Solution_> nonReplayingValueSelector, IterableValueSelector<Solution_> replayingValueSelector, boolean randomSelection, boolean checkSourceAndDestination) {
        this.nonReplayingValueSelector = nonReplayingValueSelector;
        this.replayingValueSelector = replayingValueSelector;
        this.randomSelection = randomSelection;
        this.checkSourceAndDestination = checkSourceAndDestination;
    }

    @Override
    public void solvingStarted(SolverScope<Solution_> solverScope) {
        super.solvingStarted(solverScope);
        this.nonReplayingValueSelector.solvingStarted(solverScope);
        this.replayingValueSelector.solvingStarted(solverScope);
        this.listVariableStateSupply = solverScope.getScoreDirector().getListVariableStateSupply((ListVariableDescriptor)this.nonReplayingValueSelector.getVariableDescriptor());
    }

    @Override
    public void phaseStarted(AbstractPhaseScope<Solution_> phaseScope) {
        super.phaseStarted(phaseScope);
        this.nonReplayingValueSelector.phaseStarted(phaseScope);
        this.replayingValueSelector.phaseStarted(phaseScope);
        this.reachableValues = phaseScope.getScoreDirector().getValueRangeManager().getReachableValues((ListVariableDescriptor<Solution_>)this.listVariableStateSupply.getSourceVariableDescriptor());
        this.valuesSize = this.reachableValues.getSize();
    }

    @Override
    public void phaseEnded(AbstractPhaseScope<Solution_> phaseScope) {
        super.phaseEnded(phaseScope);
        this.nonReplayingValueSelector.phaseEnded(phaseScope);
        this.replayingValueSelector.phaseEnded(phaseScope);
        this.reachableValues = null;
    }

    public IterableValueSelector<Solution_> getChildValueSelector() {
        return this.nonReplayingValueSelector;
    }

    @Override
    public GenuineVariableDescriptor<Solution_> getVariableDescriptor() {
        return this.nonReplayingValueSelector.getVariableDescriptor();
    }

    @Override
    public boolean isCountable() {
        return this.nonReplayingValueSelector.isCountable();
    }

    @Override
    public boolean isNeverEnding() {
        return this.nonReplayingValueSelector.isNeverEnding();
    }

    @Override
    public long getSize(Object entity) {
        return this.getSize();
    }

    @Override
    public long getSize() {
        return this.valuesSize;
    }

    @Override
    public Iterator<Object> iterator(Object entity) {
        return this.iterator();
    }

    @Override
    public Iterator<Object> iterator() {
        if (this.randomSelection) {
            if (this.nonReplayingValueSelector instanceof IterableFromEntityPropertyValueSelector) {
                return new OptimizedRandomFilteringValueRangeIterator(this.replayingValueSelector.iterator(), this.listVariableStateSupply, this.reachableValues, this.workingRandom, (int)this.getSize(), this.checkSourceAndDestination);
            }
            return new RandomFilteringValueRangeIterator(this.replayingValueSelector.iterator(), this.nonReplayingValueSelector.iterator(), this.listVariableStateSupply, this.reachableValues, (int)this.getSize(), this.checkSourceAndDestination);
        }
        return new OriginalFilteringValueRangeIterator(this.replayingValueSelector.iterator(), this.nonReplayingValueSelector.iterator(), this.listVariableStateSupply, this.reachableValues, this.checkSourceAndDestination);
    }

    @Override
    public Iterator<Object> endingIterator(Object entity) {
        return new OriginalFilteringValueRangeIterator(this.replayingValueSelector.iterator(), this.nonReplayingValueSelector.iterator(), this.listVariableStateSupply, this.reachableValues, this.checkSourceAndDestination);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object other) {
        if (!(other instanceof FilteringValueRangeSelector)) return false;
        FilteringValueRangeSelector that = (FilteringValueRangeSelector)other;
        if (!Objects.equals(this.nonReplayingValueSelector, that.nonReplayingValueSelector)) return false;
        if (!Objects.equals(this.replayingValueSelector, that.replayingValueSelector)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.nonReplayingValueSelector, this.replayingValueSelector);
    }

    private class OptimizedRandomFilteringValueRangeIterator
    extends AbstractFilteringValueRangeIterator {
        private final Iterator<Object> replayingValueIterator;
        private final Random workingRandom;
        private final int maxBailoutSize;

        private OptimizedRandomFilteringValueRangeIterator(Iterator<Object> replayingValueIterator, ListVariableStateSupply<Solution_> listVariableStateSupply, ReachableValues reachableValues, Random workingRandom, int maxBailoutSize, boolean checkSourceAndDestination) {
            super(listVariableStateSupply, reachableValues, checkSourceAndDestination, true);
            this.replayingValueIterator = replayingValueIterator;
            this.workingRandom = workingRandom;
            this.maxBailoutSize = maxBailoutSize;
        }

        private void initialize() {
            if (this.initialized) {
                return;
            }
            this.loadValues(Objects.requireNonNull(this.replayingValueIterator.next()));
        }

        @Override
        public boolean hasNext() {
            Object updatedUpcomingValue;
            if (this.replayingValueIterator.hasNext() && this.currentUpcomingValue != null && (updatedUpcomingValue = this.replayingValueIterator.next()) != this.currentUpcomingValue) {
                this.loadValues(updatedUpcomingValue);
            }
            return super.hasNext();
        }

        @Override
        protected Object createUpcomingSelection() {
            int index;
            Object next;
            this.initialize();
            if (!this.hasData) {
                return this.noUpcomingSelection();
            }
            int bailoutSize = this.maxBailoutSize;
            do {
                if (bailoutSize <= 0) {
                    return this.noUpcomingSelection();
                }
                --bailoutSize;
            } while (!this.isEntityReachable(next = this.valueList.get(index = this.workingRandom.nextInt(this.valueList.size()))));
            return next;
        }
    }

    private class RandomFilteringValueRangeIterator
    extends AbstractUpcomingValueRangeIterator {
        private final int maxBailoutSize;

        private RandomFilteringValueRangeIterator(Iterator<Object> replayingValueIterator, Iterator<Object> valueIterator, ListVariableStateSupply<Solution_> listVariableStateSupply, ReachableValues reachableValues, int maxBailoutSize, boolean checkSourceAndDestination) {
            super(replayingValueIterator, valueIterator, listVariableStateSupply, reachableValues, checkSourceAndDestination, false);
            this.maxBailoutSize = maxBailoutSize;
        }

        @Override
        protected Object createUpcomingSelection() {
            Object next;
            this.initialize();
            if (!this.hasData) {
                return this.noUpcomingSelection();
            }
            int bailoutSize = this.maxBailoutSize;
            do {
                if (bailoutSize <= 0 || !this.valueIterator.hasNext()) {
                    return this.noUpcomingSelection();
                }
                --bailoutSize;
            } while (!this.isValueOrEntityReachable(next = this.valueIterator.next()));
            return next;
        }
    }

    private class OriginalFilteringValueRangeIterator
    extends AbstractUpcomingValueRangeIterator {
        private OriginalFilteringValueRangeIterator(Iterator<Object> replayingValueIterator, Iterator<Object> valueIterator, ListVariableStateSupply<Solution_> listVariableStateSupply, ReachableValues reachableValues, boolean checkSourceAndDestination) {
            super(replayingValueIterator, valueIterator, listVariableStateSupply, reachableValues, checkSourceAndDestination, false);
        }

        @Override
        protected Object createUpcomingSelection() {
            Object next;
            this.initialize();
            if (!this.hasData) {
                return this.noUpcomingSelection();
            }
            do {
                if (this.valueIterator.hasNext()) continue;
                return this.noUpcomingSelection();
            } while (!this.isValueOrEntityReachable(next = this.valueIterator.next()));
            return next;
        }
    }

    private abstract class AbstractUpcomingValueRangeIterator
    extends AbstractFilteringValueRangeIterator {
        final Iterator<Object> replayingValueIterator;
        final Iterator<Object> valueIterator;

        private AbstractUpcomingValueRangeIterator(Iterator<Object> replayingValueIterator, Iterator<Object> valueIterator, ListVariableStateSupply<Solution_> listVariableStateSupply, ReachableValues reachableValues, boolean checkSourceAndDestination, boolean useValueList) {
            super(listVariableStateSupply, reachableValues, checkSourceAndDestination, useValueList);
            this.replayingValueIterator = replayingValueIterator;
            this.valueIterator = valueIterator;
        }

        void initialize() {
            if (this.initialized) {
                return;
            }
            if (this.replayingValueIterator.hasNext()) {
                Object upcomingValue = this.replayingValueIterator.next();
                if (!this.valueIterator.hasNext()) {
                    this.noData();
                } else {
                    this.loadValues(Objects.requireNonNull(upcomingValue));
                }
            } else {
                this.noData();
            }
        }
    }

    @NullMarked
    private abstract class AbstractFilteringValueRangeIterator
    extends UpcomingSelectionIterator<Object> {
        private final ListVariableStateSupply<Solution_> listVariableStateSupply;
        private final ReachableValues reachableValues;
        private final boolean checkSourceAndDestination;
        private final boolean useValueList;
        boolean initialized = false;
        boolean hasData = false;
        @Nullable Object currentUpcomingValue;
        @Nullable Object currentUpcomingEntity;
        @Nullable Set<Object> valuesSet;
        @Nullable List<Object> valueList;
        @Nullable Set<Object> entitiesSet;

        AbstractFilteringValueRangeIterator(ListVariableStateSupply<Solution_> listVariableStateSupply, ReachableValues reachableValues, boolean checkSourceAndDestination, boolean useValueList) {
            this.reachableValues = Objects.requireNonNull(reachableValues);
            this.listVariableStateSupply = listVariableStateSupply;
            this.checkSourceAndDestination = checkSourceAndDestination;
            this.useValueList = useValueList;
        }

        void loadValues(Object upcomingValue) {
            ElementPosition position;
            this.currentUpcomingValue = upcomingValue;
            this.entitiesSet = this.reachableValues.extractEntities(this.currentUpcomingValue);
            this.valueList = null;
            this.valuesSet = null;
            if (this.useValueList) {
                this.valueList = Objects.requireNonNull(this.reachableValues.extractValuesAsList(this.currentUpcomingValue));
                if (this.valueList.isEmpty()) {
                    this.noData();
                    return;
                }
            } else {
                this.valuesSet = this.reachableValues.extractValues(this.currentUpcomingValue);
                if (this.valuesSet == null || this.valuesSet.isEmpty()) {
                    this.noData();
                    return;
                }
            }
            this.currentUpcomingEntity = null;
            if (this.checkSourceAndDestination && (position = this.listVariableStateSupply.getElementPosition(this.currentUpcomingValue)) instanceof PositionInList) {
                PositionInList positionInList = (PositionInList)position;
                this.currentUpcomingEntity = positionInList.entity();
            }
            this.hasData = true;
            this.initialized = true;
        }

        void noData() {
            this.entitiesSet = null;
            this.valuesSet = null;
            this.valueList = null;
            this.currentUpcomingEntity = null;
            this.hasData = false;
            this.initialized = true;
        }

        boolean isEntityReachable(Object destinationValue) {
            boolean destinationValid = true;
            boolean sourceValid = true;
            ElementPosition assignedDestinationPosition = this.listVariableStateSupply.getElementPosition(destinationValue);
            if (assignedDestinationPosition instanceof PositionInList) {
                PositionInList elementPosition = (PositionInList)assignedDestinationPosition;
                destinationValid = this.entitiesSet.contains(elementPosition.entity());
            }
            if (this.checkSourceAndDestination && destinationValid && this.currentUpcomingEntity != null) {
                sourceValid = Objects.requireNonNull(this.reachableValues.extractEntities(destinationValue)).contains(this.currentUpcomingEntity);
            }
            return sourceValid && destinationValid;
        }

        boolean isValueOrEntityReachable(Object destinationValue) {
            if (!this.valuesSet.contains(destinationValue)) {
                return false;
            }
            return this.isEntityReachable(destinationValue);
        }
    }
}

