/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.list;

import ai.timefold.solver.core.config.heuristic.selector.common.SelectionCacheType;
import ai.timefold.solver.core.config.heuristic.selector.common.SelectionOrder;
import ai.timefold.solver.core.config.heuristic.selector.common.nearby.NearbySelectionConfig;
import ai.timefold.solver.core.config.heuristic.selector.list.DestinationSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.value.ValueSelectorConfig;
import ai.timefold.solver.core.enterprise.TimefoldSolverEnterpriseService;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.heuristic.HeuristicConfigPolicy;
import ai.timefold.solver.core.impl.heuristic.selector.AbstractSelectorFactory;
import ai.timefold.solver.core.impl.heuristic.selector.entity.EntitySelector;
import ai.timefold.solver.core.impl.heuristic.selector.entity.EntitySelectorFactory;
import ai.timefold.solver.core.impl.heuristic.selector.entity.decorator.FilteringEntityValueRangeSelector;
import ai.timefold.solver.core.impl.heuristic.selector.list.DestinationSelector;
import ai.timefold.solver.core.impl.heuristic.selector.list.ElementDestinationSelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.IterableValueSelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.ValueSelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.ValueSelectorFactory;
import java.util.Objects;

public final class DestinationSelectorFactory<Solution_>
extends AbstractSelectorFactory<Solution_, DestinationSelectorConfig> {
    public static <Solution_> DestinationSelectorFactory<Solution_> create(DestinationSelectorConfig destinationSelectorConfig) {
        return new DestinationSelectorFactory<Solution_>(destinationSelectorConfig);
    }

    private DestinationSelectorFactory(DestinationSelectorConfig destinationSelectorConfig) {
        super(destinationSelectorConfig);
    }

    public DestinationSelector<Solution_> buildDestinationSelector(HeuristicConfigPolicy<Solution_> configPolicy, SelectionCacheType minimumCacheType, boolean randomSelection) {
        return this.buildDestinationSelector(configPolicy, minimumCacheType, randomSelection, false, null);
    }

    public DestinationSelector<Solution_> buildDestinationSelector(HeuristicConfigPolicy<Solution_> configPolicy, SelectionCacheType minimumCacheType, boolean randomSelection, boolean enableEntityValueRangeFilter, String mimicRecorderId) {
        SelectionOrder selectionOrder = SelectionOrder.fromRandomSelectionBoolean(randomSelection);
        EntitySelector entitySelector = EntitySelectorFactory.create(Objects.requireNonNull(((DestinationSelectorConfig)this.config).getEntitySelectorConfig())).buildEntitySelector(configPolicy, minimumCacheType, selectionOrder);
        IterableValueSelector<Solution_> valueSelector = this.buildIterableValueSelector(configPolicy, entitySelector.getEntityDescriptor(), minimumCacheType, selectionOrder);
        if (enableEntityValueRangeFilter) {
            if (mimicRecorderId == null) {
                throw new IllegalStateException("An outer value selector mimic recorder ID is needed for the destination selector %s when using entity value ranges.".formatted(this.config));
            }
            valueSelector = ValueSelectorFactory.applyValueRangeFiltering(configPolicy, valueSelector, entitySelector.getEntityDescriptor(), mimicRecorderId, minimumCacheType, selectionOrder, randomSelection, false);
            entitySelector = this.applyEntityValueRangeFiltering(configPolicy, entitySelector, mimicRecorderId, minimumCacheType, selectionOrder, randomSelection);
        }
        ElementDestinationSelector baseDestinationSelector = new ElementDestinationSelector(entitySelector, valueSelector, selectionOrder.toRandomSelectionBoolean(), enableEntityValueRangeFilter);
        return this.applyNearbySelection(configPolicy, minimumCacheType, selectionOrder, baseDestinationSelector);
    }

    private IterableValueSelector<Solution_> buildIterableValueSelector(HeuristicConfigPolicy<Solution_> configPolicy, EntityDescriptor<Solution_> entityDescriptor, SelectionCacheType minimumCacheType, SelectionOrder inheritedSelectionOrder) {
        ValueSelector valueSelector = ValueSelectorFactory.create(Objects.requireNonNull(((DestinationSelectorConfig)this.config).getValueSelectorConfig())).buildValueSelector(configPolicy, entityDescriptor, minimumCacheType, inheritedSelectionOrder, configPolicy.isReinitializeVariableFilterEnabled(), ValueSelectorFactory.ListValueFilteringType.ACCEPT_ASSIGNED);
        return (IterableValueSelector)valueSelector;
    }

    private DestinationSelector<Solution_> applyNearbySelection(HeuristicConfigPolicy<Solution_> configPolicy, SelectionCacheType minimumCacheType, SelectionOrder resolvedSelectionOrder, ElementDestinationSelector<Solution_> destinationSelector) {
        NearbySelectionConfig nearbySelectionConfig = ((DestinationSelectorConfig)this.config).getNearbySelectionConfig();
        if (nearbySelectionConfig == null) {
            return destinationSelector;
        }
        return TimefoldSolverEnterpriseService.loadOrFail(TimefoldSolverEnterpriseService.Feature.NEARBY_SELECTION).applyNearbySelection((DestinationSelectorConfig)this.config, configPolicy, minimumCacheType, resolvedSelectionOrder, destinationSelector);
    }

    private EntitySelector<Solution_> applyEntityValueRangeFiltering(HeuristicConfigPolicy<Solution_> configPolicy, EntitySelector<Solution_> entitySelector, String valueSelectorId, SelectionCacheType minimumCacheType, SelectionOrder selectionOrder, boolean randomSelection) {
        ValueSelectorConfig valueSelectorConfig = new ValueSelectorConfig().withMimicSelectorRef(valueSelectorId);
        IterableValueSelector replayingValueSelector = (IterableValueSelector)ValueSelectorFactory.create(valueSelectorConfig).buildValueSelector(configPolicy, entitySelector.getEntityDescriptor(), minimumCacheType, selectionOrder);
        return new FilteringEntityValueRangeSelector<Solution_>(entitySelector, replayingValueSelector, randomSelection);
    }
}

