/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.entity.decorator;

import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.heuristic.selector.AbstractDemandEnabledSelector;
import ai.timefold.solver.core.impl.heuristic.selector.common.ReachableValues;
import ai.timefold.solver.core.impl.heuristic.selector.common.iterator.UpcomingSelectionIterator;
import ai.timefold.solver.core.impl.heuristic.selector.entity.EntitySelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.IterableValueSelector;
import ai.timefold.solver.core.impl.phase.scope.AbstractPhaseScope;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Random;

public final class FilteringEntityValueRangeSelector<Solution_>
extends AbstractDemandEnabledSelector<Solution_>
implements EntitySelector<Solution_> {
    private final IterableValueSelector<Solution_> replayingValueSelector;
    private final EntitySelector<Solution_> childEntitySelector;
    private final boolean randomSelection;
    private ReachableValues reachableValues;
    private long entitiesSize;

    public FilteringEntityValueRangeSelector(EntitySelector<Solution_> childEntitySelector, IterableValueSelector<Solution_> replayingValueSelector, boolean randomSelection) {
        this.replayingValueSelector = replayingValueSelector;
        this.childEntitySelector = childEntitySelector;
        this.randomSelection = randomSelection;
    }

    @Override
    public void solvingStarted(SolverScope<Solution_> solverScope) {
        super.solvingStarted(solverScope);
        this.childEntitySelector.solvingStarted(solverScope);
    }

    @Override
    public void phaseStarted(AbstractPhaseScope<Solution_> phaseScope) {
        super.phaseStarted(phaseScope);
        this.entitiesSize = this.childEntitySelector.getEntityDescriptor().extractEntities(phaseScope.getWorkingSolution()).size();
        this.reachableValues = phaseScope.getScoreDirector().getValueRangeManager().getReachableValues(phaseScope.getScoreDirector().getSolutionDescriptor().getListVariableDescriptor());
        this.childEntitySelector.phaseStarted(phaseScope);
    }

    @Override
    public void phaseEnded(AbstractPhaseScope<Solution_> phaseScope) {
        super.phaseEnded(phaseScope);
        this.reachableValues = null;
    }

    public EntitySelector<Solution_> getChildEntitySelector() {
        return this.childEntitySelector;
    }

    @Override
    public EntityDescriptor<Solution_> getEntityDescriptor() {
        return this.childEntitySelector.getEntityDescriptor();
    }

    @Override
    public long getSize() {
        return this.entitiesSize;
    }

    @Override
    public boolean isCountable() {
        return this.childEntitySelector.isCountable();
    }

    @Override
    public boolean isNeverEnding() {
        return this.childEntitySelector.isNeverEnding();
    }

    @Override
    public Iterator<Object> endingIterator() {
        return new OriginalFilteringValueRangeIterator(this.replayingValueSelector.iterator(), this.reachableValues);
    }

    @Override
    public Iterator<Object> iterator() {
        if (this.randomSelection) {
            return new EntityRandomFilteringValueRangeIterator(this.replayingValueSelector.iterator(), this.reachableValues, this.workingRandom);
        }
        return new OriginalFilteringValueRangeIterator(this.replayingValueSelector.iterator(), this.reachableValues);
    }

    @Override
    public ListIterator<Object> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<Object> listIterator(int index) {
        throw new UnsupportedOperationException();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object other) {
        if (!(other instanceof FilteringEntityValueRangeSelector)) return false;
        FilteringEntityValueRangeSelector that = (FilteringEntityValueRangeSelector)other;
        if (!Objects.equals(this.childEntitySelector, that.childEntitySelector)) return false;
        if (!Objects.equals(this.replayingValueSelector, that.replayingValueSelector)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.childEntitySelector, this.replayingValueSelector);
    }

    private static class OriginalFilteringValueRangeIterator
    extends UpcomingSelectionIterator<Object> {
        private final Iterator<Object> valueIterator;
        private final ReachableValues reachableValues;
        private Iterator<Object> otherIterator;

        private OriginalFilteringValueRangeIterator(Iterator<Object> valueIterator, ReachableValues reachableValues) {
            this.valueIterator = valueIterator;
            this.reachableValues = Objects.requireNonNull(reachableValues);
        }

        private void initialize() {
            if (this.otherIterator != null) {
                return;
            }
            List<Object> allValues = this.reachableValues.extractEntitiesAsList(Objects.requireNonNull(this.valueIterator.next()));
            this.otherIterator = Objects.requireNonNull(allValues).iterator();
        }

        @Override
        protected Object createUpcomingSelection() {
            this.initialize();
            if (!this.otherIterator.hasNext()) {
                return this.noUpcomingSelection();
            }
            return this.otherIterator.next();
        }
    }

    private static class EntityRandomFilteringValueRangeIterator
    extends UpcomingSelectionIterator<Object> {
        private final Iterator<Object> valueIterator;
        private final ReachableValues reachableValues;
        private final Random workingRandom;
        private Object currentUpcomingValue;
        private List<Object> entityList;

        private EntityRandomFilteringValueRangeIterator(Iterator<Object> valueIterator, ReachableValues reachableValues, Random workingRandom) {
            this.valueIterator = valueIterator;
            this.reachableValues = Objects.requireNonNull(reachableValues);
            this.workingRandom = workingRandom;
        }

        private void initialize() {
            if (this.entityList != null) {
                return;
            }
            this.currentUpcomingValue = Objects.requireNonNull(this.valueIterator.next());
            this.loadValues();
        }

        private void loadValues() {
            this.upcomingCreated = false;
            this.entityList = this.reachableValues.extractEntitiesAsList(this.currentUpcomingValue);
        }

        @Override
        public boolean hasNext() {
            Object updatedUpcomingValue;
            if (this.valueIterator.hasNext() && this.currentUpcomingValue != null && (updatedUpcomingValue = this.valueIterator.next()) != this.currentUpcomingValue) {
                this.currentUpcomingValue = updatedUpcomingValue;
                this.loadValues();
            }
            return super.hasNext();
        }

        @Override
        protected Object createUpcomingSelection() {
            this.initialize();
            if (this.entityList.isEmpty()) {
                return this.noUpcomingSelection();
            }
            int index = this.workingRandom.nextInt(this.entityList.size());
            return this.entityList.get(index);
        }
    }
}

