/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class ReachableValues {
    private final Map<Object, Set<Object>> valueToEntityMap;
    private final Map<Object, Set<Object>> valueToValueMap;
    private final Map<Object, List<Object>> randomAccessValueToEntityMap;
    private final Map<Object, List<Object>> randomAccessValueToValueMap;
    private final @Nullable Class<?> valueClass;

    public ReachableValues(Map<Object, Set<Object>> valueToEntityMap, Map<Object, Set<Object>> valueToValueMap) {
        this.valueToEntityMap = valueToEntityMap;
        this.randomAccessValueToEntityMap = new IdentityHashMap<Object, List<Object>>(this.valueToEntityMap.size());
        this.valueToValueMap = valueToValueMap;
        this.randomAccessValueToValueMap = new IdentityHashMap<Object, List<Object>>(this.valueToValueMap.size());
        Optional first = valueToEntityMap.entrySet().stream().findFirst();
        this.valueClass = first.map(entry -> entry.getKey().getClass()).orElse(null);
    }

    public @Nullable Set<Object> extractEntities(Object value) {
        return this.valueToEntityMap.get(value);
    }

    public @Nullable Set<Object> extractValues(Object value) {
        return this.valueToValueMap.get(value);
    }

    public List<Object> extractEntitiesAsList(Object value) {
        List<Object> result = this.randomAccessValueToEntityMap.get(value);
        if (result == null) {
            Set<Object> entitySet = this.valueToEntityMap.get(value);
            result = entitySet != null ? new ArrayList<Object>(entitySet) : Collections.emptyList();
            this.randomAccessValueToEntityMap.put(value, result);
        }
        return result;
    }

    public List<Object> extractValuesAsList(Object value) {
        List<Object> result = this.randomAccessValueToValueMap.get(value);
        if (result == null) {
            Set<Object> valueSet = this.valueToValueMap.get(value);
            result = valueSet != null ? new ArrayList<Object>(valueSet) : Collections.emptyList();
            this.randomAccessValueToValueMap.put(value, result);
        }
        return result;
    }

    public int getSize() {
        return this.valueToEntityMap.size();
    }

    public boolean isValidValueClass(Object value) {
        if (this.valueToEntityMap.isEmpty()) {
            return false;
        }
        return Objects.requireNonNull(value).getClass().equals(this.valueClass);
    }
}

