/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.exhaustivesearch.scope;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.impl.exhaustivesearch.node.ExhaustiveSearchLayer;
import ai.timefold.solver.core.impl.exhaustivesearch.node.ExhaustiveSearchNode;
import ai.timefold.solver.core.impl.exhaustivesearch.scope.ExhaustiveSearchStepScope;
import ai.timefold.solver.core.impl.phase.scope.AbstractPhaseScope;
import ai.timefold.solver.core.impl.score.director.InnerScore;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import java.util.List;
import java.util.SortedSet;

public final class ExhaustiveSearchPhaseScope<Solution_>
extends AbstractPhaseScope<Solution_> {
    private List<ExhaustiveSearchLayer> layerList;
    private SortedSet<ExhaustiveSearchNode> expandableNodeQueue;
    private InnerScore<?> bestPessimisticBound;
    private ExhaustiveSearchStepScope<Solution_> lastCompletedStepScope = new ExhaustiveSearchStepScope(this, -1);

    public ExhaustiveSearchPhaseScope(SolverScope<Solution_> solverScope, int phaseIndex) {
        super(solverScope, phaseIndex, false);
    }

    public List<ExhaustiveSearchLayer> getLayerList() {
        return this.layerList;
    }

    public void setLayerList(List<ExhaustiveSearchLayer> layerList) {
        this.layerList = layerList;
    }

    public SortedSet<ExhaustiveSearchNode> getExpandableNodeQueue() {
        return this.expandableNodeQueue;
    }

    public void setExpandableNodeQueue(SortedSet<ExhaustiveSearchNode> expandableNodeQueue) {
        this.expandableNodeQueue = expandableNodeQueue;
    }

    public <Score_ extends Score<Score_>> InnerScore<Score_> getBestPessimisticBound() {
        return this.bestPessimisticBound;
    }

    public void setBestPessimisticBound(InnerScore<?> bestPessimisticBound) {
        this.bestPessimisticBound = bestPessimisticBound;
    }

    @Override
    public ExhaustiveSearchStepScope<Solution_> getLastCompletedStepScope() {
        return this.lastCompletedStepScope;
    }

    public void setLastCompletedStepScope(ExhaustiveSearchStepScope<Solution_> lastCompletedStepScope) {
        this.lastCompletedStepScope = lastCompletedStepScope;
    }

    public int getDepthSize() {
        return this.layerList.size();
    }

    public <Score_ extends Score<Score_>> void registerPessimisticBound(InnerScore<Score_> pessimisticBound) {
        InnerScore<Score_> castBestPessimisticBound = this.getBestPessimisticBound();
        if (pessimisticBound.compareTo(castBestPessimisticBound) > 0) {
            this.bestPessimisticBound = pessimisticBound;
            this.expandableNodeQueue.removeIf(node -> {
                InnerScore optimistic = node.getOptimisticBound();
                return optimistic.compareTo(pessimisticBound) <= 0;
            });
        }
    }

    public void addExpandableNode(ExhaustiveSearchNode moveNode) {
        this.expandableNodeQueue.add(moveNode);
        moveNode.setExpandable(true);
    }
}

