/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.variable.declarative;

import ai.timefold.solver.core.impl.domain.variable.declarative.AbstractVariableReferenceGraph;
import ai.timefold.solver.core.impl.domain.variable.declarative.ChangedVariableNotifier;
import ai.timefold.solver.core.impl.domain.variable.declarative.DefaultVariableReferenceGraph;
import ai.timefold.solver.core.impl.domain.variable.declarative.EmptyVariableReferenceGraph;
import ai.timefold.solver.core.impl.domain.variable.declarative.FixedVariableReferenceGraph;
import ai.timefold.solver.core.impl.domain.variable.declarative.GraphChangeType;
import ai.timefold.solver.core.impl.domain.variable.declarative.GraphNode;
import ai.timefold.solver.core.impl.domain.variable.declarative.TopologicalOrderGraph;
import ai.timefold.solver.core.impl.domain.variable.declarative.VariableReferenceGraph;
import ai.timefold.solver.core.impl.domain.variable.declarative.VariableUpdaterInfo;
import ai.timefold.solver.core.preview.api.domain.metamodel.VariableMetaModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.IntFunction;
import org.jspecify.annotations.NonNull;

public final class VariableReferenceGraphBuilder<Solution_> {
    final ChangedVariableNotifier<Solution_> changedVariableNotifier;
    final Map<VariableMetaModel<?, ?, ?>, List<BiConsumer<AbstractVariableReferenceGraph<Solution_, ?>, Object>>> variableReferenceToBeforeProcessor;
    final Map<VariableMetaModel<?, ?, ?>, List<BiConsumer<AbstractVariableReferenceGraph<Solution_, ?>, Object>>> variableReferenceToAfterProcessor;
    final List<GraphNode<Solution_>> nodeList;
    final Map<Object, Integer> entityToEntityId;
    final Map<GraphNode<Solution_>, List<GraphNode<Solution_>>> fixedEdges;
    final Map<VariableMetaModel<?, ?, ?>, Map<Object, GraphNode<Solution_>>> variableReferenceToContainingNodeMap;
    final Map<Integer, Map<Object, GraphNode<Solution_>>> variableGroupIdToContainingNodeMap;
    boolean isGraphFixed;

    public VariableReferenceGraphBuilder(ChangedVariableNotifier<Solution_> changedVariableNotifier) {
        this.changedVariableNotifier = changedVariableNotifier;
        this.nodeList = new ArrayList<GraphNode<Solution_>>();
        this.variableReferenceToContainingNodeMap = new HashMap();
        this.variableGroupIdToContainingNodeMap = new HashMap<Integer, Map<Object, GraphNode<Solution_>>>();
        this.variableReferenceToBeforeProcessor = new HashMap();
        this.variableReferenceToAfterProcessor = new HashMap();
        this.fixedEdges = new HashMap<GraphNode<Solution_>, List<GraphNode<Solution_>>>();
        this.entityToEntityId = new IdentityHashMap<Object, Integer>();
        this.isGraphFixed = true;
    }

    public <Entity_> void addVariableReferenceEntity(Entity_ entity, List<VariableUpdaterInfo<Solution_>> variableReferences) {
        Map<Object, GraphNode<Solution_>> instanceMap;
        GraphNode<Solution_> instance;
        int groupId = variableReferences.get(0).groupId();
        boolean isGroup = variableReferences.get(0).groupEntities() != null;
        Object entityRepresentative = entity;
        if (isGroup) {
            entityRepresentative = variableReferences.get(0).groupEntities()[0];
        }
        GraphNode<Solution_> graphNode = instance = (instanceMap = this.variableGroupIdToContainingNodeMap.get(groupId)) == null ? null : instanceMap.get(entityRepresentative);
        if (instance != null) {
            return;
        }
        if (instanceMap == null) {
            instanceMap = new IdentityHashMap<Object, GraphNode<Solution_>>();
            this.variableGroupIdToContainingNodeMap.put(groupId, instanceMap);
        }
        Integer entityId = this.entityToEntityId.computeIfAbsent(entityRepresentative, ignored -> this.entityToEntityId.size());
        int[] groupEntityIds = null;
        if (isGroup) {
            Object[] groupEntities = variableReferences.get(0).groupEntities();
            groupEntityIds = new int[groupEntities.length];
            for (int i = 0; i < groupEntityIds.length; ++i) {
                Object groupEntity = variableReferences.get(0).groupEntities()[i];
                groupEntityIds[i] = this.entityToEntityId.computeIfAbsent(groupEntity, ignored -> this.entityToEntityId.size());
            }
        }
        GraphNode<Solution_> node = new GraphNode<Solution_>(entityRepresentative, variableReferences, this.nodeList.size(), entityId, groupEntityIds);
        if (isGroup) {
            for (Object groupEntity : variableReferences.get(0).groupEntities()) {
                this.addToInstanceMaps(instanceMap, groupEntity, node, variableReferences);
            }
        } else {
            this.addToInstanceMaps(instanceMap, entity, node, variableReferences);
        }
        this.nodeList.add(node);
    }

    private void addToInstanceMaps(Map<Object, GraphNode<Solution_>> instanceMap, Object entity, GraphNode<Solution_> node, List<VariableUpdaterInfo<Solution_>> variableReferences) {
        instanceMap.put(entity, node);
        for (VariableUpdaterInfo<Solution_> variable : variableReferences) {
            Map variableInstanceMap = this.variableReferenceToContainingNodeMap.computeIfAbsent(variable.id(), ignored -> new IdentityHashMap());
            variableInstanceMap.put(entity, node);
        }
    }

    public void addFixedEdge(@NonNull GraphNode<Solution_> from, @NonNull GraphNode<Solution_> to) {
        if (from.graphNodeId() == to.graphNodeId()) {
            return;
        }
        this.fixedEdges.computeIfAbsent(from, k -> new ArrayList()).add(to);
    }

    public void addBeforeProcessor(GraphChangeType graphChangeType, VariableMetaModel<?, ?, ?> variableId, BiConsumer<AbstractVariableReferenceGraph<Solution_, ?>, Object> consumer) {
        this.isGraphFixed &= !graphChangeType.affectsGraph();
        this.variableReferenceToBeforeProcessor.computeIfAbsent(variableId, k -> new ArrayList()).add(consumer);
    }

    public void addAfterProcessor(GraphChangeType graphChangeType, VariableMetaModel<?, ?, ?> variableId, BiConsumer<AbstractVariableReferenceGraph<Solution_, ?>, Object> consumer) {
        this.isGraphFixed &= !graphChangeType.affectsGraph();
        this.variableReferenceToAfterProcessor.computeIfAbsent(variableId, k -> new ArrayList()).add(consumer);
    }

    public VariableReferenceGraph build(IntFunction<TopologicalOrderGraph> graphCreator) {
        if (this.nodeList.isEmpty()) {
            return EmptyVariableReferenceGraph.INSTANCE;
        }
        if (this.isGraphFixed) {
            return new FixedVariableReferenceGraph(this, graphCreator);
        }
        return new DefaultVariableReferenceGraph(this, graphCreator);
    }

    public @NonNull GraphNode<Solution_> lookupOrError(VariableMetaModel<?, ?, ?> variableId, Object entity) {
        GraphNode out = (GraphNode)this.variableReferenceToContainingNodeMap.getOrDefault(variableId, Collections.emptyMap()).get(entity);
        if (out == null) {
            throw new IllegalArgumentException();
        }
        return out;
    }
}

