/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.variable.declarative;

import ai.timefold.solver.core.impl.domain.variable.declarative.BaseTopologicalOrderGraph;
import ai.timefold.solver.core.impl.domain.variable.declarative.LoopedStatus;
import ai.timefold.solver.core.impl.util.DynamicIntArray;
import java.util.Arrays;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class LoopedTracker {
    private static final LoopedStatus[] VALUES = LoopedStatus.values();
    private final DynamicIntArray looped;
    private final int[][] entityIdToNodes;
    private final boolean[] entityLoopedStatusChanged;

    public LoopedTracker(int nodeCount, int[][] entityIdToNodes) {
        this.entityIdToNodes = entityIdToNodes;
        this.entityLoopedStatusChanged = new boolean[entityIdToNodes.length];
        this.looped = new DynamicIntArray(nodeCount, DynamicIntArray.ClearingStrategy.PARTIAL);
    }

    public void mark(int node, LoopedStatus status) {
        this.looped.set(node, status.ordinal());
    }

    public boolean isEntityLooped(BaseTopologicalOrderGraph graph, int entityId, boolean wasEntityLooped) {
        for (int entityNode : this.entityIdToNodes[entityId]) {
            if (!graph.isLooped(this, entityNode)) continue;
            if (!wasEntityLooped) {
                this.entityLoopedStatusChanged[entityId] = true;
            }
            return true;
        }
        if (wasEntityLooped) {
            this.entityLoopedStatusChanged[entityId] = true;
        }
        return false;
    }

    public boolean didEntityLoopedStatusChange(int entityId) {
        return this.entityLoopedStatusChanged[entityId];
    }

    public LoopedStatus status(int node) {
        return VALUES[this.looped.get(node)];
    }

    public void clear() {
        Arrays.fill(this.entityLoopedStatusChanged, false);
        this.looped.clear();
    }
}

