/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.variable.declarative;

import ai.timefold.solver.core.api.function.TriFunction;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.domain.variable.ListVariableStateSupply;
import ai.timefold.solver.core.impl.domain.variable.declarative.ChangedVariableNotifier;
import ai.timefold.solver.core.impl.domain.variable.declarative.DeclarativeShadowVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.declarative.DefaultShadowVariableSession;
import ai.timefold.solver.core.impl.domain.variable.declarative.DefaultTopologicalOrderGraph;
import ai.timefold.solver.core.impl.domain.variable.declarative.EmptyVariableReferenceGraph;
import ai.timefold.solver.core.impl.domain.variable.declarative.EntityVariableUpdaterLookup;
import ai.timefold.solver.core.impl.domain.variable.declarative.GraphChangeType;
import ai.timefold.solver.core.impl.domain.variable.declarative.GraphNode;
import ai.timefold.solver.core.impl.domain.variable.declarative.GraphStructure;
import ai.timefold.solver.core.impl.domain.variable.declarative.ParentVariableType;
import ai.timefold.solver.core.impl.domain.variable.declarative.RootVariableSource;
import ai.timefold.solver.core.impl.domain.variable.declarative.SingleDirectionalParentVariableReferenceGraph;
import ai.timefold.solver.core.impl.domain.variable.declarative.TopologicalOrderGraph;
import ai.timefold.solver.core.impl.domain.variable.declarative.TopologicalSorter;
import ai.timefold.solver.core.impl.domain.variable.declarative.VariableReferenceGraph;
import ai.timefold.solver.core.impl.domain.variable.declarative.VariableReferenceGraphBuilder;
import ai.timefold.solver.core.impl.domain.variable.declarative.VariableSourceReference;
import ai.timefold.solver.core.impl.domain.variable.declarative.VariableUpdaterInfo;
import ai.timefold.solver.core.impl.domain.variable.descriptor.VariableDescriptor;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import ai.timefold.solver.core.impl.util.MutableInt;
import ai.timefold.solver.core.preview.api.domain.metamodel.VariableMetaModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import org.jspecify.annotations.NullMarked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NullMarked
public class DefaultShadowVariableSessionFactory<Solution_> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultShadowVariableSessionFactory.class);
    private final SolutionDescriptor<Solution_> solutionDescriptor;
    private final InnerScoreDirector<Solution_, ?> scoreDirector;
    private final IntFunction<TopologicalOrderGraph> graphCreator;

    public DefaultShadowVariableSessionFactory(SolutionDescriptor<Solution_> solutionDescriptor, InnerScoreDirector<Solution_, ?> scoreDirector, IntFunction<TopologicalOrderGraph> graphCreator) {
        this.solutionDescriptor = solutionDescriptor;
        this.scoreDirector = scoreDirector;
        this.graphCreator = graphCreator;
    }

    public static <Solution_> VariableReferenceGraph buildGraph(SolutionDescriptor<Solution_> solutionDescriptor, VariableReferenceGraphBuilder<Solution_> variableReferenceGraphBuilder, Object[] entities, IntFunction<TopologicalOrderGraph> graphCreator) {
        GraphStructure.GraphStructureAndDirection graphStructureAndDirection = GraphStructure.determineGraphStructure(solutionDescriptor, entities);
        LOGGER.trace("Shadow variable graph structure: {}", (Object)graphStructureAndDirection);
        return switch (graphStructureAndDirection.structure()) {
            default -> throw new IncompatibleClassChangeError();
            case GraphStructure.EMPTY -> EmptyVariableReferenceGraph.INSTANCE;
            case GraphStructure.SINGLE_DIRECTIONAL_PARENT -> {
                InnerScoreDirector scoreDirector = variableReferenceGraphBuilder.changedVariableNotifier.innerScoreDirector();
                if (scoreDirector == null) {
                    yield DefaultShadowVariableSessionFactory.buildArbitraryGraph(solutionDescriptor, variableReferenceGraphBuilder, entities, graphCreator);
                }
                yield DefaultShadowVariableSessionFactory.buildSingleDirectionalParentGraph(solutionDescriptor, variableReferenceGraphBuilder.changedVariableNotifier, graphStructureAndDirection, entities);
            }
            case GraphStructure.ARBITRARY_SINGLE_ENTITY_AT_MOST_ONE_DIRECTIONAL_PARENT_TYPE -> DefaultShadowVariableSessionFactory.buildArbitrarySingleEntityGraph(solutionDescriptor, variableReferenceGraphBuilder, entities, graphCreator);
            case GraphStructure.NO_DYNAMIC_EDGES, GraphStructure.ARBITRARY -> DefaultShadowVariableSessionFactory.buildArbitraryGraph(solutionDescriptor, variableReferenceGraphBuilder, entities, graphCreator);
        };
    }

    static <Solution_> VariableReferenceGraph buildSingleDirectionalParentGraph(SolutionDescriptor<Solution_> solutionDescriptor, ChangedVariableNotifier<Solution_> changedVariableNotifier, GraphStructure.GraphStructureAndDirection graphStructureAndDirection, Object[] entities) {
        List<DeclarativeShadowVariableDescriptor<Solution_>> declarativeShadowVariables = solutionDescriptor.getDeclarativeShadowVariableDescriptors();
        List<DeclarativeShadowVariableDescriptor<Solution_>> sortedDeclarativeVariables = DefaultShadowVariableSessionFactory.topologicallySortedDeclarativeShadowVariables(declarativeShadowVariables);
        TopologicalSorter topologicalSorter = DefaultShadowVariableSessionFactory.getTopologicalSorter(solutionDescriptor, Objects.requireNonNull(changedVariableNotifier.innerScoreDirector()), Objects.requireNonNull(graphStructureAndDirection.direction()));
        return new SingleDirectionalParentVariableReferenceGraph<Solution_>(sortedDeclarativeVariables, topologicalSorter, changedVariableNotifier, entities);
    }

    private static <Solution_> List<DeclarativeShadowVariableDescriptor<Solution_>> topologicallySortedDeclarativeShadowVariables(List<DeclarativeShadowVariableDescriptor<Solution_>> declarativeShadowVariables) {
        LinkedHashMap<String, Integer> nameToIndex = new LinkedHashMap<String, Integer>();
        for (DeclarativeShadowVariableDescriptor<Solution_> declarativeShadowVariableDescriptor : declarativeShadowVariables) {
            nameToIndex.put(declarativeShadowVariableDescriptor.getVariableName(), nameToIndex.size());
        }
        DefaultTopologicalOrderGraph graph = new DefaultTopologicalOrderGraph(nameToIndex.size());
        for (DeclarativeShadowVariableDescriptor<Solution_> declarativeShadowVariableDescriptor : declarativeShadowVariables) {
            Integer toIndex = (Integer)nameToIndex.get(declarativeShadowVariableDescriptor.getVariableName());
            HashSet<Integer> visited = new HashSet<Integer>();
            for (RootVariableSource<?, ?> source : declarativeShadowVariableDescriptor.getSources()) {
                Integer fromIndex;
                VariableSourceReference variableReference;
                VariableMetaModel<?, ?, ?> sourceDeclarativeVariable;
                List<VariableSourceReference> variableReferences = source.variableSourceReferences();
                if (source.parentVariableType() != ParentVariableType.NO_PARENT || (sourceDeclarativeVariable = (variableReference = variableReferences.get(0)).downstreamDeclarativeVariableMetamodel()) == null || !visited.add(fromIndex = (Integer)nameToIndex.get(sourceDeclarativeVariable.name()))) continue;
                graph.addEdge(fromIndex, toIndex);
            }
        }
        graph.commitChanges(new BitSet());
        ArrayList<DeclarativeShadowVariableDescriptor<Solution_>> arrayList = new ArrayList<DeclarativeShadowVariableDescriptor<Solution_>>(declarativeShadowVariables);
        arrayList.sort(Comparator.comparingInt(variable -> graph.getTopologicalOrder((Integer)nameToIndex.get(variable.getVariableName())).order()).thenComparing(VariableDescriptor::getVariableName));
        return arrayList;
    }

    private static <Solution_> TopologicalSorter getTopologicalSorter(SolutionDescriptor<Solution_> solutionDescriptor, InnerScoreDirector<Solution_, ?> scoreDirector, ParentVariableType parentVariableType) {
        return switch (parentVariableType) {
            case ParentVariableType.PREVIOUS -> {
                ListVariableStateSupply listStateSupply = scoreDirector.getListVariableStateSupply(solutionDescriptor.getListVariableDescriptor());
                yield new TopologicalSorter(listStateSupply::getNextElement, Comparator.comparingInt(entity -> Objects.requireNonNullElse(listStateSupply.getIndex(entity), 0)), listStateSupply::getInverseSingleton);
            }
            case ParentVariableType.NEXT -> {
                ListVariableStateSupply listStateSupply = scoreDirector.getListVariableStateSupply(solutionDescriptor.getListVariableDescriptor());
                yield new TopologicalSorter(listStateSupply::getPreviousElement, Comparator.comparingInt(entity -> Objects.requireNonNullElse(listStateSupply.getIndex(entity), 0)).reversed(), listStateSupply::getInverseSingleton);
            }
            default -> throw new IllegalStateException("Impossible state: expected parentVariableType to be previous or next but was %s.".formatted(new Object[]{parentVariableType}));
        };
    }

    private static <Solution_> VariableReferenceGraph buildArbitraryGraph(SolutionDescriptor<Solution_> solutionDescriptor, VariableReferenceGraphBuilder<Solution_> variableReferenceGraphBuilder, Object[] entities, IntFunction<TopologicalOrderGraph> graphCreator) {
        List<DeclarativeShadowVariableDescriptor<Solution_>> declarativeShadowVariableDescriptors = solutionDescriptor.getDeclarativeShadowVariableDescriptors();
        EntityVariableUpdaterLookup variableIdToUpdater = EntityVariableUpdaterLookup.entityIndependentLookup();
        Map<VariableMetaModel<?, ?, ?>, Set<VariableSourceReference>> declarativeShadowVariableToAliasMap = DefaultShadowVariableSessionFactory.createGraphNodes(variableReferenceGraphBuilder, entities, declarativeShadowVariableDescriptors, variableIdToUpdater);
        return DefaultShadowVariableSessionFactory.buildVariableReferenceGraph(declarativeShadowVariableDescriptors, variableReferenceGraphBuilder, declarativeShadowVariableToAliasMap, graphCreator, entities);
    }

    private static <Solution_> VariableReferenceGraph buildVariableReferenceGraph(List<DeclarativeShadowVariableDescriptor<Solution_>> declarativeShadowVariableDescriptors, VariableReferenceGraphBuilder<Solution_> variableReferenceGraphBuilder, Map<VariableMetaModel<?, ?, ?>, Set<VariableSourceReference>> declarativeShadowVariableToAliasMap, IntFunction<TopologicalOrderGraph> graphCreator, Object ... entities) {
        for (DeclarativeShadowVariableDescriptor<Solution_> declarativeShadowVariable : declarativeShadowVariableDescriptors) {
            VariableMetaModel fromVariableId = declarativeShadowVariable.getVariableMetaModel();
            DefaultShadowVariableSessionFactory.createSourceChangeProcessors(entities, variableReferenceGraphBuilder, declarativeShadowVariable, fromVariableId);
            Set<VariableSourceReference> aliasSet = declarativeShadowVariableToAliasMap.get(fromVariableId);
            if (aliasSet == null) continue;
            DefaultShadowVariableSessionFactory.createAliasToVariableChangeProcessors(variableReferenceGraphBuilder, aliasSet, fromVariableId);
        }
        DefaultShadowVariableSessionFactory.createFixedVariableRelationEdges(variableReferenceGraphBuilder, entities, declarativeShadowVariableDescriptors);
        return variableReferenceGraphBuilder.build(graphCreator);
    }

    private static <Solution_> Map<VariableMetaModel<Solution_, ?, ?>, GroupVariableUpdaterInfo<Solution_>> getGroupVariableUpdaterInfoMap(List<DeclarativeShadowVariableDescriptor<Solution_>> declarativeShadowVariableDescriptors, Object[] entities) {
        List<DeclarativeShadowVariableDescriptor<Solution_>> sortedDeclarativeVariableDescriptors = DefaultShadowVariableSessionFactory.topologicallySortedDeclarativeShadowVariables(declarativeShadowVariableDescriptors);
        HashMap groupIndexToVariables = new HashMap();
        ArrayList<DeclarativeShadowVariableDescriptor<Solution_>> groupVariables = new ArrayList<DeclarativeShadowVariableDescriptor<Solution_>>();
        groupIndexToVariables.put(0, groupVariables);
        for (DeclarativeShadowVariableDescriptor<Solution_> declarativeShadowVariableDescriptor : sortedDeclarativeVariableDescriptors) {
            boolean previousHasAlignmentKey;
            boolean hasGroupSources = Arrays.stream(declarativeShadowVariableDescriptor.getSources()).anyMatch(rootVariableSource -> rootVariableSource.parentVariableType() == ParentVariableType.GROUP);
            boolean hasAlignmentKey = declarativeShadowVariableDescriptor.getAlignmentKeyMap() != null;
            boolean bl = previousHasAlignmentKey = !groupVariables.isEmpty() && ((DeclarativeShadowVariableDescriptor)groupVariables.get(0)).getAlignmentKeyMap() != null;
            if (!groupVariables.isEmpty() && (hasGroupSources || hasAlignmentKey || previousHasAlignmentKey)) {
                groupVariables = new ArrayList();
                groupIndexToVariables.put(groupIndexToVariables.size(), groupVariables);
            }
            groupVariables.add(declarativeShadowVariableDescriptor);
        }
        HashMap out = new HashMap();
        ArrayList allUpdaters = new ArrayList();
        HashMap groupedUpdaters = new HashMap();
        int updaterKey = 0;
        for (int entryKey = 0; entryKey < groupIndexToVariables.size(); ++entryKey) {
            List entryGroupVariables = (List)groupIndexToVariables.get(entryKey);
            ArrayList updaters = new ArrayList();
            for (DeclarativeShadowVariableDescriptor declarativeShadowVariableDescriptor : entryGroupVariables) {
                VariableUpdaterInfo updater2 = new VariableUpdaterInfo(declarativeShadowVariableDescriptor.getVariableMetaModel(), updaterKey, declarativeShadowVariableDescriptor, declarativeShadowVariableDescriptor.getEntityDescriptor().getShadowVariableLoopedDescriptor(), declarativeShadowVariableDescriptor.getMemberAccessor(), declarativeShadowVariableDescriptor.getCalculator()::executeGetter);
                if (declarativeShadowVariableDescriptor.getAlignmentKeyMap() != null) {
                    Function<Object, Object> alignmentKeyFunction = declarativeShadowVariableDescriptor.getAlignmentKeyMap();
                    HashMap<Object, List> alignmentKeyToAlignedEntitiesMap = new HashMap<Object, List>();
                    for (Object entity : entities) {
                        if (!declarativeShadowVariableDescriptor.getEntityDescriptor().getEntityClass().isInstance(entity)) continue;
                        Object alignmentKey = alignmentKeyFunction.apply(entity);
                        alignmentKeyToAlignedEntitiesMap.computeIfAbsent(alignmentKey, k -> new ArrayList()).add(entity);
                    }
                    for (Map.Entry entry : alignmentKeyToAlignedEntitiesMap.entrySet()) {
                        VariableUpdaterInfo updaterCopy = updater2.withGroupId(updaterKey);
                        if (entry.getKey() == null) {
                            updaters.add(updaterCopy);
                            allUpdaters.add(updaterCopy);
                        } else {
                            updaterCopy = updaterCopy.withGroupEntities(((List)entry.getValue()).toArray(new Object[0]));
                            Map variableUpdaterMap = groupedUpdaters.computeIfAbsent(declarativeShadowVariableDescriptor, ignored -> new IdentityHashMap());
                            for (Object entity : (List)entry.getValue()) {
                                variableUpdaterMap.put(entity, updaterCopy);
                            }
                        }
                        ++updaterKey;
                    }
                    --updaterKey;
                    continue;
                }
                updaters.add(updater2);
                allUpdaters.add(updater2);
            }
            GroupVariableUpdaterInfo<Solution_> groupVariableUpdaterInfo = new GroupVariableUpdaterInfo<Solution_>(sortedDeclarativeVariableDescriptors, allUpdaters, updaters, groupedUpdaters);
            for (DeclarativeShadowVariableDescriptor declarativeShadowVariableDescriptor : entryGroupVariables) {
                out.put(declarativeShadowVariableDescriptor.getVariableMetaModel(), groupVariableUpdaterInfo);
            }
            ++updaterKey;
        }
        allUpdaters.replaceAll(updater -> updater.withGroupId(groupIndexToVariables.size()));
        return out;
    }

    private static <Solution_> VariableReferenceGraph buildArbitrarySingleEntityGraph(SolutionDescriptor<Solution_> solutionDescriptor, VariableReferenceGraphBuilder<Solution_> variableReferenceGraphBuilder, Object[] entities, IntFunction<TopologicalOrderGraph> graphCreator) {
        List<DeclarativeShadowVariableDescriptor<Solution_>> declarativeShadowVariableDescriptors = solutionDescriptor.getDeclarativeShadowVariableDescriptors();
        HashMap alignmentKeyMappers = new HashMap();
        for (DeclarativeShadowVariableDescriptor<Solution_> declarativeShadowVariableDescriptor : declarativeShadowVariableDescriptors) {
            if (declarativeShadowVariableDescriptor.getAlignmentKeyMap() == null) continue;
            alignmentKeyMappers.put(declarativeShadowVariableDescriptor.getVariableMetaModel(), declarativeShadowVariableDescriptor.getAlignmentKeyMap());
        }
        EntityVariableUpdaterLookup variableIdToUpdater = alignmentKeyMappers.isEmpty() ? EntityVariableUpdaterLookup.entityDependentLookup() : EntityVariableUpdaterLookup.groupedEntityDependentLookup(alignmentKeyMappers::get);
        Map variableIdToGroupedUpdater = DefaultShadowVariableSessionFactory.getGroupVariableUpdaterInfoMap(declarativeShadowVariableDescriptors, entities);
        Map<VariableMetaModel<?, ?, ?>, Set<VariableSourceReference>> declarativeShadowVariableToAliasMap = DefaultShadowVariableSessionFactory.createGraphNodes(variableReferenceGraphBuilder, entities, declarativeShadowVariableDescriptors, variableIdToUpdater, (entity, declarativeShadowVariable, variableId) -> ((GroupVariableUpdaterInfo)variableIdToGroupedUpdater.get(variableId)).getUpdatersForEntityVariable(entity, declarativeShadowVariable));
        return DefaultShadowVariableSessionFactory.buildVariableReferenceGraph(declarativeShadowVariableDescriptors, variableReferenceGraphBuilder, declarativeShadowVariableToAliasMap, graphCreator, entities);
    }

    private static <Solution_> Map<VariableMetaModel<?, ?, ?>, Set<VariableSourceReference>> createGraphNodes(VariableReferenceGraphBuilder<Solution_> graph, Object[] entities, List<DeclarativeShadowVariableDescriptor<Solution_>> declarativeShadowVariableDescriptors, EntityVariableUpdaterLookup<Solution_> variableIdToUpdaters) {
        return DefaultShadowVariableSessionFactory.createGraphNodes(graph, entities, declarativeShadowVariableDescriptors, variableIdToUpdaters, (entity, declarativeShadowVariableDescriptor, variableId) -> Collections.singletonList(new VariableUpdaterInfo(variableId, variableIdToUpdaters.getNextId(), declarativeShadowVariableDescriptor, declarativeShadowVariableDescriptor.getEntityDescriptor().getShadowVariableLoopedDescriptor(), declarativeShadowVariableDescriptor.getMemberAccessor(), declarativeShadowVariableDescriptor.getCalculator()::executeGetter)));
    }

    private static <Solution_> Map<VariableMetaModel<?, ?, ?>, Set<VariableSourceReference>> createGraphNodes(VariableReferenceGraphBuilder<Solution_> graph, Object[] entities, List<DeclarativeShadowVariableDescriptor<Solution_>> declarativeShadowVariableDescriptors, EntityVariableUpdaterLookup<Solution_> variableIdToUpdaters, TriFunction<Object, DeclarativeShadowVariableDescriptor<Solution_>, VariableMetaModel<Solution_, ?, ?>, List<VariableUpdaterInfo<Solution_>>> entityVariableToUpdatersMapper) {
        HashMap result = new HashMap();
        for (Object entity : entities) {
            for (DeclarativeShadowVariableDescriptor declarativeShadowVariableDescriptor : declarativeShadowVariableDescriptors) {
                Class<?> entityClass = declarativeShadowVariableDescriptor.getEntityDescriptor().getEntityClass();
                if (!entityClass.isInstance(entity)) continue;
                VariableMetaModel variableId = declarativeShadowVariableDescriptor.getVariableMetaModel();
                List<VariableUpdaterInfo<Solution_>> updaters = variableIdToUpdaters.computeUpdatersForVariableOnEntity(variableId, entity, () -> (List)entityVariableToUpdatersMapper.apply(entity, declarativeShadowVariableDescriptor, variableId));
                graph.addVariableReferenceEntity(entity, updaters);
                for (RootVariableSource<?, ?> sourceRoot : declarativeShadowVariableDescriptor.getSources()) {
                    for (VariableSourceReference source : sourceRoot.variableSourceReferences()) {
                        if (source.downstreamDeclarativeVariableMetamodel() == null) continue;
                        result.computeIfAbsent(source.downstreamDeclarativeVariableMetamodel(), ignored -> new LinkedHashSet()).add(source);
                    }
                }
            }
        }
        return result;
    }

    private static <Solution_> void createSourceChangeProcessors(Object[] entities, VariableReferenceGraphBuilder<Solution_> variableReferenceGraphBuilder, DeclarativeShadowVariableDescriptor<Solution_> declarativeShadowVariable, VariableMetaModel<Solution_, ?, ?> fromVariableId) {
        for (RootVariableSource<?, ?> source : declarativeShadowVariable.getSources()) {
            for (VariableSourceReference sourcePart : source.variableSourceReferences()) {
                VariableMetaModel<?, ?, ?> toVariableId = sourcePart.variableMetaModel();
                if (sourcePart.isDeclarative()) continue;
                if (sourcePart.onRootEntity()) {
                    variableReferenceGraphBuilder.addAfterProcessor(GraphChangeType.NO_CHANGE, toVariableId, (graph, entity) -> {
                        GraphNode changed = graph.lookupOrNull(fromVariableId, entity);
                        if (changed != null) {
                            graph.markChanged(changed);
                        }
                    });
                    continue;
                }
                IdentityHashMap inverseMap = new IdentityHashMap();
                BiConsumer<Object, Consumer<Object>> visitor = source.getEntityVisitor(sourcePart.chainToVariableEntity());
                for (Object rootEntity : entities) {
                    if (!declarativeShadowVariable.getEntityDescriptor().getEntityClass().isInstance(rootEntity)) continue;
                    visitor.accept(rootEntity, shadowEntity -> inverseMap.computeIfAbsent(shadowEntity, ignored -> new ArrayList()).add(rootEntity));
                }
                variableReferenceGraphBuilder.addAfterProcessor(GraphChangeType.NO_CHANGE, toVariableId, (graph, entity) -> {
                    for (Object item : inverseMap.getOrDefault(entity, Collections.emptyList())) {
                        GraphNode changed = graph.lookupOrNull(fromVariableId, item);
                        if (changed == null) continue;
                        graph.markChanged(changed);
                    }
                });
            }
        }
    }

    private static <Solution_> void createAliasToVariableChangeProcessors(VariableReferenceGraphBuilder<Solution_> variableReferenceGraphBuilder, Set<VariableSourceReference> aliasSet, VariableMetaModel<Solution_, ?, ?> fromVariableId) {
        for (VariableSourceReference alias : aliasSet) {
            VariableMetaModel<?, ?, ?> toVariableId = alias.targetVariableMetamodel();
            VariableMetaModel<?, ?, ?> sourceVariableId = alias.variableMetaModel();
            if (alias.isDeclarative() || !alias.affectGraphEdges()) continue;
            variableReferenceGraphBuilder.addBeforeProcessor(GraphChangeType.REMOVE_EDGE, sourceVariableId, (graph, toEntity) -> {
                GraphNode to = graph.lookupOrNull(toVariableId, toEntity);
                if (to == null) {
                    return;
                }
                Object fromEntity = alias.targetEntityFunctionStartingFromVariableEntity().apply(toEntity);
                if (fromEntity == null) {
                    return;
                }
                GraphNode from = graph.lookupOrNull(fromVariableId, fromEntity);
                if (from == null) {
                    return;
                }
                graph.removeEdge(from, to);
            });
            variableReferenceGraphBuilder.addAfterProcessor(GraphChangeType.ADD_EDGE, sourceVariableId, (graph, toEntity) -> {
                GraphNode to = graph.lookupOrNull(toVariableId, toEntity);
                if (to == null) {
                    return;
                }
                Object fromEntity = alias.findTargetEntity(toEntity);
                if (fromEntity == null) {
                    return;
                }
                GraphNode from = graph.lookupOrNull(fromVariableId, fromEntity);
                if (from == null) {
                    return;
                }
                graph.addEdge(from, to);
            });
        }
    }

    private static <Solution_> void createFixedVariableRelationEdges(VariableReferenceGraphBuilder<Solution_> variableReferenceGraphBuilder, Object[] entities, List<DeclarativeShadowVariableDescriptor<Solution_>> declarativeShadowVariableDescriptors) {
        for (Object entity : entities) {
            for (DeclarativeShadowVariableDescriptor<Solution_> declarativeShadowVariableDescriptor : declarativeShadowVariableDescriptors) {
                Class<?> entityClass = declarativeShadowVariableDescriptor.getEntityDescriptor().getEntityClass();
                if (!entityClass.isInstance(entity)) continue;
                VariableMetaModel toVariableId = declarativeShadowVariableDescriptor.getVariableMetaModel();
                GraphNode to = variableReferenceGraphBuilder.lookupOrError(toVariableId, entity);
                block2: for (RootVariableSource<?, ?> sourceRoot : declarativeShadowVariableDescriptor.getSources()) {
                    for (VariableSourceReference source : sourceRoot.variableSourceReferences()) {
                        if (!source.isTopLevel() || !source.isDeclarative()) continue;
                        VariableMetaModel<?, ?, ?> fromVariableId = source.variableMetaModel();
                        sourceRoot.valueEntityFunction().accept(entity, fromEntity -> {
                            GraphNode from = variableReferenceGraphBuilder.lookupOrError(fromVariableId, fromEntity);
                            variableReferenceGraphBuilder.addFixedEdge(from, to);
                        });
                        continue block2;
                    }
                }
            }
        }
    }

    public DefaultShadowVariableSession<Solution_> forSolution(Solution_ solution) {
        ArrayList entities = new ArrayList();
        this.solutionDescriptor.visitAllEntities(solution, entities::add);
        return this.forEntities(entities.toArray());
    }

    public DefaultShadowVariableSession<Solution_> forEntities(Object ... entities) {
        VariableReferenceGraphBuilder<Solution_> builder = new VariableReferenceGraphBuilder<Solution_>(ChangedVariableNotifier.of(this.scoreDirector));
        VariableReferenceGraph graph = DefaultShadowVariableSessionFactory.buildGraph(this.solutionDescriptor, builder, entities, this.graphCreator);
        return new DefaultShadowVariableSession(graph);
    }

    private record GroupVariableUpdaterInfo<Solution_>(List<DeclarativeShadowVariableDescriptor<Solution_>> sortedDeclarativeVariableDescriptors, List<VariableUpdaterInfo<Solution_>> allUpdaters, List<VariableUpdaterInfo<Solution_>> groupedUpdaters, Map<DeclarativeShadowVariableDescriptor<Solution_>, Map<Object, VariableUpdaterInfo<Solution_>>> variableToEntityToGroupUpdater) {
        public List<VariableUpdaterInfo<Solution_>> getUpdatersForEntityVariable(Object entity, DeclarativeShadowVariableDescriptor<Solution_> declarativeShadowVariableDescriptor) {
            VariableUpdaterInfo<Solution_> updater;
            if (this.variableToEntityToGroupUpdater.containsKey(declarativeShadowVariableDescriptor) && (updater = this.variableToEntityToGroupUpdater.get(declarativeShadowVariableDescriptor).get(entity)) != null) {
                return List.of(updater);
            }
            for (DeclarativeShadowVariableDescriptor<Solution_> shadowVariableDescriptor : this.sortedDeclarativeVariableDescriptors) {
                for (RootVariableSource<?, ?> rootSource : shadowVariableDescriptor.getSources()) {
                    if (rootSource.parentVariableType() != ParentVariableType.GROUP) continue;
                    MutableInt visitedCount = new MutableInt();
                    rootSource.valueEntityFunction().accept(entity, ignored -> visitedCount.increment());
                    if (visitedCount.intValue() <= 0) continue;
                    return this.groupedUpdaters;
                }
            }
            return this.allUpdaters;
        }
    }
}

