/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.variable.declarative;

import ai.timefold.solver.core.api.domain.variable.AbstractVariableListener;
import ai.timefold.solver.core.api.domain.variable.ShadowVariable;
import ai.timefold.solver.core.config.solver.PreviewFeature;
import ai.timefold.solver.core.config.solver.SolverConfig;
import ai.timefold.solver.core.impl.domain.common.ReflectionHelper;
import ai.timefold.solver.core.impl.domain.common.accessor.MemberAccessor;
import ai.timefold.solver.core.impl.domain.common.accessor.MemberAccessorFactory;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.policy.DescriptorPolicy;
import ai.timefold.solver.core.impl.domain.variable.declarative.RootVariableSource;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ShadowVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.VariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.listener.VariableListenerWithSources;
import ai.timefold.solver.core.impl.domain.variable.supply.Demand;
import ai.timefold.solver.core.impl.domain.variable.supply.SupplyManager;
import ai.timefold.solver.core.preview.api.domain.metamodel.PlanningSolutionMetaModel;
import ai.timefold.solver.core.preview.api.domain.variable.declarative.ShadowSources;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;

public class DeclarativeShadowVariableDescriptor<Solution_>
extends ShadowVariableDescriptor<Solution_> {
    MemberAccessor calculator;
    RootVariableSource<?, ?>[] sources;
    String[] sourcePaths;
    String alignmentKey;
    Function<Object, Object> alignmentKeyMap;

    public DeclarativeShadowVariableDescriptor(int ordinal, EntityDescriptor<Solution_> entityDescriptor, MemberAccessor variableMemberAccessor) {
        super(ordinal, entityDescriptor, variableMemberAccessor);
    }

    @Override
    public void processAnnotations(DescriptorPolicy descriptorPolicy) {
        if (!descriptorPolicy.isPreviewFeatureEnabled(PreviewFeature.DECLARATIVE_SHADOW_VARIABLES)) {
            throw new IllegalStateException("The member (%s) on the entity class (%s) is a declarative shadow variable, but the declarative shadow variable preview feature is disabled.\nMaybe enable declarative shadow variables in your %s?\n".formatted(this.variableMemberAccessor.getName(), this.entityDescriptor.getEntityClass().getName(), SolverConfig.class.getSimpleName()));
        }
        ShadowVariable annotation = this.variableMemberAccessor.getAnnotation(ShadowVariable.class);
        String methodName = annotation.supplierName();
        if (methodName.isEmpty()) {
            throw new IllegalStateException("DeclarativeShadowVariableDescriptor was created when method is empty.");
        }
        Method method = ReflectionHelper.getDeclaredMethod(this.variableMemberAccessor.getDeclaringClass(), methodName, new Class[0]);
        if (method == null) {
            throw new IllegalArgumentException("@%s (%s) defines a supplierMethod (%s) that does not exist inside its declaring class (%s).\nMaybe you misspelled the supplierMethod name?".formatted(ShadowVariable.class.getSimpleName(), this.variableName, methodName, this.variableMemberAccessor.getDeclaringClass().getCanonicalName()));
        }
        ShadowSources shadowVariableUpdater = method.getAnnotation(ShadowSources.class);
        if (shadowVariableUpdater == null) {
            throw new IllegalArgumentException("Method \"%s\" referenced from @%s member %s is not annotated with @%s.\nMaybe annotate the method %s with @%s?\n".formatted(methodName, ShadowVariable.class.getSimpleName(), this.variableMemberAccessor, ShadowSources.class.getSimpleName(), methodName, ShadowSources.class.getSimpleName()));
        }
        this.calculator = this.entityDescriptor.getSolutionDescriptor().getMemberAccessorFactory().buildAndCacheMemberAccessor(method, MemberAccessorFactory.MemberAccessorType.FIELD_OR_READ_METHOD, ShadowSources.class, descriptorPolicy.getDomainAccessType());
        this.sourcePaths = shadowVariableUpdater.value();
        if (this.sourcePaths.length == 0) {
            throw new IllegalArgumentException("Method \"%s\" referenced from @%s member %s has no sources.\nA shadow variable must have at least one source (since otherwise it a constant).\nMaybe add one source?\n".formatted(methodName, ShadowVariable.class.getSimpleName(), this.variableMemberAccessor));
        }
        this.alignmentKey = shadowVariableUpdater.alignmentKey() != null && !shadowVariableUpdater.alignmentKey().isEmpty() ? shadowVariableUpdater.alignmentKey() : null;
    }

    @Override
    public List<VariableDescriptor<Solution_>> getSourceVariableDescriptorList() {
        return Collections.emptyList();
    }

    @Override
    public Collection<Class<? extends AbstractVariableListener>> getVariableListenerClasses() {
        return Collections.emptyList();
    }

    @Override
    public Demand<?> getProvidedDemand() {
        return null;
    }

    @Override
    public Iterable<VariableListenerWithSources<Solution_>> buildVariableListeners(SupplyManager supplyManager) {
        return Collections.emptyList();
    }

    @Override
    public void linkVariableDescriptors(DescriptorPolicy descriptorPolicy) {
        this.sources = new RootVariableSource[this.sourcePaths.length];
        PlanningSolutionMetaModel solutionMetamodel = this.entityDescriptor.getSolutionDescriptor().getMetaModel();
        MemberAccessorFactory memberAccessorFactory = this.entityDescriptor.getSolutionDescriptor().getMemberAccessorFactory();
        for (int i = 0; i < this.sources.length; ++i) {
            this.sources[i] = RootVariableSource.from(solutionMetamodel, this.entityDescriptor.getEntityClass(), this.variableMemberAccessor.getName(), this.sourcePaths[i], memberAccessorFactory, descriptorPolicy);
        }
        Member alignmentKeyMember = DeclarativeShadowVariableDescriptor.getAlignmentKeyMemberForEntityProperty(solutionMetamodel, this.entityDescriptor.getEntityClass(), this.calculator, this.variableName, this.alignmentKey);
        this.alignmentKeyMap = alignmentKeyMember != null ? memberAccessorFactory.buildAndCacheMemberAccessor(alignmentKeyMember, MemberAccessorFactory.MemberAccessorType.FIELD_OR_GETTER_METHOD, ShadowSources.class, descriptorPolicy.getDomainAccessType())::executeGetter : null;
    }

    protected static Member getAlignmentKeyMemberForEntityProperty(PlanningSolutionMetaModel<?> solutionMetamodel, Class<?> entityClass, MemberAccessor calculator, String variableName, String propertyName) {
        if (propertyName == null) {
            return null;
        }
        Member member = RootVariableSource.getMember(entityClass, propertyName, entityClass, propertyName);
        if (RootVariableSource.isVariable(solutionMetamodel, member.getDeclaringClass(), member.getName())) {
            throw new IllegalArgumentException("The @%s-annotated supplier method (%s) for variable (%s) on class (%s) uses a alignmentKey (%s) that is a variable.\nA alignmentKey must be a problem fact and cannot change during solving.\n".formatted(ShadowSources.class.getSimpleName(), calculator.getName(), variableName, entityClass.getCanonicalName(), propertyName));
        }
        return member;
    }

    @Override
    public boolean isListVariableSource() {
        return false;
    }

    public MemberAccessor getMemberAccessor() {
        return this.variableMemberAccessor;
    }

    public MemberAccessor getCalculator() {
        return this.calculator;
    }

    public Function<Object, Object> getAlignmentKeyMap() {
        return this.alignmentKeyMap;
    }

    public @Nullable String getAlignmentKeyName() {
        return this.alignmentKey;
    }

    public RootVariableSource<?, ?>[] getSources() {
        return this.sources;
    }
}

