/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.variable.declarative;

import ai.timefold.solver.core.impl.domain.variable.declarative.BaseTopologicalOrderGraph;
import ai.timefold.solver.core.impl.domain.variable.declarative.ChangedVariableNotifier;
import ai.timefold.solver.core.impl.domain.variable.declarative.GraphNode;
import ai.timefold.solver.core.impl.domain.variable.declarative.LoopedTracker;
import ai.timefold.solver.core.impl.domain.variable.declarative.ShadowVariableLoopedVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.declarative.VariableUpdaterInfo;
import ai.timefold.solver.core.impl.domain.variable.descriptor.VariableDescriptor;
import java.util.BitSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

final class AffectedEntitiesUpdater<Solution_>
implements Consumer<BitSet> {
    private final BaseTopologicalOrderGraph graph;
    private final List<GraphNode<Solution_>> nodeList;
    private final ChangedVariableNotifier<Solution_> changedVariableNotifier;
    private final LoopedTracker loopedTracker;
    private final BitSet visited;
    private final PriorityQueue<BaseTopologicalOrderGraph.NodeTopologicalOrder> changeQueue;

    AffectedEntitiesUpdater(BaseTopologicalOrderGraph graph, List<GraphNode<Solution_>> nodeList, Function<Object, List<GraphNode<Solution_>>> entityToContainingNode, int entityCount, ChangedVariableNotifier<Solution_> changedVariableNotifier) {
        this.graph = graph;
        this.nodeList = nodeList;
        this.changedVariableNotifier = changedVariableNotifier;
        int instanceCount = nodeList.size();
        this.loopedTracker = new LoopedTracker(instanceCount, AffectedEntitiesUpdater.createNodeToEntityNodes(entityCount, nodeList, entityToContainingNode));
        this.visited = new BitSet(instanceCount);
        this.changeQueue = new PriorityQueue(instanceCount);
    }

    static <Solution_> int[][] createNodeToEntityNodes(int entityCount, List<GraphNode<Solution_>> nodeList, Function<Object, List<GraphNode<Solution_>>> entityToContainingNode) {
        int[][] out = new int[entityCount][];
        IdentityHashMap<Integer, int[]> entityToNodes = new IdentityHashMap<Integer, int[]>();
        record EntityIdPair(Object entity, int entityId) {
            @Override
            public boolean equals(Object o) {
                if (!(o instanceof EntityIdPair)) {
                    return false;
                }
                EntityIdPair that = (EntityIdPair)o;
                return this.entityId == that.entityId;
            }

            @Override
            public int hashCode() {
                return Objects.hashCode(this.entityId);
            }
        }
        Set entityIdPairSet = nodeList.stream().map(node -> new EntityIdPair(node.entity(), node.entityId())).collect(Collectors.toSet());
        for (EntityIdPair entityIdPair : entityIdPairSet) {
            entityToNodes.put(entityIdPair.entityId(), entityToContainingNode.apply(entityIdPair.entity).stream().mapToInt(GraphNode::graphNodeId).toArray());
        }
        for (Map.Entry entry : entityToNodes.entrySet()) {
            out[((Integer)entry.getKey()).intValue()] = (int[])entry.getValue();
        }
        return out;
    }

    @Override
    public void accept(BitSet changed) {
        this.initializeChangeQueue(changed);
        while (!this.changeQueue.isEmpty()) {
            int nextNode = this.changeQueue.poll().nodeId();
            if (this.visited.get(nextNode)) continue;
            this.visited.set(nextNode);
            GraphNode<Solution_> shadowVariable = this.nodeList.get(nextNode);
            boolean isChanged = this.updateEntityShadowVariables(shadowVariable, this.graph.isLooped(this.loopedTracker, nextNode));
            if (!isChanged) continue;
            PrimitiveIterator.OfInt iterator = this.graph.nodeForwardEdges(nextNode);
            while (iterator.hasNext()) {
                int nextNodeForwardEdge = iterator.nextInt();
                if (this.visited.get(nextNodeForwardEdge)) continue;
                this.changeQueue.add(this.graph.getTopologicalOrder(nextNodeForwardEdge));
            }
        }
        this.loopedTracker.clear();
        this.visited.clear();
    }

    private void initializeChangeQueue(BitSet changed) {
        int i = changed.nextSetBit(0);
        while (i >= 0) {
            this.changeQueue.add(this.graph.getTopologicalOrder(i));
            if (i == Integer.MAX_VALUE) break;
            i = changed.nextSetBit(i + 1);
        }
        changed.clear();
    }

    private boolean updateEntityShadowVariables(GraphNode<Solution_> entityVariable, boolean isVariableLooped) {
        Object entity = entityVariable.entity();
        List<VariableUpdaterInfo<Solution_>> shadowVariableReferences = entityVariable.variableReferences();
        ShadowVariableLoopedVariableDescriptor<Solution_> loopDescriptor = shadowVariableReferences.get(0).shadowVariableLoopedDescriptor();
        boolean anyChanged = false;
        if (loopDescriptor != null) {
            Object[] groupEntities = shadowVariableReferences.get(0).groupEntities();
            int[] groupEntityIds = entityVariable.groupEntityIds();
            if (groupEntities != null) {
                for (int i = 0; i < groupEntityIds.length; ++i) {
                    Object groupEntity = groupEntities[i];
                    int groupEntityId = groupEntityIds[i];
                    anyChanged |= this.updateLoopedStatusOfEntity(groupEntity, groupEntityId, loopDescriptor);
                }
            } else {
                anyChanged |= this.updateLoopedStatusOfEntity(entity, entityVariable.entityId(), loopDescriptor);
            }
        }
        for (VariableUpdaterInfo<Solution_> shadowVariableReference : shadowVariableReferences) {
            anyChanged |= this.updateShadowVariable(isVariableLooped, shadowVariableReference, entity);
        }
        return anyChanged;
    }

    private boolean updateLoopedStatusOfEntity(Object entity, int entityId, ShadowVariableLoopedVariableDescriptor<Solution_> loopDescriptor) {
        boolean oldLooped = (Boolean)loopDescriptor.getValue(entity);
        boolean isEntityLooped = this.loopedTracker.isEntityLooped(this.graph, entityId, oldLooped);
        if (!Objects.equals(oldLooped, isEntityLooped)) {
            this.changeShadowVariableAndNotify(loopDescriptor, entity, isEntityLooped);
        }
        return this.loopedTracker.didEntityLoopedStatusChange(entityId);
    }

    private boolean updateShadowVariable(boolean isLooped, VariableUpdaterInfo<Solution_> shadowVariableReference, Object entity) {
        if (isLooped) {
            return shadowVariableReference.updateIfChanged(entity, null, this.changedVariableNotifier);
        }
        return shadowVariableReference.updateIfChanged(entity, this.changedVariableNotifier);
    }

    private void changeShadowVariableAndNotify(VariableDescriptor<Solution_> variableDescriptor, Object entity, Object newValue) {
        this.changedVariableNotifier.beforeVariableChanged().accept(variableDescriptor, entity);
        variableDescriptor.setValue(entity, newValue);
        this.changedVariableNotifier.afterVariableChanged().accept(variableDescriptor, entity);
    }
}

