/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.solution.descriptor;

import ai.timefold.solver.core.api.domain.autodiscover.AutoDiscoverMemberType;
import ai.timefold.solver.core.api.domain.common.DomainAccessType;
import ai.timefold.solver.core.api.domain.constraintweight.ConstraintConfiguration;
import ai.timefold.solver.core.api.domain.constraintweight.ConstraintConfigurationProvider;
import ai.timefold.solver.core.api.domain.entity.PlanningEntity;
import ai.timefold.solver.core.api.domain.lookup.LookUpStrategyType;
import ai.timefold.solver.core.api.domain.solution.ConstraintWeightOverrides;
import ai.timefold.solver.core.api.domain.solution.PlanningEntityCollectionProperty;
import ai.timefold.solver.core.api.domain.solution.PlanningEntityProperty;
import ai.timefold.solver.core.api.domain.solution.PlanningScore;
import ai.timefold.solver.core.api.domain.solution.PlanningSolution;
import ai.timefold.solver.core.api.domain.solution.ProblemFactCollectionProperty;
import ai.timefold.solver.core.api.domain.solution.ProblemFactProperty;
import ai.timefold.solver.core.api.domain.solution.cloner.SolutionCloner;
import ai.timefold.solver.core.api.domain.valuerange.ValueRangeProvider;
import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.director.ScoreDirector;
import ai.timefold.solver.core.config.solver.PreviewFeature;
import ai.timefold.solver.core.config.util.ConfigUtils;
import ai.timefold.solver.core.impl.domain.common.ReflectionHelper;
import ai.timefold.solver.core.impl.domain.common.accessor.MemberAccessor;
import ai.timefold.solver.core.impl.domain.common.accessor.MemberAccessorFactory;
import ai.timefold.solver.core.impl.domain.common.accessor.ReflectionFieldMemberAccessor;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.lookup.LookUpStrategyResolver;
import ai.timefold.solver.core.impl.domain.policy.DescriptorPolicy;
import ai.timefold.solver.core.impl.domain.score.descriptor.ScoreDescriptor;
import ai.timefold.solver.core.impl.domain.solution.ConstraintConfigurationBasedConstraintWeightSupplier;
import ai.timefold.solver.core.impl.domain.solution.ConstraintWeightSupplier;
import ai.timefold.solver.core.impl.domain.solution.OverridesBasedConstraintWeightSupplier;
import ai.timefold.solver.core.impl.domain.solution.cloner.FieldAccessingSolutionCloner;
import ai.timefold.solver.core.impl.domain.solution.cloner.gizmo.GizmoSolutionCloner;
import ai.timefold.solver.core.impl.domain.solution.cloner.gizmo.GizmoSolutionClonerFactory;
import ai.timefold.solver.core.impl.domain.solution.descriptor.DefaultPlanningEntityDiff;
import ai.timefold.solver.core.impl.domain.solution.descriptor.DefaultPlanningEntityMetaModel;
import ai.timefold.solver.core.impl.domain.solution.descriptor.DefaultPlanningListVariableMetaModel;
import ai.timefold.solver.core.impl.domain.solution.descriptor.DefaultPlanningSolutionDiff;
import ai.timefold.solver.core.impl.domain.solution.descriptor.DefaultPlanningSolutionMetaModel;
import ai.timefold.solver.core.impl.domain.solution.descriptor.DefaultPlanningVariableDiff;
import ai.timefold.solver.core.impl.domain.solution.descriptor.DefaultPlanningVariableMetaModel;
import ai.timefold.solver.core.impl.domain.solution.descriptor.DefaultShadowVariableMetaModel;
import ai.timefold.solver.core.impl.domain.solution.descriptor.DummyMemberAccessor;
import ai.timefold.solver.core.impl.domain.variable.declarative.DeclarativeShadowVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.BasicVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ShadowVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.VariableDescriptor;
import ai.timefold.solver.core.impl.score.definition.ScoreDefinition;
import ai.timefold.solver.core.impl.util.MutableInt;
import ai.timefold.solver.core.impl.util.MutableLong;
import ai.timefold.solver.core.impl.util.MutablePair;
import ai.timefold.solver.core.preview.api.domain.metamodel.PlanningSolutionMetaModel;
import ai.timefold.solver.core.preview.api.domain.metamodel.VariableMetaModel;
import ai.timefold.solver.core.preview.api.domain.solution.diff.PlanningSolutionDiff;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jspecify.annotations.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolutionDescriptor<Solution_> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SolutionDescriptor.class);
    private static final EntityDescriptor<?> NULL_ENTITY_DESCRIPTOR = new EntityDescriptor(-1, null, PlanningEntity.class);
    protected static final Class[] ANNOTATED_MEMBERS_CLASSES = new Class[]{ProblemFactCollectionProperty.class, ValueRangeProvider.class, PlanningEntityCollectionProperty.class, PlanningScore.class};
    private final Class<Solution_> solutionClass;
    private final MemberAccessorFactory memberAccessorFactory;
    private DomainAccessType domainAccessType;
    private AutoDiscoverMemberType autoDiscoverMemberType;
    private LookUpStrategyResolver lookUpStrategyResolver;
    @Deprecated(forRemoval=true, since="1.13.0")
    private MemberAccessor constraintConfigurationMemberAccessor;
    private final Map<String, MemberAccessor> problemFactMemberAccessorMap = new LinkedHashMap<String, MemberAccessor>();
    private final Map<String, MemberAccessor> problemFactCollectionMemberAccessorMap = new LinkedHashMap<String, MemberAccessor>();
    private final Map<String, MemberAccessor> entityMemberAccessorMap = new LinkedHashMap<String, MemberAccessor>();
    private final Map<String, MemberAccessor> entityCollectionMemberAccessorMap = new LinkedHashMap<String, MemberAccessor>();
    private Set<Class<?>> problemFactOrEntityClassSet;
    private List<ListVariableDescriptor<Solution_>> listVariableDescriptorList;
    private ScoreDescriptor<?> scoreDescriptor;
    private ConstraintWeightSupplier<Solution_, ?> constraintWeightSupplier;
    private final Map<Class<?>, EntityDescriptor<Solution_>> entityDescriptorMap = new LinkedHashMap();
    private final List<Class<?>> reversedEntityClassList = new ArrayList();
    private final ConcurrentMap<Class<?>, EntityDescriptor<Solution_>> lowestEntityDescriptorMap = new ConcurrentHashMap();
    private final ConcurrentMap<Class<?>, MemberAccessor> planningIdMemberAccessorMap = new ConcurrentHashMap();
    private PlanningSolutionMetaModel<Solution_> planningSolutionMetaModel;
    private SolutionCloner<Solution_> solutionCloner;

    public static <Solution_> SolutionDescriptor<Solution_> buildSolutionDescriptor(Class<Solution_> solutionClass, Class<?> ... entityClasses) {
        return SolutionDescriptor.buildSolutionDescriptor(solutionClass, Arrays.asList(entityClasses));
    }

    public static <Solution_> SolutionDescriptor<Solution_> buildSolutionDescriptor(Class<Solution_> solutionClass, List<Class<?>> entityClassList) {
        return SolutionDescriptor.buildSolutionDescriptor(EnumSet.noneOf(PreviewFeature.class), solutionClass, entityClassList);
    }

    public static <Solution_> SolutionDescriptor<Solution_> buildSolutionDescriptor(Set<PreviewFeature> enabledPreviewFeaturesSet, Class<Solution_> solutionClass, Class<?> ... entityClasses) {
        return SolutionDescriptor.buildSolutionDescriptor(enabledPreviewFeaturesSet, solutionClass, List.of(entityClasses));
    }

    public static <Solution_> SolutionDescriptor<Solution_> buildSolutionDescriptor(Set<PreviewFeature> enabledPreviewFeaturesSet, Class<Solution_> solutionClass, List<Class<?>> entityClassList) {
        return SolutionDescriptor.buildSolutionDescriptor(enabledPreviewFeaturesSet, DomainAccessType.REFLECTION, solutionClass, null, null, entityClassList);
    }

    public static <Solution_> SolutionDescriptor<Solution_> buildSolutionDescriptor(Set<PreviewFeature> enabledPreviewFeatureSet, DomainAccessType domainAccessType, Class<Solution_> solutionClass, Map<String, MemberAccessor> memberAccessorMap, Map<String, SolutionCloner> solutionClonerMap, List<Class<?>> entityClassList) {
        SolutionDescriptor.assertMutable(solutionClass, "solutionClass");
        SolutionDescriptor.assertSingleInheritance(solutionClass);
        SolutionDescriptor.assertValidAnnotatedMembers(solutionClass);
        solutionClonerMap = Objects.requireNonNullElse(solutionClonerMap, Collections.emptyMap());
        SolutionDescriptor<Solution_> solutionDescriptor = new SolutionDescriptor<Solution_>(solutionClass, memberAccessorMap);
        DescriptorPolicy descriptorPolicy = new DescriptorPolicy();
        if (enabledPreviewFeatureSet != null) {
            descriptorPolicy.setEnabledPreviewFeatureSet(enabledPreviewFeatureSet);
        }
        descriptorPolicy.setDomainAccessType(domainAccessType);
        descriptorPolicy.setGeneratedSolutionClonerMap(solutionClonerMap);
        descriptorPolicy.setMemberAccessorFactory(solutionDescriptor.getMemberAccessorFactory());
        solutionDescriptor.processUnannotatedFieldsAndMethods(descriptorPolicy);
        solutionDescriptor.processAnnotations(descriptorPolicy, entityClassList);
        int ordinal = 0;
        ArrayList updatedEntityClassList = new ArrayList(entityClassList);
        for (Class<?> entityClass : entityClassList) {
            List<Class<?>> inheritedEntityClasses = EntityDescriptor.extractInheritedClasses(entityClass);
            List<Class> filteredInheritedEntityClasses = inheritedEntityClasses.stream().filter(c -> !updatedEntityClassList.contains(c)).toList();
            updatedEntityClassList.addAll(filteredInheritedEntityClasses);
        }
        for (Class<?> entityClass : SolutionDescriptor.sortEntityClassList(updatedEntityClassList)) {
            EntityDescriptor<Solution_> entityDescriptor = new EntityDescriptor<Solution_>(ordinal++, solutionDescriptor, entityClass);
            solutionDescriptor.addEntityDescriptor(entityDescriptor);
            entityDescriptor.processAnnotations(descriptorPolicy);
        }
        solutionDescriptor.afterAnnotationsProcessed(descriptorPolicy);
        if (solutionDescriptor.constraintWeightSupplier != null) {
            solutionDescriptor.constraintWeightSupplier.initialize(solutionDescriptor, descriptorPolicy.getMemberAccessorFactory(), descriptorPolicy.getDomainAccessType());
        }
        return solutionDescriptor;
    }

    public static void assertMutable(Class<?> clz, String classType) {
        if (clz.isRecord()) {
            throw new IllegalArgumentException("The %s (%s) cannot be a record as it needs to be mutable.\nUse a regular class instead.".formatted(classType, clz.getCanonicalName()));
        }
        if (clz.isEnum()) {
            throw new IllegalArgumentException("The %s (%s) cannot be an enum as it needs to be mutable.\nUse a regular class instead.".formatted(classType, clz.getCanonicalName()));
        }
    }

    private static void assertValidAnnotatedMembers(Class<?> clazz) {
        if (clazz.getAnnotation(PlanningSolution.class) == null && SolutionDescriptor.hasAnyAnnotatedMembers(clazz)) {
            List<String> annotatedMembers = SolutionDescriptor.extractAnnotatedMembers(clazz).stream().map(Member::getName).toList();
            throw new IllegalStateException("The class %s is not annotated with @PlanningSolution but defines annotated members.\nMaybe annotate %s with @PlanningSolution.\nMaybe remove the annotated members (%s).".formatted(clazz.getName(), clazz.getName(), annotatedMembers));
        }
        Class<?> otherClazz = clazz.getSuperclass();
        if (otherClazz != null && otherClazz.getAnnotation(PlanningSolution.class) == null && SolutionDescriptor.hasAnyAnnotatedMembers(otherClazz)) {
            List<String> annotatedMembers = SolutionDescriptor.extractAnnotatedMembers(otherClazz).stream().map(Member::getName).toList();
            throw new IllegalStateException("The class %s is not annotated with @PlanningSolution but defines annotated members.\nMaybe annotate %s with @PlanningSolution.\nMaybe remove the annotated members (%s).".formatted(otherClazz.getName(), otherClazz.getName(), annotatedMembers));
        }
    }

    private static void assertSingleInheritance(Class<?> solutionClass) {
        List<Class<?>> inheritedClassList = ConfigUtils.getAllAnnotatedLineageClasses(solutionClass.getSuperclass(), PlanningSolution.class);
        if (inheritedClassList.size() > 1) {
            throw new IllegalStateException("The class %s inherits its @%s annotation from multiple classes (%s).\nRemove solution class(es) from the inheritance chain to create a single-level inheritance structure.".formatted(solutionClass.getName(), PlanningSolution.class.getSimpleName(), inheritedClassList));
        }
    }

    private static List<Class<?>> sortEntityClassList(List<Class<?>> entityClassList) {
        ArrayList sortedEntityClassList = new ArrayList(entityClassList.size());
        for (Class<?> entityClass : entityClassList) {
            boolean added = false;
            for (int i = 0; i < sortedEntityClassList.size(); ++i) {
                Class<?> sortedEntityClass = sortedEntityClassList.get(i);
                if (!entityClass.isAssignableFrom(sortedEntityClass)) continue;
                sortedEntityClassList.add(i, entityClass);
                added = true;
                break;
            }
            if (added) continue;
            sortedEntityClassList.add(entityClass);
        }
        return sortedEntityClassList;
    }

    private static List<Member> extractAnnotatedMembers(Class<?> solutionClass) {
        List<Member> membersList = ConfigUtils.getDeclaredMembers(solutionClass);
        return membersList.stream().filter(member -> !ConfigUtils.extractAnnotationClasses(member, ANNOTATED_MEMBERS_CLASSES).isEmpty()).toList();
    }

    private static boolean hasAnyAnnotatedMembers(Class<?> solutionClass) {
        return !SolutionDescriptor.extractAnnotatedMembers(solutionClass).isEmpty();
    }

    private SolutionDescriptor(Class<Solution_> solutionClass, Map<String, MemberAccessor> memberAccessorMap) {
        this.solutionClass = solutionClass;
        if (solutionClass.getPackage() == null) {
            LOGGER.warn("The solutionClass ({}) should be in a proper java package.", solutionClass);
        }
        this.memberAccessorFactory = new MemberAccessorFactory(memberAccessorMap);
    }

    public void addEntityDescriptor(EntityDescriptor<Solution_> entityDescriptor) {
        Class<?> entityClass = entityDescriptor.getEntityClass();
        for (Class<?> otherEntityClass : this.entityDescriptorMap.keySet()) {
            if (!entityClass.isAssignableFrom(otherEntityClass)) continue;
            throw new IllegalArgumentException("An earlier entityClass (%s) should not be a subclass of a later entityClass (%s). Switch their declaration so superclasses are defined earlier.".formatted(otherEntityClass, entityClass));
        }
        this.entityDescriptorMap.put(entityClass, entityDescriptor);
        this.reversedEntityClassList.add(0, entityClass);
        this.lowestEntityDescriptorMap.put(entityClass, entityDescriptor);
    }

    public void processUnannotatedFieldsAndMethods(DescriptorPolicy descriptorPolicy) {
        this.processConstraintWeights(descriptorPolicy);
    }

    private void processConstraintWeights(DescriptorPolicy descriptorPolicy) {
        block4: for (Class<?> lineageClass : ConfigUtils.getAllParents(this.solutionClass)) {
            List<Member> memberList = ConfigUtils.getDeclaredMembers(lineageClass);
            List<Field> constraintWeightFieldList = memberList.stream().filter(member -> {
                Field field;
                return member instanceof Field && ConstraintWeightOverrides.class.isAssignableFrom((field = (Field)member).getType());
            }).map(f -> (Field)f).toList();
            switch (constraintWeightFieldList.size()) {
                case 0: {
                    continue block4;
                }
                case 1: {
                    if (this.constraintWeightSupplier != null) {
                        throw new IllegalStateException("The solutionClass (%s) has a field of type (%s) which was already found on its parent class.".formatted(lineageClass, ConstraintWeightOverrides.class));
                    }
                    this.constraintWeightSupplier = OverridesBasedConstraintWeightSupplier.create(this, descriptorPolicy, constraintWeightFieldList.get(0));
                    continue block4;
                }
            }
            throw new IllegalStateException("The solutionClass (%s) has more than one field (%s) of type %s.".formatted(this.solutionClass, constraintWeightFieldList, ConstraintWeightOverrides.class));
        }
    }

    public void processAnnotations(DescriptorPolicy descriptorPolicy, List<Class<?>> entityClassList) {
        this.domainAccessType = descriptorPolicy.getDomainAccessType();
        this.processSolutionAnnotations(descriptorPolicy);
        ArrayList potentiallyOverwritingMethodList = new ArrayList();
        List<Class<?>> lineageClassList = ConfigUtils.getAllAnnotatedLineageClasses(this.solutionClass, PlanningSolution.class);
        if (lineageClassList.isEmpty() && this.solutionClass.getSuperclass().isAnnotationPresent(PlanningSolution.class)) {
            lineageClassList = ConfigUtils.getAllAnnotatedLineageClasses(this.solutionClass.getSuperclass(), PlanningSolution.class);
        }
        for (Class<?> lineageClass : lineageClassList) {
            List<Member> memberList = ConfigUtils.getDeclaredMembers(lineageClass);
            for (Member member2 : memberList) {
                if (member2 instanceof Method) {
                    Method method = (Method)member2;
                    if (potentiallyOverwritingMethodList.stream().anyMatch(m -> member2.getName().equals(m.getName()) && ReflectionHelper.isMethodOverwritten(method, m.getDeclaringClass()))) continue;
                }
                this.processValueRangeProviderAnnotation(descriptorPolicy, member2);
                this.processFactEntityOrScoreAnnotation(descriptorPolicy, member2, entityClassList);
            }
            potentiallyOverwritingMethodList.ensureCapacity(potentiallyOverwritingMethodList.size() + memberList.size());
            memberList.stream().filter(Method.class::isInstance).forEach(member -> potentiallyOverwritingMethodList.add((Method)member));
        }
        if (this.entityCollectionMemberAccessorMap.isEmpty() && this.entityMemberAccessorMap.isEmpty()) {
            throw new IllegalStateException("The solutionClass (%s) must have at least 1 member with a %s annotation or a %s annotation.".formatted(this.solutionClass, PlanningEntityCollectionProperty.class.getSimpleName(), PlanningEntityProperty.class.getSimpleName()));
        }
        if (this.scoreDescriptor == null) {
            throw new IllegalStateException("The solutionClass (%s) must have 1 member with a @%s annotation.\nMaybe add a getScore() method with a @%s annotation.".formatted(this.solutionClass, PlanningScore.class.getSimpleName(), PlanningScore.class.getSimpleName()));
        }
    }

    private void processSolutionAnnotations(DescriptorPolicy descriptorPolicy) {
        PlanningSolution annotation = this.extractMostRelevantPlanningSolutionAnnotation();
        this.autoDiscoverMemberType = annotation.autoDiscoverMemberType();
        Class<? extends SolutionCloner> solutionClonerClass = annotation.solutionCloner();
        if (solutionClonerClass != PlanningSolution.NullSolutionCloner.class) {
            this.solutionCloner = ConfigUtils.newInstance(this::toString, "solutionClonerClass", solutionClonerClass);
        }
        LookUpStrategyType lookUpStrategyType = annotation.lookUpStrategyType();
        this.lookUpStrategyResolver = new LookUpStrategyResolver(descriptorPolicy, lookUpStrategyType);
    }

    private @NonNull PlanningSolution extractMostRelevantPlanningSolutionAnnotation() {
        PlanningSolution solutionAnnotation = this.solutionClass.getAnnotation(PlanningSolution.class);
        if (solutionAnnotation != null) {
            return solutionAnnotation;
        }
        Class<Solution_> solutionSuperclass = this.solutionClass.getSuperclass();
        if (solutionSuperclass == null) {
            throw new IllegalStateException("The solutionClass (%s) has been specified as a solution in the configuration, but does not have a @%s annotation.".formatted(this.solutionClass.getCanonicalName(), PlanningSolution.class.getSimpleName()));
        }
        PlanningSolution parentSolutionAnnotation = solutionSuperclass.getAnnotation(PlanningSolution.class);
        if (parentSolutionAnnotation == null) {
            throw new IllegalStateException("The solutionClass (%s) has been specified as a solution in the configuration, but neither it nor its superclass (%s) have a @%s annotation.".formatted(this.solutionClass.getCanonicalName(), solutionSuperclass.getCanonicalName(), PlanningSolution.class.getSimpleName()));
        }
        return parentSolutionAnnotation;
    }

    private void processValueRangeProviderAnnotation(DescriptorPolicy descriptorPolicy, Member member) {
        if (((AnnotatedElement)((Object)member)).isAnnotationPresent(ValueRangeProvider.class)) {
            MemberAccessor memberAccessor = descriptorPolicy.getMemberAccessorFactory().buildAndCacheMemberAccessor(member, MemberAccessorFactory.MemberAccessorType.FIELD_OR_READ_METHOD, ValueRangeProvider.class, descriptorPolicy.getDomainAccessType());
            descriptorPolicy.addFromSolutionValueRangeProvider(memberAccessor);
        }
    }

    private void processFactEntityOrScoreAnnotation(DescriptorPolicy descriptorPolicy, Member member, List<Class<?>> entityClassList) {
        Class<Annotation> annotationClass = this.extractFactEntityOrScoreAnnotationClassOrAutoDiscover(member, entityClassList);
        if (annotationClass == null) {
            return;
        }
        if (annotationClass.equals(ConstraintConfigurationProvider.class)) {
            this.processConstraintConfigurationProviderAnnotation(descriptorPolicy, member, annotationClass);
        } else if (annotationClass.equals(ProblemFactProperty.class) || annotationClass.equals(ProblemFactCollectionProperty.class)) {
            this.processProblemFactPropertyAnnotation(descriptorPolicy, member, annotationClass);
        } else if (annotationClass.equals(PlanningEntityProperty.class) || annotationClass.equals(PlanningEntityCollectionProperty.class)) {
            this.processPlanningEntityPropertyAnnotation(descriptorPolicy, member, annotationClass);
        } else if (annotationClass.equals(PlanningScore.class)) {
            if (this.scoreDescriptor == null) {
                this.scoreDescriptor = ScoreDescriptor.buildScoreDescriptor(descriptorPolicy, member, this.solutionClass);
            } else {
                this.scoreDescriptor.failFastOnDuplicateMember(descriptorPolicy, member, this.solutionClass);
            }
        }
    }

    private Class<? extends Annotation> extractFactEntityOrScoreAnnotationClassOrAutoDiscover(Member member, List<Class<?>> entityClassList) {
        Class annotationClass = ConfigUtils.extractAnnotationClass(member, ConstraintConfigurationProvider.class, ProblemFactProperty.class, ProblemFactCollectionProperty.class, PlanningEntityProperty.class, PlanningEntityCollectionProperty.class, PlanningScore.class);
        if (annotationClass == null) {
            Class<?> type;
            if (this.autoDiscoverMemberType == AutoDiscoverMemberType.FIELD && member instanceof Field) {
                Field field = (Field)member;
                type = field.getType();
            } else {
                Method method;
                type = this.autoDiscoverMemberType == AutoDiscoverMemberType.GETTER && member instanceof Method && ReflectionHelper.isGetterMethod(method = (Method)member) ? method.getReturnType() : null;
            }
            if (type != null) {
                if (Score.class.isAssignableFrom(type)) {
                    annotationClass = PlanningScore.class;
                } else if (Collection.class.isAssignableFrom(type) || type.isArray()) {
                    Class<Object> elementType;
                    if (Collection.class.isAssignableFrom(type)) {
                        Type type2;
                        if (member instanceof Field) {
                            Field f = (Field)member;
                            type2 = f.getGenericType();
                        } else {
                            type2 = ((Method)member).getGenericReturnType();
                        }
                        Type genericType = type2;
                        String memberName = member.getName();
                        if (!(genericType instanceof ParameterizedType)) {
                            throw new IllegalArgumentException("The solutionClass (%s) has a auto discovered member (%s) with a member type (%s) that returns a %s which has no generic parameters.\nMaybe the member (%s) should return a typed %s.".formatted(this.solutionClass, memberName, type, Collection.class.getSimpleName(), memberName, Collection.class.getSimpleName()));
                        }
                        elementType = ConfigUtils.extractGenericTypeParameter("solutionClass", this.solutionClass, type, genericType, null, member.getName()).orElse(Object.class);
                    } else {
                        elementType = type.getComponentType();
                    }
                    if (entityClassList.stream().anyMatch(entityClass -> entityClass.isAssignableFrom(elementType))) {
                        annotationClass = PlanningEntityCollectionProperty.class;
                    } else {
                        if (elementType.isAnnotationPresent(ConstraintConfiguration.class)) {
                            throw new IllegalStateException("The autoDiscoverMemberType (%s) cannot accept a member (%s) of type (%s) with an elementType (%s) that has a @%s annotation.\nMaybe use a member of the type (%s) directly instead of a %s or array of that type.".formatted(new Object[]{this.autoDiscoverMemberType, member, type, elementType, ConstraintConfiguration.class.getSimpleName(), elementType, Collection.class.getSimpleName()}));
                        }
                        annotationClass = ProblemFactCollectionProperty.class;
                    }
                } else {
                    if (Map.class.isAssignableFrom(type)) {
                        throw new IllegalStateException("The autoDiscoverMemberType (%s) does not yet support the member (%s) of type (%s) which is an implementation of %s.".formatted(new Object[]{this.autoDiscoverMemberType, member, type, Map.class.getSimpleName()}));
                    }
                    annotationClass = entityClassList.stream().anyMatch(entityClass -> entityClass.isAssignableFrom(type)) ? PlanningEntityProperty.class : (type.isAnnotationPresent(ConstraintConfiguration.class) ? ConstraintConfigurationProvider.class : ProblemFactProperty.class);
                }
            }
        }
        return annotationClass;
    }

    @Deprecated(forRemoval=true, since="1.13.0")
    private void processConstraintConfigurationProviderAnnotation(DescriptorPolicy descriptorPolicy, Member member, Class<? extends Annotation> annotationClass) {
        if (this.constraintWeightSupplier != null) {
            throw new IllegalStateException("The solution class (%s) has both a %s member and a %s-annotated member.\n%s is deprecated, please remove it from your codebase and keep %s only.".formatted(this.solutionClass, ConstraintWeightOverrides.class.getSimpleName(), ConstraintConfigurationProvider.class.getSimpleName(), ConstraintConfigurationProvider.class.getSimpleName(), ConstraintWeightOverrides.class.getSimpleName()));
        }
        MemberAccessor memberAccessor = descriptorPolicy.getMemberAccessorFactory().buildAndCacheMemberAccessor(member, MemberAccessorFactory.MemberAccessorType.FIELD_OR_READ_METHOD, annotationClass, descriptorPolicy.getDomainAccessType());
        if (this.constraintConfigurationMemberAccessor != null) {
            if (!this.constraintConfigurationMemberAccessor.getName().equals(memberAccessor.getName()) || !this.constraintConfigurationMemberAccessor.getClass().equals(memberAccessor.getClass())) {
                throw new IllegalStateException("The solutionClass (%s) has a @%s annotated member (%s) that is duplicated by another member (%s).\nMaybe the annotation is defined on both the field and its getter.".formatted(this.solutionClass, ConstraintConfigurationProvider.class.getSimpleName(), memberAccessor, this.constraintConfigurationMemberAccessor));
            }
            return;
        }
        this.assertNoFieldAndGetterDuplicationOrConflict(memberAccessor, annotationClass);
        this.constraintConfigurationMemberAccessor = memberAccessor;
        this.problemFactMemberAccessorMap.put(memberAccessor.getName(), memberAccessor);
        Class<?> constraintConfigurationClass = this.constraintConfigurationMemberAccessor.getType();
        if (!constraintConfigurationClass.isAnnotationPresent(ConstraintConfiguration.class)) {
            throw new IllegalStateException("The solutionClass (%s) has a @%s annotated member (%s) that does not return a class (%s) that has a %s annotation.".formatted(this.solutionClass, ConstraintConfigurationProvider.class.getSimpleName(), member, constraintConfigurationClass, ConstraintConfiguration.class.getSimpleName()));
        }
        this.constraintWeightSupplier = ConstraintConfigurationBasedConstraintWeightSupplier.create(this, constraintConfigurationClass);
    }

    private void processProblemFactPropertyAnnotation(DescriptorPolicy descriptorPolicy, Member member, Class<? extends Annotation> annotationClass) {
        Class<?> problemFactType;
        MemberAccessor memberAccessor = descriptorPolicy.getMemberAccessorFactory().buildAndCacheMemberAccessor(member, MemberAccessorFactory.MemberAccessorType.FIELD_OR_READ_METHOD, annotationClass, descriptorPolicy.getDomainAccessType());
        this.assertNoFieldAndGetterDuplicationOrConflict(memberAccessor, annotationClass);
        if (annotationClass == ProblemFactProperty.class) {
            this.problemFactMemberAccessorMap.put(memberAccessor.getName(), memberAccessor);
            problemFactType = memberAccessor.getType();
        } else if (annotationClass == ProblemFactCollectionProperty.class) {
            Class<?> type = memberAccessor.getType();
            if (!Collection.class.isAssignableFrom(type) && !type.isArray()) {
                throw new IllegalStateException("The solutionClass (%s) has a @%s-annotated member (%s) that does not return a %s or an array.".formatted(this.solutionClass, ProblemFactCollectionProperty.class.getSimpleName(), member, Collection.class.getSimpleName()));
            }
            this.problemFactCollectionMemberAccessorMap.put(memberAccessor.getName(), memberAccessor);
            problemFactType = type.isArray() ? type.getComponentType() : ConfigUtils.extractGenericTypeParameterOrFail(PlanningSolution.class.getSimpleName(), memberAccessor.getDeclaringClass(), type, memberAccessor.getGenericType(), annotationClass, memberAccessor.getName());
        } else {
            throw new IllegalStateException("Impossible situation with annotationClass (" + String.valueOf(annotationClass) + ").");
        }
        if (problemFactType.isAnnotationPresent(PlanningEntity.class)) {
            throw new IllegalStateException("The solutionClass (%s) has a @%s-annotated member (%s) that returns a @%s.\nMaybe use @%s instead?".formatted(this.solutionClass, annotationClass.getSimpleName(), memberAccessor.getName(), PlanningEntity.class.getSimpleName(), annotationClass == ProblemFactProperty.class ? PlanningEntityProperty.class.getSimpleName() : PlanningEntityCollectionProperty.class.getSimpleName()));
        }
    }

    private void processPlanningEntityPropertyAnnotation(DescriptorPolicy descriptorPolicy, Member member, Class<? extends Annotation> annotationClass) {
        MemberAccessor memberAccessor = descriptorPolicy.getMemberAccessorFactory().buildAndCacheMemberAccessor(member, MemberAccessorFactory.MemberAccessorType.FIELD_OR_GETTER_METHOD, annotationClass, descriptorPolicy.getDomainAccessType());
        this.assertNoFieldAndGetterDuplicationOrConflict(memberAccessor, annotationClass);
        if (annotationClass == PlanningEntityProperty.class) {
            this.entityMemberAccessorMap.put(memberAccessor.getName(), memberAccessor);
        } else if (annotationClass == PlanningEntityCollectionProperty.class) {
            Class<?> type = memberAccessor.getType();
            if (!Collection.class.isAssignableFrom(type) && !type.isArray()) {
                throw new IllegalStateException("The solutionClass (%s) has a @%s annotated member (%s) that does not return a %s or an array.".formatted(this.solutionClass, PlanningEntityCollectionProperty.class.getSimpleName(), member, Collection.class.getSimpleName()));
            }
            this.entityCollectionMemberAccessorMap.put(memberAccessor.getName(), memberAccessor);
        } else {
            throw new IllegalStateException("Impossible situation with annotationClass (" + String.valueOf(annotationClass) + ").");
        }
    }

    private void assertNoFieldAndGetterDuplicationOrConflict(MemberAccessor memberAccessor, Class<? extends Annotation> annotationClass) {
        Class otherAnnotationClass;
        MemberAccessor duplicate;
        String memberName = memberAccessor.getName();
        if (this.constraintConfigurationMemberAccessor != null && this.constraintConfigurationMemberAccessor.getName().equals(memberName)) {
            duplicate = this.constraintConfigurationMemberAccessor;
            otherAnnotationClass = ConstraintConfigurationProvider.class;
        } else if (this.problemFactMemberAccessorMap.containsKey(memberName)) {
            duplicate = this.problemFactMemberAccessorMap.get(memberName);
            otherAnnotationClass = ProblemFactProperty.class;
        } else if (this.problemFactCollectionMemberAccessorMap.containsKey(memberName)) {
            duplicate = this.problemFactCollectionMemberAccessorMap.get(memberName);
            otherAnnotationClass = ProblemFactCollectionProperty.class;
        } else if (this.entityMemberAccessorMap.containsKey(memberName)) {
            duplicate = this.entityMemberAccessorMap.get(memberName);
            otherAnnotationClass = PlanningEntityProperty.class;
        } else if (this.entityCollectionMemberAccessorMap.containsKey(memberName)) {
            duplicate = this.entityCollectionMemberAccessorMap.get(memberName);
            otherAnnotationClass = PlanningEntityCollectionProperty.class;
        } else {
            return;
        }
        throw new IllegalStateException("The solutionClass (%s) has a @%s annotated member (%s) that is duplicated by a @%s annotated member (%s).\n%s".formatted(this.solutionClass, annotationClass.getSimpleName(), memberAccessor, otherAnnotationClass.getSimpleName(), duplicate, annotationClass.equals(otherAnnotationClass) ? "Maybe the annotation is defined on both the field and its getter." : "Maybe 2 mutually exclusive annotations are configured."));
    }

    private void afterAnnotationsProcessed(DescriptorPolicy descriptorPolicy) {
        for (EntityDescriptor<Solution_> entityDescriptor : this.entityDescriptorMap.values()) {
            entityDescriptor.linkEntityDescriptors(descriptorPolicy);
        }
        for (EntityDescriptor<Solution_> entityDescriptor : this.entityDescriptorMap.values()) {
            entityDescriptor.linkVariableDescriptors(descriptorPolicy);
        }
        this.determineGlobalShadowOrder();
        this.problemFactOrEntityClassSet = this.collectEntityAndProblemFactClasses();
        this.listVariableDescriptorList = this.findListVariableDescriptors();
        this.validateListVariableDescriptors();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("    Model annotations parsed for solution {}:", (Object)this.solutionClass.getSimpleName());
            for (Map.Entry entry : this.entityDescriptorMap.entrySet()) {
                EntityDescriptor entityDescriptor = (EntityDescriptor)entry.getValue();
                LOGGER.trace("        Entity {}:", (Object)entityDescriptor.getEntityClass().getSimpleName());
                for (VariableDescriptor variableDescriptor : entityDescriptor.getDeclaredVariableDescriptors()) {
                    LOGGER.trace("            {} variable {} ({})", new Object[]{variableDescriptor instanceof GenuineVariableDescriptor ? "Genuine" : "Shadow", variableDescriptor.getVariableName(), variableDescriptor.getMemberAccessorSpeedNote()});
                }
            }
        }
        this.initSolutionCloner(descriptorPolicy);
    }

    private void determineGlobalShadowOrder() {
        ArrayList<MutablePair> pairList = new ArrayList<MutablePair>();
        HashMap<ShadowVariableDescriptor<Solution_>, MutablePair<ShadowVariableDescriptor<Solution_>, Integer>> shadowToPairMap = new HashMap<ShadowVariableDescriptor<Solution_>, MutablePair<ShadowVariableDescriptor<Solution_>, Integer>>();
        for (EntityDescriptor<Solution_> entityDescriptor : this.entityDescriptorMap.values()) {
            for (ShadowVariableDescriptor<Solution_> shadowVariableDescriptor : entityDescriptor.getDeclaredShadowVariableDescriptors()) {
                int sourceSize = shadowVariableDescriptor.getSourceVariableDescriptorList().size();
                MutablePair<ShadowVariableDescriptor<Solution_>, Integer> pair = MutablePair.of(shadowVariableDescriptor, sourceSize);
                pairList.add(pair);
                shadowToPairMap.put(shadowVariableDescriptor, pair);
            }
        }
        for (EntityDescriptor<Solution_> entityDescriptor : this.entityDescriptorMap.values()) {
            for (GenuineVariableDescriptor genuineVariableDescriptor : entityDescriptor.getDeclaredGenuineVariableDescriptors()) {
                for (ShadowVariableDescriptor sink : genuineVariableDescriptor.getSinkVariableDescriptorList()) {
                    MutablePair sinkPair = (MutablePair)shadowToPairMap.get(sink);
                    sinkPair.setValue((Integer)sinkPair.getValue() - 1);
                }
            }
        }
        int globalShadowOrder = 0;
        while (!pairList.isEmpty()) {
            pairList.sort(Comparator.comparingInt(MutablePair::getValue));
            MutablePair pair = (MutablePair)pairList.remove(0);
            ShadowVariableDescriptor shadow = (ShadowVariableDescriptor)pair.getKey();
            if ((Integer)pair.getValue() != 0) {
                if ((Integer)pair.getValue() < 0) {
                    throw new IllegalStateException("Impossible state because the shadowVariable (%s) cannot be used more as a sink than it has sources.".formatted(shadow.getSimpleEntityAndVariableName()));
                }
                throw new IllegalStateException("There is a cyclic shadow variable path that involves the shadowVariable (%s) because it must be later than its sources (%s) and also earlier than its sinks (%s).".formatted(shadow.getSimpleEntityAndVariableName(), shadow.getSourceVariableDescriptorList(), shadow.getSinkVariableDescriptorList()));
            }
            for (ShadowVariableDescriptor sink : shadow.getSinkVariableDescriptorList()) {
                MutablePair sinkPair = (MutablePair)shadowToPairMap.get(sink);
                sinkPair.setValue((Integer)sinkPair.getValue() - 1);
            }
            shadow.setGlobalShadowOrder(globalShadowOrder);
            ++globalShadowOrder;
        }
    }

    private void validateListVariableDescriptors() {
        if (this.listVariableDescriptorList.isEmpty()) {
            return;
        }
        if (this.listVariableDescriptorList.size() > 1) {
            throw new UnsupportedOperationException("Defining multiple list variables (%s) across the model is currently not supported.".formatted(this.listVariableDescriptorList));
        }
        ListVariableDescriptor<Solution_> listVariableDescriptor = this.listVariableDescriptorList.get(0);
        EntityDescriptor listVariableEntityDescriptor = listVariableDescriptor.getEntityDescriptor();
        if (this.hasChainedVariable()) {
            ArrayList basicVariableDescriptorList = new ArrayList(listVariableEntityDescriptor.getGenuineVariableDescriptorList());
            basicVariableDescriptorList.remove(listVariableDescriptor);
            throw new UnsupportedOperationException("Combining chained variables (%s) with list variables (%s) on a single planning entity (%s) is not supported.".formatted(basicVariableDescriptorList, listVariableDescriptor, listVariableDescriptor.getEntityDescriptor().getEntityClass().getCanonicalName()));
        }
    }

    private Set<Class<?>> collectEntityAndProblemFactClasses() {
        Stream entityClassStream = this.entityDescriptorMap.keySet().stream();
        Stream<Class> factClassStream = this.problemFactMemberAccessorMap.values().stream().map(MemberAccessor::getType);
        Stream<Class> problemFactOrEntityClassStream = Stream.concat(entityClassStream, factClassStream);
        Stream<Class> factCollectionClassStream = this.problemFactCollectionMemberAccessorMap.values().stream().map(accessor -> ConfigUtils.extractGenericTypeParameter("solutionClass", this.getSolutionClass(), accessor.getType(), accessor.getGenericType(), ProblemFactCollectionProperty.class, accessor.getName()).orElse(Object.class));
        problemFactOrEntityClassStream = Stream.concat(problemFactOrEntityClassStream, factCollectionClassStream);
        if (this.constraintWeightSupplier != null) {
            problemFactOrEntityClassStream = Stream.concat(problemFactOrEntityClassStream, Stream.of(this.constraintWeightSupplier.getProblemFactClass()));
        }
        return problemFactOrEntityClassStream.collect(Collectors.toSet());
    }

    private List<ListVariableDescriptor<Solution_>> findListVariableDescriptors() {
        return this.getGenuineEntityDescriptors().stream().map(EntityDescriptor::getGenuineVariableDescriptorList).flatMap(Collection::stream).filter(VariableDescriptor::isListVariable).map(variableDescriptor -> (ListVariableDescriptor)variableDescriptor).toList();
    }

    private void initSolutionCloner(DescriptorPolicy descriptorPolicy) {
        this.solutionCloner = this.solutionCloner == null ? descriptorPolicy.getGeneratedSolutionClonerMap().get(GizmoSolutionClonerFactory.getGeneratedClassName(this)) : this.solutionCloner;
        SolutionCloner<Solution_> solutionCloner = this.solutionCloner;
        if (solutionCloner instanceof GizmoSolutionCloner) {
            GizmoSolutionCloner gizmoSolutionCloner = (GizmoSolutionCloner)solutionCloner;
            gizmoSolutionCloner.setSolutionDescriptor(this);
        }
        if (this.solutionCloner == null) {
            switch (descriptorPolicy.getDomainAccessType()) {
                case GIZMO: {
                    this.solutionCloner = GizmoSolutionClonerFactory.build(this, this.memberAccessorFactory.getGizmoClassLoader());
                    break;
                }
                case REFLECTION: {
                    this.solutionCloner = new FieldAccessingSolutionCloner(this);
                    break;
                }
                default: {
                    throw new IllegalStateException("The domainAccessType (" + String.valueOf((Object)this.domainAccessType) + ") is not implemented.");
                }
            }
        }
    }

    public Class<Solution_> getSolutionClass() {
        return this.solutionClass;
    }

    public MemberAccessorFactory getMemberAccessorFactory() {
        return this.memberAccessorFactory;
    }

    public DomainAccessType getDomainAccessType() {
        return this.domainAccessType;
    }

    public <Score_ extends Score<Score_>> ScoreDefinition<Score_> getScoreDefinition() {
        return this.getScoreDescriptor().getScoreDefinition();
    }

    public <Score_ extends Score<Score_>> ScoreDescriptor<Score_> getScoreDescriptor() {
        return this.scoreDescriptor;
    }

    public Map<String, MemberAccessor> getProblemFactMemberAccessorMap() {
        return this.problemFactMemberAccessorMap;
    }

    public Map<String, MemberAccessor> getProblemFactCollectionMemberAccessorMap() {
        return this.problemFactCollectionMemberAccessorMap;
    }

    public Map<String, MemberAccessor> getEntityMemberAccessorMap() {
        return this.entityMemberAccessorMap;
    }

    public Map<String, MemberAccessor> getEntityCollectionMemberAccessorMap() {
        return this.entityCollectionMemberAccessorMap;
    }

    public Set<Class<?>> getProblemFactOrEntityClassSet() {
        return this.problemFactOrEntityClassSet;
    }

    public ListVariableDescriptor<Solution_> getListVariableDescriptor() {
        return this.listVariableDescriptorList.isEmpty() ? null : this.listVariableDescriptorList.get(0);
    }

    public SolutionCloner<Solution_> getSolutionCloner() {
        return this.solutionCloner;
    }

    public PlanningSolutionMetaModel<Solution_> getMetaModel() {
        if (this.planningSolutionMetaModel == null) {
            DefaultPlanningSolutionMetaModel metaModel = new DefaultPlanningSolutionMetaModel(this);
            for (EntityDescriptor<Solution_> entityDescriptor : this.getEntityDescriptors()) {
                DefaultPlanningEntityMetaModel entityMetaModel = new DefaultPlanningEntityMetaModel(metaModel, entityDescriptor);
                for (GenuineVariableDescriptor<Solution_> genuineVariableDescriptor : entityDescriptor.getGenuineVariableDescriptorList()) {
                    if (genuineVariableDescriptor.isListVariable()) {
                        ListVariableDescriptor listVariableDescriptor = (ListVariableDescriptor)genuineVariableDescriptor;
                        DefaultPlanningListVariableMetaModel listVariableMetaModel = new DefaultPlanningListVariableMetaModel(entityMetaModel, listVariableDescriptor);
                        entityMetaModel.addVariable(listVariableMetaModel);
                        continue;
                    }
                    BasicVariableDescriptor basicVariableDescriptor = (BasicVariableDescriptor)genuineVariableDescriptor;
                    DefaultPlanningVariableMetaModel basicVariableMetaModel = new DefaultPlanningVariableMetaModel(entityMetaModel, basicVariableDescriptor);
                    entityMetaModel.addVariable(basicVariableMetaModel);
                }
                for (ShadowVariableDescriptor shadowVariableDescriptor : entityDescriptor.getShadowVariableDescriptors()) {
                    DefaultShadowVariableMetaModel shadowVariableMetaModel = new DefaultShadowVariableMetaModel(entityMetaModel, shadowVariableDescriptor);
                    entityMetaModel.addVariable(shadowVariableMetaModel);
                }
                metaModel.addEntity(entityMetaModel);
            }
            this.planningSolutionMetaModel = metaModel;
        }
        return this.planningSolutionMetaModel;
    }

    public List<BasicVariableDescriptor<Solution_>> getBasicVariableDescriptorList() {
        return this.getGenuineEntityDescriptors().stream().flatMap(entityDescriptor -> entityDescriptor.getGenuineBasicVariableDescriptorList().stream()).map(descriptor -> (BasicVariableDescriptor)descriptor).toList();
    }

    public boolean hasBasicVariable() {
        return !this.getBasicVariableDescriptorList().isEmpty();
    }

    public boolean hasChainedVariable() {
        return this.getGenuineEntityDescriptors().stream().anyMatch(EntityDescriptor::hasAnyGenuineChainedVariables);
    }

    public boolean hasListVariable() {
        return this.getListVariableDescriptor() != null;
    }

    public boolean hasBothBasicAndListVariables() {
        return this.hasBasicVariable() && this.hasListVariable();
    }

    @Deprecated(forRemoval=true, since="1.13.0")
    public MemberAccessor getConstraintConfigurationMemberAccessor() {
        return this.constraintConfigurationMemberAccessor;
    }

    public <Score_ extends Score<Score_>> ConstraintWeightSupplier<Solution_, Score_> getConstraintWeightSupplier() {
        return this.constraintWeightSupplier;
    }

    public Set<Class<?>> getEntityClassSet() {
        return this.entityDescriptorMap.keySet();
    }

    public Collection<EntityDescriptor<Solution_>> getEntityDescriptors() {
        return this.entityDescriptorMap.values();
    }

    public Collection<EntityDescriptor<Solution_>> getGenuineEntityDescriptors() {
        ArrayList<EntityDescriptor<Solution_>> genuineEntityDescriptorList = new ArrayList<EntityDescriptor<Solution_>>(this.entityDescriptorMap.size());
        for (EntityDescriptor<Solution_> entityDescriptor : this.entityDescriptorMap.values()) {
            if (!entityDescriptor.hasAnyDeclaredGenuineVariableDescriptor()) continue;
            genuineEntityDescriptorList.add(entityDescriptor);
        }
        return genuineEntityDescriptorList;
    }

    public EntityDescriptor<Solution_> getEntityDescriptorStrict(Class<?> entityClass) {
        return this.entityDescriptorMap.get(entityClass);
    }

    public boolean hasEntityDescriptor(Class<?> entitySubclass) {
        EntityDescriptor<Solution_> entityDescriptor = this.findEntityDescriptor(entitySubclass);
        return entityDescriptor != null;
    }

    public EntityDescriptor<Solution_> findEntityDescriptorOrFail(Class<?> entitySubclass) {
        EntityDescriptor<Solution_> entityDescriptor = this.findEntityDescriptor(entitySubclass);
        if (entityDescriptor == null) {
            throw new IllegalArgumentException("A planning entity is an instance of a class (%s) that is not configured as a planning entity class (%s).\nIf that class (%s) (or superclass thereof) is not a @%s annotated class, maybe your @%s annotated class has an incorrect @%s or @%s annotated member.\nOtherwise, if you're not using the Quarkus extension or Spring Boot starter, maybe that entity class (%s) is missing from your solver configuration.".formatted(entitySubclass, this.getEntityClassSet(), entitySubclass.getSimpleName(), PlanningEntity.class.getSimpleName(), PlanningSolution.class.getSimpleName(), PlanningEntityCollectionProperty.class.getSimpleName(), PlanningEntityProperty.class.getSimpleName(), entitySubclass.getSimpleName()));
        }
        return entityDescriptor;
    }

    public EntityDescriptor<Solution_> findEntityDescriptor(Class<?> entitySubclass) {
        EntityDescriptor cachedEntityDescriptor = (EntityDescriptor)this.lowestEntityDescriptorMap.get(entitySubclass);
        if (cachedEntityDescriptor == NULL_ENTITY_DESCRIPTOR) {
            return null;
        }
        if (cachedEntityDescriptor != null) {
            return cachedEntityDescriptor;
        }
        EntityDescriptor<Solution_> newEntityDescriptor = this.innerFindEntityDescriptor(entitySubclass);
        if (newEntityDescriptor == null) {
            this.lowestEntityDescriptorMap.put(entitySubclass, NULL_ENTITY_DESCRIPTOR);
            return null;
        }
        this.lowestEntityDescriptorMap.put(entitySubclass, newEntityDescriptor);
        return newEntityDescriptor;
    }

    private EntityDescriptor<Solution_> innerFindEntityDescriptor(Class<?> entitySubclass) {
        for (Class<?> entityClass : this.reversedEntityClassList) {
            if (!entityClass.isAssignableFrom(entitySubclass)) continue;
            return this.entityDescriptorMap.get(entityClass);
        }
        return null;
    }

    public VariableDescriptor<Solution_> findVariableDescriptorOrFail(Object entity, String variableName) {
        EntityDescriptor<Solution_> entityDescriptor = this.findEntityDescriptorOrFail(entity.getClass());
        VariableDescriptor<Solution_> variableDescriptor = entityDescriptor.getVariableDescriptor(variableName);
        if (variableDescriptor == null) {
            throw new IllegalArgumentException(entityDescriptor.buildInvalidVariableNameExceptionMessage(variableName));
        }
        return variableDescriptor;
    }

    public LookUpStrategyResolver getLookUpStrategyResolver() {
        return this.lookUpStrategyResolver;
    }

    public Collection<Object> getAllEntitiesAndProblemFacts(Solution_ solution) {
        ArrayList<Object> facts = new ArrayList<Object>();
        this.visitAll(solution, facts::add);
        return facts;
    }

    public int getGenuineEntityCount(Solution_ solution) {
        MutableInt entityCount = new MutableInt();
        this.visitAllEntities(solution, fact -> {
            EntityDescriptor<Solution_> entityDescriptor = this.findEntityDescriptorOrFail(fact.getClass());
            if (entityDescriptor.isGenuine()) {
                entityCount.increment();
            }
        });
        return entityCount.intValue();
    }

    public MemberAccessor getPlanningIdAccessor(Class<?> factClass) {
        MemberAccessor memberAccessor = (MemberAccessor)this.planningIdMemberAccessorMap.get(factClass);
        if (memberAccessor == null) {
            memberAccessor = ConfigUtils.findPlanningIdMemberAccessor(factClass, this.getMemberAccessorFactory(), this.getDomainAccessType());
            MemberAccessor nonNullMemberAccessor = Objects.requireNonNullElse(memberAccessor, DummyMemberAccessor.INSTANCE);
            this.planningIdMemberAccessorMap.put(factClass, nonNullMemberAccessor);
            return memberAccessor;
        }
        if (memberAccessor == DummyMemberAccessor.INSTANCE) {
            return null;
        }
        return memberAccessor;
    }

    public void visitAllEntities(Solution_ solution, Consumer<Object> visitor) {
        this.visitAllEntities(solution, visitor, collection -> collection.forEach(visitor));
    }

    private void visitAllEntities(Solution_ solution, Consumer<Object> visitor, Consumer<Collection<Object>> collectionVisitor) {
        for (MemberAccessor entityMemberAccessor : this.entityMemberAccessorMap.values()) {
            Object entity = this.extractMemberObject(entityMemberAccessor, solution);
            if (entity == null) continue;
            visitor.accept(entity);
        }
        for (MemberAccessor entityCollectionMemberAccessor : this.entityCollectionMemberAccessorMap.values()) {
            Collection<Object> entityCollection = this.extractMemberCollectionOrArray(entityCollectionMemberAccessor, solution, false);
            collectionVisitor.accept(entityCollection);
        }
    }

    public void visitEntitiesByEntityClass(Solution_ solution, Class<?> entityClass, Predicate<Object> visitor) {
        for (MemberAccessor entityMemberAccessor : this.entityMemberAccessorMap.values()) {
            Object entity = this.extractMemberObject(entityMemberAccessor, solution);
            if (!entityClass.isInstance(entity) || !visitor.test(entity)) continue;
            return;
        }
        for (MemberAccessor entityCollectionMemberAccessor : this.entityCollectionMemberAccessorMap.values()) {
            Optional<Class<?>> optionalTypeParameter = ConfigUtils.extractGenericTypeParameter("solutionClass", entityCollectionMemberAccessor.getDeclaringClass(), entityCollectionMemberAccessor.getType(), entityCollectionMemberAccessor.getGenericType(), null, entityCollectionMemberAccessor.getName());
            boolean collectionGuaranteedToContainOnlyGivenEntityType = optionalTypeParameter.map(entityClass::isAssignableFrom).orElse(false);
            if (collectionGuaranteedToContainOnlyGivenEntityType) {
                Collection<Object> entityCollection = this.extractMemberCollectionOrArray(entityCollectionMemberAccessor, solution, false);
                for (Object o : entityCollection) {
                    if (!visitor.test(o)) continue;
                    return;
                }
                continue;
            }
            boolean collectionCouldPossiblyContainGivenEntityType = optionalTypeParameter.map(e -> e.isAssignableFrom(entityClass)).orElse(true);
            if (!collectionCouldPossiblyContainGivenEntityType) continue;
            Collection<Object> entityCollection = this.extractMemberCollectionOrArray(entityCollectionMemberAccessor, solution, false);
            for (Object entity : entityCollection) {
                if (!entityClass.isInstance(entity) || !visitor.test(entity)) continue;
                return;
            }
        }
    }

    public void visitAllProblemFacts(Solution_ solution, Consumer<Object> visitor) {
        for (MemberAccessor accessor : this.problemFactMemberAccessorMap.values()) {
            Object object = this.extractMemberObject(accessor, solution);
            if (object == null) continue;
            visitor.accept(object);
        }
        for (MemberAccessor accessor : this.problemFactCollectionMemberAccessorMap.values()) {
            Collection<Object> objects = this.extractMemberCollectionOrArray(accessor, solution, true);
            for (Object object : objects) {
                visitor.accept(object);
            }
        }
    }

    public void visitAll(Solution_ solution, Consumer<Object> visitor) {
        this.visitAllProblemFacts(solution, visitor);
        this.visitAllEntities(solution, visitor);
    }

    public boolean hasMovableEntities(ScoreDirector<Solution_> scoreDirector) {
        Solution_ workingSolution = scoreDirector.getWorkingSolution();
        return this.extractAllEntitiesStream(workingSolution).anyMatch(entity -> this.findEntityDescriptorOrFail(entity.getClass()).isMovable(workingSolution, entity));
    }

    public long getGenuineVariableCount(Solution_ solution) {
        MutableLong result = new MutableLong();
        this.visitAllEntities(solution, entity -> {
            EntityDescriptor<Solution_> entityDescriptor = this.findEntityDescriptorOrFail(entity.getClass());
            if (entityDescriptor.isGenuine()) {
                result.add(entityDescriptor.getGenuineVariableCount());
            }
        });
        return result.longValue();
    }

    public List<ShadowVariableDescriptor<Solution_>> getAllShadowVariableDescriptors() {
        ArrayList<ShadowVariableDescriptor<Solution_>> out = new ArrayList<ShadowVariableDescriptor<Solution_>>();
        for (EntityDescriptor<Solution_> entityDescriptor : this.entityDescriptorMap.values()) {
            out.addAll(entityDescriptor.getShadowVariableDescriptors());
        }
        return out;
    }

    public List<DeclarativeShadowVariableDescriptor<Solution_>> getDeclarativeShadowVariableDescriptors() {
        HashSet<DeclarativeShadowVariableDescriptor> out = new HashSet<DeclarativeShadowVariableDescriptor>();
        for (EntityDescriptor<Solution_> entityDescriptor : this.entityDescriptorMap.values()) {
            entityDescriptor.getShadowVariableDescriptors();
            for (ShadowVariableDescriptor<Solution_> shadowVariableDescriptor : entityDescriptor.getShadowVariableDescriptors()) {
                if (!(shadowVariableDescriptor instanceof DeclarativeShadowVariableDescriptor)) continue;
                DeclarativeShadowVariableDescriptor declarativeShadowVariableDescriptor = (DeclarativeShadowVariableDescriptor)shadowVariableDescriptor;
                out.add(declarativeShadowVariableDescriptor);
            }
        }
        return new ArrayList<DeclarativeShadowVariableDescriptor<Solution_>>(out);
    }

    public Stream<Object> extractAllEntitiesStream(Solution_ solution) {
        Stream<Object> stream = Stream.empty();
        for (MemberAccessor memberAccessor : this.entityMemberAccessorMap.values()) {
            Object entity = this.extractMemberObject(memberAccessor, solution);
            if (entity == null) continue;
            stream = Stream.concat(stream, Stream.of(entity));
        }
        for (MemberAccessor memberAccessor : this.entityCollectionMemberAccessorMap.values()) {
            Collection<Object> entityCollection = this.extractMemberCollectionOrArray(memberAccessor, solution, false);
            stream = Stream.concat(stream, entityCollection.stream());
        }
        return stream;
    }

    private Object extractMemberObject(MemberAccessor memberAccessor, Solution_ solution) {
        return memberAccessor.executeGetter(solution);
    }

    private Collection<Object> extractMemberCollectionOrArray(MemberAccessor memberAccessor, Solution_ solution, boolean isFact) {
        List<Object> collection;
        if (memberAccessor.getType().isArray()) {
            Object arrayObject = memberAccessor.executeGetter(solution);
            collection = ReflectionHelper.transformArrayToList(arrayObject);
        } else {
            collection = (List<Object>)memberAccessor.executeGetter(solution);
        }
        if (collection == null) {
            throw new IllegalArgumentException("The solutionClass (%s)'s %s (%s) should never return null.\n%sMaybe that property (%s) was set with null instead of an empty collection/array when the class (%s) instance was created.".formatted(this.solutionClass, isFact ? "factCollectionProperty" : "entityCollectionProperty", memberAccessor, memberAccessor instanceof ReflectionFieldMemberAccessor ? "" : "Maybe the getter/method always returns null instead of the actual data.\n", memberAccessor.getName(), this.solutionClass.getSimpleName()));
        }
        return collection;
    }

    public <Score_ extends Score<Score_>> Score_ getScore(Solution_ solution) {
        return this.getScoreDescriptor().getScore(solution);
    }

    public <Score_ extends Score<Score_>> void setScore(Solution_ solution, Score_ score) {
        this.getScoreDescriptor().setScore(solution, score);
    }

    public PlanningSolutionDiff<Solution_> diff(Solution_ oldSolution, Solution_ newSolution) {
        SortedMap<String, Set<Object>> oldEntities = this.sortEntitiesForDiff(oldSolution);
        SortedMap<String, Set<Object>> newEntities = this.sortEntitiesForDiff(newSolution);
        LinkedHashSet<Object> removedOldEntities = new LinkedHashSet<Object>(oldEntities.size());
        LinkedHashMap oldToNewEntities = new LinkedHashMap(newEntities.size());
        for (Map.Entry<String, Set<Object>> entry : oldEntities.entrySet()) {
            String entityClassName = entry.getKey();
            for (Object object : entry.getValue()) {
                Object newEntity2 = newEntities.getOrDefault(entityClassName, Collections.emptySet()).stream().filter(e -> Objects.equals(e, oldEntity)).findFirst().orElse(null);
                if (newEntity2 == null) {
                    removedOldEntities.add(object);
                    continue;
                }
                oldToNewEntities.put(object, newEntity2);
            }
        }
        LinkedHashSet addedNewEntities = newEntities.values().stream().flatMap(Collection::stream).filter(newEntity -> !oldToNewEntities.containsValue(newEntity)).collect(Collectors.toCollection(LinkedHashSet::new));
        Comparator<VariableDescriptor> variableDescriptorComparator = Comparator.comparing(variableDescriptor -> variableDescriptor instanceof GenuineVariableDescriptor ? "0" : "1").thenComparingInt(VariableDescriptor::getOrdinal);
        DefaultPlanningSolutionDiff<Solution_> solutionDiff = new DefaultPlanningSolutionDiff<Solution_>(this.getMetaModel(), oldSolution, newSolution, removedOldEntities, addedNewEntities);
        for (Map.Entry entry : oldToNewEntities.entrySet()) {
            Object oldEntity = entry.getKey();
            Object newEntity3 = entry.getValue();
            EntityDescriptor<Solution_> entityDescriptor = this.findEntityDescriptorOrFail(oldEntity.getClass());
            DefaultPlanningEntityDiff entityDiff = new DefaultPlanningEntityDiff(solutionDiff, entry.getKey());
            entityDescriptor.getVariableDescriptorMap().values().stream().sorted(variableDescriptorComparator).flatMap(variableDescriptor -> {
                Object newValue;
                Object oldValue = variableDescriptor.getValue(oldEntity);
                if (Objects.equals(oldValue, newValue = variableDescriptor.getValue(newEntity3))) {
                    return Stream.empty();
                }
                VariableMetaModel variableMetaModel = entityDiff.entityMetaModel().variable(variableDescriptor.getVariableName());
                DefaultPlanningVariableDiff variableDiff = new DefaultPlanningVariableDiff(entityDiff, variableMetaModel, oldValue, newValue);
                return Stream.of(variableDiff);
            }).forEach(entityDiff::addVariableDiff);
            if (entityDiff.variableDiffs().isEmpty()) continue;
            solutionDiff.addEntityDiff(entityDiff);
        }
        return solutionDiff;
    }

    private SortedMap<String, Set<Object>> sortEntitiesForDiff(Solution_ solution) {
        return this.getEntityDescriptors().stream().map(descriptor -> descriptor.extractEntities(solution)).flatMap(Collection::stream).collect(Collectors.groupingBy(s -> s.getClass().getCanonicalName(), TreeMap::new, Collectors.toCollection(LinkedHashSet::new)));
    }

    public String toString() {
        return "%s(%s)".formatted(this.getClass().getSimpleName(), this.solutionClass.getName());
    }
}

