/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.config.heuristic.selector.move;

import ai.timefold.solver.core.config.heuristic.selector.common.nearby.NearbySelectionConfig;
import ai.timefold.solver.core.config.heuristic.selector.entity.EntitySelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.list.DestinationSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.generic.ChangeMoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.generic.SwapMoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.generic.chained.TailChainSwapMoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.generic.list.ListChangeMoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.generic.list.ListSwapMoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.generic.list.kopt.KOptListMoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.value.ValueSelectorConfig;
import ai.timefold.solver.core.config.util.ConfigUtils;
import ai.timefold.solver.core.impl.heuristic.selector.common.nearby.NearbyDistanceMeter;
import java.util.Random;
import org.jspecify.annotations.NonNull;

public final class NearbyUtil {
    public static @NonNull ChangeMoveSelectorConfig enable(@NonNull ChangeMoveSelectorConfig changeMoveSelectorConfig, @NonNull Class<? extends NearbyDistanceMeter<?, ?>> distanceMeter, @NonNull Random random) {
        ChangeMoveSelectorConfig nearbyConfig = changeMoveSelectorConfig.copyConfig();
        EntitySelectorConfig entityConfig = NearbyUtil.configureEntitySelector(nearbyConfig.getEntitySelectorConfig(), random);
        ValueSelectorConfig valueConfig = NearbyUtil.configureValueSelector(nearbyConfig.getValueSelectorConfig(), entityConfig.getId(), distanceMeter);
        return nearbyConfig.withEntitySelectorConfig(entityConfig).withValueSelectorConfig(valueConfig);
    }

    private static EntitySelectorConfig configureEntitySelector(EntitySelectorConfig entitySelectorConfig, Random random) {
        if (entitySelectorConfig == null) {
            entitySelectorConfig = new EntitySelectorConfig();
        }
        String entitySelectorId = ConfigUtils.addRandomSuffix("entitySelector", random);
        entitySelectorConfig.withId(entitySelectorId);
        return entitySelectorConfig;
    }

    private static ValueSelectorConfig configureValueSelector(ValueSelectorConfig valueSelectorConfig, String recordingSelectorId, Class<? extends NearbyDistanceMeter<?, ?>> distanceMeter) {
        if (valueSelectorConfig == null) {
            valueSelectorConfig = new ValueSelectorConfig();
        }
        return valueSelectorConfig.withNearbySelectionConfig(NearbyUtil.configureNearbySelectionWithEntity(recordingSelectorId, distanceMeter));
    }

    private static NearbySelectionConfig configureNearbySelectionWithEntity(String recordingSelectorId, Class<? extends NearbyDistanceMeter<?, ?>> distanceMeter) {
        return new NearbySelectionConfig().withOriginEntitySelectorConfig(new EntitySelectorConfig().withMimicSelectorRef(recordingSelectorId)).withNearbyDistanceMeterClass(distanceMeter);
    }

    public static @NonNull ChangeMoveSelectorConfig enable(@NonNull ChangeMoveSelectorConfig changeMoveSelectorConfig, Class<? extends NearbyDistanceMeter<?, ?>> distanceMeter, String recordingSelectorId) {
        ChangeMoveSelectorConfig nearbyConfig = changeMoveSelectorConfig.copyConfig();
        EntitySelectorConfig entityConfig = new EntitySelectorConfig().withMimicSelectorRef(recordingSelectorId);
        ValueSelectorConfig valueConfig = NearbyUtil.configureValueSelector(nearbyConfig.getValueSelectorConfig(), recordingSelectorId, distanceMeter);
        return nearbyConfig.withEntitySelectorConfig(entityConfig).withValueSelectorConfig(valueConfig);
    }

    public static @NonNull SwapMoveSelectorConfig enable(@NonNull SwapMoveSelectorConfig swapMoveSelectorConfig, @NonNull Class<? extends NearbyDistanceMeter<?, ?>> distanceMeter, @NonNull Random random) {
        SwapMoveSelectorConfig nearbyConfig = swapMoveSelectorConfig.copyConfig();
        EntitySelectorConfig entityConfig = NearbyUtil.configureEntitySelector(nearbyConfig.getEntitySelectorConfig(), random);
        EntitySelectorConfig secondaryConfig = nearbyConfig.getSecondaryEntitySelectorConfig();
        if (secondaryConfig == null) {
            secondaryConfig = new EntitySelectorConfig();
        }
        secondaryConfig.withNearbySelectionConfig(NearbyUtil.configureNearbySelectionWithEntity(entityConfig.getId(), distanceMeter));
        return nearbyConfig.withEntitySelectorConfig(entityConfig).withSecondaryEntitySelectorConfig(secondaryConfig);
    }

    public static @NonNull TailChainSwapMoveSelectorConfig enable(@NonNull TailChainSwapMoveSelectorConfig tailChainSwapMoveSelectorConfig, @NonNull Class<? extends NearbyDistanceMeter<?, ?>> distanceMeter, @NonNull Random random) {
        TailChainSwapMoveSelectorConfig nearbyConfig = tailChainSwapMoveSelectorConfig.copyConfig();
        EntitySelectorConfig entityConfig = NearbyUtil.configureEntitySelector(nearbyConfig.getEntitySelectorConfig(), random);
        ValueSelectorConfig valueConfig = NearbyUtil.configureValueSelector(nearbyConfig.getValueSelectorConfig(), entityConfig.getId(), distanceMeter);
        return nearbyConfig.withEntitySelectorConfig(entityConfig).withValueSelectorConfig(valueConfig);
    }

    public static @NonNull ListChangeMoveSelectorConfig enable(@NonNull ListChangeMoveSelectorConfig listChangeMoveSelectorConfig, @NonNull Class<? extends NearbyDistanceMeter<?, ?>> distanceMeter, @NonNull Random random) {
        ListChangeMoveSelectorConfig nearbyConfig = listChangeMoveSelectorConfig.copyConfig();
        ValueSelectorConfig valueConfig = NearbyUtil.configureValueSelector(nearbyConfig.getValueSelectorConfig(), random);
        DestinationSelectorConfig destinationConfig = nearbyConfig.getDestinationSelectorConfig();
        if (destinationConfig == null) {
            destinationConfig = new DestinationSelectorConfig();
        }
        destinationConfig.withNearbySelectionConfig(NearbyUtil.configureNearbySelectionWithValue(valueConfig.getId(), distanceMeter));
        nearbyConfig.withValueSelectorConfig(valueConfig).withDestinationSelectorConfig(destinationConfig);
        return nearbyConfig;
    }

    private static NearbySelectionConfig configureNearbySelectionWithValue(String recordingSelectorId, Class<? extends NearbyDistanceMeter<?, ?>> distanceMeter) {
        return new NearbySelectionConfig().withOriginValueSelectorConfig(new ValueSelectorConfig().withMimicSelectorRef(recordingSelectorId)).withNearbyDistanceMeterClass(distanceMeter);
    }

    public static @NonNull ListChangeMoveSelectorConfig enable(@NonNull ListChangeMoveSelectorConfig listChangeMoveSelectorConfig, @NonNull Class<? extends NearbyDistanceMeter<?, ?>> distanceMeter, @NonNull String recordingSelectorId) {
        ListChangeMoveSelectorConfig nearbyConfig = listChangeMoveSelectorConfig.copyConfig();
        ValueSelectorConfig valueConfig = new ValueSelectorConfig().withMimicSelectorRef(recordingSelectorId);
        DestinationSelectorConfig destinationConfig = nearbyConfig.getDestinationSelectorConfig();
        if (destinationConfig == null) {
            destinationConfig = new DestinationSelectorConfig();
        }
        destinationConfig.withNearbySelectionConfig(NearbyUtil.configureNearbySelectionWithValue(recordingSelectorId, distanceMeter));
        return nearbyConfig.withValueSelectorConfig(valueConfig).withDestinationSelectorConfig(destinationConfig);
    }

    private static ValueSelectorConfig configureValueSelector(ValueSelectorConfig valueSelectorConfig, Random random) {
        if (valueSelectorConfig == null) {
            valueSelectorConfig = new ValueSelectorConfig();
        }
        String valueSelectorId = ConfigUtils.addRandomSuffix("valueSelector", random);
        valueSelectorConfig.withId(valueSelectorId);
        return valueSelectorConfig;
    }

    public static @NonNull ListSwapMoveSelectorConfig enable(@NonNull ListSwapMoveSelectorConfig listSwapMoveSelectorConfig, @NonNull Class<? extends NearbyDistanceMeter<?, ?>> distanceMeter, @NonNull Random random) {
        ListSwapMoveSelectorConfig nearbyConfig = listSwapMoveSelectorConfig.copyConfig();
        ValueSelectorConfig valueConfig = NearbyUtil.configureValueSelector(nearbyConfig.getValueSelectorConfig(), random);
        ValueSelectorConfig secondaryConfig = NearbyUtil.configureSecondaryValueSelector(nearbyConfig.getSecondaryValueSelectorConfig(), valueConfig, distanceMeter);
        return nearbyConfig.withValueSelectorConfig(valueConfig).withSecondaryValueSelectorConfig(secondaryConfig);
    }

    private static ValueSelectorConfig configureSecondaryValueSelector(ValueSelectorConfig secondaryValueSelectorConfig, ValueSelectorConfig primaryValueSelectorConfig, Class<? extends NearbyDistanceMeter<?, ?>> distanceMeter) {
        if (secondaryValueSelectorConfig == null) {
            secondaryValueSelectorConfig = new ValueSelectorConfig();
        }
        secondaryValueSelectorConfig.withNearbySelectionConfig(NearbyUtil.configureNearbySelectionWithValue(primaryValueSelectorConfig.getId(), distanceMeter));
        return secondaryValueSelectorConfig;
    }

    public static @NonNull KOptListMoveSelectorConfig enable(@NonNull KOptListMoveSelectorConfig kOptListMoveSelectorConfig, @NonNull Class<? extends NearbyDistanceMeter<?, ?>> distanceMeter, @NonNull Random random) {
        KOptListMoveSelectorConfig nearbyConfig = kOptListMoveSelectorConfig.copyConfig();
        ValueSelectorConfig originConfig = NearbyUtil.configureValueSelector(nearbyConfig.getOriginSelectorConfig(), random);
        ValueSelectorConfig valueConfig = NearbyUtil.configureSecondaryValueSelector(nearbyConfig.getValueSelectorConfig(), originConfig, distanceMeter);
        return nearbyConfig.withOriginSelectorConfig(originConfig).withValueSelectorConfig(valueConfig);
    }

    private NearbyUtil() {
    }
}

