/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.api.score.stream;

import ai.timefold.solver.core.api.function.PentaPredicate;
import ai.timefold.solver.core.api.function.QuadFunction;
import ai.timefold.solver.core.api.function.QuadPredicate;
import ai.timefold.solver.core.api.function.TriFunction;
import ai.timefold.solver.core.api.function.TriPredicate;
import ai.timefold.solver.core.api.score.stream.bi.BiJoiner;
import ai.timefold.solver.core.api.score.stream.penta.PentaJoiner;
import ai.timefold.solver.core.api.score.stream.quad.QuadJoiner;
import ai.timefold.solver.core.api.score.stream.tri.TriJoiner;
import ai.timefold.solver.core.impl.bavet.bi.joiner.DefaultBiJoiner;
import ai.timefold.solver.core.impl.bavet.bi.joiner.FilteringBiJoiner;
import ai.timefold.solver.core.impl.bavet.common.joiner.JoinerType;
import ai.timefold.solver.core.impl.bavet.penta.joiner.DefaultPentaJoiner;
import ai.timefold.solver.core.impl.bavet.penta.joiner.FilteringPentaJoiner;
import ai.timefold.solver.core.impl.bavet.quad.joiner.DefaultQuadJoiner;
import ai.timefold.solver.core.impl.bavet.quad.joiner.FilteringQuadJoiner;
import ai.timefold.solver.core.impl.bavet.tri.joiner.DefaultTriJoiner;
import ai.timefold.solver.core.impl.bavet.tri.joiner.FilteringTriJoiner;
import ai.timefold.solver.core.impl.util.ConstantLambdaUtils;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import org.jspecify.annotations.NonNull;

public final class Joiners {
    public static <A> @NonNull BiJoiner<A, A> equal() {
        return Joiners.equal(ConstantLambdaUtils.identity());
    }

    public static <A, Property_> @NonNull BiJoiner<A, A> equal(Function<A, Property_> mapping) {
        return Joiners.equal(mapping, mapping);
    }

    public static <A, B, Property_> @NonNull BiJoiner<A, B> equal(Function<A, Property_> leftMapping, Function<B, Property_> rightMapping) {
        return new DefaultBiJoiner<A, B>(leftMapping, JoinerType.EQUAL, rightMapping);
    }

    public static <A, Property_ extends Comparable<Property_>> @NonNull BiJoiner<A, A> lessThan(Function<A, Property_> mapping) {
        return Joiners.lessThan(mapping, mapping);
    }

    public static <A, B, Property_ extends Comparable<Property_>> @NonNull BiJoiner<A, B> lessThan(Function<A, Property_> leftMapping, Function<B, Property_> rightMapping) {
        return new DefaultBiJoiner<A, B>(leftMapping, JoinerType.LESS_THAN, rightMapping);
    }

    public static <A, Property_ extends Comparable<Property_>> @NonNull BiJoiner<A, A> lessThanOrEqual(Function<A, Property_> mapping) {
        return Joiners.lessThanOrEqual(mapping, mapping);
    }

    public static <A, B, Property_ extends Comparable<Property_>> @NonNull BiJoiner<A, B> lessThanOrEqual(Function<A, Property_> leftMapping, Function<B, Property_> rightMapping) {
        return new DefaultBiJoiner<A, B>(leftMapping, JoinerType.LESS_THAN_OR_EQUAL, rightMapping);
    }

    public static <A, Property_ extends Comparable<Property_>> @NonNull BiJoiner<A, A> greaterThan(Function<A, Property_> mapping) {
        return Joiners.greaterThan(mapping, mapping);
    }

    public static <A, B, Property_ extends Comparable<Property_>> @NonNull BiJoiner<A, B> greaterThan(Function<A, Property_> leftMapping, Function<B, Property_> rightMapping) {
        return new DefaultBiJoiner<A, B>(leftMapping, JoinerType.GREATER_THAN, rightMapping);
    }

    public static <A, Property_ extends Comparable<Property_>> @NonNull BiJoiner<A, A> greaterThanOrEqual(Function<A, Property_> mapping) {
        return Joiners.greaterThanOrEqual(mapping, mapping);
    }

    public static <A, B, Property_ extends Comparable<Property_>> @NonNull BiJoiner<A, B> greaterThanOrEqual(Function<A, Property_> leftMapping, Function<B, Property_> rightMapping) {
        return new DefaultBiJoiner<A, B>(leftMapping, JoinerType.GREATER_THAN_OR_EQUAL, rightMapping);
    }

    public static <A, B> @NonNull BiJoiner<A, B> filtering(@NonNull BiPredicate<A, B> filter) {
        return new FilteringBiJoiner<A, B>(filter);
    }

    public static <A, Property_ extends Comparable<Property_>> @NonNull BiJoiner<A, A> overlapping(Function<A, Property_> startMapping, Function<A, Property_> endMapping) {
        return Joiners.overlapping(startMapping, endMapping, startMapping, endMapping);
    }

    public static <A, B, Property_ extends Comparable<Property_>> @NonNull BiJoiner<A, B> overlapping(Function<A, Property_> leftStartMapping, Function<A, Property_> leftEndMapping, Function<B, Property_> rightStartMapping, Function<B, Property_> rightEndMapping) {
        return Joiners.lessThan(leftStartMapping, rightEndMapping).and(Joiners.greaterThan(leftEndMapping, rightStartMapping));
    }

    public static <A, B, C, Property_> @NonNull TriJoiner<A, B, C> equal(BiFunction<A, B, Property_> leftMapping, Function<C, Property_> rightMapping) {
        return new DefaultTriJoiner<A, B, C>(leftMapping, JoinerType.EQUAL, rightMapping);
    }

    public static <A, B, C, Property_ extends Comparable<Property_>> @NonNull TriJoiner<A, B, C> lessThan(BiFunction<A, B, Property_> leftMapping, Function<C, Property_> rightMapping) {
        return new DefaultTriJoiner<A, B, C>(leftMapping, JoinerType.LESS_THAN, rightMapping);
    }

    public static <A, B, C, Property_ extends Comparable<Property_>> @NonNull TriJoiner<A, B, C> lessThanOrEqual(BiFunction<A, B, Property_> leftMapping, Function<C, Property_> rightMapping) {
        return new DefaultTriJoiner<A, B, C>(leftMapping, JoinerType.LESS_THAN_OR_EQUAL, rightMapping);
    }

    public static <A, B, C, Property_ extends Comparable<Property_>> @NonNull TriJoiner<A, B, C> greaterThan(BiFunction<A, B, Property_> leftMapping, Function<C, Property_> rightMapping) {
        return new DefaultTriJoiner<A, B, C>(leftMapping, JoinerType.GREATER_THAN, rightMapping);
    }

    public static <A, B, C, Property_ extends Comparable<Property_>> @NonNull TriJoiner<A, B, C> greaterThanOrEqual(BiFunction<A, B, Property_> leftMapping, Function<C, Property_> rightMapping) {
        return new DefaultTriJoiner<A, B, C>(leftMapping, JoinerType.GREATER_THAN_OR_EQUAL, rightMapping);
    }

    public static <A, B, C> @NonNull TriJoiner<A, B, C> filtering(@NonNull TriPredicate<A, B, C> filter) {
        return new FilteringTriJoiner<A, B, C>(filter);
    }

    public static <A, B, C, Property_ extends Comparable<Property_>> @NonNull TriJoiner<A, B, C> overlapping(BiFunction<A, B, Property_> leftStartMapping, BiFunction<A, B, Property_> leftEndMapping, Function<C, Property_> rightStartMapping, Function<C, Property_> rightEndMapping) {
        return Joiners.lessThan(leftStartMapping, rightEndMapping).and(Joiners.greaterThan(leftEndMapping, rightStartMapping));
    }

    public static <A, B, C, D, Property_> @NonNull QuadJoiner<A, B, C, D> equal(TriFunction<A, B, C, Property_> leftMapping, Function<D, Property_> rightMapping) {
        return new DefaultQuadJoiner<A, B, C, D>(leftMapping, JoinerType.EQUAL, rightMapping);
    }

    public static <A, B, C, D, Property_ extends Comparable<Property_>> @NonNull QuadJoiner<A, B, C, D> lessThan(TriFunction<A, B, C, Property_> leftMapping, Function<D, Property_> rightMapping) {
        return new DefaultQuadJoiner<A, B, C, D>(leftMapping, JoinerType.LESS_THAN, rightMapping);
    }

    public static <A, B, C, D, Property_ extends Comparable<Property_>> @NonNull QuadJoiner<A, B, C, D> lessThanOrEqual(TriFunction<A, B, C, Property_> leftMapping, Function<D, Property_> rightMapping) {
        return new DefaultQuadJoiner<A, B, C, D>(leftMapping, JoinerType.LESS_THAN_OR_EQUAL, rightMapping);
    }

    public static <A, B, C, D, Property_ extends Comparable<Property_>> @NonNull QuadJoiner<A, B, C, D> greaterThan(TriFunction<A, B, C, Property_> leftMapping, Function<D, Property_> rightMapping) {
        return new DefaultQuadJoiner<A, B, C, D>(leftMapping, JoinerType.GREATER_THAN, rightMapping);
    }

    public static <A, B, C, D, Property_ extends Comparable<Property_>> @NonNull QuadJoiner<A, B, C, D> greaterThanOrEqual(TriFunction<A, B, C, Property_> leftMapping, Function<D, Property_> rightMapping) {
        return new DefaultQuadJoiner<A, B, C, D>(leftMapping, JoinerType.GREATER_THAN_OR_EQUAL, rightMapping);
    }

    public static <A, B, C, D> @NonNull QuadJoiner<A, B, C, D> filtering(@NonNull QuadPredicate<A, B, C, D> filter) {
        return new FilteringQuadJoiner<A, B, C, D>(filter);
    }

    public static <A, B, C, D, Property_ extends Comparable<Property_>> @NonNull QuadJoiner<A, B, C, D> overlapping(TriFunction<A, B, C, Property_> leftStartMapping, TriFunction<A, B, C, Property_> leftEndMapping, Function<D, Property_> rightStartMapping, Function<D, Property_> rightEndMapping) {
        return Joiners.lessThan(leftStartMapping, rightEndMapping).and(Joiners.greaterThan(leftEndMapping, rightStartMapping));
    }

    public static <A, B, C, D, E, Property_> @NonNull PentaJoiner<A, B, C, D, E> equal(QuadFunction<A, B, C, D, Property_> leftMapping, Function<E, Property_> rightMapping) {
        return new DefaultPentaJoiner<A, B, C, D, E>(leftMapping, JoinerType.EQUAL, rightMapping);
    }

    public static <A, B, C, D, E, Property_ extends Comparable<Property_>> @NonNull PentaJoiner<A, B, C, D, E> lessThan(QuadFunction<A, B, C, D, Property_> leftMapping, Function<E, Property_> rightMapping) {
        return new DefaultPentaJoiner<A, B, C, D, E>(leftMapping, JoinerType.LESS_THAN, rightMapping);
    }

    public static <A, B, C, D, E, Property_ extends Comparable<Property_>> @NonNull PentaJoiner<A, B, C, D, E> lessThanOrEqual(QuadFunction<A, B, C, D, Property_> leftMapping, Function<E, Property_> rightMapping) {
        return new DefaultPentaJoiner<A, B, C, D, E>(leftMapping, JoinerType.LESS_THAN_OR_EQUAL, rightMapping);
    }

    public static <A, B, C, D, E, Property_ extends Comparable<Property_>> @NonNull PentaJoiner<A, B, C, D, E> greaterThan(QuadFunction<A, B, C, D, Property_> leftMapping, Function<E, Property_> rightMapping) {
        return new DefaultPentaJoiner<A, B, C, D, E>(leftMapping, JoinerType.GREATER_THAN, rightMapping);
    }

    public static <A, B, C, D, E, Property_ extends Comparable<Property_>> @NonNull PentaJoiner<A, B, C, D, E> greaterThanOrEqual(QuadFunction<A, B, C, D, Property_> leftMapping, Function<E, Property_> rightMapping) {
        return new DefaultPentaJoiner<A, B, C, D, E>(leftMapping, JoinerType.GREATER_THAN_OR_EQUAL, rightMapping);
    }

    public static <A, B, C, D, E> @NonNull PentaJoiner<A, B, C, D, E> filtering(@NonNull PentaPredicate<A, B, C, D, E> filter) {
        return new FilteringPentaJoiner<A, B, C, D, E>(filter);
    }

    public static <A, B, C, D, E, Property_ extends Comparable<Property_>> @NonNull PentaJoiner<A, B, C, D, E> overlapping(QuadFunction<A, B, C, D, Property_> leftStartMapping, QuadFunction<A, B, C, D, Property_> leftEndMapping, Function<E, Property_> rightStartMapping, Function<E, Property_> rightEndMapping) {
        return Joiners.lessThan(leftStartMapping, rightEndMapping).and(Joiners.greaterThan(leftEndMapping, rightStartMapping));
    }

    private Joiners() {
    }
}

