/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.api.score.stream;

import ai.timefold.solver.core.api.function.QuadFunction;
import ai.timefold.solver.core.api.function.QuadPredicate;
import ai.timefold.solver.core.api.function.ToIntQuadFunction;
import ai.timefold.solver.core.api.function.ToIntTriFunction;
import ai.timefold.solver.core.api.function.ToLongQuadFunction;
import ai.timefold.solver.core.api.function.ToLongTriFunction;
import ai.timefold.solver.core.api.function.TriFunction;
import ai.timefold.solver.core.api.function.TriPredicate;
import ai.timefold.solver.core.api.score.stream.bi.BiConstraintCollector;
import ai.timefold.solver.core.api.score.stream.common.ConnectedRangeChain;
import ai.timefold.solver.core.api.score.stream.common.LoadBalance;
import ai.timefold.solver.core.api.score.stream.common.SequenceChain;
import ai.timefold.solver.core.api.score.stream.quad.QuadConstraintCollector;
import ai.timefold.solver.core.api.score.stream.tri.TriConstraintCollector;
import ai.timefold.solver.core.api.score.stream.uni.UniConstraintCollector;
import ai.timefold.solver.core.impl.score.stream.collector.bi.InnerBiConstraintCollectors;
import ai.timefold.solver.core.impl.score.stream.collector.quad.InnerQuadConstraintCollectors;
import ai.timefold.solver.core.impl.score.stream.collector.tri.InnerTriConstraintCollectors;
import ai.timefold.solver.core.impl.score.stream.collector.uni.InnerUniConstraintCollectors;
import ai.timefold.solver.core.impl.util.ConstantLambdaUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Duration;
import java.time.Period;
import java.time.temporal.Temporal;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.ToIntBiFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongBiFunction;
import java.util.function.ToLongFunction;
import org.jspecify.annotations.NonNull;

public final class ConstraintCollectors {
    public static <A> @NonNull UniConstraintCollector<A, ?, Integer> count() {
        return InnerUniConstraintCollectors.count();
    }

    public static <A> @NonNull UniConstraintCollector<A, ?, Long> countLong() {
        return InnerUniConstraintCollectors.countLong();
    }

    public static <A, B> @NonNull BiConstraintCollector<A, B, ?, Integer> countBi() {
        return InnerBiConstraintCollectors.count();
    }

    public static <A, B> @NonNull BiConstraintCollector<A, B, ?, Long> countLongBi() {
        return InnerBiConstraintCollectors.countLong();
    }

    public static <A, B, C> @NonNull TriConstraintCollector<A, B, C, ?, Integer> countTri() {
        return InnerTriConstraintCollectors.count();
    }

    public static <A, B, C> @NonNull TriConstraintCollector<A, B, C, ?, Long> countLongTri() {
        return InnerTriConstraintCollectors.countLong();
    }

    public static <A, B, C, D> @NonNull QuadConstraintCollector<A, B, C, D, ?, Integer> countQuad() {
        return InnerQuadConstraintCollectors.count();
    }

    public static <A, B, C, D> @NonNull QuadConstraintCollector<A, B, C, D, ?, Long> countLongQuad() {
        return InnerQuadConstraintCollectors.countLong();
    }

    public static <A> @NonNull UniConstraintCollector<A, ?, Integer> countDistinct() {
        return ConstraintCollectors.countDistinct(ConstantLambdaUtils.identity());
    }

    public static <A> @NonNull UniConstraintCollector<A, ?, Integer> countDistinct(@NonNull Function<A, ?> groupValueMapping) {
        return InnerUniConstraintCollectors.countDistinct(groupValueMapping);
    }

    public static <A> @NonNull UniConstraintCollector<A, ?, Long> countDistinctLong(@NonNull Function<A, ?> groupValueMapping) {
        return InnerUniConstraintCollectors.countDistinctLong(groupValueMapping);
    }

    public static <A, B> @NonNull BiConstraintCollector<A, B, ?, Integer> countDistinct(@NonNull BiFunction<A, B, ?> groupValueMapping) {
        return InnerBiConstraintCollectors.countDistinct(groupValueMapping);
    }

    public static <A, B> @NonNull BiConstraintCollector<A, B, ?, Long> countDistinctLong(@NonNull BiFunction<A, B, ?> groupValueMapping) {
        return InnerBiConstraintCollectors.countDistinctLong(groupValueMapping);
    }

    public static <A, B, C> @NonNull TriConstraintCollector<A, B, C, ?, Integer> countDistinct(@NonNull TriFunction<A, B, C, ?> groupValueMapping) {
        return InnerTriConstraintCollectors.countDistinct(groupValueMapping);
    }

    public static <A, B, C> @NonNull TriConstraintCollector<A, B, C, ?, Long> countDistinctLong(@NonNull TriFunction<A, B, C, ?> groupValueMapping) {
        return InnerTriConstraintCollectors.countDistinctLong(groupValueMapping);
    }

    public static <A, B, C, D> @NonNull QuadConstraintCollector<A, B, C, D, ?, Integer> countDistinct(@NonNull QuadFunction<A, B, C, D, ?> groupValueMapping) {
        return InnerQuadConstraintCollectors.countDistinct(groupValueMapping);
    }

    public static <A, B, C, D> @NonNull QuadConstraintCollector<A, B, C, D, ?, Long> countDistinctLong(@NonNull QuadFunction<A, B, C, D, ?> groupValueMapping) {
        return InnerQuadConstraintCollectors.countDistinctLong(groupValueMapping);
    }

    public static <A> @NonNull UniConstraintCollector<A, ?, Integer> sum(@NonNull ToIntFunction<? super A> groupValueMapping) {
        return InnerUniConstraintCollectors.sum(groupValueMapping);
    }

    public static <A> @NonNull UniConstraintCollector<A, ?, Long> sumLong(@NonNull ToLongFunction<? super A> groupValueMapping) {
        return InnerUniConstraintCollectors.sum(groupValueMapping);
    }

    public static <A, Result> @NonNull UniConstraintCollector<A, ?, Result> sum(@NonNull Function<? super A, Result> groupValueMapping, @NonNull Result zero, @NonNull BinaryOperator<Result> adder, @NonNull BinaryOperator<Result> subtractor) {
        return InnerUniConstraintCollectors.sum(groupValueMapping, zero, adder, subtractor);
    }

    public static <A> @NonNull UniConstraintCollector<A, ?, BigDecimal> sumBigDecimal(@NonNull Function<? super A, BigDecimal> groupValueMapping) {
        return ConstraintCollectors.sum(groupValueMapping, BigDecimal.ZERO, BigDecimal::add, BigDecimal::subtract);
    }

    public static <A> @NonNull UniConstraintCollector<A, ?, BigInteger> sumBigInteger(@NonNull Function<? super A, BigInteger> groupValueMapping) {
        return ConstraintCollectors.sum(groupValueMapping, BigInteger.ZERO, BigInteger::add, BigInteger::subtract);
    }

    public static <A> @NonNull UniConstraintCollector<A, ?, Duration> sumDuration(@NonNull Function<? super A, Duration> groupValueMapping) {
        return ConstraintCollectors.sum(groupValueMapping, Duration.ZERO, Duration::plus, Duration::minus);
    }

    public static <A> @NonNull UniConstraintCollector<A, ?, Period> sumPeriod(@NonNull Function<? super A, Period> groupValueMapping) {
        return ConstraintCollectors.sum(groupValueMapping, Period.ZERO, Period::plus, Period::minus);
    }

    public static <A, B> @NonNull BiConstraintCollector<A, B, ?, Integer> sum(@NonNull ToIntBiFunction<? super A, ? super B> groupValueMapping) {
        return InnerBiConstraintCollectors.sum(groupValueMapping);
    }

    public static <A, B> @NonNull BiConstraintCollector<A, B, ?, Long> sumLong(@NonNull ToLongBiFunction<? super A, ? super B> groupValueMapping) {
        return InnerBiConstraintCollectors.sum(groupValueMapping);
    }

    public static <A, B, Result> @NonNull BiConstraintCollector<A, B, ?, Result> sum(@NonNull BiFunction<? super A, ? super B, Result> groupValueMapping, @NonNull Result zero, @NonNull BinaryOperator<Result> adder, @NonNull BinaryOperator<Result> subtractor) {
        return InnerBiConstraintCollectors.sum(groupValueMapping, zero, adder, subtractor);
    }

    public static <A, B> @NonNull BiConstraintCollector<A, B, ?, BigDecimal> sumBigDecimal(@NonNull BiFunction<? super A, ? super B, BigDecimal> groupValueMapping) {
        return ConstraintCollectors.sum(groupValueMapping, BigDecimal.ZERO, BigDecimal::add, BigDecimal::subtract);
    }

    public static <A, B> @NonNull BiConstraintCollector<A, B, ?, BigInteger> sumBigInteger(@NonNull BiFunction<? super A, ? super B, BigInteger> groupValueMapping) {
        return ConstraintCollectors.sum(groupValueMapping, BigInteger.ZERO, BigInteger::add, BigInteger::subtract);
    }

    public static <A, B> @NonNull BiConstraintCollector<A, B, ?, Duration> sumDuration(@NonNull BiFunction<? super A, ? super B, Duration> groupValueMapping) {
        return ConstraintCollectors.sum(groupValueMapping, Duration.ZERO, Duration::plus, Duration::minus);
    }

    public static <A, B> @NonNull BiConstraintCollector<A, B, ?, Period> sumPeriod(@NonNull BiFunction<? super A, ? super B, Period> groupValueMapping) {
        return ConstraintCollectors.sum(groupValueMapping, Period.ZERO, Period::plus, Period::minus);
    }

    public static <A, B, C> @NonNull TriConstraintCollector<A, B, C, ?, Integer> sum(@NonNull ToIntTriFunction<? super A, ? super B, ? super C> groupValueMapping) {
        return InnerTriConstraintCollectors.sum(groupValueMapping);
    }

    public static <A, B, C> @NonNull TriConstraintCollector<A, B, C, ?, Long> sumLong(@NonNull ToLongTriFunction<? super A, ? super B, ? super C> groupValueMapping) {
        return InnerTriConstraintCollectors.sum(groupValueMapping);
    }

    public static <A, B, C, Result> @NonNull TriConstraintCollector<A, B, C, ?, Result> sum(@NonNull TriFunction<? super A, ? super B, ? super C, Result> groupValueMapping, @NonNull Result zero, @NonNull BinaryOperator<Result> adder, @NonNull BinaryOperator<Result> subtractor) {
        return InnerTriConstraintCollectors.sum(groupValueMapping, zero, adder, subtractor);
    }

    public static <A, B, C> @NonNull TriConstraintCollector<A, B, C, ?, BigDecimal> sumBigDecimal(@NonNull TriFunction<? super A, ? super B, ? super C, BigDecimal> groupValueMapping) {
        return ConstraintCollectors.sum(groupValueMapping, BigDecimal.ZERO, BigDecimal::add, BigDecimal::subtract);
    }

    public static <A, B, C> @NonNull TriConstraintCollector<A, B, C, ?, BigInteger> sumBigInteger(@NonNull TriFunction<? super A, ? super B, ? super C, BigInteger> groupValueMapping) {
        return ConstraintCollectors.sum(groupValueMapping, BigInteger.ZERO, BigInteger::add, BigInteger::subtract);
    }

    public static <A, B, C> @NonNull TriConstraintCollector<A, B, C, ?, Duration> sumDuration(@NonNull TriFunction<? super A, ? super B, ? super C, Duration> groupValueMapping) {
        return ConstraintCollectors.sum(groupValueMapping, Duration.ZERO, Duration::plus, Duration::minus);
    }

    public static <A, B, C> @NonNull TriConstraintCollector<A, B, C, ?, Period> sumPeriod(@NonNull TriFunction<? super A, ? super B, ? super C, Period> groupValueMapping) {
        return ConstraintCollectors.sum(groupValueMapping, Period.ZERO, Period::plus, Period::minus);
    }

    public static <A, B, C, D> @NonNull QuadConstraintCollector<A, B, C, D, ?, Integer> sum(@NonNull ToIntQuadFunction<? super A, ? super B, ? super C, ? super D> groupValueMapping) {
        return InnerQuadConstraintCollectors.sum(groupValueMapping);
    }

    public static <A, B, C, D> @NonNull QuadConstraintCollector<A, B, C, D, ?, Long> sumLong(@NonNull ToLongQuadFunction<? super A, ? super B, ? super C, ? super D> groupValueMapping) {
        return InnerQuadConstraintCollectors.sum(groupValueMapping);
    }

    public static <A, B, C, D, Result> @NonNull QuadConstraintCollector<A, B, C, D, ?, Result> sum(@NonNull QuadFunction<? super A, ? super B, ? super C, ? super D, Result> groupValueMapping, @NonNull Result zero, @NonNull BinaryOperator<Result> adder, @NonNull BinaryOperator<Result> subtractor) {
        return InnerQuadConstraintCollectors.sum(groupValueMapping, zero, adder, subtractor);
    }

    public static <A, B, C, D> @NonNull QuadConstraintCollector<A, B, C, D, ?, BigDecimal> sumBigDecimal(@NonNull QuadFunction<? super A, ? super B, ? super C, ? super D, BigDecimal> groupValueMapping) {
        return ConstraintCollectors.sum(groupValueMapping, BigDecimal.ZERO, BigDecimal::add, BigDecimal::subtract);
    }

    public static <A, B, C, D> @NonNull QuadConstraintCollector<A, B, C, D, ?, BigInteger> sumBigInteger(@NonNull QuadFunction<? super A, ? super B, ? super C, ? super D, BigInteger> groupValueMapping) {
        return ConstraintCollectors.sum(groupValueMapping, BigInteger.ZERO, BigInteger::add, BigInteger::subtract);
    }

    public static <A, B, C, D> @NonNull QuadConstraintCollector<A, B, C, D, ?, Duration> sumDuration(@NonNull QuadFunction<? super A, ? super B, ? super C, ? super D, Duration> groupValueMapping) {
        return ConstraintCollectors.sum(groupValueMapping, Duration.ZERO, Duration::plus, Duration::minus);
    }

    public static <A, B, C, D> @NonNull QuadConstraintCollector<A, B, C, D, ?, Period> sumPeriod(@NonNull QuadFunction<? super A, ? super B, ? super C, ? super D, Period> groupValueMapping) {
        return ConstraintCollectors.sum(groupValueMapping, Period.ZERO, Period::plus, Period::minus);
    }

    public static <A extends Comparable<A>> @NonNull UniConstraintCollector<A, ?, A> min() {
        return InnerUniConstraintCollectors.min(ConstantLambdaUtils.identity());
    }

    public static <A, Mapped extends Comparable<? super Mapped>> @NonNull UniConstraintCollector<A, ?, Mapped> min(@NonNull Function<A, Mapped> groupValueMapping) {
        return InnerUniConstraintCollectors.min(groupValueMapping);
    }

    public static <A, Mapped, Comparable_ extends Comparable<? super Comparable_>> @NonNull UniConstraintCollector<A, ?, Mapped> min(@NonNull Function<A, Mapped> groupValueMapping, @NonNull Function<Mapped, Comparable_> comparableFunction) {
        return InnerUniConstraintCollectors.min(groupValueMapping, comparableFunction);
    }

    @Deprecated(forRemoval=true, since="1.0.0")
    public static <A> UniConstraintCollector<A, ?, A> min(Comparator<? super A> comparator) {
        return ConstraintCollectors.min(ConstantLambdaUtils.identity(), comparator);
    }

    @Deprecated(forRemoval=true, since="1.0.0")
    public static <A, Mapped> UniConstraintCollector<A, ?, Mapped> min(Function<A, Mapped> groupValueMapping, Comparator<? super Mapped> comparator) {
        return InnerUniConstraintCollectors.min(groupValueMapping, comparator);
    }

    public static <A, B, Mapped extends Comparable<? super Mapped>> @NonNull BiConstraintCollector<A, B, ?, Mapped> min(@NonNull BiFunction<A, B, Mapped> groupValueMapping) {
        return InnerBiConstraintCollectors.min(groupValueMapping);
    }

    public static <A, B, Mapped, Comparable_ extends Comparable<? super Comparable_>> @NonNull BiConstraintCollector<A, B, ?, Mapped> min(@NonNull BiFunction<A, B, Mapped> groupValueMapping, @NonNull Function<Mapped, Comparable_> comparableFunction) {
        return InnerBiConstraintCollectors.min(groupValueMapping, comparableFunction);
    }

    @Deprecated(forRemoval=true, since="1.0.0")
    public static <A, B, Mapped> BiConstraintCollector<A, B, ?, Mapped> min(BiFunction<A, B, Mapped> groupValueMapping, Comparator<? super Mapped> comparator) {
        return InnerBiConstraintCollectors.min(groupValueMapping, comparator);
    }

    public static <A, B, C, Mapped extends Comparable<? super Mapped>> @NonNull TriConstraintCollector<A, B, C, ?, Mapped> min(@NonNull TriFunction<A, B, C, Mapped> groupValueMapping) {
        return InnerTriConstraintCollectors.min(groupValueMapping);
    }

    public static <A, B, C, Mapped, Comparable_ extends Comparable<? super Comparable_>> @NonNull TriConstraintCollector<A, B, C, ?, Mapped> min(@NonNull TriFunction<A, B, C, Mapped> groupValueMapping, @NonNull Function<Mapped, Comparable_> comparableFunction) {
        return InnerTriConstraintCollectors.min(groupValueMapping, comparableFunction);
    }

    @Deprecated(forRemoval=true, since="1.0.0")
    public static <A, B, C, Mapped> TriConstraintCollector<A, B, C, ?, Mapped> min(TriFunction<A, B, C, Mapped> groupValueMapping, Comparator<? super Mapped> comparator) {
        return InnerTriConstraintCollectors.min(groupValueMapping, comparator);
    }

    public static <A, B, C, D, Mapped extends Comparable<? super Mapped>> @NonNull QuadConstraintCollector<A, B, C, D, ?, Mapped> min(@NonNull QuadFunction<A, B, C, D, Mapped> groupValueMapping) {
        return InnerQuadConstraintCollectors.min(groupValueMapping);
    }

    public static <A, B, C, D, Mapped, Comparable_ extends Comparable<? super Comparable_>> @NonNull QuadConstraintCollector<A, B, C, D, ?, Mapped> min(@NonNull QuadFunction<A, B, C, D, Mapped> groupValueMapping, @NonNull Function<Mapped, Comparable_> comparableFunction) {
        return InnerQuadConstraintCollectors.min(groupValueMapping, comparableFunction);
    }

    @Deprecated(forRemoval=true, since="1.0.0")
    public static <A, B, C, D, Mapped> QuadConstraintCollector<A, B, C, D, ?, Mapped> min(QuadFunction<A, B, C, D, Mapped> groupValueMapping, Comparator<? super Mapped> comparator) {
        return InnerQuadConstraintCollectors.min(groupValueMapping, comparator);
    }

    public static <A extends Comparable<A>> @NonNull UniConstraintCollector<A, ?, A> max() {
        return InnerUniConstraintCollectors.max(ConstantLambdaUtils.identity());
    }

    public static <A, Mapped extends Comparable<? super Mapped>> @NonNull UniConstraintCollector<A, ?, Mapped> max(@NonNull Function<A, Mapped> groupValueMapping) {
        return InnerUniConstraintCollectors.max(groupValueMapping);
    }

    @Deprecated(forRemoval=true, since="1.0.0")
    public static <A> UniConstraintCollector<A, ?, A> max(Comparator<? super A> comparator) {
        return InnerUniConstraintCollectors.max(ConstantLambdaUtils.identity(), comparator);
    }

    public static <A, Mapped, Comparable_ extends Comparable<? super Comparable_>> @NonNull UniConstraintCollector<A, ?, Mapped> max(@NonNull Function<A, Mapped> groupValueMapping, @NonNull Function<Mapped, Comparable_> comparableFunction) {
        return InnerUniConstraintCollectors.max(groupValueMapping, comparableFunction);
    }

    @Deprecated(forRemoval=true, since="1.0.0")
    public static <A, Mapped> UniConstraintCollector<A, ?, Mapped> max(Function<A, Mapped> groupValueMapping, Comparator<? super Mapped> comparator) {
        return InnerUniConstraintCollectors.max(groupValueMapping, comparator);
    }

    public static <A, B, Mapped extends Comparable<? super Mapped>> @NonNull BiConstraintCollector<A, B, ?, Mapped> max(@NonNull BiFunction<A, B, Mapped> groupValueMapping) {
        return InnerBiConstraintCollectors.max(groupValueMapping);
    }

    public static <A, B, Mapped, Comparable_ extends Comparable<? super Comparable_>> @NonNull BiConstraintCollector<A, B, ?, Mapped> max(@NonNull BiFunction<A, B, Mapped> groupValueMapping, @NonNull Function<Mapped, Comparable_> comparableFunction) {
        return InnerBiConstraintCollectors.max(groupValueMapping, comparableFunction);
    }

    @Deprecated(forRemoval=true, since="1.0.0")
    public static <A, B, Mapped> BiConstraintCollector<A, B, ?, Mapped> max(BiFunction<A, B, Mapped> groupValueMapping, Comparator<? super Mapped> comparator) {
        return InnerBiConstraintCollectors.max(groupValueMapping, comparator);
    }

    public static <A, B, C, Mapped extends Comparable<? super Mapped>> @NonNull TriConstraintCollector<A, B, C, ?, Mapped> max(@NonNull TriFunction<A, B, C, Mapped> groupValueMapping) {
        return InnerTriConstraintCollectors.max(groupValueMapping);
    }

    public static <A, B, C, Mapped, Comparable_ extends Comparable<? super Comparable_>> @NonNull TriConstraintCollector<A, B, C, ?, Mapped> max(@NonNull TriFunction<A, B, C, Mapped> groupValueMapping, @NonNull Function<Mapped, Comparable_> comparableFunction) {
        return InnerTriConstraintCollectors.max(groupValueMapping, comparableFunction);
    }

    @Deprecated(forRemoval=true, since="1.0.0")
    public static <A, B, C, Mapped> TriConstraintCollector<A, B, C, ?, Mapped> max(TriFunction<A, B, C, Mapped> groupValueMapping, Comparator<? super Mapped> comparator) {
        return InnerTriConstraintCollectors.max(groupValueMapping, comparator);
    }

    public static <A, B, C, D, Mapped extends Comparable<? super Mapped>> @NonNull QuadConstraintCollector<A, B, C, D, ?, Mapped> max(@NonNull QuadFunction<A, B, C, D, Mapped> groupValueMapping) {
        return InnerQuadConstraintCollectors.max(groupValueMapping);
    }

    public static <A, B, C, D, Mapped, Comparable_ extends Comparable<? super Comparable_>> @NonNull QuadConstraintCollector<A, B, C, D, ?, Mapped> max(@NonNull QuadFunction<A, B, C, D, Mapped> groupValueMapping, @NonNull Function<Mapped, Comparable_> comparableFunction) {
        return InnerQuadConstraintCollectors.max(groupValueMapping, comparableFunction);
    }

    @Deprecated(forRemoval=true, since="1.0.0")
    public static <A, B, C, D, Mapped> QuadConstraintCollector<A, B, C, D, ?, Mapped> max(QuadFunction<A, B, C, D, Mapped> groupValueMapping, Comparator<? super Mapped> comparator) {
        return InnerQuadConstraintCollectors.max(groupValueMapping, comparator);
    }

    @Deprecated
    public static <A, Result extends Collection<A>> UniConstraintCollector<A, ?, Result> toCollection(IntFunction<Result> collectionFunction) {
        return ConstraintCollectors.toCollection(ConstantLambdaUtils.identity(), collectionFunction);
    }

    public static <A> @NonNull UniConstraintCollector<A, ?, Double> average(@NonNull ToIntFunction<A> groupValueMapping) {
        return InnerUniConstraintCollectors.average(groupValueMapping);
    }

    public static <A> @NonNull UniConstraintCollector<A, ?, Double> averageLong(@NonNull ToLongFunction<A> groupValueMapping) {
        return InnerUniConstraintCollectors.average(groupValueMapping);
    }

    public static <A> @NonNull UniConstraintCollector<A, ?, BigDecimal> averageBigDecimal(@NonNull Function<A, BigDecimal> groupValueMapping) {
        return InnerUniConstraintCollectors.averageBigDecimal(groupValueMapping);
    }

    public static <A> @NonNull UniConstraintCollector<A, ?, BigDecimal> averageBigInteger(@NonNull Function<A, BigInteger> groupValueMapping) {
        return InnerUniConstraintCollectors.averageBigInteger(groupValueMapping);
    }

    public static <A> @NonNull UniConstraintCollector<A, ?, Duration> averageDuration(@NonNull Function<A, Duration> groupValueMapping) {
        return InnerUniConstraintCollectors.averageDuration(groupValueMapping);
    }

    public static <A, B> @NonNull BiConstraintCollector<A, B, ?, Double> average(@NonNull ToIntBiFunction<A, B> groupValueMapping) {
        return InnerBiConstraintCollectors.average(groupValueMapping);
    }

    public static <A, B> @NonNull BiConstraintCollector<A, B, ?, Double> averageLong(@NonNull ToLongBiFunction<A, B> groupValueMapping) {
        return InnerBiConstraintCollectors.average(groupValueMapping);
    }

    public static <A, B> @NonNull BiConstraintCollector<A, B, ?, BigDecimal> averageBigDecimal(@NonNull BiFunction<A, B, BigDecimal> groupValueMapping) {
        return InnerBiConstraintCollectors.averageBigDecimal(groupValueMapping);
    }

    public static <A, B> @NonNull BiConstraintCollector<A, B, ?, BigDecimal> averageBigInteger(@NonNull BiFunction<A, B, BigInteger> groupValueMapping) {
        return InnerBiConstraintCollectors.averageBigInteger(groupValueMapping);
    }

    public static <A, B> @NonNull BiConstraintCollector<A, B, ?, Duration> averageDuration(@NonNull BiFunction<A, B, Duration> groupValueMapping) {
        return InnerBiConstraintCollectors.averageDuration(groupValueMapping);
    }

    public static <A, B, C> @NonNull TriConstraintCollector<A, B, C, ?, Double> average(@NonNull ToIntTriFunction<A, B, C> groupValueMapping) {
        return InnerTriConstraintCollectors.average(groupValueMapping);
    }

    public static <A, B, C> @NonNull TriConstraintCollector<A, B, C, ?, Double> averageLong(@NonNull ToLongTriFunction<A, B, C> groupValueMapping) {
        return InnerTriConstraintCollectors.average(groupValueMapping);
    }

    public static <A, B, C> @NonNull TriConstraintCollector<A, B, C, ?, BigDecimal> averageBigDecimal(@NonNull TriFunction<A, B, C, BigDecimal> groupValueMapping) {
        return InnerTriConstraintCollectors.averageBigDecimal(groupValueMapping);
    }

    public static <A, B, C> @NonNull TriConstraintCollector<A, B, C, ?, BigDecimal> averageBigInteger(@NonNull TriFunction<A, B, C, BigInteger> groupValueMapping) {
        return InnerTriConstraintCollectors.averageBigInteger(groupValueMapping);
    }

    public static <A, B, C> @NonNull TriConstraintCollector<A, B, C, ?, Duration> averageDuration(@NonNull TriFunction<A, B, C, Duration> groupValueMapping) {
        return InnerTriConstraintCollectors.averageDuration(groupValueMapping);
    }

    public static <A, B, C, D> @NonNull QuadConstraintCollector<A, B, C, D, ?, Double> average(@NonNull ToIntQuadFunction<A, B, C, D> groupValueMapping) {
        return InnerQuadConstraintCollectors.average(groupValueMapping);
    }

    public static <A, B, C, D> @NonNull QuadConstraintCollector<A, B, C, D, ?, Double> averageLong(@NonNull ToLongQuadFunction<A, B, C, D> groupValueMapping) {
        return InnerQuadConstraintCollectors.average(groupValueMapping);
    }

    public static <A, B, C, D> @NonNull QuadConstraintCollector<A, B, C, D, ?, BigDecimal> averageBigDecimal(@NonNull QuadFunction<A, B, C, D, BigDecimal> groupValueMapping) {
        return InnerQuadConstraintCollectors.averageBigDecimal(groupValueMapping);
    }

    public static <A, B, C, D> @NonNull QuadConstraintCollector<A, B, C, D, ?, BigDecimal> averageBigInteger(@NonNull QuadFunction<A, B, C, D, BigInteger> groupValueMapping) {
        return InnerQuadConstraintCollectors.averageBigInteger(groupValueMapping);
    }

    public static <A, B, C, D> @NonNull QuadConstraintCollector<A, B, C, D, ?, Duration> averageDuration(@NonNull QuadFunction<A, B, C, D, Duration> groupValueMapping) {
        return InnerQuadConstraintCollectors.averageDuration(groupValueMapping);
    }

    public static <A> @NonNull UniConstraintCollector<A, ?, Set<A>> toSet() {
        return ConstraintCollectors.toSet(ConstantLambdaUtils.identity());
    }

    public static <A extends Comparable<A>> @NonNull UniConstraintCollector<A, ?, SortedSet<A>> toSortedSet() {
        return ConstraintCollectors.toSortedSet(ConstantLambdaUtils.identity());
    }

    public static <A> @NonNull UniConstraintCollector<A, ?, SortedSet<A>> toSortedSet(@NonNull Comparator<? super A> comparator) {
        return ConstraintCollectors.toSortedSet(ConstantLambdaUtils.identity(), comparator);
    }

    public static <A> @NonNull UniConstraintCollector<A, ?, List<A>> toList() {
        return ConstraintCollectors.toList(ConstantLambdaUtils.identity());
    }

    @Deprecated
    public static <A, Mapped, Result extends Collection<Mapped>> UniConstraintCollector<A, ?, Result> toCollection(Function<A, Mapped> groupValueMapping, IntFunction<Result> collectionFunction) {
        return InnerUniConstraintCollectors.toCollection(groupValueMapping, collectionFunction);
    }

    public static <A, Mapped> @NonNull UniConstraintCollector<A, ?, Set<Mapped>> toSet(@NonNull Function<A, Mapped> groupValueMapping) {
        return InnerUniConstraintCollectors.toSet(groupValueMapping);
    }

    public static <A, Mapped extends Comparable<? super Mapped>> @NonNull UniConstraintCollector<A, ?, SortedSet<Mapped>> toSortedSet(@NonNull Function<A, Mapped> groupValueMapping) {
        return ConstraintCollectors.toSortedSet(groupValueMapping, Comparator.naturalOrder());
    }

    public static <A, Mapped> @NonNull UniConstraintCollector<A, ?, SortedSet<Mapped>> toSortedSet(@NonNull Function<A, Mapped> groupValueMapping, @NonNull Comparator<? super Mapped> comparator) {
        return InnerUniConstraintCollectors.toSortedSet(groupValueMapping, comparator);
    }

    public static <A, Mapped> @NonNull UniConstraintCollector<A, ?, List<Mapped>> toList(@NonNull Function<A, Mapped> groupValueMapping) {
        return InnerUniConstraintCollectors.toList(groupValueMapping);
    }

    @Deprecated
    public static <A, B, Mapped, Result extends Collection<Mapped>> BiConstraintCollector<A, B, ?, Result> toCollection(BiFunction<A, B, Mapped> groupValueMapping, IntFunction<Result> collectionFunction) {
        return InnerBiConstraintCollectors.toCollection(groupValueMapping, collectionFunction);
    }

    public static <A, B, Mapped> @NonNull BiConstraintCollector<A, B, ?, Set<Mapped>> toSet(@NonNull BiFunction<A, B, Mapped> groupValueMapping) {
        return InnerBiConstraintCollectors.toSet(groupValueMapping);
    }

    public static <A, B, Mapped extends Comparable<? super Mapped>> @NonNull BiConstraintCollector<A, B, ?, SortedSet<Mapped>> toSortedSet(@NonNull BiFunction<A, B, Mapped> groupValueMapping) {
        return ConstraintCollectors.toSortedSet(groupValueMapping, Comparator.naturalOrder());
    }

    public static <A, B, Mapped> @NonNull BiConstraintCollector<A, B, ?, SortedSet<Mapped>> toSortedSet(@NonNull BiFunction<A, B, Mapped> groupValueMapping, @NonNull Comparator<? super Mapped> comparator) {
        return InnerBiConstraintCollectors.toSortedSet(groupValueMapping, comparator);
    }

    public static <A, B, Mapped> @NonNull BiConstraintCollector<A, B, ?, List<Mapped>> toList(@NonNull BiFunction<A, B, Mapped> groupValueMapping) {
        return InnerBiConstraintCollectors.toList(groupValueMapping);
    }

    @Deprecated
    public static <A, B, C, Mapped, Result extends Collection<Mapped>> TriConstraintCollector<A, B, C, ?, Result> toCollection(TriFunction<A, B, C, Mapped> groupValueMapping, IntFunction<Result> collectionFunction) {
        return InnerTriConstraintCollectors.toCollection(groupValueMapping, collectionFunction);
    }

    public static <A, B, C, Mapped> @NonNull TriConstraintCollector<A, B, C, ?, Set<Mapped>> toSet(@NonNull TriFunction<A, B, C, Mapped> groupValueMapping) {
        return InnerTriConstraintCollectors.toSet(groupValueMapping);
    }

    public static <A, B, C, Mapped extends Comparable<? super Mapped>> @NonNull TriConstraintCollector<A, B, C, ?, SortedSet<Mapped>> toSortedSet(@NonNull TriFunction<A, B, C, Mapped> groupValueMapping) {
        return ConstraintCollectors.toSortedSet(groupValueMapping, Comparator.naturalOrder());
    }

    public static <A, B, C, Mapped> @NonNull TriConstraintCollector<A, B, C, ?, SortedSet<Mapped>> toSortedSet(@NonNull TriFunction<A, B, C, Mapped> groupValueMapping, @NonNull Comparator<? super Mapped> comparator) {
        return InnerTriConstraintCollectors.toSortedSet(groupValueMapping, comparator);
    }

    public static <A, B, C, Mapped> @NonNull TriConstraintCollector<A, B, C, ?, List<Mapped>> toList(@NonNull TriFunction<A, B, C, Mapped> groupValueMapping) {
        return InnerTriConstraintCollectors.toList(groupValueMapping);
    }

    @Deprecated
    public static <A, B, C, D, Mapped, Result extends Collection<Mapped>> QuadConstraintCollector<A, B, C, D, ?, Result> toCollection(QuadFunction<A, B, C, D, Mapped> groupValueMapping, IntFunction<Result> collectionFunction) {
        return InnerQuadConstraintCollectors.toCollection(groupValueMapping, collectionFunction);
    }

    public static <A, B, C, D, Mapped> @NonNull QuadConstraintCollector<A, B, C, D, ?, Set<Mapped>> toSet(@NonNull QuadFunction<A, B, C, D, Mapped> groupValueMapping) {
        return InnerQuadConstraintCollectors.toSet(groupValueMapping);
    }

    public static <A, B, C, D, Mapped extends Comparable<? super Mapped>> @NonNull QuadConstraintCollector<A, B, C, D, ?, SortedSet<Mapped>> toSortedSet(@NonNull QuadFunction<A, B, C, D, Mapped> groupValueMapping) {
        return ConstraintCollectors.toSortedSet(groupValueMapping, Comparator.naturalOrder());
    }

    public static <A, B, C, D, Mapped> @NonNull QuadConstraintCollector<A, B, C, D, ?, SortedSet<Mapped>> toSortedSet(@NonNull QuadFunction<A, B, C, D, Mapped> groupValueMapping, @NonNull Comparator<? super Mapped> comparator) {
        return InnerQuadConstraintCollectors.toSortedSet(groupValueMapping, comparator);
    }

    public static <A, B, C, D, Mapped> @NonNull QuadConstraintCollector<A, B, C, D, ?, List<Mapped>> toList(@NonNull QuadFunction<A, B, C, D, Mapped> groupValueMapping) {
        return InnerQuadConstraintCollectors.toList(groupValueMapping);
    }

    public static <A, Key, Value> @NonNull UniConstraintCollector<A, ?, Map<Key, Set<Value>>> toMap(@NonNull Function<? super A, ? extends Key> keyMapper, @NonNull Function<? super A, ? extends Value> valueMapper) {
        return ConstraintCollectors.toMap(keyMapper, valueMapper, LinkedHashSet::new);
    }

    public static <A, Key, Value, ValueSet extends Set<Value>> @NonNull UniConstraintCollector<A, ?, Map<Key, ValueSet>> toMap(@NonNull Function<? super A, ? extends Key> keyMapper, @NonNull Function<? super A, ? extends Value> valueMapper, @NonNull IntFunction<ValueSet> valueSetFunction) {
        return InnerUniConstraintCollectors.toMap(keyMapper, valueMapper, HashMap::new, valueSetFunction);
    }

    public static <A, Key, Value> @NonNull UniConstraintCollector<A, ?, Map<Key, Value>> toMap(@NonNull Function<? super A, ? extends Key> keyMapper, @NonNull Function<? super A, ? extends Value> valueMapper, @NonNull BinaryOperator<Value> mergeFunction) {
        return InnerUniConstraintCollectors.toMap(keyMapper, valueMapper, HashMap::new, mergeFunction);
    }

    public static <A, Key extends Comparable<? super Key>, Value> @NonNull UniConstraintCollector<A, ?, SortedMap<Key, Set<Value>>> toSortedMap(@NonNull Function<? super A, ? extends Key> keyMapper, @NonNull Function<? super A, ? extends Value> valueMapper) {
        return ConstraintCollectors.toSortedMap(keyMapper, valueMapper, LinkedHashSet::new);
    }

    public static <A, Key extends Comparable<? super Key>, Value, ValueSet extends Set<Value>> @NonNull UniConstraintCollector<A, ?, SortedMap<Key, ValueSet>> toSortedMap(@NonNull Function<? super A, ? extends Key> keyMapper, @NonNull Function<? super A, ? extends Value> valueMapper, @NonNull IntFunction<ValueSet> valueSetFunction) {
        return InnerUniConstraintCollectors.toMap(keyMapper, valueMapper, TreeMap::new, valueSetFunction);
    }

    public static <A, Key extends Comparable<? super Key>, Value> @NonNull UniConstraintCollector<A, ?, SortedMap<Key, Value>> toSortedMap(@NonNull Function<? super A, ? extends Key> keyMapper, @NonNull Function<? super A, ? extends Value> valueMapper, @NonNull BinaryOperator<Value> mergeFunction) {
        return InnerUniConstraintCollectors.toMap(keyMapper, valueMapper, TreeMap::new, mergeFunction);
    }

    public static <A, B, Key, Value> @NonNull BiConstraintCollector<A, B, ?, Map<Key, Set<Value>>> toMap(@NonNull BiFunction<? super A, ? super B, ? extends Key> keyMapper, @NonNull BiFunction<? super A, ? super B, ? extends Value> valueMapper) {
        return ConstraintCollectors.toMap(keyMapper, valueMapper, LinkedHashSet::new);
    }

    public static <A, B, Key, Value, ValueSet extends Set<Value>> @NonNull BiConstraintCollector<A, B, ?, Map<Key, ValueSet>> toMap(@NonNull BiFunction<? super A, ? super B, ? extends Key> keyMapper, @NonNull BiFunction<? super A, ? super B, ? extends Value> valueMapper, @NonNull IntFunction<ValueSet> valueSetFunction) {
        return InnerBiConstraintCollectors.toMap(keyMapper, valueMapper, HashMap::new, valueSetFunction);
    }

    public static <A, B, Key, Value> @NonNull BiConstraintCollector<A, B, ?, Map<Key, Value>> toMap(@NonNull BiFunction<? super A, ? super B, ? extends Key> keyMapper, @NonNull BiFunction<? super A, ? super B, ? extends Value> valueMapper, @NonNull BinaryOperator<Value> mergeFunction) {
        return InnerBiConstraintCollectors.toMap(keyMapper, valueMapper, HashMap::new, mergeFunction);
    }

    public static <A, B, Key extends Comparable<? super Key>, Value> @NonNull BiConstraintCollector<A, B, ?, SortedMap<Key, Set<Value>>> toSortedMap(@NonNull BiFunction<? super A, ? super B, ? extends Key> keyMapper, @NonNull BiFunction<? super A, ? super B, ? extends Value> valueMapper) {
        return ConstraintCollectors.toSortedMap(keyMapper, valueMapper, LinkedHashSet::new);
    }

    public static <A, B, Key extends Comparable<? super Key>, Value, ValueSet extends Set<Value>> @NonNull BiConstraintCollector<A, B, ?, SortedMap<Key, ValueSet>> toSortedMap(@NonNull BiFunction<? super A, ? super B, ? extends Key> keyMapper, @NonNull BiFunction<? super A, ? super B, ? extends Value> valueMapper, @NonNull IntFunction<ValueSet> valueSetFunction) {
        return InnerBiConstraintCollectors.toMap(keyMapper, valueMapper, TreeMap::new, valueSetFunction);
    }

    public static <A, B, Key extends Comparable<? super Key>, Value> @NonNull BiConstraintCollector<A, B, ?, SortedMap<Key, Value>> toSortedMap(@NonNull BiFunction<? super A, ? super B, ? extends Key> keyMapper, @NonNull BiFunction<? super A, ? super B, ? extends Value> valueMapper, @NonNull BinaryOperator<Value> mergeFunction) {
        return InnerBiConstraintCollectors.toMap(keyMapper, valueMapper, TreeMap::new, mergeFunction);
    }

    public static <A, B, C, Key, Value> @NonNull TriConstraintCollector<A, B, C, ?, Map<Key, Set<Value>>> toMap(@NonNull TriFunction<? super A, ? super B, ? super C, ? extends Key> keyMapper, @NonNull TriFunction<? super A, ? super B, ? super C, ? extends Value> valueMapper) {
        return ConstraintCollectors.toMap(keyMapper, valueMapper, LinkedHashSet::new);
    }

    public static <A, B, C, Key, Value, ValueSet extends Set<Value>> @NonNull TriConstraintCollector<A, B, C, ?, Map<Key, ValueSet>> toMap(@NonNull TriFunction<? super A, ? super B, ? super C, ? extends Key> keyMapper, @NonNull TriFunction<? super A, ? super B, ? super C, ? extends Value> valueMapper, @NonNull IntFunction<ValueSet> valueSetFunction) {
        return InnerTriConstraintCollectors.toMap(keyMapper, valueMapper, HashMap::new, valueSetFunction);
    }

    public static <A, B, C, Key, Value> @NonNull TriConstraintCollector<A, B, C, ?, Map<Key, Value>> toMap(@NonNull TriFunction<? super A, ? super B, ? super C, ? extends Key> keyMapper, @NonNull TriFunction<? super A, ? super B, ? super C, ? extends Value> valueMapper, @NonNull BinaryOperator<Value> mergeFunction) {
        return InnerTriConstraintCollectors.toMap(keyMapper, valueMapper, HashMap::new, mergeFunction);
    }

    public static <A, B, C, Key extends Comparable<? super Key>, Value> @NonNull TriConstraintCollector<A, B, C, ?, SortedMap<Key, Set<Value>>> toSortedMap(@NonNull TriFunction<? super A, ? super B, ? super C, ? extends Key> keyMapper, @NonNull TriFunction<? super A, ? super B, ? super C, ? extends Value> valueMapper) {
        return ConstraintCollectors.toSortedMap(keyMapper, valueMapper, LinkedHashSet::new);
    }

    public static <A, B, C, Key extends Comparable<? super Key>, Value, ValueSet extends Set<Value>> @NonNull TriConstraintCollector<A, B, C, ?, SortedMap<Key, ValueSet>> toSortedMap(@NonNull TriFunction<? super A, ? super B, ? super C, ? extends Key> keyMapper, @NonNull TriFunction<? super A, ? super B, ? super C, ? extends Value> valueMapper, @NonNull IntFunction<ValueSet> valueSetFunction) {
        return InnerTriConstraintCollectors.toMap(keyMapper, valueMapper, TreeMap::new, valueSetFunction);
    }

    public static <A, B, C, Key extends Comparable<? super Key>, Value> @NonNull TriConstraintCollector<A, B, C, ?, SortedMap<Key, Value>> toSortedMap(@NonNull TriFunction<? super A, ? super B, ? super C, ? extends Key> keyMapper, @NonNull TriFunction<? super A, ? super B, ? super C, ? extends Value> valueMapper, @NonNull BinaryOperator<Value> mergeFunction) {
        return InnerTriConstraintCollectors.toMap(keyMapper, valueMapper, TreeMap::new, mergeFunction);
    }

    public static <A, B, C, D, Key, Value> @NonNull QuadConstraintCollector<A, B, C, D, ?, Map<Key, Set<Value>>> toMap(@NonNull QuadFunction<? super A, ? super B, ? super C, ? super D, ? extends Key> keyMapper, @NonNull QuadFunction<? super A, ? super B, ? super C, ? super D, ? extends Value> valueMapper) {
        return ConstraintCollectors.toMap(keyMapper, valueMapper, LinkedHashSet::new);
    }

    public static <A, B, C, D, Key, Value, ValueSet extends Set<Value>> @NonNull QuadConstraintCollector<A, B, C, D, ?, Map<Key, ValueSet>> toMap(@NonNull QuadFunction<? super A, ? super B, ? super C, ? super D, ? extends Key> keyMapper, @NonNull QuadFunction<? super A, ? super B, ? super C, ? super D, ? extends Value> valueMapper, @NonNull IntFunction<ValueSet> valueSetFunction) {
        return InnerQuadConstraintCollectors.toMap(keyMapper, valueMapper, HashMap::new, valueSetFunction);
    }

    public static <A, B, C, D, Key, Value> @NonNull QuadConstraintCollector<A, B, C, D, ?, Map<Key, Value>> toMap(@NonNull QuadFunction<? super A, ? super B, ? super C, ? super D, ? extends Key> keyMapper, @NonNull QuadFunction<? super A, ? super B, ? super C, ? super D, ? extends Value> valueMapper, @NonNull BinaryOperator<Value> mergeFunction) {
        return InnerQuadConstraintCollectors.toMap(keyMapper, valueMapper, HashMap::new, mergeFunction);
    }

    public static <A, B, C, D, Key extends Comparable<? super Key>, Value> @NonNull QuadConstraintCollector<A, B, C, D, ?, SortedMap<Key, Set<Value>>> toSortedMap(@NonNull QuadFunction<? super A, ? super B, ? super C, ? super D, ? extends Key> keyMapper, @NonNull QuadFunction<? super A, ? super B, ? super C, ? super D, ? extends Value> valueMapper) {
        return ConstraintCollectors.toSortedMap(keyMapper, valueMapper, LinkedHashSet::new);
    }

    public static <A, B, C, D, Key extends Comparable<? super Key>, Value, ValueSet extends Set<Value>> @NonNull QuadConstraintCollector<A, B, C, D, ?, SortedMap<Key, ValueSet>> toSortedMap(@NonNull QuadFunction<? super A, ? super B, ? super C, ? super D, ? extends Key> keyMapper, @NonNull QuadFunction<? super A, ? super B, ? super C, ? super D, ? extends Value> valueMapper, @NonNull IntFunction<ValueSet> valueSetFunction) {
        return InnerQuadConstraintCollectors.toMap(keyMapper, valueMapper, TreeMap::new, valueSetFunction);
    }

    public static <A, B, C, D, Key extends Comparable<? super Key>, Value> @NonNull QuadConstraintCollector<A, B, C, D, ?, SortedMap<Key, Value>> toSortedMap(@NonNull QuadFunction<? super A, ? super B, ? super C, ? super D, ? extends Key> keyMapper, @NonNull QuadFunction<? super A, ? super B, ? super C, ? super D, ? extends Value> valueMapper, @NonNull BinaryOperator<Value> mergeFunction) {
        return InnerQuadConstraintCollectors.toMap(keyMapper, valueMapper, TreeMap::new, mergeFunction);
    }

    public static <A, ResultContainer_, Result_> @NonNull UniConstraintCollector<A, ResultContainer_, Result_> conditionally(@NonNull Predicate<A> condition, @NonNull UniConstraintCollector<A, ResultContainer_, Result_> delegate) {
        return InnerUniConstraintCollectors.conditionally(condition, delegate);
    }

    public static <A, B, ResultContainer_, Result_> @NonNull BiConstraintCollector<A, B, ResultContainer_, Result_> conditionally(@NonNull BiPredicate<A, B> condition, @NonNull BiConstraintCollector<A, B, ResultContainer_, Result_> delegate) {
        return InnerBiConstraintCollectors.conditionally(condition, delegate);
    }

    public static <A, B, C, ResultContainer_, Result_> @NonNull TriConstraintCollector<A, B, C, ResultContainer_, Result_> conditionally(@NonNull TriPredicate<A, B, C> condition, @NonNull TriConstraintCollector<A, B, C, ResultContainer_, Result_> delegate) {
        return InnerTriConstraintCollectors.conditionally(condition, delegate);
    }

    public static <A, B, C, D, ResultContainer_, Result_> @NonNull QuadConstraintCollector<A, B, C, D, ResultContainer_, Result_> conditionally(@NonNull QuadPredicate<A, B, C, D> condition, @NonNull QuadConstraintCollector<A, B, C, D, ResultContainer_, Result_> delegate) {
        return InnerQuadConstraintCollectors.conditionally(condition, delegate);
    }

    public static <A, Intermediate_, Result_> @NonNull UniConstraintCollector<A, ?, Result_> collectAndThen(@NonNull UniConstraintCollector<A, ?, Intermediate_> delegate, @NonNull Function<Intermediate_, Result_> mappingFunction) {
        return InnerUniConstraintCollectors.collectAndThen(delegate, mappingFunction);
    }

    public static <A, B, Intermediate_, Result_> @NonNull BiConstraintCollector<A, B, ?, Result_> collectAndThen(@NonNull BiConstraintCollector<A, B, ?, Intermediate_> delegate, @NonNull Function<Intermediate_, Result_> mappingFunction) {
        return InnerBiConstraintCollectors.collectAndThen(delegate, mappingFunction);
    }

    public static <A, B, C, Intermediate_, Result_> @NonNull TriConstraintCollector<A, B, C, ?, Result_> collectAndThen(@NonNull TriConstraintCollector<A, B, C, ?, Intermediate_> delegate, @NonNull Function<Intermediate_, Result_> mappingFunction) {
        return InnerTriConstraintCollectors.collectAndThen(delegate, mappingFunction);
    }

    public static <A, B, C, D, Intermediate_, Result_> @NonNull QuadConstraintCollector<A, B, C, D, ?, Result_> collectAndThen(@NonNull QuadConstraintCollector<A, B, C, D, ?, Intermediate_> delegate, @NonNull Function<Intermediate_, Result_> mappingFunction) {
        return InnerQuadConstraintCollectors.collectAndThen(delegate, mappingFunction);
    }

    public static <A, Result_, SubResultContainer1_, SubResultContainer2_, SubResult1_, SubResult2_> @NonNull UniConstraintCollector<A, ?, Result_> compose(@NonNull UniConstraintCollector<A, SubResultContainer1_, SubResult1_> subCollector1, @NonNull UniConstraintCollector<A, SubResultContainer2_, SubResult2_> subCollector2, @NonNull BiFunction<SubResult1_, SubResult2_, Result_> composeFunction) {
        return InnerUniConstraintCollectors.compose(subCollector1, subCollector2, composeFunction);
    }

    public static <A, Result_, SubResultContainer1_, SubResultContainer2_, SubResultContainer3_, SubResult1_, SubResult2_, SubResult3_> @NonNull UniConstraintCollector<A, ?, Result_> compose(@NonNull UniConstraintCollector<A, SubResultContainer1_, SubResult1_> subCollector1, @NonNull UniConstraintCollector<A, SubResultContainer2_, SubResult2_> subCollector2, @NonNull UniConstraintCollector<A, SubResultContainer3_, SubResult3_> subCollector3, @NonNull TriFunction<SubResult1_, SubResult2_, SubResult3_, Result_> composeFunction) {
        return InnerUniConstraintCollectors.compose(subCollector1, subCollector2, subCollector3, composeFunction);
    }

    public static <A, Result_, SubResultContainer1_, SubResultContainer2_, SubResultContainer3_, SubResultContainer4_, SubResult1_, SubResult2_, SubResult3_, SubResult4_> @NonNull UniConstraintCollector<A, ?, Result_> compose(@NonNull UniConstraintCollector<A, SubResultContainer1_, SubResult1_> subCollector1, @NonNull UniConstraintCollector<A, SubResultContainer2_, SubResult2_> subCollector2, @NonNull UniConstraintCollector<A, SubResultContainer3_, SubResult3_> subCollector3, @NonNull UniConstraintCollector<A, SubResultContainer4_, SubResult4_> subCollector4, @NonNull QuadFunction<SubResult1_, SubResult2_, SubResult3_, SubResult4_, Result_> composeFunction) {
        return InnerUniConstraintCollectors.compose(subCollector1, subCollector2, subCollector3, subCollector4, composeFunction);
    }

    public static <A, B, Result_, SubResultContainer1_, SubResultContainer2_, SubResult1_, SubResult2_> @NonNull BiConstraintCollector<A, B, ?, Result_> compose(@NonNull BiConstraintCollector<A, B, SubResultContainer1_, SubResult1_> subCollector1, @NonNull BiConstraintCollector<A, B, SubResultContainer2_, SubResult2_> subCollector2, @NonNull BiFunction<SubResult1_, SubResult2_, Result_> composeFunction) {
        return InnerBiConstraintCollectors.compose(subCollector1, subCollector2, composeFunction);
    }

    public static <A, B, Result_, SubResultContainer1_, SubResultContainer2_, SubResultContainer3_, SubResult1_, SubResult2_, SubResult3_> @NonNull BiConstraintCollector<A, B, ?, Result_> compose(@NonNull BiConstraintCollector<A, B, SubResultContainer1_, SubResult1_> subCollector1, @NonNull BiConstraintCollector<A, B, SubResultContainer2_, SubResult2_> subCollector2, @NonNull BiConstraintCollector<A, B, SubResultContainer3_, SubResult3_> subCollector3, @NonNull TriFunction<SubResult1_, SubResult2_, SubResult3_, Result_> composeFunction) {
        return InnerBiConstraintCollectors.compose(subCollector1, subCollector2, subCollector3, composeFunction);
    }

    public static <A, B, Result_, SubResultContainer1_, SubResultContainer2_, SubResultContainer3_, SubResultContainer4_, SubResult1_, SubResult2_, SubResult3_, SubResult4_> @NonNull BiConstraintCollector<A, B, ?, Result_> compose(@NonNull BiConstraintCollector<A, B, SubResultContainer1_, SubResult1_> subCollector1, @NonNull BiConstraintCollector<A, B, SubResultContainer2_, SubResult2_> subCollector2, @NonNull BiConstraintCollector<A, B, SubResultContainer3_, SubResult3_> subCollector3, @NonNull BiConstraintCollector<A, B, SubResultContainer4_, SubResult4_> subCollector4, @NonNull QuadFunction<SubResult1_, SubResult2_, SubResult3_, SubResult4_, Result_> composeFunction) {
        return InnerBiConstraintCollectors.compose(subCollector1, subCollector2, subCollector3, subCollector4, composeFunction);
    }

    public static <A, B, C, Result_, SubResultContainer1_, SubResultContainer2_, SubResult1_, SubResult2_> @NonNull TriConstraintCollector<A, B, C, ?, Result_> compose(@NonNull TriConstraintCollector<A, B, C, SubResultContainer1_, SubResult1_> subCollector1, @NonNull TriConstraintCollector<A, B, C, SubResultContainer2_, SubResult2_> subCollector2, @NonNull BiFunction<SubResult1_, SubResult2_, Result_> composeFunction) {
        return InnerTriConstraintCollectors.compose(subCollector1, subCollector2, composeFunction);
    }

    public static <A, B, C, Result_, SubResultContainer1_, SubResultContainer2_, SubResultContainer3_, SubResult1_, SubResult2_, SubResult3_> @NonNull TriConstraintCollector<A, B, C, ?, Result_> compose(@NonNull TriConstraintCollector<A, B, C, SubResultContainer1_, SubResult1_> subCollector1, @NonNull TriConstraintCollector<A, B, C, SubResultContainer2_, SubResult2_> subCollector2, @NonNull TriConstraintCollector<A, B, C, SubResultContainer3_, SubResult3_> subCollector3, @NonNull TriFunction<SubResult1_, SubResult2_, SubResult3_, Result_> composeFunction) {
        return InnerTriConstraintCollectors.compose(subCollector1, subCollector2, subCollector3, composeFunction);
    }

    public static <A, B, C, Result_, SubResultContainer1_, SubResultContainer2_, SubResultContainer3_, SubResultContainer4_, SubResult1_, SubResult2_, SubResult3_, SubResult4_> @NonNull TriConstraintCollector<A, B, C, ?, Result_> compose(@NonNull TriConstraintCollector<A, B, C, SubResultContainer1_, SubResult1_> subCollector1, @NonNull TriConstraintCollector<A, B, C, SubResultContainer2_, SubResult2_> subCollector2, @NonNull TriConstraintCollector<A, B, C, SubResultContainer3_, SubResult3_> subCollector3, @NonNull TriConstraintCollector<A, B, C, SubResultContainer4_, SubResult4_> subCollector4, @NonNull QuadFunction<SubResult1_, SubResult2_, SubResult3_, SubResult4_, Result_> composeFunction) {
        return InnerTriConstraintCollectors.compose(subCollector1, subCollector2, subCollector3, subCollector4, composeFunction);
    }

    public static <A, B, C, D, Result_, SubResultContainer1_, SubResultContainer2_, SubResult1_, SubResult2_> @NonNull QuadConstraintCollector<A, B, C, D, ?, Result_> compose(@NonNull QuadConstraintCollector<A, B, C, D, SubResultContainer1_, SubResult1_> subCollector1, @NonNull QuadConstraintCollector<A, B, C, D, SubResultContainer2_, SubResult2_> subCollector2, @NonNull BiFunction<SubResult1_, SubResult2_, Result_> composeFunction) {
        return InnerQuadConstraintCollectors.compose(subCollector1, subCollector2, composeFunction);
    }

    public static <A, B, C, D, Result_, SubResultContainer1_, SubResultContainer2_, SubResultContainer3_, SubResult1_, SubResult2_, SubResult3_> @NonNull QuadConstraintCollector<A, B, C, D, ?, Result_> compose(@NonNull QuadConstraintCollector<A, B, C, D, SubResultContainer1_, SubResult1_> subCollector1, @NonNull QuadConstraintCollector<A, B, C, D, SubResultContainer2_, SubResult2_> subCollector2, @NonNull QuadConstraintCollector<A, B, C, D, SubResultContainer3_, SubResult3_> subCollector3, @NonNull TriFunction<SubResult1_, SubResult2_, SubResult3_, Result_> composeFunction) {
        return InnerQuadConstraintCollectors.compose(subCollector1, subCollector2, subCollector3, composeFunction);
    }

    public static <A, B, C, D, Result_, SubResultContainer1_, SubResultContainer2_, SubResultContainer3_, SubResultContainer4_, SubResult1_, SubResult2_, SubResult3_, SubResult4_> @NonNull QuadConstraintCollector<A, B, C, D, ?, Result_> compose(@NonNull QuadConstraintCollector<A, B, C, D, SubResultContainer1_, SubResult1_> subCollector1, @NonNull QuadConstraintCollector<A, B, C, D, SubResultContainer2_, SubResult2_> subCollector2, @NonNull QuadConstraintCollector<A, B, C, D, SubResultContainer3_, SubResult3_> subCollector3, @NonNull QuadConstraintCollector<A, B, C, D, SubResultContainer4_, SubResult4_> subCollector4, @NonNull QuadFunction<SubResult1_, SubResult2_, SubResult3_, SubResult4_, Result_> composeFunction) {
        return InnerQuadConstraintCollectors.compose(subCollector1, subCollector2, subCollector3, subCollector4, composeFunction);
    }

    public static <A> @NonNull UniConstraintCollector<A, ?, SequenceChain<A, Integer>> toConsecutiveSequences(@NonNull ToIntFunction<A> indexMap) {
        return InnerUniConstraintCollectors.toConsecutiveSequences(indexMap);
    }

    public static <A, B, Result_> @NonNull BiConstraintCollector<A, B, ?, SequenceChain<Result_, Integer>> toConsecutiveSequences(@NonNull BiFunction<A, B, Result_> resultMap, @NonNull ToIntFunction<Result_> indexMap) {
        return InnerBiConstraintCollectors.toConsecutiveSequences(resultMap, indexMap);
    }

    public static <A, B, C, Result_> @NonNull TriConstraintCollector<A, B, C, ?, SequenceChain<Result_, Integer>> toConsecutiveSequences(@NonNull TriFunction<A, B, C, Result_> resultMap, @NonNull ToIntFunction<Result_> indexMap) {
        return InnerTriConstraintCollectors.toConsecutiveSequences(resultMap, indexMap);
    }

    public static <A, B, C, D, Result_> @NonNull QuadConstraintCollector<A, B, C, D, ?, SequenceChain<Result_, Integer>> toConsecutiveSequences(@NonNull QuadFunction<A, B, C, D, Result_> resultMap, @NonNull ToIntFunction<Result_> indexMap) {
        return InnerQuadConstraintCollectors.toConsecutiveSequences(resultMap, indexMap);
    }

    public static <A, PointType_ extends Comparable<PointType_>, DifferenceType_ extends Comparable<DifferenceType_>> @NonNull UniConstraintCollector<A, ?, ConnectedRangeChain<A, PointType_, DifferenceType_>> toConnectedRanges(@NonNull Function<A, PointType_> startInclusiveMap, @NonNull Function<A, PointType_> endExclusiveMap, @NonNull BiFunction<PointType_, PointType_, DifferenceType_> differenceFunction) {
        return InnerUniConstraintCollectors.toConnectedRanges(ConstantLambdaUtils.identity(), startInclusiveMap, endExclusiveMap, differenceFunction);
    }

    public static <A, PointType_ extends Temporal & Comparable<PointType_>> @NonNull UniConstraintCollector<A, ?, ConnectedRangeChain<A, PointType_, Duration>> toConnectedTemporalRanges(@NonNull Function<A, PointType_> startInclusiveMap, @NonNull Function<A, PointType_> endExclusiveMap) {
        return ConstraintCollectors.toConnectedRanges(startInclusiveMap, endExclusiveMap, (PointType_ x$0, PointType_ x$1) -> Duration.between((Temporal)x$0, (Temporal)x$1));
    }

    public static <A> @NonNull UniConstraintCollector<A, ?, ConnectedRangeChain<A, Long, Long>> toConnectedRanges(@NonNull ToLongFunction<A> startInclusiveMap, @NonNull ToLongFunction<A> endExclusiveMap) {
        return ConstraintCollectors.toConnectedRanges(startInclusiveMap::applyAsLong, endExclusiveMap::applyAsLong, (PointType_ a, PointType_ b) -> b - a);
    }

    public static <A, B, IntervalType_, PointType_ extends Comparable<PointType_>, DifferenceType_ extends Comparable<DifferenceType_>> @NonNull BiConstraintCollector<A, B, ?, ConnectedRangeChain<IntervalType_, PointType_, DifferenceType_>> toConnectedRanges(@NonNull BiFunction<A, B, IntervalType_> intervalMap, @NonNull Function<IntervalType_, PointType_> startInclusiveMap, @NonNull Function<IntervalType_, PointType_> endExclusiveMap, @NonNull BiFunction<PointType_, PointType_, DifferenceType_> differenceFunction) {
        return InnerBiConstraintCollectors.toConnectedRanges(intervalMap, startInclusiveMap, endExclusiveMap, differenceFunction);
    }

    public static <A, B, IntervalType_, PointType_ extends Temporal & Comparable<PointType_>> @NonNull BiConstraintCollector<A, B, ?, ConnectedRangeChain<IntervalType_, PointType_, Duration>> toConnectedTemporalRanges(@NonNull BiFunction<A, B, IntervalType_> intervalMap, @NonNull Function<IntervalType_, PointType_> startInclusiveMap, @NonNull Function<IntervalType_, PointType_> endExclusiveMap) {
        return ConstraintCollectors.toConnectedRanges(intervalMap, startInclusiveMap, endExclusiveMap, (PointType_ x$0, PointType_ x$1) -> Duration.between((Temporal)x$0, (Temporal)x$1));
    }

    public static <A, B, IntervalType_> @NonNull BiConstraintCollector<A, B, ?, ConnectedRangeChain<IntervalType_, Long, Long>> toConnectedRanges(@NonNull BiFunction<A, B, IntervalType_> intervalMap, @NonNull ToLongFunction<IntervalType_> startInclusiveMap, @NonNull ToLongFunction<IntervalType_> endExclusiveMap) {
        return ConstraintCollectors.toConnectedRanges(intervalMap, startInclusiveMap::applyAsLong, endExclusiveMap::applyAsLong, (PointType_ a, PointType_ b) -> b - a);
    }

    public static <A, B, C, IntervalType_, PointType_ extends Comparable<PointType_>, DifferenceType_ extends Comparable<DifferenceType_>> @NonNull TriConstraintCollector<A, B, C, ?, ConnectedRangeChain<IntervalType_, PointType_, DifferenceType_>> toConnectedRanges(@NonNull TriFunction<A, B, C, IntervalType_> intervalMap, @NonNull Function<IntervalType_, PointType_> startInclusiveMap, @NonNull Function<IntervalType_, PointType_> endExclusiveMap, @NonNull BiFunction<PointType_, PointType_, DifferenceType_> differenceFunction) {
        return InnerTriConstraintCollectors.toConnectedRanges(intervalMap, startInclusiveMap, endExclusiveMap, differenceFunction);
    }

    public static <A, B, C, IntervalType_, PointType_ extends Temporal & Comparable<PointType_>> @NonNull TriConstraintCollector<A, B, C, ?, ConnectedRangeChain<IntervalType_, PointType_, Duration>> toConnectedTemporalRanges(@NonNull TriFunction<A, B, C, IntervalType_> intervalMap, @NonNull Function<IntervalType_, PointType_> startInclusiveMap, @NonNull Function<IntervalType_, PointType_> endExclusiveMap) {
        return ConstraintCollectors.toConnectedRanges(intervalMap, startInclusiveMap, endExclusiveMap, (PointType_ x$0, PointType_ x$1) -> Duration.between((Temporal)x$0, (Temporal)x$1));
    }

    public static <A, B, C, IntervalType_> @NonNull TriConstraintCollector<A, B, C, ?, ConnectedRangeChain<IntervalType_, Long, Long>> toConnectedRanges(@NonNull TriFunction<A, B, C, IntervalType_> intervalMap, @NonNull ToLongFunction<IntervalType_> startInclusiveMap, @NonNull ToLongFunction<IntervalType_> endExclusiveMap) {
        return ConstraintCollectors.toConnectedRanges(intervalMap, startInclusiveMap::applyAsLong, endExclusiveMap::applyAsLong, (PointType_ a, PointType_ b) -> b - a);
    }

    public static <A, B, C, D, IntervalType_, PointType_ extends Comparable<PointType_>, DifferenceType_ extends Comparable<DifferenceType_>> @NonNull QuadConstraintCollector<A, B, C, D, ?, ConnectedRangeChain<IntervalType_, PointType_, DifferenceType_>> toConnectedRanges(@NonNull QuadFunction<A, B, C, D, IntervalType_> intervalMap, @NonNull Function<IntervalType_, PointType_> startInclusiveMap, @NonNull Function<IntervalType_, PointType_> endExclusiveMap, @NonNull BiFunction<PointType_, PointType_, DifferenceType_> differenceFunction) {
        return InnerQuadConstraintCollectors.toConnectedRanges(intervalMap, startInclusiveMap, endExclusiveMap, differenceFunction);
    }

    public static <A, B, C, D, IntervalType_, PointType_ extends Temporal & Comparable<PointType_>> @NonNull QuadConstraintCollector<A, B, C, D, ?, ConnectedRangeChain<IntervalType_, PointType_, Duration>> toConnectedTemporalRanges(@NonNull QuadFunction<A, B, C, D, IntervalType_> intervalMap, @NonNull Function<IntervalType_, PointType_> startInclusiveMap, @NonNull Function<IntervalType_, PointType_> endExclusiveMap) {
        return ConstraintCollectors.toConnectedRanges(intervalMap, startInclusiveMap, endExclusiveMap, (PointType_ x$0, PointType_ x$1) -> Duration.between((Temporal)x$0, (Temporal)x$1));
    }

    public static <A, B, C, D, IntervalType_> @NonNull QuadConstraintCollector<A, B, C, D, ?, ConnectedRangeChain<IntervalType_, Long, Long>> toConnectedRanges(@NonNull QuadFunction<A, B, C, D, IntervalType_> intervalMap, @NonNull ToLongFunction<IntervalType_> startInclusiveMap, @NonNull ToLongFunction<IntervalType_> endExclusiveMap) {
        return ConstraintCollectors.toConnectedRanges(intervalMap, startInclusiveMap::applyAsLong, endExclusiveMap::applyAsLong, (PointType_ a, PointType_ b) -> b - a);
    }

    public static <A, Balanced_> @NonNull UniConstraintCollector<A, ?, LoadBalance<Balanced_>> loadBalance(@NonNull Function<A, Balanced_> balancedItemFunction) {
        return ConstraintCollectors.loadBalance(balancedItemFunction, ConstantLambdaUtils.uniConstantOneLong());
    }

    public static <A, Balanced_> @NonNull UniConstraintCollector<A, ?, LoadBalance<Balanced_>> loadBalance(@NonNull Function<A, Balanced_> balancedItemFunction, @NonNull ToLongFunction<A> loadFunction) {
        return ConstraintCollectors.loadBalance(balancedItemFunction, loadFunction, ConstantLambdaUtils.uniConstantZeroLong());
    }

    public static <A, Balanced_> @NonNull UniConstraintCollector<A, ?, LoadBalance<Balanced_>> loadBalance(@NonNull Function<A, Balanced_> balancedItemFunction, @NonNull ToLongFunction<A> loadFunction, @NonNull ToLongFunction<A> initialLoadFunction) {
        return InnerUniConstraintCollectors.loadBalance(balancedItemFunction, loadFunction, initialLoadFunction);
    }

    public static <A, B, Balanced_> @NonNull BiConstraintCollector<A, B, ?, LoadBalance<Balanced_>> loadBalance(@NonNull BiFunction<A, B, Balanced_> balancedItemFunction) {
        return ConstraintCollectors.loadBalance(balancedItemFunction, ConstantLambdaUtils.biConstantOneLong());
    }

    public static <A, B, Balanced_> @NonNull BiConstraintCollector<A, B, ?, LoadBalance<Balanced_>> loadBalance(@NonNull BiFunction<A, B, Balanced_> balancedItemFunction, @NonNull ToLongBiFunction<A, B> loadFunction) {
        return ConstraintCollectors.loadBalance(balancedItemFunction, loadFunction, ConstantLambdaUtils.biConstantZeroLong());
    }

    public static <A, B, Balanced_> @NonNull BiConstraintCollector<A, B, ?, LoadBalance<Balanced_>> loadBalance(@NonNull BiFunction<A, B, Balanced_> balancedItemFunction, @NonNull ToLongBiFunction<A, B> loadFunction, @NonNull ToLongBiFunction<A, B> initialLoadFunction) {
        return InnerBiConstraintCollectors.loadBalance(balancedItemFunction, loadFunction, initialLoadFunction);
    }

    public static <A, B, C, Balanced_> @NonNull TriConstraintCollector<A, B, C, ?, LoadBalance<Balanced_>> loadBalance(@NonNull TriFunction<A, B, C, Balanced_> balancedItemFunction) {
        return ConstraintCollectors.loadBalance(balancedItemFunction, ConstantLambdaUtils.triConstantOneLong());
    }

    public static <A, B, C, Balanced_> @NonNull TriConstraintCollector<A, B, C, ?, LoadBalance<Balanced_>> loadBalance(@NonNull TriFunction<A, B, C, Balanced_> balancedItemFunction, @NonNull ToLongTriFunction<A, B, C> loadFunction) {
        return ConstraintCollectors.loadBalance(balancedItemFunction, loadFunction, ConstantLambdaUtils.triConstantZeroLong());
    }

    public static <A, B, C, Balanced_> @NonNull TriConstraintCollector<A, B, C, ?, LoadBalance<Balanced_>> loadBalance(@NonNull TriFunction<A, B, C, Balanced_> balancedItemFunction, @NonNull ToLongTriFunction<A, B, C> loadFunction, @NonNull ToLongTriFunction<A, B, C> initialLoadFunction) {
        return InnerTriConstraintCollectors.loadBalance(balancedItemFunction, loadFunction, initialLoadFunction);
    }

    public static <A, B, C, D, Balanced_> @NonNull QuadConstraintCollector<A, B, C, D, ?, LoadBalance<Balanced_>> loadBalance(@NonNull QuadFunction<A, B, C, D, Balanced_> balancedItemFunction) {
        return ConstraintCollectors.loadBalance(balancedItemFunction, ConstantLambdaUtils.quadConstantOneLong());
    }

    public static <A, B, C, D, Balanced_> @NonNull QuadConstraintCollector<A, B, C, D, ?, LoadBalance<Balanced_>> loadBalance(@NonNull QuadFunction<A, B, C, D, Balanced_> balancedItemFunction, @NonNull ToLongQuadFunction<A, B, C, D> loadFunction) {
        return ConstraintCollectors.loadBalance(balancedItemFunction, loadFunction, ConstantLambdaUtils.quadConstantZeroLong());
    }

    public static <A, B, C, D, Balanced_> @NonNull QuadConstraintCollector<A, B, C, D, ?, LoadBalance<Balanced_>> loadBalance(@NonNull QuadFunction<A, B, C, D, Balanced_> balancedItemFunction, @NonNull ToLongQuadFunction<A, B, C, D> loadFunction, @NonNull ToLongQuadFunction<A, B, C, D> initialLoadFunction) {
        return InnerQuadConstraintCollectors.loadBalance(balancedItemFunction, loadFunction, initialLoadFunction);
    }

    private ConstraintCollectors() {
    }
}

