/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.solver.thread;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThreadUtils.class);

    public static void shutdownAwaitOrKill(ExecutorService executor, String logIndentation, String name) {
        if (Thread.interrupted()) {
            executor.shutdownNow();
        } else {
            executor.shutdown();
        }
        try {
            boolean awaitingSeconds = true;
            if (!executor.awaitTermination(1L, TimeUnit.SECONDS)) {
                LOGGER.error("{}{}'s ExecutorService didn't terminate within timeout ({} seconds).", new Object[]{logIndentation, name, 1});
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Thread pool termination was interrupted.", e);
        }
        finally {
            executor.shutdownNow();
        }
    }

    private ThreadUtils() {
    }
}

