/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.collector.connected_ranges;

import ai.timefold.solver.core.api.score.stream.common.ConnectedRangeChain;
import ai.timefold.solver.core.impl.score.stream.collector.connected_ranges.ConnectedRangeChainImpl;
import ai.timefold.solver.core.impl.score.stream.collector.connected_ranges.ContainedRangeIterator;
import ai.timefold.solver.core.impl.score.stream.collector.connected_ranges.Range;
import ai.timefold.solver.core.impl.score.stream.collector.connected_ranges.RangeSplitPoint;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.function.Function;

public final class ConnectedRangeTracker<Range_, Point_ extends Comparable<Point_>, Difference_ extends Comparable<Difference_>> {
    private final Function<? super Range_, ? extends Point_> startMapping;
    private final Function<? super Range_, ? extends Point_> endMapping;
    private final NavigableSet<RangeSplitPoint<Range_, Point_>> splitPointSet;
    private final ConnectedRangeChainImpl<Range_, Point_, Difference_> connectedRangeChain;

    public ConnectedRangeTracker(Function<? super Range_, ? extends Point_> startMapping, Function<? super Range_, ? extends Point_> endMapping, BiFunction<? super Point_, ? super Point_, ? extends Difference_> differenceFunction) {
        this.startMapping = startMapping;
        this.endMapping = endMapping;
        this.splitPointSet = new TreeSet<RangeSplitPoint<Range_, Point_>>();
        this.connectedRangeChain = new ConnectedRangeChainImpl<Range_, Point_, Difference_>(this.splitPointSet, differenceFunction);
    }

    public Range<Range_, Point_> getRange(Range_ rangeValue) {
        return new Range<Range_, Point_>(rangeValue, this.startMapping, this.endMapping);
    }

    public boolean isEmpty() {
        return this.splitPointSet.isEmpty();
    }

    public boolean contains(Range_ o) {
        if (null == o || this.splitPointSet.isEmpty()) {
            return false;
        }
        Range<Range_, Point_> range = this.getRange(o);
        RangeSplitPoint<Range_, Point_> floorStartSplitPoint = this.splitPointSet.floor(range.getStartSplitPoint());
        if (floorStartSplitPoint == null) {
            return false;
        }
        return floorStartSplitPoint.containsRangeStarting(range);
    }

    public Iterator<Range_> iterator() {
        return new ContainedRangeIterator<Range_, Point_>(this.splitPointSet);
    }

    public boolean add(Range<Range_, Point_> range) {
        RangeSplitPoint<Range_, Point_> startSplitPoint = range.getStartSplitPoint();
        RangeSplitPoint<Range_, Point_> endSplitPoint = range.getEndSplitPoint();
        RangeSplitPoint<Range_, Point_> flooredStartSplitPoint = this.splitPointSet.floor(startSplitPoint);
        if (flooredStartSplitPoint == null || !flooredStartSplitPoint.equals(startSplitPoint)) {
            this.splitPointSet.add(startSplitPoint);
            startSplitPoint.createCollections();
            startSplitPoint.addRangeStartingAtSplitPoint(range);
        } else {
            flooredStartSplitPoint.addRangeStartingAtSplitPoint(range);
        }
        RangeSplitPoint<Range_, Point_> ceilingEndSplitPoint = this.splitPointSet.ceiling(endSplitPoint);
        if (ceilingEndSplitPoint == null || !ceilingEndSplitPoint.equals(endSplitPoint)) {
            this.splitPointSet.add(endSplitPoint);
            endSplitPoint.createCollections();
            endSplitPoint.addRangeEndingAtSplitPoint(range);
        } else {
            ceilingEndSplitPoint.addRangeEndingAtSplitPoint(range);
        }
        this.connectedRangeChain.addRange(range);
        return true;
    }

    public boolean remove(Range<Range_, Point_> range) {
        RangeSplitPoint<Range_, Point_> startSplitPoint = range.getStartSplitPoint();
        RangeSplitPoint<Range_, Point_> endSplitPoint = range.getEndSplitPoint();
        RangeSplitPoint<Range_, Point_> flooredStartSplitPoint = this.splitPointSet.floor(startSplitPoint);
        if (flooredStartSplitPoint == null || !flooredStartSplitPoint.containsRangeStarting(range)) {
            return false;
        }
        flooredStartSplitPoint.removeRangeStartingAtSplitPoint(range);
        if (flooredStartSplitPoint.isEmpty()) {
            this.splitPointSet.remove(flooredStartSplitPoint);
        }
        RangeSplitPoint<Range_, Point_> ceilEndSplitPoint = this.splitPointSet.ceiling(endSplitPoint);
        ceilEndSplitPoint.removeRangeEndingAtSplitPoint(range);
        if (ceilEndSplitPoint.isEmpty()) {
            this.splitPointSet.remove(ceilEndSplitPoint);
        }
        this.connectedRangeChain.removeRange(range);
        return true;
    }

    public ConnectedRangeChain<Range_, Point_, Difference_> getConnectedRangeChain() {
        return this.connectedRangeChain;
    }
}

