/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.collector.bi;

import ai.timefold.solver.core.api.function.QuadFunction;
import ai.timefold.solver.core.api.function.TriFunction;
import ai.timefold.solver.core.api.score.stream.bi.BiConstraintCollector;
import ai.timefold.solver.core.api.score.stream.common.ConnectedRangeChain;
import ai.timefold.solver.core.api.score.stream.common.LoadBalance;
import ai.timefold.solver.core.api.score.stream.common.SequenceChain;
import ai.timefold.solver.core.impl.score.stream.collector.ReferenceAverageCalculator;
import ai.timefold.solver.core.impl.score.stream.collector.bi.AndThenBiCollector;
import ai.timefold.solver.core.impl.score.stream.collector.bi.AverageIntBiCollector;
import ai.timefold.solver.core.impl.score.stream.collector.bi.AverageLongBiCollector;
import ai.timefold.solver.core.impl.score.stream.collector.bi.AverageReferenceBiCollector;
import ai.timefold.solver.core.impl.score.stream.collector.bi.ComposeFourBiCollector;
import ai.timefold.solver.core.impl.score.stream.collector.bi.ComposeThreeBiCollector;
import ai.timefold.solver.core.impl.score.stream.collector.bi.ComposeTwoBiCollector;
import ai.timefold.solver.core.impl.score.stream.collector.bi.ConditionalBiCollector;
import ai.timefold.solver.core.impl.score.stream.collector.bi.ConnectedRangesBiConstraintCollector;
import ai.timefold.solver.core.impl.score.stream.collector.bi.ConsecutiveSequencesBiConstraintCollector;
import ai.timefold.solver.core.impl.score.stream.collector.bi.CountDistinctIntBiCollector;
import ai.timefold.solver.core.impl.score.stream.collector.bi.CountDistinctLongBiCollector;
import ai.timefold.solver.core.impl.score.stream.collector.bi.CountIntBiCollector;
import ai.timefold.solver.core.impl.score.stream.collector.bi.CountLongBiCollector;
import ai.timefold.solver.core.impl.score.stream.collector.bi.LoadBalanceBiCollector;
import ai.timefold.solver.core.impl.score.stream.collector.bi.MaxComparableBiCollector;
import ai.timefold.solver.core.impl.score.stream.collector.bi.MaxComparatorBiCollector;
import ai.timefold.solver.core.impl.score.stream.collector.bi.MaxPropertyBiCollector;
import ai.timefold.solver.core.impl.score.stream.collector.bi.MinComparableBiCollector;
import ai.timefold.solver.core.impl.score.stream.collector.bi.MinComparatorBiCollector;
import ai.timefold.solver.core.impl.score.stream.collector.bi.MinPropertyBiCollector;
import ai.timefold.solver.core.impl.score.stream.collector.bi.SumIntBiCollector;
import ai.timefold.solver.core.impl.score.stream.collector.bi.SumLongBiCollector;
import ai.timefold.solver.core.impl.score.stream.collector.bi.SumReferenceBiCollector;
import ai.timefold.solver.core.impl.score.stream.collector.bi.ToCollectionBiCollector;
import ai.timefold.solver.core.impl.score.stream.collector.bi.ToListBiCollector;
import ai.timefold.solver.core.impl.score.stream.collector.bi.ToMultiMapBiCollector;
import ai.timefold.solver.core.impl.score.stream.collector.bi.ToSetBiCollector;
import ai.timefold.solver.core.impl.score.stream.collector.bi.ToSimpleMapBiCollector;
import ai.timefold.solver.core.impl.score.stream.collector.bi.ToSortedSetComparatorBiCollector;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Duration;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.function.ToIntBiFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongBiFunction;

public class InnerBiConstraintCollectors {
    public static <A, B> BiConstraintCollector<A, B, ?, Double> average(ToIntBiFunction<? super A, ? super B> mapper) {
        return new AverageIntBiCollector<A, B>(mapper);
    }

    public static <A, B> BiConstraintCollector<A, B, ?, Double> average(ToLongBiFunction<? super A, ? super B> mapper) {
        return new AverageLongBiCollector<A, B>(mapper);
    }

    static <A, B, Mapped_, Average_> BiConstraintCollector<A, B, ?, Average_> average(BiFunction<? super A, ? super B, ? extends Mapped_> mapper, Supplier<ReferenceAverageCalculator<Mapped_, Average_>> calculatorSupplier) {
        return new AverageReferenceBiCollector<A, B, Mapped_, Average_>(mapper, calculatorSupplier);
    }

    public static <A, B> BiConstraintCollector<A, B, ?, BigDecimal> averageBigDecimal(BiFunction<? super A, ? super B, ? extends BigDecimal> mapper) {
        return InnerBiConstraintCollectors.average(mapper, ReferenceAverageCalculator.bigDecimal());
    }

    public static <A, B> BiConstraintCollector<A, B, ?, Duration> averageDuration(BiFunction<? super A, ? super B, ? extends Duration> mapper) {
        return InnerBiConstraintCollectors.average(mapper, ReferenceAverageCalculator.duration());
    }

    public static <A, B> BiConstraintCollector<A, B, ?, BigDecimal> averageBigInteger(BiFunction<? super A, ? super B, ? extends BigInteger> mapper) {
        return InnerBiConstraintCollectors.average(mapper, ReferenceAverageCalculator.bigInteger());
    }

    public static <A, B, ResultHolder1_, ResultHolder2_, ResultHolder3_, ResultHolder4_, Result1_, Result2_, Result3_, Result4_, Result_> BiConstraintCollector<A, B, ?, Result_> compose(BiConstraintCollector<A, B, ResultHolder1_, Result1_> first, BiConstraintCollector<A, B, ResultHolder2_, Result2_> second, BiConstraintCollector<A, B, ResultHolder3_, Result3_> third, BiConstraintCollector<A, B, ResultHolder4_, Result4_> fourth, QuadFunction<Result1_, Result2_, Result3_, Result4_, Result_> composeFunction) {
        return new ComposeFourBiCollector<A, B, ResultHolder1_, ResultHolder2_, ResultHolder3_, ResultHolder4_, Result1_, Result2_, Result3_, Result4_, Result_>(first, second, third, fourth, composeFunction);
    }

    public static <A, B, ResultHolder1_, ResultHolder2_, ResultHolder3_, Result1_, Result2_, Result3_, Result_> BiConstraintCollector<A, B, ?, Result_> compose(BiConstraintCollector<A, B, ResultHolder1_, Result1_> first, BiConstraintCollector<A, B, ResultHolder2_, Result2_> second, BiConstraintCollector<A, B, ResultHolder3_, Result3_> third, TriFunction<Result1_, Result2_, Result3_, Result_> composeFunction) {
        return new ComposeThreeBiCollector<A, B, ResultHolder1_, ResultHolder2_, ResultHolder3_, Result1_, Result2_, Result3_, Result_>(first, second, third, composeFunction);
    }

    public static <A, B, ResultHolder1_, ResultHolder2_, Result1_, Result2_, Result_> BiConstraintCollector<A, B, ?, Result_> compose(BiConstraintCollector<A, B, ResultHolder1_, Result1_> first, BiConstraintCollector<A, B, ResultHolder2_, Result2_> second, BiFunction<Result1_, Result2_, Result_> composeFunction) {
        return new ComposeTwoBiCollector<A, B, ResultHolder1_, ResultHolder2_, Result1_, Result2_, Result_>(first, second, composeFunction);
    }

    public static <A, B, ResultContainer_, Result_> BiConstraintCollector<A, B, ResultContainer_, Result_> conditionally(BiPredicate<A, B> predicate, BiConstraintCollector<A, B, ResultContainer_, Result_> delegate) {
        return new ConditionalBiCollector<A, B, ResultContainer_, Result_>(predicate, delegate);
    }

    public static <A, B> BiConstraintCollector<A, B, ?, Integer> count() {
        return CountIntBiCollector.getInstance();
    }

    public static <A, B, Mapped_> BiConstraintCollector<A, B, ?, Integer> countDistinct(BiFunction<? super A, ? super B, ? extends Mapped_> mapper) {
        return new CountDistinctIntBiCollector<A, B, Mapped_>(mapper);
    }

    public static <A, B, Mapped_> BiConstraintCollector<A, B, ?, Long> countDistinctLong(BiFunction<? super A, ? super B, ? extends Mapped_> mapper) {
        return new CountDistinctLongBiCollector<A, B, Mapped_>(mapper);
    }

    public static <A, B> BiConstraintCollector<A, B, ?, Long> countLong() {
        return CountLongBiCollector.getInstance();
    }

    public static <A, B, Result_ extends Comparable<? super Result_>> BiConstraintCollector<A, B, ?, Result_> max(BiFunction<? super A, ? super B, ? extends Result_> mapper) {
        return new MaxComparableBiCollector<A, B, Result_>(mapper);
    }

    public static <A, B, Result_> BiConstraintCollector<A, B, ?, Result_> max(BiFunction<? super A, ? super B, ? extends Result_> mapper, Comparator<? super Result_> comparator) {
        return new MaxComparatorBiCollector<A, B, Result_>(mapper, comparator);
    }

    public static <A, B, Result_, Property_ extends Comparable<? super Property_>> BiConstraintCollector<A, B, ?, Result_> max(BiFunction<? super A, ? super B, ? extends Result_> mapper, Function<? super Result_, ? extends Property_> propertyMapper) {
        return new MaxPropertyBiCollector<A, B, Result_, Property_>(mapper, propertyMapper);
    }

    public static <A, B, Result_ extends Comparable<? super Result_>> BiConstraintCollector<A, B, ?, Result_> min(BiFunction<? super A, ? super B, ? extends Result_> mapper) {
        return new MinComparableBiCollector<A, B, Result_>(mapper);
    }

    public static <A, B, Result_> BiConstraintCollector<A, B, ?, Result_> min(BiFunction<? super A, ? super B, ? extends Result_> mapper, Comparator<? super Result_> comparator) {
        return new MinComparatorBiCollector<A, B, Result_>(mapper, comparator);
    }

    public static <A, B, Result_, Property_ extends Comparable<? super Property_>> BiConstraintCollector<A, B, ?, Result_> min(BiFunction<? super A, ? super B, ? extends Result_> mapper, Function<? super Result_, ? extends Property_> propertyMapper) {
        return new MinPropertyBiCollector<A, B, Result_, Property_>(mapper, propertyMapper);
    }

    public static <A, B> BiConstraintCollector<A, B, ?, Integer> sum(ToIntBiFunction<? super A, ? super B> mapper) {
        return new SumIntBiCollector<A, B>(mapper);
    }

    public static <A, B> BiConstraintCollector<A, B, ?, Long> sum(ToLongBiFunction<? super A, ? super B> mapper) {
        return new SumLongBiCollector<A, B>(mapper);
    }

    public static <A, B, Result_> BiConstraintCollector<A, B, ?, Result_> sum(BiFunction<? super A, ? super B, ? extends Result_> mapper, Result_ zero, BinaryOperator<Result_> adder, BinaryOperator<Result_> subtractor) {
        return new SumReferenceBiCollector<A, B, Result_>(mapper, zero, adder, subtractor);
    }

    public static <A, B, Mapped_, Result_ extends Collection<Mapped_>> BiConstraintCollector<A, B, ?, Result_> toCollection(BiFunction<? super A, ? super B, ? extends Mapped_> mapper, IntFunction<Result_> collectionFunction) {
        return new ToCollectionBiCollector<A, B, Mapped_, Result_>(mapper, collectionFunction);
    }

    public static <A, B, Mapped_> BiConstraintCollector<A, B, ?, List<Mapped_>> toList(BiFunction<? super A, ? super B, ? extends Mapped_> mapper) {
        return new ToListBiCollector<A, B, Mapped_>(mapper);
    }

    public static <A, B, Key_, Value_, Set_ extends Set<Value_>, Result_ extends Map<Key_, Set_>> BiConstraintCollector<A, B, ?, Result_> toMap(BiFunction<? super A, ? super B, ? extends Key_> keyFunction, BiFunction<? super A, ? super B, ? extends Value_> valueFunction, Supplier<Result_> mapSupplier, IntFunction<Set_> setFunction) {
        return new ToMultiMapBiCollector<A, B, Key_, Value_, Set_, Result_>(keyFunction, valueFunction, mapSupplier, setFunction);
    }

    public static <A, B, Key_, Value_, Result_ extends Map<Key_, Value_>> BiConstraintCollector<A, B, ?, Result_> toMap(BiFunction<? super A, ? super B, ? extends Key_> keyFunction, BiFunction<? super A, ? super B, ? extends Value_> valueFunction, Supplier<Result_> mapSupplier, BinaryOperator<Value_> mergeFunction) {
        return new ToSimpleMapBiCollector<A, B, Key_, Value_, Result_>(keyFunction, valueFunction, mapSupplier, mergeFunction);
    }

    public static <A, B, Mapped_> BiConstraintCollector<A, B, ?, Set<Mapped_>> toSet(BiFunction<? super A, ? super B, ? extends Mapped_> mapper) {
        return new ToSetBiCollector<A, B, Mapped_>(mapper);
    }

    public static <A, B, Mapped_> BiConstraintCollector<A, B, ?, SortedSet<Mapped_>> toSortedSet(BiFunction<? super A, ? super B, ? extends Mapped_> mapper, Comparator<? super Mapped_> comparator) {
        return new ToSortedSetComparatorBiCollector<A, B, Mapped_>(mapper, comparator);
    }

    public static <A, B, Result_> BiConstraintCollector<A, B, ?, SequenceChain<Result_, Integer>> toConsecutiveSequences(BiFunction<A, B, Result_> resultMap, ToIntFunction<Result_> indexMap) {
        return new ConsecutiveSequencesBiConstraintCollector<A, B, Result_>(resultMap, indexMap);
    }

    public static <A, B, Interval_, Point_ extends Comparable<Point_>, Difference_ extends Comparable<Difference_>> BiConstraintCollector<A, B, ?, ConnectedRangeChain<Interval_, Point_, Difference_>> toConnectedRanges(BiFunction<? super A, ? super B, ? extends Interval_> mapper, Function<? super Interval_, ? extends Point_> startMap, Function<? super Interval_, ? extends Point_> endMap, BiFunction<? super Point_, ? super Point_, ? extends Difference_> differenceFunction) {
        return new ConnectedRangesBiConstraintCollector<A, B, Interval_, Point_, Difference_>(mapper, startMap, endMap, differenceFunction);
    }

    public static <A, B, Intermediate_, Result_> BiConstraintCollector<A, B, ?, Result_> collectAndThen(BiConstraintCollector<A, B, ?, Intermediate_> delegate, Function<Intermediate_, Result_> mappingFunction) {
        return new AndThenBiCollector(delegate, mappingFunction);
    }

    public static <A, B, Balanced_> BiConstraintCollector<A, B, ?, LoadBalance<Balanced_>> loadBalance(BiFunction<A, B, Balanced_> balancedItemFunction, ToLongBiFunction<A, B> loadFunction, ToLongBiFunction<A, B> initialLoadFunction) {
        return new LoadBalanceBiCollector<A, B, Balanced_>(balancedItemFunction, loadFunction, initialLoadFunction);
    }
}

