/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.move.streams.dataset;

import ai.timefold.solver.core.impl.bavet.common.tuple.AbstractTuple;
import ai.timefold.solver.core.impl.bavet.common.tuple.TupleLifecycle;
import ai.timefold.solver.core.impl.move.streams.dataset.AbstractDataset;
import ai.timefold.solver.core.impl.util.ElementAwareList;
import ai.timefold.solver.core.impl.util.ElementAwareListEntry;
import java.util.Iterator;
import java.util.Objects;
import java.util.Random;

public final class DatasetInstance<Solution_, Tuple_ extends AbstractTuple>
implements TupleLifecycle<Tuple_> {
    private final AbstractDataset<Solution_, Tuple_> parent;
    private final int inputStoreIndex;
    private final ElementAwareList<Tuple_> tupleList = new ElementAwareList();

    public DatasetInstance(AbstractDataset<Solution_, Tuple_> parent, int inputStoreIndex) {
        this.parent = Objects.requireNonNull(parent);
        this.inputStoreIndex = inputStoreIndex;
    }

    public AbstractDataset<Solution_, Tuple_> getParent() {
        return this.parent;
    }

    @Override
    public void insert(Tuple_ tuple) {
        ElementAwareListEntry<Tuple_> entry = this.tupleList.add(tuple);
        ((AbstractTuple)tuple).setStore(this.inputStoreIndex, entry);
    }

    @Override
    public void update(Tuple_ tuple) {
    }

    @Override
    public void retract(Tuple_ tuple) {
        ElementAwareListEntry entry = (ElementAwareListEntry)((AbstractTuple)tuple).removeStore(this.inputStoreIndex);
        entry.remove();
    }

    public Iterator<Tuple_> iterator() {
        return this.tupleList.iterator();
    }

    public Iterator<Tuple_> iterator(Random workingRandom) {
        return this.tupleList.randomizedIterator(workingRandom);
    }
}

