/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.move.streams.dataset;

import ai.timefold.solver.core.impl.bavet.common.tuple.AbstractTuple;
import ai.timefold.solver.core.impl.move.streams.dataset.AbstractDataStream;
import ai.timefold.solver.core.impl.move.streams.dataset.DataStreamFactory;
import ai.timefold.solver.core.impl.move.streams.dataset.DatasetInstance;
import java.util.Objects;
import java.util.Set;

public abstract class AbstractDataset<Solution_, Tuple_ extends AbstractTuple> {
    private final DataStreamFactory<Solution_> dataStreamFactory;
    private final AbstractDataStream<Solution_> parent;

    protected AbstractDataset(DataStreamFactory<Solution_> dataStreamFactory, AbstractDataStream<Solution_> parent) {
        this.dataStreamFactory = Objects.requireNonNull(dataStreamFactory);
        this.parent = Objects.requireNonNull(parent);
    }

    public void collectActiveDataStreams(Set<AbstractDataStream<Solution_>> dataStreamSet) {
        this.parent.collectActiveDataStreams(dataStreamSet);
    }

    public DatasetInstance<Solution_, Tuple_> instantiate(int storeIndex) {
        return new DatasetInstance(this, storeIndex);
    }

    public boolean equals(Object entity) {
        if (!(entity instanceof AbstractDataset)) {
            return false;
        }
        AbstractDataset dataset = (AbstractDataset)entity;
        return Objects.equals(this.dataStreamFactory, dataset.dataStreamFactory) && Objects.equals(this.parent, dataset.parent);
    }

    public int hashCode() {
        return Objects.hash(this.dataStreamFactory, this.parent);
    }

    public String toString() {
        return "%s for %s".formatted(this.getClass().getSimpleName(), this.parent);
    }
}

