/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.move.streams;

import ai.timefold.solver.core.impl.bavet.common.tuple.UniTuple;
import ai.timefold.solver.core.impl.move.streams.DefaultMoveStreamSession;
import ai.timefold.solver.core.impl.move.streams.InnerMoveProducer;
import ai.timefold.solver.core.impl.move.streams.MoveIterable;
import ai.timefold.solver.core.impl.move.streams.dataset.AbstractDataStream;
import ai.timefold.solver.core.impl.move.streams.dataset.AbstractDataset;
import ai.timefold.solver.core.impl.move.streams.dataset.DatasetInstance;
import ai.timefold.solver.core.impl.move.streams.maybeapi.stream.BiMoveConstructor;
import ai.timefold.solver.core.impl.move.streams.maybeapi.stream.MoveStreamSession;
import ai.timefold.solver.core.preview.api.move.Move;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class BiMoveProducer<Solution_, A, B>
implements InnerMoveProducer<Solution_> {
    private final AbstractDataset<Solution_, UniTuple<A>> aDataset;
    private final AbstractDataset<Solution_, UniTuple<B>> bDataset;
    private final BiMoveConstructor<Solution_, A, B> moveConstructor;
    private final BiPredicate<A, B> filter;

    public BiMoveProducer(AbstractDataset<Solution_, UniTuple<A>> aDataset, AbstractDataset<Solution_, UniTuple<B>> bDataset, BiPredicate<A, B> filter, BiMoveConstructor<Solution_, A, B> moveConstructor) {
        this.aDataset = Objects.requireNonNull(aDataset);
        this.bDataset = Objects.requireNonNull(bDataset);
        this.filter = Objects.requireNonNull(filter);
        this.moveConstructor = Objects.requireNonNull(moveConstructor);
    }

    @Override
    public MoveIterable<Solution_> getMoveIterable(MoveStreamSession<Solution_> moveStreamSession) {
        return new BiMoveIterable((DefaultMoveStreamSession)moveStreamSession);
    }

    @Override
    public void collectActiveDataStreams(Set<AbstractDataStream<Solution_>> activeDataStreamSet) {
        this.aDataset.collectActiveDataStreams(activeDataStreamSet);
        this.bDataset.collectActiveDataStreams(activeDataStreamSet);
    }

    private final class BiMoveIterable
    implements MoveIterable<Solution_> {
        private final DefaultMoveStreamSession<Solution_> moveStreamSession;

        public BiMoveIterable(DefaultMoveStreamSession<Solution_> moveStreamSession) {
            this.moveStreamSession = Objects.requireNonNull(moveStreamSession);
        }

        @Override
        public Iterator<Move<Solution_>> iterator() {
            return new BiMoveIterator(this.moveStreamSession);
        }

        @Override
        public Iterator<Move<Solution_>> iterator(Random random) {
            return new BiMoveIterator(this.moveStreamSession, random);
        }
    }

    private final class BiMoveIterator
    implements Iterator<Move<Solution_>> {
        private final IteratorSupplier<A> aIteratorSupplier;
        private final IteratorSupplier<B> bIteratorSupplier;
        private final Solution_ solution;
        private @Nullable Move<Solution_> nextMove;
        private @Nullable Iterator<UniTuple<A>> aIterator;
        private @Nullable Iterator<UniTuple<B>> bIterator;
        private @Nullable A currentA;

        public BiMoveIterator(DefaultMoveStreamSession<Solution_> moveStreamSession) {
            DatasetInstance aInstance = moveStreamSession.getDatasetInstance(BiMoveProducer.this.aDataset);
            this.aIteratorSupplier = aInstance::iterator;
            DatasetInstance bInstance = moveStreamSession.getDatasetInstance(BiMoveProducer.this.bDataset);
            this.bIteratorSupplier = bInstance::iterator;
            this.solution = moveStreamSession.getWorkingSolution();
        }

        public BiMoveIterator(DefaultMoveStreamSession<Solution_> moveStreamSession, Random random) {
            DatasetInstance aInstance = moveStreamSession.getDatasetInstance(BiMoveProducer.this.aDataset);
            this.aIteratorSupplier = () -> aInstance.iterator(random);
            DatasetInstance bInstance = moveStreamSession.getDatasetInstance(BiMoveProducer.this.bDataset);
            this.bIteratorSupplier = () -> bInstance.iterator(random);
            this.solution = moveStreamSession.getWorkingSolution();
        }

        @Override
        public boolean hasNext() {
            if (this.nextMove != null) {
                return true;
            }
            if (this.aIterator == null) {
                this.aIterator = (Iterator)this.aIteratorSupplier.get();
                if (!this.aIterator.hasNext()) {
                    return false;
                }
                this.currentA = this.aIterator.next().factA;
                this.bIterator = (Iterator)this.bIteratorSupplier.get();
            }
            while (true) {
                if (this.bIterator.hasNext()) {
                    UniTuple bTuple = this.bIterator.next();
                    Object currentB = bTuple.factA;
                    if (!BiMoveProducer.this.filter.test(this.currentA, currentB)) continue;
                    this.nextMove = BiMoveProducer.this.moveConstructor.apply(this.solution, this.currentA, currentB);
                    return true;
                }
                if (!this.aIterator.hasNext()) break;
                this.currentA = this.aIterator.next().factA;
                this.bIterator = (Iterator)this.bIteratorSupplier.get();
            }
            return false;
        }

        @Override
        public Move<Solution_> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Move result = this.nextMove;
            this.nextMove = null;
            return result;
        }

        @FunctionalInterface
        private static interface IteratorSupplier<A>
        extends Supplier<Iterator<UniTuple<A>>> {
        }
    }
}

