/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.value;

import ai.timefold.solver.core.api.domain.valuerange.CountableValueRange;
import ai.timefold.solver.core.api.domain.valuerange.ValueRange;
import ai.timefold.solver.core.config.heuristic.selector.common.SelectionCacheType;
import ai.timefold.solver.core.config.heuristic.selector.common.SelectionOrder;
import ai.timefold.solver.core.impl.domain.valuerange.descriptor.EntityIndependentValueRangeDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.selector.AbstractDemandEnabledSelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.EntityIndependentValueSelector;
import ai.timefold.solver.core.impl.phase.scope.AbstractPhaseScope;
import ai.timefold.solver.core.impl.phase.scope.AbstractStepScope;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import java.util.Iterator;
import java.util.Objects;

public final class FromSolutionPropertyValueSelector<Solution_>
extends AbstractDemandEnabledSelector<Solution_>
implements EntityIndependentValueSelector<Solution_> {
    private final EntityIndependentValueRangeDescriptor<Solution_> valueRangeDescriptor;
    private final SelectionCacheType minimumCacheType;
    private final boolean randomSelection;
    private final boolean valueRangeMightContainEntity;
    private ValueRange<Object> cachedValueRange = null;
    private Long cachedEntityListRevision = null;
    private boolean cachedEntityListIsDirty = false;

    public FromSolutionPropertyValueSelector(EntityIndependentValueRangeDescriptor<Solution_> valueRangeDescriptor, SelectionCacheType minimumCacheType, boolean randomSelection) {
        this.valueRangeDescriptor = valueRangeDescriptor;
        this.minimumCacheType = minimumCacheType;
        this.randomSelection = randomSelection;
        this.valueRangeMightContainEntity = valueRangeDescriptor.mightContainEntity();
    }

    @Override
    public GenuineVariableDescriptor<Solution_> getVariableDescriptor() {
        return this.valueRangeDescriptor.getVariableDescriptor();
    }

    @Override
    public SelectionCacheType getCacheType() {
        SelectionCacheType intrinsicCacheType = this.valueRangeMightContainEntity ? SelectionCacheType.STEP : SelectionCacheType.PHASE;
        return intrinsicCacheType.compareTo(this.minimumCacheType) > 0 ? intrinsicCacheType : this.minimumCacheType;
    }

    @Override
    public void phaseStarted(AbstractPhaseScope<Solution_> phaseScope) {
        super.phaseStarted(phaseScope);
        InnerScoreDirector scoreDirector = phaseScope.getScoreDirector();
        this.cachedValueRange = this.valueRangeDescriptor.extractValueRange(scoreDirector.getWorkingSolution());
        if (this.valueRangeMightContainEntity) {
            this.cachedEntityListRevision = scoreDirector.getWorkingEntityListRevision();
            this.cachedEntityListIsDirty = false;
        }
    }

    @Override
    public void stepStarted(AbstractStepScope<Solution_> stepScope) {
        InnerScoreDirector scoreDirector;
        super.stepStarted(stepScope);
        if (this.valueRangeMightContainEntity && (scoreDirector = stepScope.getScoreDirector()).isWorkingEntityListDirty(this.cachedEntityListRevision)) {
            if (this.minimumCacheType.compareTo(SelectionCacheType.STEP) > 0) {
                this.cachedEntityListIsDirty = true;
            } else {
                this.cachedValueRange = this.valueRangeDescriptor.extractValueRange(scoreDirector.getWorkingSolution());
                this.cachedEntityListRevision = scoreDirector.getWorkingEntityListRevision();
            }
        }
    }

    @Override
    public void phaseEnded(AbstractPhaseScope<Solution_> phaseScope) {
        super.phaseEnded(phaseScope);
        this.cachedValueRange = null;
        if (this.valueRangeMightContainEntity) {
            this.cachedEntityListRevision = null;
            this.cachedEntityListIsDirty = false;
        }
    }

    @Override
    public boolean isCountable() {
        return this.valueRangeDescriptor.isCountable();
    }

    @Override
    public boolean isNeverEnding() {
        return this.randomSelection || !this.isCountable();
    }

    @Override
    public long getSize(Object entity) {
        return this.getSize();
    }

    @Override
    public long getSize() {
        return ((CountableValueRange)this.cachedValueRange).getSize();
    }

    @Override
    public Iterator<Object> iterator(Object entity) {
        return this.iterator();
    }

    @Override
    public Iterator<Object> iterator() {
        this.checkCachedEntityListIsDirty();
        if (this.randomSelection) {
            return this.cachedValueRange.createRandomIterator(this.workingRandom);
        }
        ValueRange<Object> valueRange = this.cachedValueRange;
        if (valueRange instanceof CountableValueRange) {
            CountableValueRange range = (CountableValueRange)valueRange;
            return range.createOriginalIterator();
        }
        throw new IllegalStateException("Value range's class (" + this.cachedValueRange.getClass().getCanonicalName() + ") does not implement " + String.valueOf(CountableValueRange.class) + ", yet selectionOrder is not " + String.valueOf((Object)SelectionOrder.RANDOM) + ".\nMaybe switch selectors' selectionOrder to " + String.valueOf((Object)SelectionOrder.RANDOM) + "?\nMaybe switch selectors' cacheType to " + String.valueOf((Object)SelectionCacheType.JUST_IN_TIME) + "?");
    }

    @Override
    public Iterator<Object> endingIterator(Object entity) {
        return this.endingIterator();
    }

    public Iterator<Object> endingIterator() {
        return ((CountableValueRange)this.cachedValueRange).createOriginalIterator();
    }

    private void checkCachedEntityListIsDirty() {
        if (this.cachedEntityListIsDirty) {
            throw new IllegalStateException("The selector (" + String.valueOf(this) + ") with minimumCacheType (" + String.valueOf((Object)this.minimumCacheType) + ")'s workingEntityList became dirty between steps but is still used afterwards.");
        }
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        FromSolutionPropertyValueSelector that = (FromSolutionPropertyValueSelector)other;
        return this.randomSelection == that.randomSelection && Objects.equals(this.valueRangeDescriptor, that.valueRangeDescriptor) && this.minimumCacheType == that.minimumCacheType;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.valueRangeDescriptor, this.minimumCacheType, this.randomSelection});
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getVariableDescriptor().getVariableName() + ")";
    }
}

