/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.kopt;

import ai.timefold.solver.core.impl.domain.variable.ListVariableStateSupply;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.supply.SupplyManager;
import ai.timefold.solver.core.impl.heuristic.move.Move;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.GenericMoveSelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.ListChangeMoveSelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.kopt.KOptListMoveIterator;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.kopt.KOptUtils;
import ai.timefold.solver.core.impl.heuristic.selector.value.EntityIndependentValueSelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.decorator.FilteringValueSelector;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.commons.math3.util.CombinatoricsUtils;

final class KOptListMoveSelector<Solution_>
extends GenericMoveSelector<Solution_> {
    private final ListVariableDescriptor<Solution_> listVariableDescriptor;
    private final EntityIndependentValueSelector<Solution_> originSelector;
    private final EntityIndependentValueSelector<Solution_> valueSelector;
    private final int minK;
    private final int maxK;
    private final int[] pickedKDistribution;
    private ListVariableStateSupply<Solution_> listVariableStateSupply;

    public KOptListMoveSelector(ListVariableDescriptor<Solution_> listVariableDescriptor, EntityIndependentValueSelector<Solution_> originSelector, EntityIndependentValueSelector<Solution_> valueSelector, int minK, int maxK, int[] pickedKDistribution) {
        this.listVariableDescriptor = listVariableDescriptor;
        this.originSelector = this.createEffectiveValueSelector(originSelector, this::getListVariableStateSupply);
        this.valueSelector = this.createEffectiveValueSelector(valueSelector, this::getListVariableStateSupply);
        this.minK = minK;
        this.maxK = maxK;
        this.pickedKDistribution = pickedKDistribution;
        this.phaseLifecycleSupport.addEventListener(this.originSelector);
        this.phaseLifecycleSupport.addEventListener(this.valueSelector);
    }

    private EntityIndependentValueSelector<Solution_> createEffectiveValueSelector(EntityIndependentValueSelector<Solution_> entityIndependentValueSelector, Supplier<ListVariableStateSupply<Solution_>> listVariableStateSupplier) {
        EntityIndependentValueSelector<Solution_> filteredValueSelector = ListChangeMoveSelector.filterPinnedListPlanningVariableValuesWithIndex(entityIndependentValueSelector, listVariableStateSupplier);
        return FilteringValueSelector.ofAssigned(filteredValueSelector, listVariableStateSupplier);
    }

    private ListVariableStateSupply<Solution_> getListVariableStateSupply() {
        return Objects.requireNonNull(this.listVariableStateSupply, "Impossible state: The listVariableStateSupply is not initialized yet.");
    }

    @Override
    public void solvingStarted(SolverScope<Solution_> solverScope) {
        super.solvingStarted(solverScope);
        SupplyManager supplyManager = solverScope.getScoreDirector().getSupplyManager();
        this.listVariableStateSupply = (ListVariableStateSupply)supplyManager.demand(this.listVariableDescriptor.getStateDemand());
    }

    @Override
    public void solvingEnded(SolverScope<Solution_> solverScope) {
        super.solvingEnded(solverScope);
        this.listVariableStateSupply = null;
    }

    @Override
    public long getSize() {
        long total = 0L;
        long valueSelectorSize = this.valueSelector.getSize();
        int i = this.minK;
        while ((long)i < Math.min(valueSelectorSize, (long)this.maxK)) {
            if (valueSelectorSize > (long)i) {
                long kOptMoveTypes = KOptUtils.getPureKOptMoveTypes(i);
                long edgeChoices = valueSelectorSize <= Integer.MAX_VALUE ? CombinatoricsUtils.binomialCoefficient((int)((int)(valueSelectorSize - 1L)), (int)i) : Long.MAX_VALUE;
                total += kOptMoveTypes * edgeChoices;
            }
            ++i;
        }
        return total;
    }

    @Override
    public Iterator<Move<Solution_>> iterator() {
        return new KOptListMoveIterator<Solution_, Solution_>(this.workingRandom, this.listVariableDescriptor, this.listVariableStateSupply, this.originSelector, this.valueSelector, this.minK, this.maxK, this.pickedKDistribution);
    }

    @Override
    public boolean isCountable() {
        return false;
    }

    @Override
    public boolean isNeverEnding() {
        return true;
    }
}

