/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.variable.declarative;

import ai.timefold.solver.core.impl.domain.variable.declarative.AbstractVariableReferenceGraph;
import ai.timefold.solver.core.impl.domain.variable.declarative.ChangedVariableNotifier;
import ai.timefold.solver.core.impl.domain.variable.declarative.DefaultVariableReferenceGraph;
import ai.timefold.solver.core.impl.domain.variable.declarative.EmptyVariableReferenceGraph;
import ai.timefold.solver.core.impl.domain.variable.declarative.EntityVariablePair;
import ai.timefold.solver.core.impl.domain.variable.declarative.FixedVariableReferenceGraph;
import ai.timefold.solver.core.impl.domain.variable.declarative.GraphChangeType;
import ai.timefold.solver.core.impl.domain.variable.declarative.TopologicalOrderGraph;
import ai.timefold.solver.core.impl.domain.variable.declarative.VariableReferenceGraph;
import ai.timefold.solver.core.impl.domain.variable.declarative.VariableUpdaterInfo;
import ai.timefold.solver.core.preview.api.domain.metamodel.VariableMetaModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.IntFunction;
import org.jspecify.annotations.NonNull;

public final class VariableReferenceGraphBuilder<Solution_> {
    final ChangedVariableNotifier<Solution_> changedVariableNotifier;
    final Map<VariableMetaModel<?, ?, ?>, List<BiConsumer<AbstractVariableReferenceGraph<Solution_, ?>, Object>>> variableReferenceToBeforeProcessor;
    final Map<VariableMetaModel<?, ?, ?>, List<BiConsumer<AbstractVariableReferenceGraph<Solution_, ?>, Object>>> variableReferenceToAfterProcessor;
    final List<EntityVariablePair<Solution_>> instanceList;
    final Map<EntityVariablePair<Solution_>, List<EntityVariablePair<Solution_>>> fixedEdges;
    final Map<VariableMetaModel<?, ?, ?>, Map<Object, EntityVariablePair<Solution_>>> variableReferenceToInstanceMap;
    final Map<Integer, Map<Object, EntityVariablePair<Solution_>>> variableGroupIdToInstanceMap;
    boolean isGraphFixed;

    public VariableReferenceGraphBuilder(ChangedVariableNotifier<Solution_> changedVariableNotifier) {
        this.changedVariableNotifier = changedVariableNotifier;
        this.instanceList = new ArrayList<EntityVariablePair<Solution_>>();
        this.variableReferenceToInstanceMap = new HashMap();
        this.variableGroupIdToInstanceMap = new HashMap<Integer, Map<Object, EntityVariablePair<Solution_>>>();
        this.variableReferenceToBeforeProcessor = new HashMap();
        this.variableReferenceToAfterProcessor = new HashMap();
        this.fixedEdges = new HashMap<EntityVariablePair<Solution_>, List<EntityVariablePair<Solution_>>>();
        this.isGraphFixed = true;
    }

    public <Entity_> void addVariableReferenceEntity(Entity_ entity, List<VariableUpdaterInfo<Solution_>> variableReferences) {
        EntityVariablePair<Solution_> instance;
        int groupId = variableReferences.get(0).groupId();
        Map<Object, EntityVariablePair<Solution_>> instanceMap = this.variableGroupIdToInstanceMap.get(groupId);
        EntityVariablePair<Solution_> entityVariablePair = instance = instanceMap == null ? null : instanceMap.get(entity);
        if (instance != null) {
            return;
        }
        if (instanceMap == null) {
            instanceMap = new IdentityHashMap<Object, EntityVariablePair<Solution_>>();
            this.variableGroupIdToInstanceMap.put(groupId, instanceMap);
        }
        EntityVariablePair<Solution_> node = new EntityVariablePair<Solution_>(entity, variableReferences, this.instanceList.size());
        instanceMap.put(entity, node);
        for (VariableUpdaterInfo<Solution_> variable : variableReferences) {
            Map variableInstanceMap = this.variableReferenceToInstanceMap.computeIfAbsent(variable.id(), ignored -> new IdentityHashMap());
            variableInstanceMap.put(entity, node);
        }
        this.instanceList.add(node);
    }

    public void addFixedEdge(@NonNull EntityVariablePair<Solution_> from, @NonNull EntityVariablePair<Solution_> to) {
        if (from.graphNodeId() == to.graphNodeId()) {
            return;
        }
        this.fixedEdges.computeIfAbsent(from, k -> new ArrayList()).add(to);
    }

    public void addBeforeProcessor(GraphChangeType graphChangeType, VariableMetaModel<?, ?, ?> variableId, BiConsumer<AbstractVariableReferenceGraph<Solution_, ?>, Object> consumer) {
        this.isGraphFixed &= !graphChangeType.affectsGraph();
        this.variableReferenceToBeforeProcessor.computeIfAbsent(variableId, k -> new ArrayList()).add(consumer);
    }

    public void addAfterProcessor(GraphChangeType graphChangeType, VariableMetaModel<?, ?, ?> variableId, BiConsumer<AbstractVariableReferenceGraph<Solution_, ?>, Object> consumer) {
        this.isGraphFixed &= !graphChangeType.affectsGraph();
        this.variableReferenceToAfterProcessor.computeIfAbsent(variableId, k -> new ArrayList()).add(consumer);
    }

    public VariableReferenceGraph build(IntFunction<TopologicalOrderGraph> graphCreator) {
        if (this.instanceList.isEmpty()) {
            return EmptyVariableReferenceGraph.INSTANCE;
        }
        if (this.isGraphFixed) {
            return new FixedVariableReferenceGraph(this, graphCreator);
        }
        return new DefaultVariableReferenceGraph(this, graphCreator);
    }

    public @NonNull EntityVariablePair<Solution_> lookupOrError(VariableMetaModel<?, ?, ?> variableId, Object entity) {
        EntityVariablePair out = (EntityVariablePair)this.variableReferenceToInstanceMap.getOrDefault(variableId, Collections.emptyMap()).get(entity);
        if (out == null) {
            throw new IllegalArgumentException();
        }
        return out;
    }
}

