/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.variable.declarative;

import ai.timefold.solver.core.impl.domain.variable.declarative.ChangedVariableNotifier;
import ai.timefold.solver.core.impl.domain.variable.declarative.DeclarativeShadowVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.declarative.RootVariableSource;
import ai.timefold.solver.core.impl.domain.variable.declarative.ShadowVariableLoopedVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.declarative.TopologicalSorter;
import ai.timefold.solver.core.impl.domain.variable.declarative.VariableReferenceGraph;
import ai.timefold.solver.core.impl.domain.variable.declarative.VariableSourceReference;
import ai.timefold.solver.core.impl.domain.variable.declarative.VariableUpdaterInfo;
import ai.timefold.solver.core.preview.api.domain.metamodel.VariableMetaModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.UnaryOperator;

public final class SingleDirectionalParentVariableReferenceGraph<Solution_>
implements VariableReferenceGraph {
    private final Set<VariableMetaModel<?, ?, ?>> monitoredSourceVariableSet;
    private final VariableUpdaterInfo<Solution_>[] sortedVariableUpdaterInfos;
    private final UnaryOperator<Object> successorFunction;
    private final Comparator<Object> topologicalOrderComparator;
    private final UnaryOperator<Object> keyFunction;
    private final ChangedVariableNotifier<Solution_> changedVariableNotifier;
    private final List<Object> changedEntities;
    private final Class<?> monitoredEntityClass;
    private boolean isUpdating;

    public SingleDirectionalParentVariableReferenceGraph(List<DeclarativeShadowVariableDescriptor<Solution_>> sortedDeclarativeShadowVariableDescriptors, TopologicalSorter topologicalSorter, ChangedVariableNotifier<Solution_> changedVariableNotifier, Object[] entities) {
        this.monitoredEntityClass = sortedDeclarativeShadowVariableDescriptors.get(0).getEntityDescriptor().getEntityClass();
        this.sortedVariableUpdaterInfos = new VariableUpdaterInfo[sortedDeclarativeShadowVariableDescriptors.size()];
        this.monitoredSourceVariableSet = new HashSet();
        this.changedEntities = new ArrayList<Object>();
        this.isUpdating = false;
        this.successorFunction = topologicalSorter.successor();
        this.topologicalOrderComparator = topologicalSorter.comparator();
        this.keyFunction = topologicalSorter.key();
        this.changedVariableNotifier = changedVariableNotifier;
        Object[] shadowEntities = Arrays.stream(entities).filter(this.monitoredEntityClass::isInstance).sorted(this.topologicalOrderComparator).toArray();
        ShadowVariableLoopedVariableDescriptor loopedDescriptor = sortedDeclarativeShadowVariableDescriptors.get(0).getEntityDescriptor().getShadowVariableLoopedDescriptor();
        int updaterIndex = 0;
        for (DeclarativeShadowVariableDescriptor<Solution_> variableDescriptor : sortedDeclarativeShadowVariableDescriptors) {
            VariableMetaModel variableMetaModel = variableDescriptor.getVariableMetaModel();
            VariableUpdaterInfo variableUpdaterInfo = new VariableUpdaterInfo(variableMetaModel, updaterIndex, variableDescriptor, loopedDescriptor, variableDescriptor.getMemberAccessor(), variableDescriptor.getCalculator()::executeGetter);
            this.sortedVariableUpdaterInfos[updaterIndex++] = variableUpdaterInfo;
            for (RootVariableSource<?, ?> source : variableDescriptor.getSources()) {
                for (VariableSourceReference sourceReference : source.variableSourceReferences()) {
                    this.monitoredSourceVariableSet.add(sourceReference.variableMetaModel());
                }
            }
        }
        this.changedEntities.addAll(List.of(shadowEntities));
        this.updateChanged();
        if (loopedDescriptor != null) {
            for (Object shadowEntity : shadowEntities) {
                changedVariableNotifier.beforeVariableChanged().accept(loopedDescriptor, shadowEntity);
                loopedDescriptor.setValue(shadowEntity, false);
                changedVariableNotifier.afterVariableChanged().accept(loopedDescriptor, shadowEntity);
            }
        }
    }

    @Override
    public void updateChanged() {
        this.isUpdating = true;
        this.changedEntities.sort(this.topologicalOrderComparator);
        IdentityHashMap processed = new IdentityHashMap();
        for (Object changedEntity : this.changedEntities) {
            Object key = this.keyFunction.apply(changedEntity);
            Object lastProcessed = processed.get(key);
            if (lastProcessed != null && this.topologicalOrderComparator.compare(lastProcessed, changedEntity) >= 0) continue;
            lastProcessed = this.updateChanged(changedEntity);
            processed.put(key, lastProcessed);
        }
        this.isUpdating = false;
        this.changedEntities.clear();
    }

    private Object updateChanged(Object entity) {
        Object current;
        Object previous = current = entity;
        while (current != null) {
            boolean anyChanged = false;
            for (VariableUpdaterInfo<Solution_> updater : this.sortedVariableUpdaterInfos) {
                Object newValue;
                Object oldValue = updater.memberAccessor().executeGetter(current);
                if (Objects.equals(oldValue, newValue = updater.calculator().apply(current))) continue;
                anyChanged = true;
                this.changedVariableNotifier.beforeVariableChanged().accept(updater.variableDescriptor(), current);
                updater.memberAccessor().executeSetter(current, newValue);
                this.changedVariableNotifier.afterVariableChanged().accept(updater.variableDescriptor(), current);
            }
            if (anyChanged) {
                previous = current;
                current = this.successorFunction.apply(current);
                continue;
            }
            return current;
        }
        return previous;
    }

    @Override
    public void beforeVariableChanged(VariableMetaModel<?, ?, ?> variableReference, Object entity) {
    }

    @Override
    public void afterVariableChanged(VariableMetaModel<?, ?, ?> variableReference, Object entity) {
        if (!this.isUpdating && this.monitoredSourceVariableSet.contains(variableReference) && this.monitoredEntityClass.isInstance(entity)) {
            this.changedEntities.add(entity);
        }
    }
}

