/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.variable;

import ai.timefold.solver.core.api.domain.entity.PlanningEntity;
import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.constraint.ConstraintMatchTotal;
import ai.timefold.solver.core.api.score.constraint.Indictment;
import ai.timefold.solver.core.config.solver.PreviewFeature;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.solution.descriptor.DefaultShadowVariableMetaModel;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.domain.variable.cascade.CascadingUpdateShadowVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.custom.CustomShadowVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.declarative.ChangedVariableNotifier;
import ai.timefold.solver.core.impl.domain.variable.declarative.DefaultShadowVariableSessionFactory;
import ai.timefold.solver.core.impl.domain.variable.declarative.DefaultTopologicalOrderGraph;
import ai.timefold.solver.core.impl.domain.variable.declarative.VariableReferenceGraph;
import ai.timefold.solver.core.impl.domain.variable.declarative.VariableReferenceGraphBuilder;
import ai.timefold.solver.core.impl.domain.variable.descriptor.BasicVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ShadowVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.VariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.index.IndexShadowVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.inverserelation.InverseRelationShadowVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.listener.support.ShadowVariableType;
import ai.timefold.solver.core.impl.domain.variable.listener.support.VariableListenerSupport;
import ai.timefold.solver.core.impl.domain.variable.nextprev.NextElementShadowVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.nextprev.PreviousElementShadowVariableDescriptor;
import ai.timefold.solver.core.impl.score.constraint.ConstraintMatchPolicy;
import ai.timefold.solver.core.impl.score.director.AbstractScoreDirector;
import ai.timefold.solver.core.impl.score.director.AbstractScoreDirectorFactory;
import ai.timefold.solver.core.impl.score.director.InnerScore;
import ai.timefold.solver.core.preview.api.domain.metamodel.PlanningEntityMetaModel;
import ai.timefold.solver.core.preview.api.domain.metamodel.ShadowVariableMetaModel;
import ai.timefold.solver.core.preview.api.domain.metamodel.VariableMetaModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public final class ShadowVariableUpdateHelper<Solution_> {
    private static final EnumSet<ShadowVariableType> SUPPORTED_TYPES = EnumSet.of(ShadowVariableType.BASIC, ShadowVariableType.CUSTOM_LISTENER, ShadowVariableType.CASCADING_UPDATE, ShadowVariableType.DECLARATIVE);
    private final EnumSet<ShadowVariableType> supportedShadowVariableTypes;

    public static <Solution_> ShadowVariableUpdateHelper<Solution_> create() {
        return new ShadowVariableUpdateHelper<Solution_>(SUPPORTED_TYPES);
    }

    static <Solution_> ShadowVariableUpdateHelper<Solution_> create(ShadowVariableType ... supportedTypes) {
        EnumSet<ShadowVariableType> typesSet = EnumSet.noneOf(ShadowVariableType.class);
        typesSet.addAll(Arrays.asList(supportedTypes));
        return new ShadowVariableUpdateHelper<Solution_>(typesSet);
    }

    private ShadowVariableUpdateHelper(EnumSet<ShadowVariableType> supportedShadowVariableTypes) {
        this.supportedShadowVariableTypes = supportedShadowVariableTypes;
    }

    public void updateShadowVariables(Solution_ solution) {
        EnumSet<PreviewFeature> enabledPreviewFeatures = EnumSet.of(PreviewFeature.DECLARATIVE_SHADOW_VARIABLES);
        Class<?> solutionClass = solution.getClass();
        SolutionDescriptor<?> initialSolutionDescriptor = SolutionDescriptor.buildSolutionDescriptor(enabledPreviewFeatures, solutionClass, new Class[0]);
        Class[] entityClassArray = (Class[])initialSolutionDescriptor.getAllEntitiesAndProblemFacts(solution).stream().map(Object::getClass).distinct().toArray(Class[]::new);
        SolutionDescriptor<?> solutionDescriptor = SolutionDescriptor.buildSolutionDescriptor(enabledPreviewFeatures, solutionClass, entityClassArray);
        try (InternalScoreDirector scoreDirector = new InternalScoreDirector(solutionDescriptor);){
            scoreDirector.setWorkingSolution(solution);
            scoreDirector.forceTriggerVariableListeners();
        }
    }

    public void updateShadowVariables(Class<Solution_> solutionClass, Object ... entities) {
        List<Class> entityClassList = Arrays.stream(entities).map(Object::getClass).filter(clazz -> clazz.isAnnotationPresent(PlanningEntity.class)).distinct().toList();
        SolutionDescriptor<Solution_> solutionDescriptor = SolutionDescriptor.buildSolutionDescriptor(EnumSet.of(PreviewFeature.DECLARATIVE_SHADOW_VARIABLES), solutionClass, entityClassList.toArray(new Class[0]));
        List<ShadowVariableDescriptor> customShadowVariableDescriptorList = solutionDescriptor.getAllShadowVariableDescriptors().stream().filter(CustomShadowVariableDescriptor.class::isInstance).toList();
        if (!customShadowVariableDescriptorList.isEmpty()) {
            throw new IllegalArgumentException("Custom shadow variable descriptors are not supported (%s)".formatted(customShadowVariableDescriptorList));
        }
        VariableListenerSupport<Solution_> variableListenerSupport = VariableListenerSupport.create(new InternalScoreDirector(solutionDescriptor));
        List<ShadowVariableType> missingShadowVariableTypeList = variableListenerSupport.getSupportedShadowVariableTypes().stream().filter(type -> !this.supportedShadowVariableTypes.contains(type)).toList();
        if (!missingShadowVariableTypeList.isEmpty()) {
            throw new IllegalStateException("Impossible state: The following shadow variable types are not currently supported (%s).".formatted(missingShadowVariableTypeList));
        }
        InternalShadowVariableSession<Solution_> session = InternalShadowVariableSession.build(solutionDescriptor, new VariableReferenceGraphBuilder(ChangedVariableNotifier.empty()), entities);
        ListVariableDescriptor<Solution_> listVariableDescriptor = solutionDescriptor.getListVariableDescriptor();
        if (listVariableDescriptor == null) {
            session.processBasicVariable(entities);
            session.processChainedVariable(entities);
        } else {
            session.processListVariable(entities);
            session.processCascadingVariable(entities);
        }
        session.processDeclarativeVariables();
    }

    private static class InternalScoreDirector<Solution_, Score_ extends Score<Score_>>
    extends AbstractScoreDirector<Solution_, Score_, InternalScoreDirectorFactory<Solution_, Score_>> {
        public InternalScoreDirector(SolutionDescriptor<Solution_> solutionDescriptor) {
            super(new InternalScoreDirectorFactory(solutionDescriptor), false, ConstraintMatchPolicy.DISABLED, false);
        }

        @Override
        public void setWorkingSolution(Solution_ workingSolution) {
            super.setWorkingSolution(workingSolution, ignore -> {});
        }

        @Override
        public InnerScore<Score_> calculateScore() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, ConstraintMatchTotal<Score_>> getConstraintMatchTotalMap() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<Object, Indictment<Score_>> getIndictmentMap() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean requiresFlushing() {
            throw new UnsupportedOperationException();
        }
    }

    private record InternalShadowVariableSession<Solution_>(SolutionDescriptor<Solution_> solutionDescriptor, VariableReferenceGraph graph) {
        public static <Solution_> InternalShadowVariableSession<Solution_> build(SolutionDescriptor<Solution_> solutionDescriptor, VariableReferenceGraphBuilder<Solution_> graph, Object ... entities) {
            return new InternalShadowVariableSession<Solution_>(solutionDescriptor, DefaultShadowVariableSessionFactory.buildGraph(solutionDescriptor, graph, entities, DefaultTopologicalOrderGraph::new));
        }

        public void processBasicVariable(Object ... entities) {
            IdentityHashMap<Object, ShadowEntityVariable> shadowEntityToUpdate = new IdentityHashMap<Object, ShadowEntityVariable>();
            for (EntityWithDescriptor<Solution_> entityWithDescriptor : this.fetchEntityAndDescriptors(entities)) {
                for (BasicVariableDescriptor<Solution_> variableDescriptor : this.fetchBasicDescriptors(entityWithDescriptor.entityDescriptor(), false)) {
                    Object shadowEntity = variableDescriptor.getValue(entityWithDescriptor.entity());
                    this.addShadowEntity(entityWithDescriptor, variableDescriptor, shadowEntity, shadowEntityToUpdate);
                }
            }
            shadowEntityToUpdate.forEach((key, value) -> this.updateShadowVariable(value.variableName(), key, value.values()));
        }

        private void addShadowEntity(EntityWithDescriptor<Solution_> entityWithDescriptor, BasicVariableDescriptor<Solution_> variableDescriptor, Object shadowEntity, Map<Object, ShadowEntityVariable> shadowEntityToUpdate) {
            InverseRelationShadowVariableDescriptor descriptor = this.findShadowVariableDescriptor(shadowEntity.getClass(), InverseRelationShadowVariableDescriptor.class);
            if (descriptor != null) {
                Collection values = (Collection)descriptor.getValue(shadowEntity);
                if (values == null) {
                    throw new IllegalStateException("The entity (%s) has a variable (%s) with value (%s) which has a sourceVariableName variable (%s) which is null.".formatted(entityWithDescriptor.entity().getClass(), variableDescriptor.getVariableName(), shadowEntity, descriptor.getVariableName()));
                }
                if (!values.contains(entityWithDescriptor.entity())) {
                    values.add(entityWithDescriptor.entity());
                }
                shadowEntityToUpdate.putIfAbsent(shadowEntity, new ShadowEntityVariable(descriptor.getVariableName(), values));
            }
        }

        public void processChainedVariable(Object ... entities) {
            for (EntityWithDescriptor<Solution_> entityWithDescriptor : this.fetchEntityAndDescriptors(entities)) {
                for (BasicVariableDescriptor<Solution_> variableDescriptor : this.fetchBasicDescriptors(entityWithDescriptor.entityDescriptor(), true)) {
                    Object shadowEntity = variableDescriptor.getValue(entityWithDescriptor.entity());
                    if (shadowEntity == null) continue;
                    this.updateShadowVariable(shadowEntity.getClass(), InverseRelationShadowVariableDescriptor.class, shadowEntity, entityWithDescriptor.entity());
                }
            }
        }

        public void processListVariable(Object ... entities) {
            ListVariableDescriptor listVariableDescriptor = this.solutionDescriptor.getListVariableDescriptor();
            List<Object> planningEntityList = Arrays.stream(entities).filter(entity -> listVariableDescriptor.getEntityDescriptor().getEntityClass().equals(entity.getClass())).toList();
            for (Object entity2 : planningEntityList) {
                Object values = listVariableDescriptor.getValue(entity2);
                if (values.isEmpty()) continue;
                Class<?> entityType = values.get(0).getClass();
                for (int i = 0; i < values.size(); ++i) {
                    Object shadowEntity = values.get(i);
                    this.updateShadowVariable(entityType, InverseRelationShadowVariableDescriptor.class, shadowEntity, entity2);
                    Object previousElement = i > 0 ? values.get(i - 1) : null;
                    this.updateShadowVariable(entityType, PreviousElementShadowVariableDescriptor.class, shadowEntity, previousElement);
                    Object nextElement = i < values.size() - 1 ? values.get(i + 1) : null;
                    this.updateShadowVariable(entityType, NextElementShadowVariableDescriptor.class, shadowEntity, nextElement);
                    this.updateShadowVariable(entityType, IndexShadowVariableDescriptor.class, shadowEntity, i);
                }
            }
        }

        public void processCascadingVariable(Object ... entities) {
            ListVariableDescriptor<Solution_> listVariableDescriptor = this.solutionDescriptor.getListVariableDescriptor();
            if (listVariableDescriptor != null) {
                for (Object entity : entities) {
                    CascadingUpdateShadowVariableDescriptor cascadingVariableDescriptor = this.findShadowVariableDescriptor(entity.getClass(), CascadingUpdateShadowVariableDescriptor.class);
                    if (cascadingVariableDescriptor == null) continue;
                    cascadingVariableDescriptor.update(new InternalScoreDirector(this.solutionDescriptor), entity);
                }
            }
        }

        private <T> T findShadowVariableDescriptor(Class<?> entityType, Class<T> descriptorType) {
            PlanningEntityMetaModel valueMetaModel = this.solutionDescriptor.getMetaModel().entities().stream().filter(type -> type.type().equals(entityType)).findFirst().orElse(null);
            if (valueMetaModel == null) {
                return null;
            }
            return valueMetaModel.variables().stream().filter(ShadowVariableMetaModel.class::isInstance).map(DefaultShadowVariableMetaModel.class::cast).map(DefaultShadowVariableMetaModel::variableDescriptor).filter(descriptorType::isInstance).findFirst().orElse(null);
        }

        private void updateShadowVariable(String variableName, Object destination, Object value) {
            VariableDescriptor<Solution_> variableDescriptor = this.solutionDescriptor.getEntityDescriptorStrict(destination.getClass()).getVariableDescriptor(variableName);
            if (this.solutionDescriptor.getDeclarativeShadowVariableDescriptors().isEmpty() && variableDescriptor != null) {
                variableDescriptor.setValue(destination, value);
            } else if (variableDescriptor != null) {
                VariableMetaModel variableMetamodel = this.solutionDescriptor.getMetaModel().entity(destination.getClass()).variable(variableName);
                this.graph.beforeVariableChanged(variableMetamodel, destination);
                variableDescriptor.setValue(destination, value);
                this.graph.afterVariableChanged(variableMetamodel, destination);
            }
        }

        private void updateShadowVariable(Class<?> entityType, Class<? extends ShadowVariableDescriptor> descriptorType, Object destination, Object value) {
            ShadowVariableDescriptor descriptor = this.findShadowVariableDescriptor(entityType, descriptorType);
            if (descriptor != null) {
                this.updateShadowVariable(descriptor.getVariableName(), destination, value);
            }
        }

        public void processDeclarativeVariables() {
            if (!this.solutionDescriptor.getDeclarativeShadowVariableDescriptors().isEmpty()) {
                this.graph.updateChanged();
            }
        }

        private List<EntityWithDescriptor<Solution_>> fetchEntityAndDescriptors(Object ... entities) {
            ArrayList descriptorList = new ArrayList();
            Collection<EntityDescriptor<Solution_>> genuineEntityDescriptorCollection = this.solutionDescriptor.getGenuineEntityDescriptors();
            for (Object entity : entities) {
                genuineEntityDescriptorCollection.stream().filter(variableDescriptor -> variableDescriptor.getEntityClass().equals(entity.getClass())).findFirst().ifPresent(genuineEntityDescriptor -> descriptorList.add(new EntityWithDescriptor(entity, genuineEntityDescriptor)));
            }
            return descriptorList;
        }

        private List<BasicVariableDescriptor<Solution_>> fetchBasicDescriptors(EntityDescriptor<Solution_> entityDescriptor, boolean chained) {
            ArrayList<BasicVariableDescriptor<Solution_>> descriptorList = new ArrayList<BasicVariableDescriptor<Solution_>>();
            for (GenuineVariableDescriptor<Solution_> descriptor : entityDescriptor.getDeclaredGenuineVariableDescriptors()) {
                if (!(descriptor instanceof BasicVariableDescriptor)) continue;
                BasicVariableDescriptor basicVariableDescriptor = (BasicVariableDescriptor)descriptor;
                if ((chained || basicVariableDescriptor.isChained()) && (!chained || !basicVariableDescriptor.isChained())) continue;
                descriptorList.add(basicVariableDescriptor);
            }
            return descriptorList;
        }
    }

    private record EntityWithDescriptor<Solution_>(Object entity, EntityDescriptor<Solution_> entityDescriptor) {
    }

    private record ShadowEntityVariable(String variableName, Collection<Object> values) {
    }

    private static class InternalScoreDirectorFactory<Solution_, Score_ extends Score<Score_>>
    extends AbstractScoreDirectorFactory<Solution_, Score_, InternalScoreDirectorFactory<Solution_, Score_>> {
        public InternalScoreDirectorFactory(SolutionDescriptor<Solution_> solutionDescriptor) {
            super(solutionDescriptor);
        }

        @Override
        public AbstractScoreDirector.AbstractScoreDirectorBuilder<Solution_, Score_, ?, ?> createScoreDirectorBuilder() {
            throw new UnsupportedOperationException();
        }
    }
}

