/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.solution.cloner.gizmo;

import ai.timefold.solver.core.api.domain.solution.cloner.SolutionCloner;
import ai.timefold.solver.core.impl.domain.common.accessor.gizmo.GizmoClassLoader;
import ai.timefold.solver.core.impl.domain.common.accessor.gizmo.GizmoMemberDescriptor;
import ai.timefold.solver.core.impl.domain.solution.cloner.DeepCloningUtils;
import ai.timefold.solver.core.impl.domain.solution.cloner.FieldAccessingSolutionCloner;
import ai.timefold.solver.core.impl.domain.solution.cloner.PlanningCloneable;
import ai.timefold.solver.core.impl.domain.solution.cloner.gizmo.GizmoCloningUtils;
import ai.timefold.solver.core.impl.domain.solution.cloner.gizmo.GizmoSolutionCloner;
import ai.timefold.solver.core.impl.domain.solution.cloner.gizmo.GizmoSolutionClonerFactory;
import ai.timefold.solver.core.impl.domain.solution.cloner.gizmo.GizmoSolutionOrEntityDescriptor;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.util.MutableReference;
import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class GizmoSolutionClonerImplementor {
    private static final MethodDescriptor EQUALS_METHOD = MethodDescriptor.ofMethod(Object.class, (String)"equals", Boolean.TYPE, (Class[])new Class[]{Object.class});
    protected static final MethodDescriptor GET_METHOD = MethodDescriptor.ofMethod(Map.class, (String)"get", Object.class, (Class[])new Class[]{Object.class});
    private static final MethodDescriptor PUT_METHOD = MethodDescriptor.ofMethod(Map.class, (String)"put", Object.class, (Class[])new Class[]{Object.class, Object.class});
    private static final String FALLBACK_CLONER = "fallbackCloner";
    public static final boolean DEBUG = false;

    public static Comparator<Class<?>> getInstanceOfComparator(Set<Class<?>> deepClonedClassSet) {
        HashMap classToSubclassLevel = new HashMap();
        deepClonedClassSet.forEach(clazz -> {
            if (deepClonedClassSet.stream().allMatch(otherClazz -> clazz.isAssignableFrom((Class<?>)otherClazz) || !otherClazz.isAssignableFrom((Class<?>)clazz))) {
                classToSubclassLevel.put((Class<?>)clazz, 0);
            }
        });
        boolean isChanged = true;
        while (isChanged) {
            isChanged = false;
            for (Class<?> clazz2 : deepClonedClassSet) {
                Optional<Integer> maxParentSubclassLevel = classToSubclassLevel.keySet().stream().filter(otherClazz -> otherClazz != clazz2 && otherClazz.isAssignableFrom(clazz2)).map(classToSubclassLevel::get).max(Integer::compare);
                if (!maxParentSubclassLevel.isPresent()) continue;
                Integer oldVal = classToSubclassLevel.getOrDefault(clazz2, -1);
                Integer newVal = maxParentSubclassLevel.get() + 1;
                if (newVal.compareTo(oldVal) <= 0) continue;
                isChanged = true;
                classToSubclassLevel.put(clazz2, newVal);
            }
        }
        return Comparator.comparing(classToSubclassLevel::get).thenComparing(Class::getName).reversed();
    }

    protected void createFields(ClassCreator classCreator) {
        classCreator.getFieldCreator(FALLBACK_CLONER, FieldAccessingSolutionCloner.class).setModifiers(10);
    }

    public static void defineClonerFor(ClassCreator classCreator, SolutionDescriptor<?> solutionDescriptor, Set<Class<?>> solutionClassSet, Map<Class<?>, GizmoSolutionOrEntityDescriptor> memoizedSolutionOrEntityDescriptorMap, Set<Class<?>> deepClonedClassSet) {
        GizmoSolutionClonerImplementor.defineClonerFor(GizmoSolutionClonerImplementor::new, classCreator, solutionDescriptor, solutionClassSet, memoizedSolutionOrEntityDescriptorMap, deepClonedClassSet);
    }

    public static boolean isCloneableClass(Class<?> clazz) {
        return !clazz.isInterface() && !Modifier.isAbstract(clazz.getModifiers());
    }

    public static void defineClonerFor(Supplier<GizmoSolutionClonerImplementor> implementorSupplier, ClassCreator classCreator, SolutionDescriptor<?> solutionDescriptor, Set<Class<?>> solutionClassSet, Map<Class<?>, GizmoSolutionOrEntityDescriptor> memoizedSolutionOrEntityDescriptorMap, Set<Class<?>> deepClonedClassSet) {
        GizmoSolutionClonerImplementor implementor = implementorSupplier.get();
        Set deepCloneClassesThatAreNotSolutionSet = deepClonedClassSet.stream().filter(clazz -> !solutionClassSet.contains(clazz) && !clazz.isArray()).filter(GizmoSolutionClonerImplementor::isCloneableClass).collect(Collectors.toSet());
        Comparator<Class<?>> instanceOfComparator = GizmoSolutionClonerImplementor.getInstanceOfComparator(deepClonedClassSet);
        TreeSet deepCloneClassesThatAreNotSolutionSortedSet = new TreeSet(instanceOfComparator);
        deepCloneClassesThatAreNotSolutionSortedSet.addAll(deepCloneClassesThatAreNotSolutionSet);
        implementor.createFields(classCreator);
        implementor.createConstructor(classCreator);
        implementor.createSetSolutionDescriptor(classCreator, solutionDescriptor);
        implementor.createCloneSolution(classCreator, solutionDescriptor);
        implementor.createCloneSolutionRun(classCreator, solutionDescriptor, solutionClassSet, memoizedSolutionOrEntityDescriptorMap, deepCloneClassesThatAreNotSolutionSortedSet, instanceOfComparator);
        for (Class clazz2 : deepCloneClassesThatAreNotSolutionSortedSet) {
            implementor.createDeepCloneHelperMethod(classCreator, clazz2, solutionDescriptor, memoizedSolutionOrEntityDescriptorMap, deepCloneClassesThatAreNotSolutionSortedSet);
        }
        Set abstractDeepCloneClassSet = deepClonedClassSet.stream().filter(clazz -> !solutionClassSet.contains(clazz) && !clazz.isArray()).filter(Predicate.not(GizmoSolutionClonerImplementor::isCloneableClass)).collect(Collectors.toSet());
        for (Class abstractDeepClonedClass : abstractDeepCloneClassSet) {
            implementor.createAbstractDeepCloneHelperMethod(classCreator, abstractDeepClonedClass, solutionDescriptor, memoizedSolutionOrEntityDescriptorMap, deepCloneClassesThatAreNotSolutionSortedSet);
        }
    }

    public static ClassOutput createClassOutputWithDebuggingCapability(MutableReference<byte[]> classBytecodeHolder) {
        return (path, byteCode) -> classBytecodeHolder.setValue(byteCode);
    }

    static <T> SolutionCloner<T> createClonerFor(SolutionDescriptor<T> solutionDescriptor, GizmoClassLoader gizmoClassLoader) {
        GizmoSolutionClonerImplementor implementor = new GizmoSolutionClonerImplementor();
        String className = GizmoSolutionClonerFactory.getGeneratedClassName(solutionDescriptor);
        if (gizmoClassLoader.hasBytecodeFor(className)) {
            return implementor.createInstance(className, gizmoClassLoader, solutionDescriptor);
        }
        MutableReference<Object> classBytecodeHolder = new MutableReference<Object>(null);
        ClassCreator classCreator = ClassCreator.builder().className(className).interfaces(new Class[]{GizmoSolutionCloner.class}).superClass(Object.class).classOutput(GizmoSolutionClonerImplementor.createClassOutputWithDebuggingCapability(classBytecodeHolder)).setFinal(true).build();
        Set<Class<?>> deepClonedClassSet = GizmoCloningUtils.getDeepClonedClasses(solutionDescriptor, Collections.emptyList());
        GizmoSolutionClonerImplementor.defineClonerFor(() -> implementor, classCreator, solutionDescriptor, Collections.singleton(solutionDescriptor.getSolutionClass()), new HashMap(), deepClonedClassSet);
        classCreator.close();
        byte[] classBytecode = classBytecodeHolder.getValue();
        gizmoClassLoader.storeBytecode(className, classBytecode);
        return implementor.createInstance(className, gizmoClassLoader, solutionDescriptor);
    }

    private <T> SolutionCloner<T> createInstance(String className, ClassLoader gizmoClassLoader, SolutionDescriptor<T> solutionDescriptor) {
        try {
            Class<?> outClass = gizmoClassLoader.loadClass(className);
            GizmoSolutionCloner out = (GizmoSolutionCloner)outClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            out.setSolutionDescriptor(solutionDescriptor);
            return out;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    private void createConstructor(ClassCreator classCreator) {
        MethodCreator methodCreator = classCreator.getMethodCreator(MethodDescriptor.ofConstructor((String)classCreator.getClassName(), (String[])new String[0]));
        ResultHandle thisObj = methodCreator.getThis();
        methodCreator.invokeSpecialMethod(MethodDescriptor.ofConstructor(Object.class, (Class[])new Class[0]), thisObj, new ResultHandle[0]);
        methodCreator.returnValue(thisObj);
    }

    protected void createSetSolutionDescriptor(ClassCreator classCreator, SolutionDescriptor<?> solutionDescriptor) {
        MethodCreator methodCreator = classCreator.getMethodCreator(MethodDescriptor.ofMethod(GizmoSolutionCloner.class, (String)"setSolutionDescriptor", Void.TYPE, (Class[])new Class[]{SolutionDescriptor.class}));
        methodCreator.writeStaticField(FieldDescriptor.of((String)GizmoSolutionClonerFactory.getGeneratedClassName(solutionDescriptor), (String)FALLBACK_CLONER, FieldAccessingSolutionCloner.class), methodCreator.newInstance(MethodDescriptor.ofConstructor(FieldAccessingSolutionCloner.class, (Class[])new Class[]{SolutionDescriptor.class}), new ResultHandle[]{methodCreator.getMethodParam(0)}));
        methodCreator.returnValue(null);
    }

    private void createCloneSolution(ClassCreator classCreator, SolutionDescriptor<?> solutionDescriptor) {
        Class<?> solutionClass = solutionDescriptor.getSolutionClass();
        MethodCreator methodCreator = classCreator.getMethodCreator(MethodDescriptor.ofMethod(SolutionCloner.class, (String)"cloneSolution", Object.class, (Class[])new Class[]{Object.class}));
        ResultHandle thisObj = methodCreator.getMethodParam(0);
        ResultHandle clone = methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod((Object)GizmoSolutionClonerFactory.getGeneratedClassName(solutionDescriptor), (String)"cloneSolutionRun", solutionClass, (Object[])new Object[]{solutionClass, Map.class}), new ResultHandle[]{thisObj, methodCreator.newInstance(MethodDescriptor.ofConstructor(IdentityHashMap.class, (Class[])new Class[0]), new ResultHandle[0])});
        methodCreator.returnValue(clone);
    }

    private void createCloneSolutionRun(ClassCreator classCreator, SolutionDescriptor<?> solutionDescriptor, Set<Class<?>> solutionClassSet, Map<Class<?>, GizmoSolutionOrEntityDescriptor> memoizedSolutionOrEntityDescriptorMap, SortedSet<Class<?>> deepClonedClassesSortedSet, Comparator<Class<?>> instanceOfComparator) {
        Class<?> solutionClass = solutionDescriptor.getSolutionClass();
        MethodCreator methodCreator = classCreator.getMethodCreator("cloneSolutionRun", solutionClass, new Class[]{solutionClass, Map.class});
        methodCreator.setModifiers(10);
        ResultHandle thisObj = methodCreator.getMethodParam(0);
        BranchResult solutionNullBranchResult = methodCreator.ifNull(thisObj);
        BytecodeCreator solutionIsNullBranch = solutionNullBranchResult.trueBranch();
        solutionIsNullBranch.returnValue(thisObj);
        BytecodeCreator solutionIsNotNullBranch = solutionNullBranchResult.falseBranch();
        ResultHandle createdCloneMap = methodCreator.getMethodParam(1);
        ResultHandle maybeClone = solutionIsNotNullBranch.invokeInterfaceMethod(GET_METHOD, createdCloneMap, new ResultHandle[]{thisObj});
        BranchResult hasCloneBranchResult = solutionIsNotNullBranch.ifNotNull(maybeClone);
        BytecodeCreator hasCloneBranch = hasCloneBranchResult.trueBranch();
        hasCloneBranch.returnValue(maybeClone);
        BytecodeCreator noCloneBranch = hasCloneBranchResult.falseBranch();
        ArrayList sortedSolutionClassList = new ArrayList(solutionClassSet);
        sortedSolutionClassList.sort(instanceOfComparator);
        BytecodeCreator currentBranch = noCloneBranch;
        ResultHandle thisObjClass = currentBranch.invokeVirtualMethod(MethodDescriptor.ofMethod(Object.class, (String)"getClass", Class.class, (Class[])new Class[0]), thisObj, new ResultHandle[0]);
        for (Class clazz : sortedSolutionClassList) {
            ResultHandle clone;
            ResultHandle solutionSubclassResultHandle = currentBranch.loadClass(clazz);
            ResultHandle isSubclass = currentBranch.invokeVirtualMethod(EQUALS_METHOD, solutionSubclassResultHandle, new ResultHandle[]{thisObjClass});
            BranchResult isSubclassBranchResult = currentBranch.ifTrue(isSubclass);
            BytecodeCreator isSubclassBranch = isSubclassBranchResult.trueBranch();
            GizmoSolutionOrEntityDescriptor solutionSubclassDescriptor = memoizedSolutionOrEntityDescriptorMap.computeIfAbsent(clazz, key -> new GizmoSolutionOrEntityDescriptor(solutionDescriptor, solutionSubclass));
            if (PlanningCloneable.class.isAssignableFrom(clazz)) {
                clone = isSubclassBranch.invokeInterfaceMethod(MethodDescriptor.ofMethod(PlanningCloneable.class, (String)"createNewInstance", Object.class, (Class[])new Class[0]), thisObj, new ResultHandle[0]);
                clone = isSubclassBranch.checkCast(clone, clazz);
            } else {
                clone = isSubclassBranch.newInstance(MethodDescriptor.ofConstructor((Class)clazz, (Class[])new Class[0]), new ResultHandle[0]);
            }
            isSubclassBranch.invokeInterfaceMethod(MethodDescriptor.ofMethod(Map.class, (String)"put", Object.class, (Class[])new Class[]{Object.class, Object.class}), createdCloneMap, new ResultHandle[]{thisObj, clone});
            for (GizmoMemberDescriptor shallowlyClonedField : solutionSubclassDescriptor.getShallowClonedMemberDescriptors()) {
                this.writeShallowCloneInstructions(solutionSubclassDescriptor, isSubclassBranch, shallowlyClonedField, thisObj, clone, createdCloneMap, deepClonedClassesSortedSet);
            }
            for (Field deeplyClonedField : solutionSubclassDescriptor.getDeepClonedFields()) {
                GizmoMemberDescriptor gizmoMemberDescriptor = solutionSubclassDescriptor.getMemberDescriptorForField(deeplyClonedField);
                ResultHandle fieldValue = gizmoMemberDescriptor.readMemberValue(isSubclassBranch, thisObj);
                AssignableResultHandle cloneValue = isSubclassBranch.createVariable(deeplyClonedField.getType());
                this.writeDeepCloneInstructions(isSubclassBranch, solutionSubclassDescriptor, deeplyClonedField, gizmoMemberDescriptor, fieldValue, cloneValue, createdCloneMap, deepClonedClassesSortedSet);
                if (gizmoMemberDescriptor.writeMemberValue(isSubclassBranch, clone, (ResultHandle)cloneValue)) continue;
                throw new IllegalStateException("The member (" + gizmoMemberDescriptor.getName() + ") of class (" + gizmoMemberDescriptor.getDeclaringClassName() + ") does not have a setter.");
            }
            isSubclassBranch.returnValue(clone);
            currentBranch = isSubclassBranchResult.falseBranch();
        }
        ResultHandle errorBuilder = currentBranch.newInstance(MethodDescriptor.ofConstructor(StringBuilder.class, (Class[])new Class[]{String.class}), new ResultHandle[]{currentBranch.load("Failed to create clone: encountered (")});
        MethodDescriptor methodDescriptor = MethodDescriptor.ofMethod(StringBuilder.class, (String)"append", StringBuilder.class, (Class[])new Class[]{Object.class});
        currentBranch.invokeVirtualMethod(methodDescriptor, errorBuilder, new ResultHandle[]{thisObjClass});
        currentBranch.invokeVirtualMethod(methodDescriptor, errorBuilder, new ResultHandle[]{currentBranch.load(") which is not a known subclass of the solution class (" + String.valueOf(solutionDescriptor.getSolutionClass()) + "). The known subclasses are " + solutionClassSet.stream().map(Class::getName).collect(Collectors.joining(", ", "[", "]")) + ".\nMaybe use DomainAccessType.REFLECTION?")});
        ResultHandle errorMsg = currentBranch.invokeVirtualMethod(MethodDescriptor.ofMethod(Object.class, (String)"toString", String.class, (Class[])new Class[0]), errorBuilder, new ResultHandle[0]);
        ResultHandle error = currentBranch.newInstance(MethodDescriptor.ofConstructor(IllegalArgumentException.class, (Class[])new Class[]{String.class}), new ResultHandle[]{errorMsg});
        currentBranch.throwException(error);
    }

    private void writeShallowCloneInstructions(GizmoSolutionOrEntityDescriptor solutionInfo, BytecodeCreator methodCreator, GizmoMemberDescriptor shallowlyClonedField, ResultHandle thisObj, ResultHandle clone, ResultHandle createdCloneMap, SortedSet<Class<?>> deepClonedClassesSortedSet) {
        try {
            boolean isArray = shallowlyClonedField.getTypeName().endsWith("[]");
            Class<?> type = null;
            if (shallowlyClonedField.getType() instanceof Class) {
                type = (Class<?>)shallowlyClonedField.getType();
            }
            List<Object> entitySubclasses = Collections.emptyList();
            if (type == null && !isArray) {
                type = Class.forName(shallowlyClonedField.getTypeName().replace('/', '.'), false, Thread.currentThread().getContextClassLoader());
            }
            if (type != null && !isArray) {
                entitySubclasses = deepClonedClassesSortedSet.stream().filter(type::isAssignableFrom).toList();
            }
            ResultHandle fieldValue = shallowlyClonedField.readMemberValue(methodCreator, thisObj);
            if (!entitySubclasses.isEmpty()) {
                AssignableResultHandle cloneResultHolder = methodCreator.createVariable(type);
                this.writeDeepCloneEntityOrFactInstructions(methodCreator, solutionInfo, type, fieldValue, cloneResultHolder, createdCloneMap, deepClonedClassesSortedSet, UnhandledCloneType.SHALLOW);
                fieldValue = cloneResultHolder;
            }
            if (!shallowlyClonedField.writeMemberValue(methodCreator, clone, fieldValue)) {
                throw new IllegalStateException("Field (" + shallowlyClonedField.getName() + ") of class (" + shallowlyClonedField.getDeclaringClassName() + ") does not have a setter.");
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Error creating Gizmo Solution Cloner", e);
        }
    }

    private void writeDeepCloneInstructions(BytecodeCreator bytecodeCreator, GizmoSolutionOrEntityDescriptor solutionDescriptor, Field deeplyClonedField, GizmoMemberDescriptor gizmoMemberDescriptor, ResultHandle toClone, AssignableResultHandle cloneResultHolder, ResultHandle createdCloneMap, SortedSet<Class<?>> deepClonedClassesSortedSet) {
        BranchResult isNull = bytecodeCreator.ifNull(toClone);
        BytecodeCreator isNullBranch = isNull.trueBranch();
        isNullBranch.assign(cloneResultHolder, isNullBranch.loadNull());
        BytecodeCreator isNotNullBranch = isNull.falseBranch();
        Class<?> deeplyClonedFieldClass = deeplyClonedField.getType();
        Type type = gizmoMemberDescriptor.getType();
        if (solutionDescriptor.getSolutionDescriptor().getSolutionClass().isAssignableFrom(deeplyClonedFieldClass)) {
            this.writeDeepCloneSolutionInstructions(bytecodeCreator, solutionDescriptor, toClone, cloneResultHolder, createdCloneMap);
        } else if (Collection.class.isAssignableFrom(deeplyClonedFieldClass)) {
            this.writeDeepCloneCollectionInstructions(isNotNullBranch, solutionDescriptor, deeplyClonedFieldClass, type, toClone, cloneResultHolder, createdCloneMap, deepClonedClassesSortedSet);
        } else if (Map.class.isAssignableFrom(deeplyClonedFieldClass)) {
            this.writeDeepCloneMapInstructions(isNotNullBranch, solutionDescriptor, deeplyClonedFieldClass, type, toClone, cloneResultHolder, createdCloneMap, deepClonedClassesSortedSet);
        } else if (deeplyClonedFieldClass.isArray()) {
            this.writeDeepCloneArrayInstructions(isNotNullBranch, solutionDescriptor, deeplyClonedFieldClass, toClone, cloneResultHolder, createdCloneMap, deepClonedClassesSortedSet);
        } else {
            UnhandledCloneType unknownClassCloneType = DeepCloningUtils.isFieldDeepCloned(solutionDescriptor.solutionDescriptor, deeplyClonedField, deeplyClonedField.getDeclaringClass()) ? UnhandledCloneType.DEEP : UnhandledCloneType.SHALLOW;
            this.writeDeepCloneEntityOrFactInstructions(isNotNullBranch, solutionDescriptor, deeplyClonedFieldClass, toClone, cloneResultHolder, createdCloneMap, deepClonedClassesSortedSet, unknownClassCloneType);
        }
    }

    private void writeDeepCloneInstructions(BytecodeCreator bytecodeCreator, GizmoSolutionOrEntityDescriptor solutionDescriptor, Class<?> deeplyClonedFieldClass, Type type, ResultHandle toClone, AssignableResultHandle cloneResultHolder, ResultHandle createdCloneMap, SortedSet<Class<?>> deepClonedClassesSortedSet) {
        BranchResult isNull = bytecodeCreator.ifNull(toClone);
        BytecodeCreator isNullBranch = isNull.trueBranch();
        isNullBranch.assign(cloneResultHolder, isNullBranch.loadNull());
        BytecodeCreator isNotNullBranch = isNull.falseBranch();
        if (solutionDescriptor.getSolutionDescriptor().getSolutionClass().isAssignableFrom(deeplyClonedFieldClass)) {
            this.writeDeepCloneSolutionInstructions(bytecodeCreator, solutionDescriptor, toClone, cloneResultHolder, createdCloneMap);
        } else if (Collection.class.isAssignableFrom(deeplyClonedFieldClass)) {
            this.writeDeepCloneCollectionInstructions(isNotNullBranch, solutionDescriptor, deeplyClonedFieldClass, type, toClone, cloneResultHolder, createdCloneMap, deepClonedClassesSortedSet);
        } else if (Map.class.isAssignableFrom(deeplyClonedFieldClass)) {
            this.writeDeepCloneMapInstructions(isNotNullBranch, solutionDescriptor, deeplyClonedFieldClass, type, toClone, cloneResultHolder, createdCloneMap, deepClonedClassesSortedSet);
        } else if (deeplyClonedFieldClass.isArray()) {
            this.writeDeepCloneArrayInstructions(isNotNullBranch, solutionDescriptor, deeplyClonedFieldClass, toClone, cloneResultHolder, createdCloneMap, deepClonedClassesSortedSet);
        } else {
            UnhandledCloneType unknownClassCloneType = DeepCloningUtils.isClassDeepCloned(solutionDescriptor.solutionDescriptor, deeplyClonedFieldClass) ? UnhandledCloneType.DEEP : UnhandledCloneType.SHALLOW;
            this.writeDeepCloneEntityOrFactInstructions(isNotNullBranch, solutionDescriptor, deeplyClonedFieldClass, toClone, cloneResultHolder, createdCloneMap, deepClonedClassesSortedSet, unknownClassCloneType);
        }
    }

    private void writeDeepCloneSolutionInstructions(BytecodeCreator bytecodeCreator, GizmoSolutionOrEntityDescriptor solutionDescriptor, ResultHandle toClone, AssignableResultHandle cloneResultHolder, ResultHandle createdCloneMap) {
        BranchResult isNull = bytecodeCreator.ifNull(toClone);
        BytecodeCreator isNullBranch = isNull.trueBranch();
        isNullBranch.assign(cloneResultHolder, isNullBranch.loadNull());
        BytecodeCreator isNotNullBranch = isNull.falseBranch();
        ResultHandle clone = isNotNullBranch.invokeStaticMethod(MethodDescriptor.ofMethod((Object)GizmoSolutionClonerFactory.getGeneratedClassName(solutionDescriptor.getSolutionDescriptor()), (String)"cloneSolutionRun", solutionDescriptor.getSolutionDescriptor().getSolutionClass(), (Object[])new Object[]{solutionDescriptor.getSolutionDescriptor().getSolutionClass(), Map.class}), new ResultHandle[]{toClone, createdCloneMap});
        isNotNullBranch.assign(cloneResultHolder, clone);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeDeepCloneCollectionInstructions(BytecodeCreator bytecodeCreator, GizmoSolutionOrEntityDescriptor solutionDescriptor, Class<?> deeplyClonedFieldClass, Type type, ResultHandle toClone, AssignableResultHandle cloneResultHolder, ResultHandle createdCloneMap, SortedSet<Class<?>> deepClonedClassesSortedSet) {
        Class elementClass;
        AssignableResultHandle cloneCollection = bytecodeCreator.createVariable(deeplyClonedFieldClass);
        ResultHandle size = bytecodeCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Collection.class, (String)"size", Integer.TYPE, (Class[])new Class[0]), toClone, new ResultHandle[0]);
        if (PlanningCloneable.class.isAssignableFrom(deeplyClonedFieldClass)) {
            ResultHandle emptyInstance = bytecodeCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(PlanningCloneable.class, (String)"createNewInstance", Object.class, (Class[])new Class[0]), bytecodeCreator.checkCast(toClone, PlanningCloneable.class), new ResultHandle[0]);
            bytecodeCreator.assign(cloneCollection, bytecodeCreator.checkCast(emptyInstance, Collection.class));
        } else if (List.class.isAssignableFrom(deeplyClonedFieldClass)) {
            bytecodeCreator.assign(cloneCollection, bytecodeCreator.newInstance(MethodDescriptor.ofConstructor(ArrayList.class, (Class[])new Class[]{Integer.TYPE}), new ResultHandle[]{size}));
        } else if (Set.class.isAssignableFrom(deeplyClonedFieldClass)) {
            ResultHandle isSortedSet = bytecodeCreator.instanceOf(toClone, SortedSet.class);
            BranchResult isSortedSetBranchResult = bytecodeCreator.ifTrue(isSortedSet);
            BytecodeCreator isSortedSetBranch = isSortedSetBranchResult.trueBranch();
            ResultHandle setComparator = isSortedSetBranch.invokeInterfaceMethod(MethodDescriptor.ofMethod(SortedSet.class, (String)"comparator", Comparator.class, (Class[])new Class[0]), toClone, new ResultHandle[0]);
            isSortedSetBranch.assign(cloneCollection, isSortedSetBranch.newInstance(MethodDescriptor.ofConstructor(TreeSet.class, (Class[])new Class[]{Comparator.class}), new ResultHandle[]{setComparator}));
            BytecodeCreator isNotSortedSetBranch = isSortedSetBranchResult.falseBranch();
            isNotSortedSetBranch.assign(cloneCollection, isNotSortedSetBranch.newInstance(MethodDescriptor.ofConstructor(LinkedHashSet.class, (Class[])new Class[]{Integer.TYPE}), new ResultHandle[]{size}));
        } else {
            ResultHandle isSet = bytecodeCreator.instanceOf(toClone, Set.class);
            BranchResult isSetBranchResult = bytecodeCreator.ifTrue(isSet);
            BytecodeCreator isSetBranch = isSetBranchResult.trueBranch();
            ResultHandle isSortedSet = isSetBranch.instanceOf(toClone, SortedSet.class);
            BranchResult isSortedSetBranchResult = isSetBranch.ifTrue(isSortedSet);
            BytecodeCreator isSortedSetBranch = isSortedSetBranchResult.trueBranch();
            ResultHandle setComparator = isSortedSetBranch.invokeInterfaceMethod(MethodDescriptor.ofMethod(SortedSet.class, (String)"comparator", Comparator.class, (Class[])new Class[0]), toClone, new ResultHandle[0]);
            isSortedSetBranch.assign(cloneCollection, isSortedSetBranch.newInstance(MethodDescriptor.ofConstructor(TreeSet.class, (Class[])new Class[]{Comparator.class}), new ResultHandle[]{setComparator}));
            BytecodeCreator isNotSortedSetBranch = isSortedSetBranchResult.falseBranch();
            isNotSortedSetBranch.assign(cloneCollection, isNotSortedSetBranch.newInstance(MethodDescriptor.ofConstructor(LinkedHashSet.class, (Class[])new Class[]{Integer.TYPE}), new ResultHandle[]{size}));
            BytecodeCreator isNotSetBranch = isSetBranchResult.falseBranch();
            isNotSetBranch.assign(cloneCollection, isNotSetBranch.newInstance(MethodDescriptor.ofConstructor(ArrayList.class, (Class[])new Class[]{Integer.TYPE}), new ResultHandle[]{size}));
        }
        ResultHandle iterator = bytecodeCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Iterable.class, (String)"iterator", Iterator.class, (Class[])new Class[0]), toClone, new ResultHandle[0]);
        BytecodeCreator whileLoopBlock = bytecodeCreator.whileLoop(conditionBytecode -> {
            ResultHandle hasNext = conditionBytecode.invokeInterfaceMethod(MethodDescriptor.ofMethod(Iterator.class, (String)"hasNext", Boolean.TYPE, (Class[])new Class[0]), iterator, new ResultHandle[0]);
            return conditionBytecode.ifTrue(hasNext);
        }).block();
        if (!(type instanceof ParameterizedType)) throw new IllegalStateException("Cannot infer element type for Collection type (" + String.valueOf(type) + ").");
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Type elementClassType = parameterizedType.getActualTypeArguments()[0];
        if (elementClassType instanceof Class) {
            Class class1;
            elementClass = class1 = (Class)elementClassType;
        } else if (elementClassType instanceof ParameterizedType) {
            ParameterizedType parameterizedElementClassType = (ParameterizedType)elementClassType;
            elementClass = (Class)parameterizedElementClassType.getRawType();
        } else {
            if (!(elementClassType instanceof WildcardType)) throw new IllegalStateException("Unhandled type " + String.valueOf(elementClassType) + ".");
            WildcardType wildcardType = (WildcardType)elementClassType;
            elementClass = (Class)wildcardType.getUpperBounds()[0];
        }
        ResultHandle next = whileLoopBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(Iterator.class, (String)"next", Object.class, (Class[])new Class[0]), iterator, new ResultHandle[0]);
        AssignableResultHandle clonedElement = whileLoopBlock.createVariable(elementClass);
        this.writeDeepCloneInstructions(whileLoopBlock, solutionDescriptor, elementClass, elementClassType, next, clonedElement, createdCloneMap, deepClonedClassesSortedSet);
        whileLoopBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(Collection.class, (String)"add", Boolean.TYPE, (Class[])new Class[]{Object.class}), (ResultHandle)cloneCollection, new ResultHandle[]{clonedElement});
        bytecodeCreator.assign(cloneResultHolder, (ResultHandle)cloneCollection);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeDeepCloneMapInstructions(BytecodeCreator bytecodeCreator, GizmoSolutionOrEntityDescriptor solutionDescriptor, Class<?> deeplyClonedFieldClass, Type type, ResultHandle toClone, AssignableResultHandle cloneResultHolder, ResultHandle createdCloneMap, SortedSet<Class<?>> deepClonedClassesSortedSet) {
        Class keyClass;
        Class elementClass;
        ResultHandle cloneMap;
        if (PlanningCloneable.class.isAssignableFrom(deeplyClonedFieldClass)) {
            ResultHandle emptyInstance = bytecodeCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(PlanningCloneable.class, (String)"createNewInstance", Object.class, (Class[])new Class[0]), bytecodeCreator.checkCast(toClone, PlanningCloneable.class), new ResultHandle[0]);
            cloneMap = bytecodeCreator.checkCast(emptyInstance, Map.class);
        } else {
            Class<Object> holderClass = deeplyClonedFieldClass;
            try {
                holderClass.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                holderClass = LinkedHashMap.class.isAssignableFrom(holderClass) ? LinkedHashMap.class : (ConcurrentHashMap.class.isAssignableFrom(holderClass) ? ConcurrentHashMap.class : LinkedHashMap.class);
            }
            ResultHandle size = bytecodeCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Map.class, (String)"size", Integer.TYPE, (Class[])new Class[0]), toClone, new ResultHandle[0]);
            try {
                holderClass.getConstructor(Integer.TYPE);
                cloneMap = bytecodeCreator.newInstance(MethodDescriptor.ofConstructor(holderClass, (Class[])new Class[]{Integer.TYPE}), new ResultHandle[]{size});
            }
            catch (NoSuchMethodException e) {
                cloneMap = bytecodeCreator.newInstance(MethodDescriptor.ofConstructor(holderClass, (Class[])new Class[0]), new ResultHandle[0]);
            }
        }
        ResultHandle entrySet = bytecodeCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Map.class, (String)"entrySet", Set.class, (Class[])new Class[0]), toClone, new ResultHandle[0]);
        ResultHandle iterator = bytecodeCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Iterable.class, (String)"iterator", Iterator.class, (Class[])new Class[0]), entrySet, new ResultHandle[0]);
        BytecodeCreator whileLoopBlock = bytecodeCreator.whileLoop(conditionBytecode -> {
            ResultHandle hasNext = conditionBytecode.invokeInterfaceMethod(MethodDescriptor.ofMethod(Iterator.class, (String)"hasNext", Boolean.TYPE, (Class[])new Class[0]), iterator, new ResultHandle[0]);
            return conditionBytecode.ifTrue(hasNext);
        }).block();
        if (!(type instanceof ParameterizedType)) throw new IllegalStateException("Cannot infer element type for Map type (" + String.valueOf(type) + ").");
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Type keyType = parameterizedType.getActualTypeArguments()[0];
        Type elementClassType = parameterizedType.getActualTypeArguments()[1];
        if (elementClassType instanceof Class) {
            Class class1;
            elementClass = class1 = (Class)elementClassType;
        } else {
            if (!(elementClassType instanceof ParameterizedType)) throw new IllegalStateException("Unhandled type " + String.valueOf(elementClassType) + ".");
            ParameterizedType parameterizedElementClassType = (ParameterizedType)elementClassType;
            elementClass = (Class)parameterizedElementClassType.getRawType();
        }
        if (keyType instanceof Class) {
            Class class1;
            keyClass = class1 = (Class)keyType;
        } else {
            if (!(keyType instanceof ParameterizedType)) throw new IllegalStateException("Unhandled type " + String.valueOf(keyType) + ".");
            ParameterizedType parameterizedElementClassType = (ParameterizedType)keyType;
            keyClass = (Class)parameterizedElementClassType.getRawType();
        }
        List<Class> entitySubclasses = deepClonedClassesSortedSet.stream().filter(keyClass::isAssignableFrom).toList();
        ResultHandle entry = whileLoopBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(Iterator.class, (String)"next", Object.class, (Class[])new Class[0]), iterator, new ResultHandle[0]);
        ResultHandle toCloneValue = whileLoopBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(Map.Entry.class, (String)"getValue", Object.class, (Class[])new Class[0]), entry, new ResultHandle[0]);
        AssignableResultHandle clonedElement = whileLoopBlock.createVariable(elementClass);
        this.writeDeepCloneInstructions(whileLoopBlock, solutionDescriptor, elementClass, elementClassType, toCloneValue, clonedElement, createdCloneMap, deepClonedClassesSortedSet);
        ResultHandle key = whileLoopBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(Map.Entry.class, (String)"getKey", Object.class, (Class[])new Class[0]), entry, new ResultHandle[0]);
        if (!entitySubclasses.isEmpty()) {
            AssignableResultHandle keyCloneResultHolder = whileLoopBlock.createVariable(keyClass);
            this.writeDeepCloneEntityOrFactInstructions(whileLoopBlock, solutionDescriptor, keyClass, key, keyCloneResultHolder, createdCloneMap, deepClonedClassesSortedSet, UnhandledCloneType.DEEP);
            whileLoopBlock.invokeInterfaceMethod(PUT_METHOD, cloneMap, new ResultHandle[]{keyCloneResultHolder, clonedElement});
        } else {
            whileLoopBlock.invokeInterfaceMethod(PUT_METHOD, cloneMap, new ResultHandle[]{key, clonedElement});
        }
        bytecodeCreator.assign(cloneResultHolder, cloneMap);
    }

    private void writeDeepCloneArrayInstructions(BytecodeCreator bytecodeCreator, GizmoSolutionOrEntityDescriptor solutionDescriptor, Class<?> deeplyClonedFieldClass, ResultHandle toClone, AssignableResultHandle cloneResultHolder, ResultHandle createdCloneMap, SortedSet<Class<?>> deepClonedClassesSortedSet) {
        Class<?> arrayComponent = deeplyClonedFieldClass.getComponentType();
        ResultHandle arrayLength = bytecodeCreator.arrayLength(toClone);
        ResultHandle arrayClone = bytecodeCreator.newArray(arrayComponent, arrayLength);
        AssignableResultHandle iterations = bytecodeCreator.createVariable(Integer.TYPE);
        bytecodeCreator.assign(iterations, bytecodeCreator.load(0));
        BytecodeCreator whileLoopBlock = bytecodeCreator.whileLoop(conditionBytecode -> conditionBytecode.ifIntegerLessThan((ResultHandle)iterations, arrayLength)).block();
        ResultHandle toCloneElement = whileLoopBlock.readArrayValue(toClone, (ResultHandle)iterations);
        AssignableResultHandle clonedElement = whileLoopBlock.createVariable(arrayComponent);
        this.writeDeepCloneInstructions(whileLoopBlock, solutionDescriptor, arrayComponent, arrayComponent, toCloneElement, clonedElement, createdCloneMap, deepClonedClassesSortedSet);
        whileLoopBlock.writeArrayValue(arrayClone, (ResultHandle)iterations, (ResultHandle)clonedElement);
        whileLoopBlock.assign(iterations, whileLoopBlock.increment((ResultHandle)iterations));
        bytecodeCreator.assign(cloneResultHolder, arrayClone);
    }

    private void writeDeepCloneEntityOrFactInstructions(BytecodeCreator bytecodeCreator, GizmoSolutionOrEntityDescriptor solutionDescriptor, Class<?> deeplyClonedFieldClass, ResultHandle toClone, AssignableResultHandle cloneResultHolder, ResultHandle createdCloneMap, SortedSet<Class<?>> deepClonedClassesSortedSet, UnhandledCloneType unhandledCloneType) {
        List<Class> deepClonedSubclasses = deepClonedClassesSortedSet.stream().filter(deeplyClonedFieldClass::isAssignableFrom).filter(type -> DeepCloningUtils.isClassDeepCloned(solutionDescriptor.getSolutionDescriptor(), type)).toList();
        BytecodeCreator currentBranch = bytecodeCreator;
        for (Class deepClonedSubclass : deepClonedSubclasses) {
            ResultHandle isInstance = currentBranch.instanceOf(toClone, deepClonedSubclass);
            BranchResult isInstanceBranchResult = currentBranch.ifTrue(isInstance);
            BytecodeCreator isInstanceBranch = isInstanceBranchResult.trueBranch();
            ResultHandle cloneObj = isInstanceBranch.invokeStaticMethod(MethodDescriptor.ofMethod((Object)GizmoSolutionClonerFactory.getGeneratedClassName(solutionDescriptor.getSolutionDescriptor()), (String)this.getEntityHelperMethodName(deepClonedSubclass), (Object)deepClonedSubclass, (Object[])new Object[]{deepClonedSubclass, Map.class}), new ResultHandle[]{toClone, createdCloneMap});
            isInstanceBranch.assign(cloneResultHolder, cloneObj);
            currentBranch = isInstanceBranchResult.falseBranch();
        }
        switch (unhandledCloneType) {
            case SHALLOW: {
                currentBranch.assign(cloneResultHolder, toClone);
                break;
            }
            case DEEP: {
                ResultHandle cloneObj = currentBranch.invokeStaticMethod(MethodDescriptor.ofMethod((Object)GizmoSolutionClonerFactory.getGeneratedClassName(solutionDescriptor.getSolutionDescriptor()), (String)this.getEntityHelperMethodName(deeplyClonedFieldClass), deeplyClonedFieldClass, (Object[])new Object[]{deeplyClonedFieldClass, Map.class}), new ResultHandle[]{toClone, createdCloneMap});
                currentBranch.assign(cloneResultHolder, cloneObj);
            }
        }
    }

    protected String getEntityHelperMethodName(Class<?> entityClass) {
        return "$clone" + entityClass.getName().replace('.', '_');
    }

    protected BytecodeCreator createUnknownClassHandler(BytecodeCreator bytecodeCreator, SolutionDescriptor<?> solutionDescriptor, Class<?> entityClass, ResultHandle toClone, ResultHandle cloneMap) {
        ResultHandle actualClass = bytecodeCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(Object.class, (String)"getClass", Class.class, (Class[])new Class[0]), toClone, new ResultHandle[0]);
        BranchResult branchResult = bytecodeCreator.ifReferencesNotEqual(actualClass, bytecodeCreator.loadClass(entityClass));
        BytecodeCreator currentBranch = branchResult.trueBranch();
        ResultHandle fallbackCloner = currentBranch.readStaticField(FieldDescriptor.of((String)GizmoSolutionClonerFactory.getGeneratedClassName(solutionDescriptor), (String)FALLBACK_CLONER, FieldAccessingSolutionCloner.class));
        ResultHandle cloneObj = currentBranch.invokeVirtualMethod(MethodDescriptor.ofMethod(FieldAccessingSolutionCloner.class, (String)"gizmoFallbackDeepClone", Object.class, (Class[])new Class[]{Object.class, Map.class}), fallbackCloner, new ResultHandle[]{toClone, cloneMap});
        currentBranch.returnValue(cloneObj);
        return branchResult.falseBranch();
    }

    private void createDeepCloneHelperMethod(ClassCreator classCreator, Class<?> entityClass, SolutionDescriptor<?> solutionDescriptor, Map<Class<?>, GizmoSolutionOrEntityDescriptor> memoizedSolutionOrEntityDescriptorMap, SortedSet<Class<?>> deepClonedClassesSortedSet) {
        ResultHandle cloneObj;
        MethodCreator methodCreator = classCreator.getMethodCreator(this.getEntityHelperMethodName(entityClass), entityClass, new Class[]{entityClass, Map.class});
        methodCreator.setModifiers(10);
        GizmoSolutionOrEntityDescriptor entityDescriptor = memoizedSolutionOrEntityDescriptorMap.computeIfAbsent(entityClass, key -> new GizmoSolutionOrEntityDescriptor(solutionDescriptor, entityClass));
        ResultHandle toClone = methodCreator.getMethodParam(0);
        ResultHandle cloneMap = methodCreator.getMethodParam(1);
        ResultHandle maybeClone = methodCreator.invokeInterfaceMethod(GET_METHOD, cloneMap, new ResultHandle[]{toClone});
        BranchResult hasCloneBranchResult = methodCreator.ifNotNull(maybeClone);
        BytecodeCreator hasCloneBranch = hasCloneBranchResult.trueBranch();
        hasCloneBranch.returnValue(maybeClone);
        BytecodeCreator noCloneBranch = hasCloneBranchResult.falseBranch();
        noCloneBranch = this.createUnknownClassHandler(noCloneBranch, solutionDescriptor, entityClass, toClone, cloneMap);
        if (PlanningCloneable.class.isAssignableFrom(entityClass)) {
            cloneObj = noCloneBranch.invokeInterfaceMethod(MethodDescriptor.ofMethod(PlanningCloneable.class, (String)"createNewInstance", Object.class, (Class[])new Class[0]), toClone, new ResultHandle[0]);
            cloneObj = noCloneBranch.checkCast(cloneObj, entityClass);
        } else {
            cloneObj = noCloneBranch.newInstance(MethodDescriptor.ofConstructor(entityClass, (Class[])new Class[0]), new ResultHandle[0]);
        }
        noCloneBranch.invokeInterfaceMethod(MethodDescriptor.ofMethod(Map.class, (String)"put", Object.class, (Class[])new Class[]{Object.class, Object.class}), cloneMap, new ResultHandle[]{toClone, cloneObj});
        for (GizmoMemberDescriptor shallowlyClonedField : entityDescriptor.getShallowClonedMemberDescriptors()) {
            this.writeShallowCloneInstructions(entityDescriptor, noCloneBranch, shallowlyClonedField, toClone, cloneObj, cloneMap, deepClonedClassesSortedSet);
        }
        for (Field deeplyClonedField : entityDescriptor.getDeepClonedFields()) {
            GizmoMemberDescriptor gizmoMemberDescriptor = entityDescriptor.getMemberDescriptorForField(deeplyClonedField);
            ResultHandle subfieldValue = gizmoMemberDescriptor.readMemberValue(noCloneBranch, toClone);
            AssignableResultHandle cloneValue = noCloneBranch.createVariable(deeplyClonedField.getType());
            this.writeDeepCloneInstructions(noCloneBranch, entityDescriptor, deeplyClonedField, gizmoMemberDescriptor, subfieldValue, cloneValue, cloneMap, deepClonedClassesSortedSet);
            if (gizmoMemberDescriptor.writeMemberValue(noCloneBranch, cloneObj, (ResultHandle)cloneValue)) continue;
            throw new IllegalStateException("The member (" + gizmoMemberDescriptor.getName() + ") of class (" + gizmoMemberDescriptor.getDeclaringClassName() + ") does not have a setter.");
        }
        noCloneBranch.returnValue(cloneObj);
    }

    protected void createAbstractDeepCloneHelperMethod(ClassCreator classCreator, Class<?> entityClass, SolutionDescriptor<?> solutionDescriptor, Map<Class<?>, GizmoSolutionOrEntityDescriptor> memoizedSolutionOrEntityDescriptorMap, SortedSet<Class<?>> deepClonedClassesSortedSet) {
        MethodCreator methodCreator = classCreator.getMethodCreator(this.getEntityHelperMethodName(entityClass), entityClass, new Class[]{entityClass, Map.class});
        methodCreator.setModifiers(10);
        ResultHandle toClone = methodCreator.getMethodParam(0);
        ResultHandle cloneMap = methodCreator.getMethodParam(1);
        ResultHandle maybeClone = methodCreator.invokeInterfaceMethod(GET_METHOD, cloneMap, new ResultHandle[]{toClone});
        BranchResult hasCloneBranchResult = methodCreator.ifNotNull(maybeClone);
        BytecodeCreator hasCloneBranch = hasCloneBranchResult.trueBranch();
        hasCloneBranch.returnValue(maybeClone);
        BytecodeCreator noCloneBranch = hasCloneBranchResult.falseBranch();
        ResultHandle fallbackCloner = noCloneBranch.readStaticField(FieldDescriptor.of((String)GizmoSolutionClonerFactory.getGeneratedClassName(solutionDescriptor), (String)FALLBACK_CLONER, FieldAccessingSolutionCloner.class));
        ResultHandle cloneObj = noCloneBranch.invokeVirtualMethod(MethodDescriptor.ofMethod(FieldAccessingSolutionCloner.class, (String)"gizmoFallbackDeepClone", Object.class, (Class[])new Class[]{Object.class, Map.class}), fallbackCloner, new ResultHandle[]{toClone, cloneMap});
        noCloneBranch.returnValue(cloneObj);
    }

    private static enum UnhandledCloneType {
        SHALLOW,
        DEEP;

    }
}

