/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.bavet.uni;

import ai.timefold.solver.core.impl.bavet.common.tuple.TupleLifecycle;
import ai.timefold.solver.core.impl.bavet.common.tuple.UniTuple;
import ai.timefold.solver.core.impl.bavet.uni.AbstractForEachUniNode;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.solution.descriptor.DefaultPlanningEntityMetaModel;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.domain.variable.ListVariableStateSupply;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.supply.SupplyManager;
import ai.timefold.solver.core.preview.api.domain.metamodel.PlanningEntityMetaModel;
import java.util.Objects;
import java.util.function.Predicate;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class ForEachExcludingPinnedUniNode<Solution_, A>
extends AbstractForEachUniNode<A>
implements AbstractForEachUniNode.InitializableForEachNode<Solution_> {
    private static final Predicate ALWAYS_TRUE = entity -> true;
    private final EntityDescriptor<Solution_> entityDescriptor;
    private @Nullable ListVariableStateSupply<Solution_> listVariableStateSupply;
    private Predicate<A> filter = ALWAYS_TRUE;

    public ForEachExcludingPinnedUniNode(PlanningEntityMetaModel<Solution_, A> entityMetaModel, TupleLifecycle<UniTuple<A>> nextNodesTupleLifecycle, int outputStoreSize) {
        super(Objects.requireNonNull(entityMetaModel).type(), nextNodesTupleLifecycle, outputStoreSize);
        this.entityDescriptor = ((DefaultPlanningEntityMetaModel)entityMetaModel).entityDescriptor();
    }

    @Override
    public void initialize(Solution_ workingSolution, SupplyManager supplyManager) {
        this.filter = this.buildFilter(workingSolution, supplyManager);
    }

    private Predicate<A> buildFilter(Solution_ workingSolution, SupplyManager supplyManager) {
        if (this.entityDescriptor.isGenuine()) {
            return entity -> this.entityDescriptor.isMovable(workingSolution, entity);
        }
        SolutionDescriptor<Solution_> solutionDescriptor = this.entityDescriptor.getSolutionDescriptor();
        ListVariableDescriptor<Solution_> listVariableDescriptor = solutionDescriptor.getListVariableDescriptor();
        this.listVariableStateSupply = Objects.requireNonNull((ListVariableStateSupply)supplyManager.demand(listVariableDescriptor.getStateDemand()));
        return entity -> !this.listVariableStateSupply.isPinned(entity);
    }

    @Override
    public void insert(A a) {
        if (!this.filter.test(a)) {
            return;
        }
        super.insert(a);
    }

    @Override
    public void update(A a) {
        UniTuple tuple = (UniTuple)this.tupleMap.get(a);
        if (tuple == null) {
            this.insert(a);
        } else if (this.filter.test(a)) {
            this.updateExisting(a, tuple);
        } else {
            this.retract(a);
        }
    }

    @Override
    public void retract(A a) {
        UniTuple tuple = (UniTuple)this.tupleMap.remove(a);
        if (tuple == null) {
            return;
        }
        super.retractExisting(a, tuple);
    }

    @Override
    public boolean supports(AbstractForEachUniNode.LifecycleOperation lifecycleOperation) {
        return true;
    }

    @Override
    public void close() {
        this.filter = ALWAYS_TRUE;
        if (this.listVariableStateSupply != null) {
            this.listVariableStateSupply.close();
            this.listVariableStateSupply = null;
        }
    }
}

