/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.bavet.quad;

import ai.timefold.solver.core.api.function.QuadFunction;
import ai.timefold.solver.core.impl.bavet.common.AbstractMapNode;
import ai.timefold.solver.core.impl.bavet.common.tuple.QuadTuple;
import ai.timefold.solver.core.impl.bavet.common.tuple.TupleLifecycle;
import java.util.Objects;

public final class MapQuadToQuadNode<A, B, C, D, NewA, NewB, NewC, NewD>
extends AbstractMapNode<QuadTuple<A, B, C, D>, QuadTuple<NewA, NewB, NewC, NewD>> {
    private final QuadFunction<A, B, C, D, NewA> mappingFunctionA;
    private final QuadFunction<A, B, C, D, NewB> mappingFunctionB;
    private final QuadFunction<A, B, C, D, NewC> mappingFunctionC;
    private final QuadFunction<A, B, C, D, NewD> mappingFunctionD;

    public MapQuadToQuadNode(int mapStoreIndex, QuadFunction<A, B, C, D, NewA> mappingFunctionA, QuadFunction<A, B, C, D, NewB> mappingFunctionB, QuadFunction<A, B, C, D, NewC> mappingFunctionC, QuadFunction<A, B, C, D, NewD> mappingFunctionD, TupleLifecycle<QuadTuple<NewA, NewB, NewC, NewD>> nextNodesTupleLifecycle, int outputStoreSize) {
        super(mapStoreIndex, nextNodesTupleLifecycle, outputStoreSize);
        this.mappingFunctionA = Objects.requireNonNull(mappingFunctionA);
        this.mappingFunctionB = Objects.requireNonNull(mappingFunctionB);
        this.mappingFunctionC = Objects.requireNonNull(mappingFunctionC);
        this.mappingFunctionD = Objects.requireNonNull(mappingFunctionD);
    }

    @Override
    protected QuadTuple<NewA, NewB, NewC, NewD> map(QuadTuple<A, B, C, D> tuple) {
        Object factA = tuple.factA;
        Object factB = tuple.factB;
        Object factC = tuple.factC;
        Object factD = tuple.factD;
        return new QuadTuple<NewA, NewB, NewC, NewD>(this.mappingFunctionA.apply(factA, factB, factC, factD), this.mappingFunctionB.apply(factA, factB, factC, factD), this.mappingFunctionC.apply(factA, factB, factC, factD), this.mappingFunctionD.apply(factA, factB, factC, factD), this.outputStoreSize);
    }

    @Override
    protected void remap(QuadTuple<A, B, C, D> inTuple, QuadTuple<NewA, NewB, NewC, NewD> outTuple) {
        Object factA = inTuple.factA;
        Object factB = inTuple.factB;
        Object factC = inTuple.factC;
        Object factD = inTuple.factD;
        NewA newA = this.mappingFunctionA.apply(factA, factB, factC, factD);
        NewB newB = this.mappingFunctionB.apply(factA, factB, factC, factD);
        NewC newC = this.mappingFunctionC.apply(factA, factB, factC, factD);
        NewD newD = this.mappingFunctionD.apply(factA, factB, factC, factD);
        outTuple.factA = newA;
        outTuple.factB = newB;
        outTuple.factC = newC;
        outTuple.factD = newD;
    }
}

