/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.move.streams;

import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.solution.descriptor.DefaultPlanningListVariableMetaModel;
import ai.timefold.solver.core.impl.domain.solution.descriptor.DefaultPlanningVariableMetaModel;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.domain.valuerange.descriptor.ValueRangeDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.supply.SupplyManager;
import ai.timefold.solver.core.impl.move.streams.DefaultMoveStreamSession;
import ai.timefold.solver.core.impl.move.streams.DefaultUniMoveStream;
import ai.timefold.solver.core.impl.move.streams.FromSolutionValueCollectingFunction;
import ai.timefold.solver.core.impl.move.streams.dataset.AbstractUniDataStream;
import ai.timefold.solver.core.impl.move.streams.dataset.DataStreamFactory;
import ai.timefold.solver.core.impl.move.streams.dataset.DatasetSession;
import ai.timefold.solver.core.impl.move.streams.dataset.DatasetSessionFactory;
import ai.timefold.solver.core.impl.move.streams.maybeapi.stream.MoveStreamFactory;
import ai.timefold.solver.core.impl.move.streams.maybeapi.stream.UniDataStream;
import ai.timefold.solver.core.impl.move.streams.maybeapi.stream.UniMoveStream;
import ai.timefold.solver.core.preview.api.domain.metamodel.GenuineVariableMetaModel;
import ai.timefold.solver.core.preview.api.domain.metamodel.PlanningVariableMetaModel;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class DefaultMoveStreamFactory<Solution_>
implements MoveStreamFactory<Solution_> {
    private final DataStreamFactory<Solution_> dataStreamFactory;
    private final DatasetSessionFactory<Solution_> datasetSessionFactory;

    public DefaultMoveStreamFactory(SolutionDescriptor<Solution_> solutionDescriptor) {
        this.dataStreamFactory = new DataStreamFactory<Solution_>(solutionDescriptor);
        this.datasetSessionFactory = new DatasetSessionFactory<Solution_>(this.dataStreamFactory);
    }

    public DefaultMoveStreamSession<Solution_> createSession(Solution_ workingSolution, SupplyManager supplyManager) {
        DatasetSession<Solution_> session = this.datasetSessionFactory.buildSession();
        session.initialize(workingSolution, supplyManager);
        return new DefaultMoveStreamSession<Solution_>(session, workingSolution);
    }

    @Override
    public <A> UniDataStream<Solution_, A> enumerate(Class<A> sourceClass) {
        EntityDescriptor<Solution_> entityDescriptor = this.getSolutionDescriptor().findEntityDescriptor(sourceClass);
        if (entityDescriptor == null) {
            return this.dataStreamFactory.forEachNonDiscriminating(sourceClass);
        }
        if (entityDescriptor.isGenuine()) {
            return this.dataStreamFactory.forEachExcludingPinned(sourceClass);
        }
        ListVariableDescriptor<Solution_> listVariableDescriptor = this.getSolutionDescriptor().getListVariableDescriptor();
        if (listVariableDescriptor == null) {
            return this.dataStreamFactory.forEachNonDiscriminating(sourceClass);
        }
        if (!listVariableDescriptor.supportsPinning()) {
            return this.dataStreamFactory.forEachNonDiscriminating(sourceClass);
        }
        if (!listVariableDescriptor.acceptsValueType(sourceClass)) {
            return this.dataStreamFactory.forEachNonDiscriminating(sourceClass);
        }
        return this.dataStreamFactory.forEachExcludingPinned(sourceClass);
    }

    @Override
    public <A> UniDataStream<Solution_, A> enumerateIncludingPinned(Class<A> sourceClass) {
        return this.dataStreamFactory.forEachNonDiscriminating(sourceClass);
    }

    @Override
    public <Entity_, A> UniDataStream<Solution_, A> enumeratePossibleValues(PlanningVariableMetaModel<Solution_, Entity_, A> variableMetaModel) {
        if (variableMetaModel.isChained()) {
            throw new IllegalArgumentException("Impossible state: chained variable (%s).".formatted(variableMetaModel));
        }
        GenuineVariableDescriptor<Solution_> variableDescriptor = DefaultMoveStreamFactory.getVariableDescriptor(variableMetaModel);
        ValueRangeDescriptor<Solution_> valueRangeDescriptor = variableDescriptor.getValueRangeDescriptor();
        if (variableDescriptor.isValueRangeEntityIndependent()) {
            return this.dataStreamFactory.forEachFromSolution(new FromSolutionValueCollectingFunction(valueRangeDescriptor));
        }
        throw new UnsupportedOperationException("Value range on entity is not yet supported.");
    }

    private static <Solution_> GenuineVariableDescriptor<Solution_> getVariableDescriptor(GenuineVariableMetaModel<Solution_, ?, ?> variableMetaModel) {
        if (variableMetaModel instanceof DefaultPlanningVariableMetaModel) {
            DefaultPlanningVariableMetaModel planningVariableMetaModel = (DefaultPlanningVariableMetaModel)variableMetaModel;
            return planningVariableMetaModel.variableDescriptor();
        }
        if (variableMetaModel instanceof DefaultPlanningListVariableMetaModel) {
            DefaultPlanningListVariableMetaModel planningListVariableMetaModel = (DefaultPlanningListVariableMetaModel)variableMetaModel;
            return planningListVariableMetaModel.variableDescriptor();
        }
        throw new IllegalStateException("Impossible state: variable metamodel (%s) represents neither basic not list variable.".formatted(variableMetaModel.getClass().getSimpleName()));
    }

    @Override
    public <A> UniMoveStream<Solution_, A> pick(UniDataStream<Solution_, A> dataStream) {
        return new DefaultUniMoveStream(this, ((AbstractUniDataStream)dataStream).createDataset());
    }

    public SolutionDescriptor<Solution_> getSolutionDescriptor() {
        return this.dataStreamFactory.getSolutionDescriptor();
    }
}

