/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.kopt;

import ai.timefold.solver.core.api.domain.entity.PlanningEntity;
import ai.timefold.solver.core.api.domain.variable.PlanningListVariable;
import ai.timefold.solver.core.config.heuristic.selector.common.SelectionCacheType;
import ai.timefold.solver.core.config.heuristic.selector.common.SelectionOrder;
import ai.timefold.solver.core.config.heuristic.selector.move.generic.list.kopt.KOptListMoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.value.ValueSelectorConfig;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.HeuristicConfigPolicy;
import ai.timefold.solver.core.impl.heuristic.selector.move.AbstractMoveSelectorFactory;
import ai.timefold.solver.core.impl.heuristic.selector.move.MoveSelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.kopt.KOptListMoveSelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.EntityIndependentValueSelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.ValueSelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.ValueSelectorFactory;
import java.util.Objects;

public final class KOptListMoveSelectorFactory<Solution_>
extends AbstractMoveSelectorFactory<Solution_, KOptListMoveSelectorConfig> {
    private static final int DEFAULT_MINIMUM_K = 2;
    private static final int DEFAULT_MAXIMUM_K = 2;

    public KOptListMoveSelectorFactory(KOptListMoveSelectorConfig moveSelectorConfig) {
        super(moveSelectorConfig);
    }

    @Override
    protected MoveSelector<Solution_> buildBaseMoveSelector(HeuristicConfigPolicy<Solution_> configPolicy, SelectionCacheType minimumCacheType, boolean randomSelection) {
        int i;
        ListVariableDescriptor<Solution_> listVariableDescriptor = configPolicy.getSolutionDescriptor().getListVariableDescriptor();
        if (listVariableDescriptor == null) {
            throw new IllegalArgumentException("The kOptListMoveSelector (%s) can only be used when the domain model has a list variable.\nCheck your @%s and make sure it has a @%s.".formatted(this.config, PlanningEntity.class.getSimpleName(), PlanningListVariable.class.getSimpleName()));
        }
        ValueSelectorConfig originSelectorConfig = Objects.requireNonNullElseGet(((KOptListMoveSelectorConfig)this.config).getOriginSelectorConfig(), ValueSelectorConfig::new);
        ValueSelectorConfig valueSelectorConfig = Objects.requireNonNullElseGet(((KOptListMoveSelectorConfig)this.config).getValueSelectorConfig(), ValueSelectorConfig::new);
        EntityDescriptor<Solution_> entityDescriptor = this.getTheOnlyEntityDescriptorWithListVariable(configPolicy.getSolutionDescriptor());
        if (originSelectorConfig.getVariableName() == null) {
            originSelectorConfig.setVariableName(listVariableDescriptor.getVariableName());
        }
        if (valueSelectorConfig.getVariableName() == null) {
            valueSelectorConfig.setVariableName(listVariableDescriptor.getVariableName());
        }
        SelectionOrder selectionOrder = SelectionOrder.fromRandomSelectionBoolean(randomSelection);
        EntityIndependentValueSelector<Solution_> originSelector = this.buildEntityIndependentValueSelector(configPolicy, entityDescriptor, originSelectorConfig, minimumCacheType, selectionOrder);
        EntityIndependentValueSelector<Solution_> valueSelector = this.buildEntityIndependentValueSelector(configPolicy, entityDescriptor, valueSelectorConfig, minimumCacheType, selectionOrder);
        int minimumK = Objects.requireNonNullElse(((KOptListMoveSelectorConfig)this.config).getMinimumK(), 2);
        if (minimumK < 2) {
            throw new IllegalArgumentException("minimumK (%d) must be at least 2.".formatted(minimumK));
        }
        int maximumK = Objects.requireNonNullElse(((KOptListMoveSelectorConfig)this.config).getMaximumK(), 2);
        if (maximumK < minimumK) {
            throw new IllegalArgumentException("maximumK (%d) must be at least minimumK (%d).".formatted(maximumK, minimumK));
        }
        int[] pickedKDistribution = new int[maximumK - minimumK + 1];
        int total = 1;
        for (i = minimumK; i < maximumK; ++i) {
            total *= 8;
        }
        for (i = 0; i < pickedKDistribution.length - 1; ++i) {
            int remainder = total / 8;
            pickedKDistribution[i] = total - remainder;
            total = remainder;
        }
        pickedKDistribution[pickedKDistribution.length - 1] = total;
        return new KOptListMoveSelector<Solution_>(listVariableDescriptor, originSelector, valueSelector, minimumK, maximumK, pickedKDistribution);
    }

    private EntityIndependentValueSelector<Solution_> buildEntityIndependentValueSelector(HeuristicConfigPolicy<Solution_> configPolicy, EntityDescriptor<Solution_> entityDescriptor, ValueSelectorConfig valueSelectorConfig, SelectionCacheType minimumCacheType, SelectionOrder inheritedSelectionOrder) {
        ValueSelector valueSelector = ValueSelectorFactory.create(valueSelectorConfig).buildValueSelector(configPolicy, entityDescriptor, minimumCacheType, inheritedSelectionOrder);
        if (valueSelector instanceof EntityIndependentValueSelector) {
            EntityIndependentValueSelector entityIndependentValueSelector = (EntityIndependentValueSelector)valueSelector;
            return entityIndependentValueSelector;
        }
        throw new IllegalArgumentException("The kOptListMoveSelector (%s) for a list variable needs to be based on an %s (%s).\nCheck your valueSelectorConfig.".formatted(this.config, EntityIndependentValueSelector.class.getSimpleName(), valueSelector));
    }
}

