/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.variable.declarative;

import ai.timefold.solver.core.impl.domain.variable.declarative.AffectedEntitiesUpdater;
import ai.timefold.solver.core.impl.domain.variable.declarative.EntityVariablePair;
import ai.timefold.solver.core.impl.domain.variable.declarative.TopologicalOrderGraph;
import ai.timefold.solver.core.impl.domain.variable.declarative.VariableReferenceGraph;
import ai.timefold.solver.core.impl.domain.variable.declarative.VariableReferenceGraphBuilder;
import ai.timefold.solver.core.impl.util.DynamicIntArray;
import ai.timefold.solver.core.preview.api.domain.metamodel.VariableMetaModel;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

final class DefaultVariableReferenceGraph<Solution_>
implements VariableReferenceGraph<Solution_> {
    private final List<EntityVariablePair<Solution_>> instanceList;
    private final Map<VariableMetaModel<?, ?, ?>, Map<Object, EntityVariablePair<Solution_>>> variableReferenceToInstanceMap;
    private final Map<VariableMetaModel<?, ?, ?>, List<BiConsumer<VariableReferenceGraph<Solution_>, Object>>> variableReferenceToBeforeProcessor;
    private final Map<VariableMetaModel<?, ?, ?>, List<BiConsumer<VariableReferenceGraph<Solution_>, Object>>> variableReferenceToAfterProcessor;
    private final DynamicIntArray[] edgeCount;
    private final TopologicalOrderGraph graph;
    private final BitSet changed;
    private final Consumer<BitSet> affectedEntitiesUpdater;

    public DefaultVariableReferenceGraph(VariableReferenceGraphBuilder<Solution_> outerGraph, IntFunction<TopologicalOrderGraph> graphCreator) {
        this.instanceList = List.copyOf(outerGraph.instanceList);
        int instanceCount = this.instanceList.size();
        this.variableReferenceToInstanceMap = DefaultVariableReferenceGraph.mapOfMapsDeepCopyOf(outerGraph.variableReferenceToInstanceMap);
        this.variableReferenceToBeforeProcessor = DefaultVariableReferenceGraph.mapOfListsDeepCopyOf(outerGraph.variableReferenceToBeforeProcessor);
        this.variableReferenceToAfterProcessor = DefaultVariableReferenceGraph.mapOfListsDeepCopyOf(outerGraph.variableReferenceToAfterProcessor);
        this.edgeCount = new DynamicIntArray[instanceCount];
        for (int i = 0; i < instanceCount; ++i) {
            this.edgeCount[i] = new DynamicIntArray(instanceCount);
        }
        this.graph = graphCreator.apply(instanceCount);
        this.graph.withNodeData(this.instanceList);
        this.changed = new BitSet(instanceCount);
        IdentityHashMap<Object, List> entityToVariableReferenceMap = new IdentityHashMap<Object, List>();
        Set visited = Collections.newSetFromMap(new IdentityHashMap());
        for (EntityVariablePair<Solution_> entityVariablePair : this.instanceList) {
            Object entity = entityVariablePair.entity();
            if (visited.add(entity)) {
                for (VariableMetaModel<?, ?, ?> variableId : outerGraph.variableReferenceToAfterProcessor.keySet()) {
                    this.afterVariableChanged(variableId, entity);
                }
            }
            entityToVariableReferenceMap.computeIfAbsent(entity, ignored -> new ArrayList()).add(entityVariablePair);
        }
        for (Map.Entry entry : outerGraph.fixedEdges.entrySet()) {
            for (EntityVariablePair toEdge : (List)entry.getValue()) {
                this.addEdge((EntityVariablePair)entry.getKey(), toEdge);
            }
        }
        Map immutableEntityToVariableReferenceMap = DefaultVariableReferenceGraph.mapOfListsDeepCopyOf(entityToVariableReferenceMap);
        this.affectedEntitiesUpdater = new AffectedEntitiesUpdater<Solution_>(this.graph, this.instanceList, immutableEntityToVariableReferenceMap::get, outerGraph.changedVariableNotifier);
    }

    @Override
    public @Nullable EntityVariablePair<Solution_> lookupOrNull(VariableMetaModel<?, ?, ?> variableId, Object entity) {
        Map<Object, EntityVariablePair<Solution_>> map = this.variableReferenceToInstanceMap.get(variableId);
        if (map == null) {
            return null;
        }
        return map.get(entity);
    }

    @Override
    public void addEdge(@NonNull EntityVariablePair<Solution_> from, @NonNull EntityVariablePair<Solution_> to) {
        int toNodeId;
        int fromNodeId = from.graphNodeId();
        if (fromNodeId == (toNodeId = to.graphNodeId())) {
            return;
        }
        int count = this.edgeCount[fromNodeId].get(toNodeId);
        if (count == 0) {
            this.graph.addEdge(fromNodeId, toNodeId);
        }
        this.edgeCount[fromNodeId].set(toNodeId, count + 1);
        this.markChanged(to);
    }

    @Override
    public void removeEdge(@NonNull EntityVariablePair<Solution_> from, @NonNull EntityVariablePair<Solution_> to) {
        int toNodeId;
        int fromNodeId = from.graphNodeId();
        if (fromNodeId == (toNodeId = to.graphNodeId())) {
            return;
        }
        int count = this.edgeCount[fromNodeId].get(toNodeId);
        if (count == 1) {
            this.graph.removeEdge(fromNodeId, toNodeId);
        }
        this.edgeCount[fromNodeId].set(toNodeId, count - 1);
        this.markChanged(to);
    }

    @Override
    public void markChanged(@NonNull EntityVariablePair<Solution_> node) {
        this.changed.set(node.graphNodeId());
    }

    @Override
    public void updateChanged() {
        if (this.changed.isEmpty()) {
            return;
        }
        this.graph.commitChanges();
        this.affectedEntitiesUpdater.accept(this.changed);
    }

    @Override
    public void beforeVariableChanged(VariableMetaModel<?, ?, ?> variableReference, Object entity) {
        if (variableReference.entity().type().isInstance(entity)) {
            this.processEntity(this.variableReferenceToBeforeProcessor.getOrDefault(variableReference, Collections.emptyList()), entity);
        }
    }

    private void processEntity(List<BiConsumer<VariableReferenceGraph<Solution_>, Object>> processorList, Object entity) {
        int processorCount = processorList.size();
        for (int i = 0; i < processorCount; ++i) {
            processorList.get(i).accept(this, entity);
        }
    }

    @Override
    public void afterVariableChanged(VariableMetaModel<?, ?, ?> variableReference, Object entity) {
        if (variableReference.entity().type().isInstance(entity)) {
            EntityVariablePair<Solution_> node = this.lookupOrNull(variableReference, entity);
            if (node != null) {
                this.markChanged(node);
            }
            this.processEntity(this.variableReferenceToAfterProcessor.getOrDefault(variableReference, Collections.emptyList()), entity);
        }
    }

    public String toString() {
        LinkedHashMap edgeList = new LinkedHashMap();
        this.graph.forEachEdge((from, to) -> edgeList.computeIfAbsent(this.instanceList.get(from), k -> new ArrayList()).add(this.instanceList.get(to)));
        return edgeList.entrySet().stream().map(e -> String.valueOf(e.getKey()) + "->" + String.valueOf(e.getValue())).collect(Collectors.joining("," + System.lineSeparator() + " ", "{" + System.lineSeparator() + "  ", "}"));
    }

    private static <K1, K2, V> Map<K1, Map<K2, V>> mapOfMapsDeepCopyOf(Map<K1, Map<K2, V>> map) {
        Map.Entry[] entryArray = (Map.Entry[])map.entrySet().stream().map(e -> Map.entry(e.getKey(), Map.copyOf((Map)e.getValue()))).toArray(Map.Entry[]::new);
        return Map.ofEntries(entryArray);
    }

    private static <K1, V> Map<K1, List<V>> mapOfListsDeepCopyOf(Map<K1, List<V>> map) {
        Map.Entry[] entryArray = (Map.Entry[])map.entrySet().stream().map(e -> Map.entry(e.getKey(), List.copyOf((Collection)e.getValue()))).toArray(Map.Entry[]::new);
        return Map.ofEntries(entryArray);
    }
}

