/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.solver.termination;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.impl.phase.scope.AbstractPhaseScope;
import ai.timefold.solver.core.impl.score.definition.ScoreDefinition;
import ai.timefold.solver.core.impl.score.director.InnerScore;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import ai.timefold.solver.core.impl.solver.termination.AbstractUniversalTermination;
import ai.timefold.solver.core.impl.solver.termination.BestScoreTermination;
import java.util.Arrays;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
final class BestScoreFeasibleTermination<Solution_>
extends AbstractUniversalTermination<Solution_> {
    private final int feasibleLevelsSize;
    private final double[] timeGradientWeightFeasibleNumbers;

    public BestScoreFeasibleTermination(ScoreDefinition<?> scoreDefinition, double[] timeGradientWeightFeasibleNumbers) {
        this.feasibleLevelsSize = scoreDefinition.getFeasibleLevelsSize();
        this.timeGradientWeightFeasibleNumbers = timeGradientWeightFeasibleNumbers;
        if (timeGradientWeightFeasibleNumbers.length != this.feasibleLevelsSize - 1) {
            throw new IllegalStateException("The timeGradientWeightNumbers (%s)'s length (%d) is not 1 less than the feasibleLevelsSize (%d).".formatted(Arrays.toString(timeGradientWeightFeasibleNumbers), timeGradientWeightFeasibleNumbers.length, scoreDefinition.getFeasibleLevelsSize()));
        }
    }

    @Override
    public boolean isSolverTerminated(SolverScope<Solution_> solverScope) {
        return BestScoreFeasibleTermination.isTerminated(solverScope.getBestScore());
    }

    @Override
    public boolean isPhaseTerminated(AbstractPhaseScope<Solution_> phaseScope) {
        return BestScoreFeasibleTermination.isTerminated(phaseScope.getBestScore());
    }

    private static boolean isTerminated(InnerScore<?> innerScore) {
        return innerScore.fullyAssigned() && innerScore.raw().isFeasible();
    }

    @Override
    public double calculateSolverTimeGradient(SolverScope<Solution_> solverScope) {
        return this.calculateFeasibilityTimeGradient(InnerScore.fullyAssigned(solverScope.getStartingInitializedScore()), solverScope.getBestScore().raw());
    }

    @Override
    public double calculatePhaseTimeGradient(AbstractPhaseScope<Solution_> phaseScope) {
        return this.calculateFeasibilityTimeGradient(phaseScope.getStartingScore(), phaseScope.getBestScore().raw());
    }

    <Score_ extends Score<Score_>> double calculateFeasibilityTimeGradient(@Nullable InnerScore<Score_> innerStartScore, Score_ score) {
        if (innerStartScore == null || !innerStartScore.fullyAssigned()) {
            return 0.0;
        }
        Score_ startScore = innerStartScore.raw();
        Score_ totalDiff = startScore.negate();
        Number[] totalDiffNumbers = totalDiff.toLevelNumbers();
        Score_ scoreDiff = score.subtract(startScore);
        Number[] scoreDiffNumbers = scoreDiff.toLevelNumbers();
        if (scoreDiffNumbers.length != totalDiffNumbers.length) {
            throw new IllegalStateException("The startScore (" + String.valueOf(startScore) + ") and score (" + String.valueOf(score) + ") don't have the same levelsSize.");
        }
        return BestScoreTermination.calculateTimeGradient(totalDiffNumbers, scoreDiffNumbers, this.timeGradientWeightFeasibleNumbers, this.feasibleLevelsSize);
    }

    public String toString() {
        return "BestScoreFeasible()";
    }
}

