/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.move.streams.dataset;

import ai.timefold.solver.core.impl.bavet.common.TupleSource;
import ai.timefold.solver.core.impl.bavet.common.tuple.TupleLifecycle;
import ai.timefold.solver.core.impl.bavet.common.tuple.UniTuple;
import ai.timefold.solver.core.impl.bavet.uni.AbstractForEachUniNode;
import ai.timefold.solver.core.impl.bavet.uni.ForEachExcludingUnassignedUniNode;
import ai.timefold.solver.core.impl.bavet.uni.ForEachFromSolutionUniNode;
import ai.timefold.solver.core.impl.bavet.uni.ForEachIncludingUnassignedUniNode;
import ai.timefold.solver.core.impl.move.streams.FromSolutionValueCollectingFunction;
import ai.timefold.solver.core.impl.move.streams.dataset.AbstractDataStream;
import ai.timefold.solver.core.impl.move.streams.dataset.AbstractUniDataStream;
import ai.timefold.solver.core.impl.move.streams.dataset.DataStreamFactory;
import ai.timefold.solver.core.impl.move.streams.dataset.common.DataNodeBuildHelper;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class ForEachDataStream<Solution_, A>
extends AbstractUniDataStream<Solution_, A>
implements TupleSource {
    private final Class<A> forEachClass;
    private final @Nullable FromSolutionValueCollectingFunction<Solution_, A> valueCollectingFunction;
    private final @Nullable Predicate<A> filter;

    public ForEachDataStream(DataStreamFactory<Solution_> dataStreamFactory, Class<A> forEachClass) {
        this(dataStreamFactory, forEachClass, null);
    }

    public ForEachDataStream(DataStreamFactory<Solution_> dataStreamFactory, Class<A> forEachClass, @Nullable Predicate<A> filter) {
        super(dataStreamFactory, null);
        this.forEachClass = Objects.requireNonNull(forEachClass, "The forEachClass cannot be null.");
        this.valueCollectingFunction = null;
        this.filter = filter;
    }

    public ForEachDataStream(DataStreamFactory<Solution_> dataStreamFactory, FromSolutionValueCollectingFunction<Solution_, A> valueCollectingFunction) {
        super(dataStreamFactory, null);
        FromSolutionValueCollectingFunction<Solution_, A> function = Objects.requireNonNull(valueCollectingFunction, "The valueCollectingFunction cannot be null.");
        this.forEachClass = function.declaredClass();
        this.valueCollectingFunction = function;
        this.filter = null;
    }

    @Override
    public void collectActiveDataStreams(Set<AbstractDataStream<Solution_>> dataStreamSet) {
        dataStreamSet.add(this);
    }

    @Override
    public void buildNode(DataNodeBuildHelper<Solution_> buildHelper) {
        TupleLifecycle<UniTuple<A>> tupleLifecycle = buildHelper.getAggregatedTupleLifecycle(this.childStreamList);
        int outputStoreSize = buildHelper.extractTupleStoreSize(this);
        AbstractForEachUniNode<Solution_, A> node = this.getNode(tupleLifecycle, outputStoreSize);
        buildHelper.addNode(node, this, null);
    }

    private AbstractForEachUniNode<Solution_, A> getNode(TupleLifecycle<UniTuple<A>> tupleLifecycle, int outputStoreSize) {
        if (this.valueCollectingFunction != null) {
            return new ForEachFromSolutionUniNode<Solution_, A>(this.valueCollectingFunction, tupleLifecycle, outputStoreSize);
        }
        if (this.filter == null) {
            return new ForEachIncludingUnassignedUniNode(this.forEachClass, tupleLifecycle, outputStoreSize);
        }
        return new ForEachExcludingUnassignedUniNode(this.forEachClass, this.filter, tupleLifecycle, outputStoreSize);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof ForEachDataStream)) return false;
        ForEachDataStream that = (ForEachDataStream)o;
        if (!Objects.equals(this.forEachClass, that.forEachClass)) return false;
        if (!Objects.equals(this.valueCollectingFunction, that.valueCollectingFunction)) return false;
        if (!Objects.equals(this.filter, that.filter)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.forEachClass, this.valueCollectingFunction, this.filter);
    }

    public String toString() {
        if (this.valueCollectingFunction != null) {
            return "ForEach(" + String.valueOf(this.valueCollectingFunction) + ") with " + this.childStreamList.size() + " children";
        }
        if (this.filter == null) {
            return "ForEach(" + this.forEachClass.getSimpleName() + ") with " + this.childStreamList.size() + " children";
        }
        return "ForEach(" + this.forEachClass.getSimpleName() + ") with filter and " + this.childStreamList.size() + " children";
    }
}

