/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.exhaustivesearch;

import ai.timefold.solver.core.config.exhaustivesearch.ExhaustiveSearchPhaseConfig;
import ai.timefold.solver.core.config.exhaustivesearch.ExhaustiveSearchType;
import ai.timefold.solver.core.config.exhaustivesearch.NodeExplorationType;
import ai.timefold.solver.core.config.heuristic.selector.common.SelectionCacheType;
import ai.timefold.solver.core.config.heuristic.selector.common.SelectionOrder;
import ai.timefold.solver.core.config.heuristic.selector.entity.EntitySelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.entity.EntitySorterManner;
import ai.timefold.solver.core.config.heuristic.selector.move.MoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.composite.CartesianProductMoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.generic.ChangeMoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.value.ValueSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.value.ValueSorterManner;
import ai.timefold.solver.core.config.solver.EnvironmentMode;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.exhaustivesearch.DefaultExhaustiveSearchPhase;
import ai.timefold.solver.core.impl.exhaustivesearch.ExhaustiveSearchPhase;
import ai.timefold.solver.core.impl.exhaustivesearch.decider.ExhaustiveSearchDecider;
import ai.timefold.solver.core.impl.exhaustivesearch.node.bounder.TrendBasedScoreBounder;
import ai.timefold.solver.core.impl.heuristic.HeuristicConfigPolicy;
import ai.timefold.solver.core.impl.heuristic.selector.entity.EntitySelector;
import ai.timefold.solver.core.impl.heuristic.selector.entity.EntitySelectorFactory;
import ai.timefold.solver.core.impl.heuristic.selector.entity.mimic.ManualEntityMimicRecorder;
import ai.timefold.solver.core.impl.heuristic.selector.move.MoveSelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.MoveSelectorFactory;
import ai.timefold.solver.core.impl.move.MoveSelectorBasedMoveRepository;
import ai.timefold.solver.core.impl.phase.AbstractPhaseFactory;
import ai.timefold.solver.core.impl.solver.recaller.BestSolutionRecaller;
import ai.timefold.solver.core.impl.solver.termination.PhaseTermination;
import ai.timefold.solver.core.impl.solver.termination.SolverTermination;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class DefaultExhaustiveSearchPhaseFactory<Solution_>
extends AbstractPhaseFactory<Solution_, ExhaustiveSearchPhaseConfig> {
    public DefaultExhaustiveSearchPhaseFactory(ExhaustiveSearchPhaseConfig phaseConfig) {
        super(phaseConfig);
    }

    @Override
    public ExhaustiveSearchPhase<Solution_> buildPhase(int phaseIndex, boolean lastInitializingPhase, HeuristicConfigPolicy<Solution_> solverConfigPolicy, BestSolutionRecaller<Solution_> bestSolutionRecaller, SolverTermination<Solution_> solverTermination) {
        NodeExplorationType nodeExplorationType_;
        ExhaustiveSearchType exhaustiveSearchType_ = Objects.requireNonNullElse(((ExhaustiveSearchPhaseConfig)this.phaseConfig).getExhaustiveSearchType(), ExhaustiveSearchType.BRANCH_AND_BOUND);
        EntitySorterManner entitySorterManner = Objects.requireNonNullElse(((ExhaustiveSearchPhaseConfig)this.phaseConfig).getEntitySorterManner(), exhaustiveSearchType_.getDefaultEntitySorterManner());
        ValueSorterManner valueSorterManner = Objects.requireNonNullElse(((ExhaustiveSearchPhaseConfig)this.phaseConfig).getValueSorterManner(), exhaustiveSearchType_.getDefaultValueSorterManner());
        HeuristicConfigPolicy<Solution_> phaseConfigPolicy = solverConfigPolicy.cloneBuilder().withReinitializeVariableFilterEnabled(true).withInitializedChainedValueFilterEnabled(true).withEntitySorterManner(entitySorterManner).withValueSorterManner(valueSorterManner).build();
        PhaseTermination<Solution_> phaseTermination = this.buildPhaseTermination(phaseConfigPolicy, solverTermination);
        boolean scoreBounderEnabled = exhaustiveSearchType_.isScoreBounderEnabled();
        if (exhaustiveSearchType_ == ExhaustiveSearchType.BRUTE_FORCE) {
            nodeExplorationType_ = Objects.requireNonNullElse(((ExhaustiveSearchPhaseConfig)this.phaseConfig).getNodeExplorationType(), NodeExplorationType.ORIGINAL_ORDER);
            if (nodeExplorationType_ != NodeExplorationType.ORIGINAL_ORDER) {
                throw new IllegalArgumentException("The phaseConfig (" + String.valueOf(this.phaseConfig) + ") has an nodeExplorationType (" + String.valueOf((Object)((ExhaustiveSearchPhaseConfig)this.phaseConfig).getNodeExplorationType()) + ") which is not compatible with its exhaustiveSearchType (" + String.valueOf((Object)((ExhaustiveSearchPhaseConfig)this.phaseConfig).getExhaustiveSearchType()) + ").");
            }
        } else {
            nodeExplorationType_ = Objects.requireNonNullElse(((ExhaustiveSearchPhaseConfig)this.phaseConfig).getNodeExplorationType(), NodeExplorationType.DEPTH_FIRST);
        }
        EntitySelectorConfig entitySelectorConfig_ = this.buildEntitySelectorConfig(phaseConfigPolicy);
        EntitySelector entitySelector = EntitySelectorFactory.create(entitySelectorConfig_).buildEntitySelector(phaseConfigPolicy, SelectionCacheType.PHASE, SelectionOrder.ORIGINAL);
        return ((DefaultExhaustiveSearchPhase.Builder)new DefaultExhaustiveSearchPhase.Builder<Solution_>(phaseIndex, solverConfigPolicy.getLogIndentation(), phaseTermination, nodeExplorationType_.buildNodeComparator(scoreBounderEnabled), entitySelector, this.buildDecider(phaseConfigPolicy, entitySelector, bestSolutionRecaller, phaseTermination, scoreBounderEnabled)).enableAssertions(phaseConfigPolicy.getEnvironmentMode())).build();
    }

    private EntitySelectorConfig buildEntitySelectorConfig(HeuristicConfigPolicy<Solution_> configPolicy) {
        EntitySelectorConfig result = Objects.requireNonNullElseGet(((ExhaustiveSearchPhaseConfig)this.phaseConfig).getEntitySelectorConfig(), () -> {
            EntityDescriptor entityDescriptor = this.deduceEntityDescriptor(configPolicy.getSolutionDescriptor());
            EntitySelectorConfig entitySelectorConfig = new EntitySelectorConfig().withEntityClass(entityDescriptor.getEntityClass());
            if (EntitySelectorConfig.hasSorter(configPolicy.getEntitySorterManner(), entityDescriptor)) {
                entitySelectorConfig = entitySelectorConfig.withCacheType(SelectionCacheType.PHASE).withSelectionOrder(SelectionOrder.SORTED).withSorterManner(configPolicy.getEntitySorterManner());
            }
            return entitySelectorConfig;
        });
        SelectionCacheType cacheType = result.getCacheType();
        if (cacheType != null && cacheType.compareTo(SelectionCacheType.PHASE) < 0) {
            throw new IllegalArgumentException("The phaseConfig (%s) cannot have an entitySelectorConfig (%s) with a cacheType (%s) lower than %s.".formatted(new Object[]{this.phaseConfig, result, cacheType, SelectionCacheType.PHASE}));
        }
        return result;
    }

    protected EntityDescriptor<Solution_> deduceEntityDescriptor(SolutionDescriptor<Solution_> solutionDescriptor) {
        Collection<EntityDescriptor<Solution_>> entityDescriptors = solutionDescriptor.getGenuineEntityDescriptors();
        if (entityDescriptors.size() != 1) {
            throw new IllegalArgumentException("The phaseConfig (" + String.valueOf(this.phaseConfig) + ") has no entitySelector configured and because there are multiple in the entityClassSet (" + String.valueOf(solutionDescriptor.getEntityClassSet()) + "), it cannot be deduced automatically.");
        }
        return entityDescriptors.iterator().next();
    }

    private ExhaustiveSearchDecider<Solution_> buildDecider(HeuristicConfigPolicy<Solution_> configPolicy, EntitySelector<Solution_> sourceEntitySelector, BestSolutionRecaller<Solution_> bestSolutionRecaller, PhaseTermination<Solution_> termination, boolean scoreBounderEnabled) {
        ManualEntityMimicRecorder<Solution_> manualEntityMimicRecorder = new ManualEntityMimicRecorder<Solution_>(sourceEntitySelector);
        String mimicSelectorId = sourceEntitySelector.getEntityDescriptor().getEntityClass().getName();
        configPolicy.addEntityMimicRecorder(mimicSelectorId, manualEntityMimicRecorder);
        MoveSelectorConfig<?> moveSelectorConfig_ = this.buildMoveSelectorConfig(configPolicy, sourceEntitySelector, mimicSelectorId);
        MoveSelector moveSelector = MoveSelectorFactory.create(moveSelectorConfig_).buildMoveSelector(configPolicy, SelectionCacheType.JUST_IN_TIME, SelectionOrder.ORIGINAL, false);
        TrendBasedScoreBounder scoreBounder = scoreBounderEnabled ? new TrendBasedScoreBounder(configPolicy.getScoreDefinition(), configPolicy.getInitializingScoreTrend()) : null;
        ExhaustiveSearchDecider<Solution_> decider = new ExhaustiveSearchDecider<Solution_>(configPolicy.getLogIndentation(), bestSolutionRecaller, termination, manualEntityMimicRecorder, new MoveSelectorBasedMoveRepository(moveSelector), scoreBounderEnabled, scoreBounder);
        EnvironmentMode environmentMode = configPolicy.getEnvironmentMode();
        if (environmentMode.isFullyAsserted()) {
            decider.setAssertMoveScoreFromScratch(true);
        }
        if (environmentMode.isIntrusivelyAsserted()) {
            decider.setAssertExpectedUndoMoveScore(true);
        }
        return decider;
    }

    private MoveSelectorConfig<?> buildMoveSelectorConfig(HeuristicConfigPolicy<Solution_> configPolicy, EntitySelector<Solution_> entitySelector, String mimicSelectorId) {
        MoveSelectorConfig moveSelectorConfig_;
        if (((ExhaustiveSearchPhaseConfig)this.phaseConfig).getMoveSelectorConfig() == null) {
            EntityDescriptor<Solution_> entityDescriptor = entitySelector.getEntityDescriptor();
            List<GenuineVariableDescriptor<Solution_>> variableDescriptorList = entityDescriptor.getGenuineVariableDescriptorList();
            if (entityDescriptor.hasAnyGenuineListVariables()) {
                throw new IllegalArgumentException("Exhaustive Search does not support list variables (" + String.valueOf(variableDescriptorList) + ").");
            }
            ArrayList<MoveSelectorConfig> subMoveSelectorConfigList = new ArrayList<MoveSelectorConfig>(variableDescriptorList.size());
            for (GenuineVariableDescriptor<Solution_> variableDescriptor : variableDescriptorList) {
                ChangeMoveSelectorConfig changeMoveSelectorConfig = new ChangeMoveSelectorConfig();
                changeMoveSelectorConfig.setEntitySelectorConfig(EntitySelectorConfig.newMimicSelectorConfig(mimicSelectorId));
                ValueSelectorConfig changeValueSelectorConfig = new ValueSelectorConfig().withVariableName(variableDescriptor.getVariableName());
                if (ValueSelectorConfig.hasSorter(configPolicy.getValueSorterManner(), variableDescriptor)) {
                    changeValueSelectorConfig = changeValueSelectorConfig.withCacheType(variableDescriptor.isValueRangeEntityIndependent() ? SelectionCacheType.PHASE : SelectionCacheType.STEP).withSelectionOrder(SelectionOrder.SORTED).withSorterManner(configPolicy.getValueSorterManner());
                }
                changeMoveSelectorConfig.setValueSelectorConfig(changeValueSelectorConfig);
                subMoveSelectorConfigList.add(changeMoveSelectorConfig);
            }
            moveSelectorConfig_ = subMoveSelectorConfigList.size() > 1 ? new CartesianProductMoveSelectorConfig(subMoveSelectorConfigList) : (MoveSelectorConfig)subMoveSelectorConfigList.get(0);
        } else {
            moveSelectorConfig_ = ((ExhaustiveSearchPhaseConfig)this.phaseConfig).getMoveSelectorConfig();
        }
        return moveSelectorConfig_;
    }
}

