/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.config.heuristic.selector.move.generic;

import ai.timefold.solver.core.config.heuristic.selector.move.MoveSelectorConfig;
import ai.timefold.solver.core.config.util.ConfigUtils;
import jakarta.xml.bind.annotation.XmlType;
import java.util.function.Consumer;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@XmlType(propOrder={"minimumRuinedCount", "maximumRuinedCount", "minimumRuinedPercentage", "maximumRuinedPercentage"})
public class RuinRecreateMoveSelectorConfig
extends MoveSelectorConfig<RuinRecreateMoveSelectorConfig> {
    private static final int DEFAULT_MINIMUM_RUINED_COUNT = 5;
    private static final int DEFAULT_MAXIMUM_RUINED_COUNT = 20;
    public static final String XML_ELEMENT_NAME = "ruinRecreateMoveSelector";
    protected Integer minimumRuinedCount = null;
    protected Integer maximumRuinedCount = null;
    protected Double minimumRuinedPercentage = null;
    protected Double maximumRuinedPercentage = null;

    public @Nullable Integer getMinimumRuinedCount() {
        return this.minimumRuinedCount;
    }

    public void setMinimumRuinedCount(@Nullable Integer minimumRuinedCount) {
        this.minimumRuinedCount = minimumRuinedCount;
    }

    public @NonNull RuinRecreateMoveSelectorConfig withMinimumRuinedCount(@NonNull Integer minimumRuinedCount) {
        this.minimumRuinedCount = minimumRuinedCount;
        return this;
    }

    public @Nullable Integer getMaximumRuinedCount() {
        return this.maximumRuinedCount;
    }

    public void setMaximumRuinedCount(@Nullable Integer maximumRuinedCount) {
        this.maximumRuinedCount = maximumRuinedCount;
    }

    public @NonNull RuinRecreateMoveSelectorConfig withMaximumRuinedCount(@NonNull Integer maximumRuinedCount) {
        this.maximumRuinedCount = maximumRuinedCount;
        return this;
    }

    public @Nullable Double getMinimumRuinedPercentage() {
        return this.minimumRuinedPercentage;
    }

    public void setMinimumRuinedPercentage(@Nullable Double minimumRuinedPercentage) {
        this.minimumRuinedPercentage = minimumRuinedPercentage;
    }

    public @NonNull RuinRecreateMoveSelectorConfig withMinimumRuinedPercentage(@NonNull Double minimumRuinedPercentage) {
        this.minimumRuinedPercentage = minimumRuinedPercentage;
        return this;
    }

    public @Nullable Double getMaximumRuinedPercentage() {
        return this.maximumRuinedPercentage;
    }

    public void setMaximumRuinedPercentage(@Nullable Double maximumRuinedPercentage) {
        this.maximumRuinedPercentage = maximumRuinedPercentage;
    }

    public @NonNull RuinRecreateMoveSelectorConfig withMaximumRuinedPercentage(@NonNull Double maximumRuinedPercentage) {
        this.maximumRuinedPercentage = maximumRuinedPercentage;
        return this;
    }

    @Override
    public boolean hasNearbySelectionConfig() {
        return false;
    }

    @Override
    public @NonNull RuinRecreateMoveSelectorConfig copyConfig() {
        return new RuinRecreateMoveSelectorConfig().inherit(this);
    }

    @Override
    public void visitReferencedClasses(@NonNull Consumer<Class<?>> classVisitor) {
    }

    @Override
    public @NonNull RuinRecreateMoveSelectorConfig inherit(@NonNull RuinRecreateMoveSelectorConfig inheritedConfig) {
        super.inherit(inheritedConfig);
        this.minimumRuinedCount = ConfigUtils.inheritOverwritableProperty(this.minimumRuinedCount, inheritedConfig.getMinimumRuinedCount());
        this.maximumRuinedCount = ConfigUtils.inheritOverwritableProperty(this.maximumRuinedCount, inheritedConfig.getMaximumRuinedCount());
        this.minimumRuinedPercentage = ConfigUtils.inheritOverwritableProperty(this.minimumRuinedPercentage, inheritedConfig.getMinimumRuinedPercentage());
        this.maximumRuinedPercentage = ConfigUtils.inheritOverwritableProperty(this.maximumRuinedPercentage, inheritedConfig.getMaximumRuinedPercentage());
        return this;
    }

    public int determineMinimumRuinedCount(long entityCount) {
        if (this.minimumRuinedCount != null) {
            return this.minimumRuinedCount;
        }
        if (this.minimumRuinedPercentage != null) {
            return (int)Math.floor(this.minimumRuinedPercentage * (double)entityCount);
        }
        return (int)Math.min(5L, entityCount);
    }

    public int determineMaximumRuinedCount(long entityCount) {
        if (this.maximumRuinedCount != null) {
            return this.maximumRuinedCount;
        }
        if (this.maximumRuinedPercentage != null) {
            return (int)Math.floor(this.maximumRuinedPercentage * (double)entityCount);
        }
        return (int)Math.min(20L, entityCount);
    }
}

