/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.api.score.constraint;

import java.util.Objects;
import org.jspecify.annotations.NonNull;

public record ConstraintRef(@NonNull String packageName, @NonNull String constraintName, String constraintId) implements Comparable<ConstraintRef>
{
    private static final char PACKAGE_SEPARATOR = '/';

    public ConstraintRef(@NonNull String packageName, @NonNull String constraintName, String constraintId) {
        packageName = ConstraintRef.validate(packageName, "constraint package");
        constraintName = ConstraintRef.validate(constraintName, "constraint name");
        String expectedConstraintId = ConstraintRef.composeConstraintId(packageName, constraintName);
        if (constraintId != null && !constraintId.equals(expectedConstraintId)) {
            throw new IllegalArgumentException("Specifying custom constraintId (%s) is not allowed.".formatted(constraintId));
        }
        constraintId = expectedConstraintId;
    }

    public static ConstraintRef of(String packageName, String constraintName) {
        return new ConstraintRef(packageName, constraintName, null);
    }

    public static ConstraintRef parseId(String constraintId) {
        int slashIndex = constraintId.indexOf(47);
        if (slashIndex < 0) {
            throw new IllegalArgumentException("The constraintId (%s) is invalid as it does not contain a package separator (%s).".formatted(constraintId, Character.valueOf('/')));
        }
        String packageName = constraintId.substring(0, slashIndex);
        String constraintName = constraintId.substring(slashIndex + 1);
        return new ConstraintRef(packageName, constraintName, constraintId);
    }

    public static String composeConstraintId(String packageName, String constraintName) {
        return packageName + "/" + constraintName;
    }

    private static String validate(String identifier, String type) {
        String sanitized = Objects.requireNonNull(identifier).trim();
        if (sanitized.isEmpty()) {
            throw new IllegalArgumentException("The %s cannot be empty.".formatted(type));
        }
        if (sanitized.contains("/")) {
            throw new IllegalArgumentException("The %s (%s) cannot contain a package separator (%s).".formatted(type, sanitized, Character.valueOf('/')));
        }
        return sanitized;
    }

    @Override
    public String toString() {
        return this.constraintId;
    }

    @Override
    public int compareTo(ConstraintRef other) {
        return this.constraintId.compareTo(other.constraintId);
    }
}

