/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.move.generic.list;

import ai.timefold.solver.core.api.score.director.ScoreDirector;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.move.AbstractMove;
import ai.timefold.solver.core.impl.score.director.VariableDescriptorAwareScoreDirector;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;

public class ListChangeMove<Solution_>
extends AbstractMove<Solution_> {
    private final ListVariableDescriptor<Solution_> variableDescriptor;
    private final Object sourceEntity;
    private final int sourceIndex;
    private final Object destinationEntity;
    private final int destinationIndex;
    private Object planningValue;

    public ListChangeMove(ListVariableDescriptor<Solution_> variableDescriptor, Object sourceEntity, int sourceIndex, Object destinationEntity, int destinationIndex) {
        this.variableDescriptor = variableDescriptor;
        this.sourceEntity = sourceEntity;
        this.sourceIndex = sourceIndex;
        this.destinationEntity = destinationEntity;
        this.destinationIndex = destinationIndex;
    }

    public Object getSourceEntity() {
        return this.sourceEntity;
    }

    public int getSourceIndex() {
        return this.sourceIndex;
    }

    public Object getDestinationEntity() {
        return this.destinationEntity;
    }

    public int getDestinationIndex() {
        return this.destinationIndex;
    }

    public Object getMovedValue() {
        if (this.planningValue == null) {
            this.planningValue = this.variableDescriptor.getElement(this.sourceEntity, this.sourceIndex);
        }
        return this.planningValue;
    }

    @Override
    public boolean isMoveDoable(ScoreDirector<Solution_> scoreDirector) {
        return this.destinationEntity != this.sourceEntity || this.destinationIndex != this.sourceIndex && this.destinationIndex != this.variableDescriptor.getListSize(this.sourceEntity);
    }

    @Override
    protected void doMoveOnGenuineVariables(ScoreDirector<Solution_> scoreDirector) {
        VariableDescriptorAwareScoreDirector castScoreDirector = (VariableDescriptorAwareScoreDirector)scoreDirector;
        if (this.sourceEntity == this.destinationEntity) {
            int fromIndex = Math.min(this.sourceIndex, this.destinationIndex);
            int toIndex = Math.max(this.sourceIndex, this.destinationIndex) + 1;
            castScoreDirector.beforeListVariableChanged(this.variableDescriptor, this.sourceEntity, fromIndex, toIndex);
            Object element = this.variableDescriptor.removeElement(this.sourceEntity, this.sourceIndex);
            this.variableDescriptor.addElement(this.destinationEntity, this.destinationIndex, element);
            castScoreDirector.afterListVariableChanged(this.variableDescriptor, this.sourceEntity, fromIndex, toIndex);
            this.planningValue = element;
        } else {
            castScoreDirector.beforeListVariableChanged(this.variableDescriptor, this.sourceEntity, this.sourceIndex, this.sourceIndex + 1);
            Object element = this.variableDescriptor.removeElement(this.sourceEntity, this.sourceIndex);
            castScoreDirector.afterListVariableChanged(this.variableDescriptor, this.sourceEntity, this.sourceIndex, this.sourceIndex);
            castScoreDirector.beforeListVariableChanged(this.variableDescriptor, this.destinationEntity, this.destinationIndex, this.destinationIndex);
            this.variableDescriptor.addElement(this.destinationEntity, this.destinationIndex, element);
            castScoreDirector.afterListVariableChanged(this.variableDescriptor, this.destinationEntity, this.destinationIndex, this.destinationIndex + 1);
            this.planningValue = element;
        }
    }

    @Override
    public ListChangeMove<Solution_> rebase(ScoreDirector<Solution_> destinationScoreDirector) {
        return new ListChangeMove<Solution_>(this.variableDescriptor, destinationScoreDirector.lookUpWorkingObject(this.sourceEntity), this.sourceIndex, destinationScoreDirector.lookUpWorkingObject(this.destinationEntity), this.destinationIndex);
    }

    @Override
    public String getSimpleMoveTypeDescription() {
        return this.getClass().getSimpleName() + "(" + this.variableDescriptor.getSimpleEntityAndVariableName() + ")";
    }

    @Override
    public Collection<Object> getPlanningEntities() {
        LinkedHashSet<Object> entities = new LinkedHashSet<Object>(2);
        entities.add(this.sourceEntity);
        entities.add(this.destinationEntity);
        return entities;
    }

    @Override
    public Collection<Object> getPlanningValues() {
        return Collections.singleton(this.planningValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListChangeMove other = (ListChangeMove)o;
        return this.sourceIndex == other.sourceIndex && this.destinationIndex == other.destinationIndex && Objects.equals(this.variableDescriptor, other.variableDescriptor) && Objects.equals(this.sourceEntity, other.sourceEntity) && Objects.equals(this.destinationEntity, other.destinationEntity);
    }

    public int hashCode() {
        return Objects.hash(this.variableDescriptor, this.sourceEntity, this.sourceIndex, this.destinationEntity, this.destinationIndex);
    }

    public String toString() {
        return String.format("%s {%s[%d] -> %s[%d]}", this.getMovedValue(), this.sourceEntity, this.sourceIndex, this.destinationEntity, this.destinationIndex);
    }
}

