/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.valuerange.descriptor;

import ai.timefold.solver.core.api.domain.valuerange.CountableValueRange;
import ai.timefold.solver.core.api.domain.valuerange.ValueRange;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.domain.valuerange.buildin.composite.NullAllowingCountableValueRange;
import ai.timefold.solver.core.impl.domain.valuerange.descriptor.ValueRangeDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;

public abstract class AbstractValueRangeDescriptor<Solution_>
implements ValueRangeDescriptor<Solution_> {
    protected final GenuineVariableDescriptor<Solution_> variableDescriptor;
    protected final boolean addNullInValueRange;

    public AbstractValueRangeDescriptor(GenuineVariableDescriptor<Solution_> variableDescriptor, boolean addNullInValueRange) {
        this.variableDescriptor = variableDescriptor;
        this.addNullInValueRange = addNullInValueRange;
    }

    @Override
    public GenuineVariableDescriptor<Solution_> getVariableDescriptor() {
        return this.variableDescriptor;
    }

    @Override
    public boolean mightContainEntity() {
        SolutionDescriptor solutionDescriptor = this.variableDescriptor.getEntityDescriptor().getSolutionDescriptor();
        Class<?> variablePropertyType = this.variableDescriptor.getVariablePropertyType();
        for (Class<?> entityClass : solutionDescriptor.getEntityClassSet()) {
            if (!variablePropertyType.isAssignableFrom(entityClass)) continue;
            return true;
        }
        return false;
    }

    protected <T> ValueRange<T> doNullInValueRangeWrapping(ValueRange<T> valueRange) {
        if (this.addNullInValueRange) {
            valueRange = new NullAllowingCountableValueRange((CountableValueRange)valueRange);
        }
        return valueRange;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.variableDescriptor.getVariableName() + ")";
    }
}

